/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.action.ActionSaver;
import cz.kpsys.portaro.alert.Alert;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.UserAuthentication;
import cz.kpsys.portaro.auth.context.AuthenticatedContextualProvider;
import cz.kpsys.portaro.auth.credreg.CredentialsRegistrationSettings;
import cz.kpsys.portaro.auth.current.CurrentAuthResponse;
import cz.kpsys.portaro.auth.current.CurrentAuthWebResolver;
import cz.kpsys.portaro.auth.view.AuthenticationSystemView;
import cz.kpsys.portaro.commons.contextual.AndBooleanContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualBiFunction;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.TemporarilyCachedContextualProvider;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.localization.TranslationResolver;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.object.LabeledId;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.commons.web.CompositeListWebResolver;
import cz.kpsys.portaro.commons.web.CookieValueWebResolver;
import cz.kpsys.portaro.commons.web.WebResolver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.erp.ErpSettingsKeys;
import cz.kpsys.portaro.file.FileAccessType;
import cz.kpsys.portaro.file.custom.CustomFile;
import cz.kpsys.portaro.file.custom.RootCustomDirectory;
import cz.kpsys.portaro.file.custom.RootCustomDirectoryAccessor;
import cz.kpsys.portaro.file.custom.RootCustomDirectoryAccessorNewDirCreatingDecorator;
import cz.kpsys.portaro.file.directory.DirectoryLoader;
import cz.kpsys.portaro.file.directory.ParentableDirectoryCreator;
import cz.kpsys.portaro.intent.LabeledMappedAction;
import cz.kpsys.portaro.licence.FeatureEnabledProvider;
import cz.kpsys.portaro.licence.FeatureManager;
import cz.kpsys.portaro.licence.portaro.PortaroVersion;
import cz.kpsys.portaro.loan.ill.IllSettingKeys;
import cz.kpsys.portaro.opening.OpeningData;
import cz.kpsys.portaro.opening.OpeningNoticeByStateGenerator;
import cz.kpsys.portaro.opening.OpeningTimeRangesProviderByDayStringProviders;
import cz.kpsys.portaro.record.RecordSettingKeys;
import cz.kpsys.portaro.record.sec.CurrentAuthFondsLoader;
import cz.kpsys.portaro.search.view.SearchFormFactory;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.template.CustomFileTemplateRenderer;
import cz.kpsys.portaro.template.StaticTemplateRenderer;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.UserByBasicUserLoader;
import cz.kpsys.portaro.user.registration.RegistrationSettingKeys;
import cz.kpsys.portaro.user.relation.RepresentableUserLoader;
import cz.kpsys.portaro.view.domain.CurrentPage;
import cz.kpsys.portaro.view.domain.LoginView;
import cz.kpsys.portaro.view.domain.menu.CompositeMenuLoader;
import cz.kpsys.portaro.view.domain.menu.MenuItem;
import cz.kpsys.portaro.view.domain.menu.MenuItemEntity;
import cz.kpsys.portaro.view.web.CatalogWebSettingsKeys;
import cz.kpsys.portaro.view.web.DepartmentSelectorApiController;
import cz.kpsys.portaro.view.web.OpensearchDescriptionFileController;
import cz.kpsys.portaro.view.web.SetController;
import cz.kpsys.portaro.view.web.currentdepartment.CurrentDepartmentSaver;
import cz.kpsys.portaro.view.web.page.CustomFileController;
import cz.kpsys.portaro.view.web.page.DefaultCurrentPageFactory;
import cz.kpsys.portaro.view.web.page.ErrorsPageController;
import cz.kpsys.portaro.view.web.page.IndexController;
import cz.kpsys.portaro.view.web.page.MediaViewerPageController;
import cz.kpsys.portaro.view.web.page.ViewsController;
import cz.kpsys.portaro.view.web.rest.FormApiController;
import cz.kpsys.portaro.view.web.rest.GuiComponentsApiController;
import cz.kpsys.portaro.view.web.rest.OpeningCalendarApiController;
import cz.kpsys.portaro.view.web.rest.custompages.CustomPagesApiController;
import cz.kpsys.portaro.view.web.rest.user.CurrentAuthApiController;
import cz.kpsys.portaro.view.web.rest.user.LoginViewApiController;
import cz.kpsys.portaro.view.web.rest.user.UserAttentionRequiringActionsProvider;
import cz.kpsys.portaro.web.page.AngularTemplateController;
import cz.kpsys.portaro.web.page.CompositeCurrentPageDialogsResolver;
import cz.kpsys.portaro.web.page.CurrentPageDialogsResolver;
import cz.kpsys.portaro.web.page.CurrentPageFactory;
import cz.kpsys.portaro.web.page.ModelAndPageViewFactory;
import cz.kpsys.portaro.web.page.SettableModelAndPageViewFactory;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.web.servlet.LocaleResolver;

@Configuration
public class WebPageConfig {
    @NonNull
    private final @NonNull Provider<@NonNull String> publicContextPath;
    @NonNull
    private final FeatureManager featureManager;
    @NonNull
    private final PortaroVersion portaroVersion;
    @NonNull
    private final ActionSaver actionSaver;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final TranslationResolver<Department> translationResolver;
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final CurrentAuthFondsLoader currentAuthShowableFondsLoader;
    @NonNull
    private final CurrentAuthFondsLoader currentAuthEditableFondsLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final SettingLoader settingLoader;
    private final @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final DirectoryLoader directoryLoader;
    @NonNull
    private final ContextualProvider<Department, List<AuthenticationSystemView>> authSystemViewsListDepartmentedProvider;
    @NonNull
    private final CurrentDepartmentSaver currentDepartmentSaver;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final @NonNull Provider<@NonNull FileAccessType> defaultFileAccessTypeProvider;
    @NonNull
    private final LocaleResolver localeResolver;
    @NonNull
    private final BeanFactory applicationContext;
    @NonNull
    private final ContextualProvider<Department, CredentialsRegistrationSettings> credentialsRegistrationSettingsDepartmentedProvider;
    @NonNull
    private final RootCustomDirectoryAccessor rootCustomDirectoryAccessor;
    @NonNull
    private final Saver<RootCustomDirectory, RootCustomDirectory> rootCustomDirectorySaver;
    @NonNull
    private final ByIdLoadable<CustomFile, String> hierarchyTraversingCustomFileLoader;
    @NonNull
    private final FileDataStreamer cachedUnsecuredFileDataStreamer;
    @NonNull
    private final CompositeListWebResolver<Alert> alertsWebResolver;
    @NonNull
    private final Converter<UserAuthentication, CurrentAuthResponse> currentAuthToResponseConverter;
    @NonNull
    private final RepresentableUserLoader representableUserLoader;
    @NonNull
    private final CurrentAuthWebResolver currentAuthWebResolver;
    @NonNull
    private final CompositeCurrentPageDialogsResolver currentPageDialogsResolver;
    @NonNull
    private final SearchFormFactory searchFormFactory;
    @NonNull
    private final SettableModelAndPageViewFactory modelAndPageViewFactory;
    @NonNull
    private final UserByBasicUserLoader userLoader;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final ParentableDirectoryCreator parentableDirectoryCreator;

    @Bean
    public ContextualBiFunction<User, UserAuthentication, Department, List<LabeledMappedAction<?>>> userAttentionRequiringActionsProvider() {
        return new UserAttentionRequiringActionsProvider(this.securityManager);
    }

    @Bean
    public ContextualBiFunction<User, UserAuthentication, Department, Integer> numberOfUserAttentionRequiringActionsProvider() {
        return this.userAttentionRequiringActionsProvider().andThen(List::size);
    }

    @Bean
    public StaticTemplateRenderer customFileTemplateRenderer() {
        return new CustomFileTemplateRenderer(this.templateEngine, this.applicationContext, this.translator);
    }

    @Bean
    public IndexController indexController() {
        return new IndexController(this.publicContextPath, (ModelAndPageViewFactory)this.modelAndPageViewFactory, this.customFileTemplateRenderer());
    }

    @Bean
    public CustomPagesApiController customPagesApiController() {
        return new CustomPagesApiController(this.customFileTemplateRenderer());
    }

    @Bean
    public AngularTemplateController angularTemplateController() {
        return new AngularTemplateController((ModelAndPageViewFactory)this.modelAndPageViewFactory);
    }

    @Bean
    public OpensearchDescriptionFileController opensearchDescriptionFileController() {
        return new OpensearchDescriptionFileController();
    }

    @Bean
    public CustomFileController customFileController() {
        return new CustomFileController(this.hierarchyTraversingCustomFileLoader, this.cachedUnsecuredFileDataStreamer, this.currentPageFactory(), this.localeResolver);
    }

    @Bean
    public FormApiController formApiController() {
        return new FormApiController(this.searchFormFactory);
    }

    @Bean
    public ViewsController viewsController() {
        return new ViewsController(this.actionSaver, (Provider)new FeatureEnabledProvider(this.featureManager, "exemplar-search"), (RootCustomDirectoryAccessor)new RootCustomDirectoryAccessorNewDirCreatingDecorator(this.rootCustomDirectoryAccessor, this.rootCustomDirectorySaver, this.defaultFileAccessTypeProvider, this.parentableDirectoryCreator, this.defaultTransactionTemplateFactory.get()), (ModelAndPageViewFactory)this.modelAndPageViewFactory);
    }

    @Bean
    public MediaViewerPageController mediaViewerPageController() {
        return new MediaViewerPageController(this.directoryLoader, this.actionSaver, (ModelAndPageViewFactory)this.modelAndPageViewFactory);
    }

    @Bean
    public CurrentAuthApiController currentAuthApiController() {
        return new CurrentAuthApiController(this.currentAuthToResponseConverter);
    }

    @Bean
    public LoginViewApiController loginViewApiController() {
        return new LoginViewApiController(this.loginViewDepartmentedProvider());
    }

    @Bean
    public SetController setController() {
        return new SetController(this.publicContextPath, this.rootDepartmentProvider, this.currentDepartmentSaver, this.localeResolver);
    }

    @Bean
    public OpeningCalendarApiController openingCalendarApiController() {
        OpeningTimeRangesProviderByDayStringProviders openingTimeRangesProvider = new OpeningTimeRangesProviderByDayStringProviders().withDay(DayOfWeek.MONDAY, this.settingLoader.getDepartmentedProvider(SettingKeys.LIBRARY_OPENING_MONDAY)).withDay(DayOfWeek.TUESDAY, this.settingLoader.getDepartmentedProvider(SettingKeys.LIBRARY_OPENING_TUESDAY)).withDay(DayOfWeek.WEDNESDAY, this.settingLoader.getDepartmentedProvider(SettingKeys.LIBRARY_OPENING_WEDNESDAY)).withDay(DayOfWeek.THURSDAY, this.settingLoader.getDepartmentedProvider(SettingKeys.LIBRARY_OPENING_THURSDAY)).withDay(DayOfWeek.FRIDAY, this.settingLoader.getDepartmentedProvider(SettingKeys.LIBRARY_OPENING_FRIDAY)).withDay(DayOfWeek.SATURDAY, this.settingLoader.getDepartmentedProvider(SettingKeys.LIBRARY_OPENING_SATURDAY)).withDay(DayOfWeek.SUNDAY, this.settingLoader.getDepartmentedProvider(SettingKeys.LIBRARY_OPENING_SUNDAY));
        ContextualProvider data = department -> new OpeningData((Provider)StaticProvider.of((Object)CoreConstants.CZECH_TIME_ZONE_ID), openingTimeRangesProvider.getOn(department));
        return new OpeningCalendarApiController(data, (Provider)StaticProvider.of((Object)CoreConstants.CZECH_TIME_ZONE_ID), List.of(Texts.ofDefaulted((Text)Texts.ofMessageCoded((String)"library.opening.note"), (Text)Texts.ofEmpty())), (Converter)new OpeningNoticeByStateGenerator(Instant::now));
    }

    @Bean
    public AuthenticatedContextualProvider<Department, List<MenuItem>> menuItemsAuthenticatedContextualProvider() {
        Codebook menuItemEntityLoader = this.codebookLoaderBuilderFactory.create().providedByJpa(MenuItemEntity.class, "order").staticCached(MenuItem.class.getSimpleName()).build();
        return new CompositeMenuLoader(this.securityManager, this.currentAuthShowableFondsLoader, this.currentAuthEditableFondsLoader, this.settingLoader.getDepartmentedProvider(RecordSettingKeys.AUTHORITY_INDEX_DEFAULT_PREFIX), this.settingLoader.getDepartmentedProvider(RecordSettingKeys.AUTHORITY_INDEX_PREFIXES_BY_FONDS), menuItemEntityLoader);
    }

    @Bean
    public ContextualProvider<Department, List<String>> forbiddenMenuItems() {
        return this.settingLoader.getDepartmentedProvider(SettingKeys.FORBIDDEN_MENU_ITEMS);
    }

    @Bean
    public ContextualProvider<Department, LoginView> loginViewDepartmentedProvider() {
        return ctx -> new LoginView(((Boolean)this.settingLoader.getDepartmentedProvider(SettingKeys.FULL_REGISTRATION_ENABLED).getOn(ctx)).booleanValue(), ((Boolean)this.settingLoader.getDepartmentedProvider(RegistrationSettingKeys.EXTERNAL_FULL_REGISTRATION_ENABLED).getOn(ctx)).booleanValue(), ((CredentialsRegistrationSettings)this.credentialsRegistrationSettingsDepartmentedProvider.getOn(ctx)).isEnabled(), ((Boolean)this.settingLoader.getDepartmentedProvider(SettingKeys.FORGOTTEN_CREDENTIALS_ENABLED).getOn(ctx)).booleanValue(), AndBooleanContextualProvider.of((ContextualProvider[])new ContextualProvider[]{this.settingLoader.getDepartmentedProvider(IllSettingKeys.MVS_ACTIVE_ENABLED), this.settingLoader.getDepartmentedProvider(IllSettingKeys.PROVIDERS_REGISTRATION_ENABLED)}).getOn(ctx).booleanValue(), (List)this.authSystemViewsListDepartmentedProvider.getOn(ctx));
    }

    @Bean
    public ContextualProvider<Department, List<LabeledId<String>>> enabledLanguagesProvider() {
        List<LabeledId> allLanguages = List.of(new LabeledId((Serializable)((Object)CoreConstants.Locales.CS.getLanguage()), Texts.ofNative((String)"\u010cesky")), new LabeledId((Serializable)((Object)CoreConstants.Locales.SK.getLanguage()), Texts.ofNative((String)"Slovensky")), new LabeledId((Serializable)((Object)CoreConstants.Locales.EN.getLanguage()), Texts.ofNative((String)"English")), new LabeledId((Serializable)((Object)CoreConstants.Locales.DE.getLanguage()), Texts.ofNative((String)"Deutsch")), new LabeledId((Serializable)((Object)CoreConstants.Locales.FR.getLanguage()), Texts.ofNative((String)"Fran\u00e7ais")), new LabeledId((Serializable)((Object)CoreConstants.Locales.ES.getLanguage()), Texts.ofNative((String)"Espa\u00f1ol")), new LabeledId((Serializable)((Object)CoreConstants.Locales.IT.getLanguage()), Texts.ofNative((String)"Italiano")), new LabeledId((Serializable)((Object)CoreConstants.Locales.HU.getLanguage()), Texts.ofNative((String)"Magyar")), new LabeledId((Serializable)((Object)CoreConstants.Locales.PL.getLanguage()), Texts.ofNative((String)"Polskie")), new LabeledId((Serializable)((Object)CoreConstants.Locales.BG.getLanguage()), Texts.ofNative((String)"\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438")));
        ContextualProvider enabledLocalesProvider = this.settingLoader.getDepartmentedProvider(SettingKeys.ENABLED_LOCALES).andThen(enabledLocales -> {
            List enabledLanguages = ListUtil.convert((Iterable)enabledLocales, Locale::getLanguage);
            return ListUtil.filterAndSortByRule((Collection)allLanguages, (Collection)enabledLanguages);
        });
        return new TemporarilyCachedContextualProvider(enabledLocalesProvider, Duration.ofSeconds(10L));
    }

    @Bean
    public CurrentPageFactory<CurrentPage> currentPageFactory() {
        return new DefaultCurrentPageFactory(this.portaroVersion, this.serverUrlProvider, this.publicContextPath, this.authenticationHolder, this.securityManager, this.currentAuthToResponseConverter, this.loginViewDepartmentedProvider(), this.menuItemsAuthenticatedContextualProvider(), this.translator, this.translationResolver, this.enabledLanguagesProvider(), (WebResolver)this.alertsWebResolver, this.representableUserLoader, this.settingLoader.getDepartmentedProvider(SettingKeys.CAMERA_SCANNER_ENABLED), this.currentAuthWebResolver, this.forbiddenMenuItems(), this.customFileTemplateRenderer(), (CurrentPageDialogsResolver)this.currentPageDialogsResolver, this.settingLoader.getDepartmentedProvider(SettingKeys.GLOBAL_SEARCH_INPUT_ENABLED), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.HEADER_BACKGROUND_COLOR), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.HEADER_TEXT_COLOR), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.HEADER_LINK_COLOR), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.MAIN_MENU_BACKGROUND_COLOR), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.MAIN_MENU_TEXT_COLOR), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.MAIN_MENU_HIGHLIGHT_BACKGROUND_COLOR), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.MAIN_MENU_HIGHLIGHT_TEXT_COLOR), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.GLOBAL_SEARCH_BUTTON_COLOR), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.TABLE_HEADER_ACCENT_COLOR), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.SELECTED_TAB_HIGHLIGHT_COLOR), (WebResolver)new CookieValueWebResolver("portaroTheme"), this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.SUTOR_SUTIN_LAYOUT_ENABLED), this.numberOfUserAttentionRequiringActionsProvider(), this.userLoader, this.settingLoader.getDepartmentedProvider(ErpSettingsKeys.ERP_CUSTOM_DATA_VIEW_PAGES), this.settingLoader.getDepartmentedProvider(CoreSettingKeys.HOME_DEPARTMENT_REDIRECT_AFTER_LOGIN));
    }

    @Bean
    public ErrorsPageController errorsPageController() {
        return new ErrorsPageController(this.translator, (ModelAndPageViewFactory)this.modelAndPageViewFactory);
    }

    @Bean
    public DepartmentSelectorApiController departmentSelectorApiController() {
        return new DepartmentSelectorApiController(this.settingLoader.getContextToValueMap(CoreSettingKeys.SERVER_URL), this.departmentAccessor);
    }

    @Bean
    public GuiComponentsApiController guiComponentsApiController() {
        return new GuiComponentsApiController(this.settingLoader.getDepartmentedProvider(CatalogWebSettingsKeys.SUB_SEARCH_LINKS));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerCurrentPageFactory() {
        this.modelAndPageViewFactory.setCurrentPageFactory(this.currentPageFactory());
    }

    @ConstructorProperties(value={"publicContextPath", "featureManager", "portaroVersion", "actionSaver", "translator", "translationResolver", "templateEngine", "codebookLoaderBuilderFactory", "currentAuthShowableFondsLoader", "currentAuthEditableFondsLoader", "departmentAccessor", "securityManager", "settingLoader", "serverUrlProvider", "authenticationHolder", "directoryLoader", "authSystemViewsListDepartmentedProvider", "currentDepartmentSaver", "rootDepartmentProvider", "defaultFileAccessTypeProvider", "localeResolver", "applicationContext", "credentialsRegistrationSettingsDepartmentedProvider", "rootCustomDirectoryAccessor", "rootCustomDirectorySaver", "hierarchyTraversingCustomFileLoader", "cachedUnsecuredFileDataStreamer", "alertsWebResolver", "currentAuthToResponseConverter", "representableUserLoader", "currentAuthWebResolver", "currentPageDialogsResolver", "searchFormFactory", "modelAndPageViewFactory", "userLoader", "defaultTransactionTemplateFactory", "parentableDirectoryCreator"})
    @Generated
    public WebPageConfig(@NonNull @NonNull Provider<@NonNull String> publicContextPath, @NonNull FeatureManager featureManager, @NonNull PortaroVersion portaroVersion, @NonNull ActionSaver actionSaver, @NonNull Translator<Department> translator, @NonNull TranslationResolver<Department> translationResolver, @NonNull TemplateEngine templateEngine, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull CurrentAuthFondsLoader currentAuthShowableFondsLoader, @NonNull CurrentAuthFondsLoader currentAuthEditableFondsLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull SecurityManager securityManager, @NonNull SettingLoader settingLoader, @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider, @NonNull AuthenticationHolder authenticationHolder, @NonNull DirectoryLoader directoryLoader, @NonNull ContextualProvider<Department, List<AuthenticationSystemView>> authSystemViewsListDepartmentedProvider, @NonNull CurrentDepartmentSaver currentDepartmentSaver, @NonNull Provider<Department> rootDepartmentProvider, @NonNull @NonNull Provider<@NonNull FileAccessType> defaultFileAccessTypeProvider, @NonNull LocaleResolver localeResolver, @NonNull BeanFactory applicationContext, @NonNull ContextualProvider<Department, CredentialsRegistrationSettings> credentialsRegistrationSettingsDepartmentedProvider, @NonNull RootCustomDirectoryAccessor rootCustomDirectoryAccessor, @NonNull Saver<RootCustomDirectory, RootCustomDirectory> rootCustomDirectorySaver, @NonNull ByIdLoadable<CustomFile, String> hierarchyTraversingCustomFileLoader, @NonNull FileDataStreamer cachedUnsecuredFileDataStreamer, @NonNull CompositeListWebResolver<Alert> alertsWebResolver, @NonNull Converter<UserAuthentication, CurrentAuthResponse> currentAuthToResponseConverter, @NonNull RepresentableUserLoader representableUserLoader, @NonNull CurrentAuthWebResolver currentAuthWebResolver, @NonNull CompositeCurrentPageDialogsResolver currentPageDialogsResolver, @NonNull SearchFormFactory searchFormFactory, @NonNull SettableModelAndPageViewFactory modelAndPageViewFactory, @NonNull UserByBasicUserLoader userLoader, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull ParentableDirectoryCreator parentableDirectoryCreator) {
        Objects.requireNonNull(publicContextPath, "publicContextPath is marked non-null but is null");
        Objects.requireNonNull(featureManager, "featureManager is marked non-null but is null");
        Objects.requireNonNull(portaroVersion, "portaroVersion is marked non-null but is null");
        Objects.requireNonNull(actionSaver, "actionSaver is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(translationResolver, "translationResolver is marked non-null but is null");
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(currentAuthShowableFondsLoader, "currentAuthShowableFondsLoader is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableFondsLoader, "currentAuthEditableFondsLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(serverUrlProvider, "serverUrlProvider is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(directoryLoader, "directoryLoader is marked non-null but is null");
        Objects.requireNonNull(authSystemViewsListDepartmentedProvider, "authSystemViewsListDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(currentDepartmentSaver, "currentDepartmentSaver is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(defaultFileAccessTypeProvider, "defaultFileAccessTypeProvider is marked non-null but is null");
        Objects.requireNonNull(localeResolver, "localeResolver is marked non-null but is null");
        Objects.requireNonNull(applicationContext, "applicationContext is marked non-null but is null");
        Objects.requireNonNull(credentialsRegistrationSettingsDepartmentedProvider, "credentialsRegistrationSettingsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(rootCustomDirectoryAccessor, "rootCustomDirectoryAccessor is marked non-null but is null");
        Objects.requireNonNull(rootCustomDirectorySaver, "rootCustomDirectorySaver is marked non-null but is null");
        Objects.requireNonNull(hierarchyTraversingCustomFileLoader, "hierarchyTraversingCustomFileLoader is marked non-null but is null");
        Objects.requireNonNull(cachedUnsecuredFileDataStreamer, "cachedUnsecuredFileDataStreamer is marked non-null but is null");
        Objects.requireNonNull(alertsWebResolver, "alertsWebResolver is marked non-null but is null");
        Objects.requireNonNull(currentAuthToResponseConverter, "currentAuthToResponseConverter is marked non-null but is null");
        Objects.requireNonNull(representableUserLoader, "representableUserLoader is marked non-null but is null");
        Objects.requireNonNull(currentAuthWebResolver, "currentAuthWebResolver is marked non-null but is null");
        Objects.requireNonNull(currentPageDialogsResolver, "currentPageDialogsResolver is marked non-null but is null");
        Objects.requireNonNull(searchFormFactory, "searchFormFactory is marked non-null but is null");
        Objects.requireNonNull(modelAndPageViewFactory, "modelAndPageViewFactory is marked non-null but is null");
        Objects.requireNonNull(userLoader, "userLoader is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(parentableDirectoryCreator, "parentableDirectoryCreator is marked non-null but is null");
        this.publicContextPath = publicContextPath;
        this.featureManager = featureManager;
        this.portaroVersion = portaroVersion;
        this.actionSaver = actionSaver;
        this.translator = translator;
        this.translationResolver = translationResolver;
        this.templateEngine = templateEngine;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.currentAuthShowableFondsLoader = currentAuthShowableFondsLoader;
        this.currentAuthEditableFondsLoader = currentAuthEditableFondsLoader;
        this.departmentAccessor = departmentAccessor;
        this.securityManager = securityManager;
        this.settingLoader = settingLoader;
        this.serverUrlProvider = serverUrlProvider;
        this.authenticationHolder = authenticationHolder;
        this.directoryLoader = directoryLoader;
        this.authSystemViewsListDepartmentedProvider = authSystemViewsListDepartmentedProvider;
        this.currentDepartmentSaver = currentDepartmentSaver;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.defaultFileAccessTypeProvider = defaultFileAccessTypeProvider;
        this.localeResolver = localeResolver;
        this.applicationContext = applicationContext;
        this.credentialsRegistrationSettingsDepartmentedProvider = credentialsRegistrationSettingsDepartmentedProvider;
        this.rootCustomDirectoryAccessor = rootCustomDirectoryAccessor;
        this.rootCustomDirectorySaver = rootCustomDirectorySaver;
        this.hierarchyTraversingCustomFileLoader = hierarchyTraversingCustomFileLoader;
        this.cachedUnsecuredFileDataStreamer = cachedUnsecuredFileDataStreamer;
        this.alertsWebResolver = alertsWebResolver;
        this.currentAuthToResponseConverter = currentAuthToResponseConverter;
        this.representableUserLoader = representableUserLoader;
        this.currentAuthWebResolver = currentAuthWebResolver;
        this.currentPageDialogsResolver = currentPageDialogsResolver;
        this.searchFormFactory = searchFormFactory;
        this.modelAndPageViewFactory = modelAndPageViewFactory;
        this.userLoader = userLoader;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.parentableDirectoryCreator = parentableDirectoryCreator;
    }
}

