/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import cz.kpsys.portaro.auth.UserAuthenticationFunctions;
import cz.kpsys.portaro.auth.context.AuthenticatedContextualProvider;
import cz.kpsys.portaro.auth.current.CurrentAuthWebResolver;
import cz.kpsys.portaro.auth.department.AuthContextualDepartmentsLoader;
import cz.kpsys.portaro.auth.department.BypassableCurrentAuthDepartmentsLoader;
import cz.kpsys.portaro.auth.department.CurrentAuthDepartmentsLoader;
import cz.kpsys.portaro.auth.department.CurrentAuthDepartmentsLoaderByUserDepartmentsLoader;
import cz.kpsys.portaro.auth.department.EditableDepartmentsAuthenticatedContextualProvider;
import cz.kpsys.portaro.auth.department.EditableLocationsAuthenticatedContextualProvider;
import cz.kpsys.portaro.auth.department.FamilyModeAuthContextualDepartmentsLoader;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.StaticCache;
import cz.kpsys.portaro.commons.cache.StaticCacheFactory;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.HierarchicalContextualProvider;
import cz.kpsys.portaro.commons.convert.IdToObjectConverter;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.MissingValueException;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.ProviderByIdProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.CastingByIdLoader;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.IdConvertingByIdLoadable;
import cz.kpsys.portaro.commons.property.Property;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.database.JpaAllValuesProvider;
import cz.kpsys.portaro.datatype.DatatypedAcceptableValuesRegistry;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.department.HierarchyFinderDepartmentedFactory;
import cz.kpsys.portaro.hierarchy.HierarchyFinder;
import cz.kpsys.portaro.hierarchy.HierarchyLoader;
import cz.kpsys.portaro.location.DepartmentLocationRelationLoader;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.sec.ActionPermissionsEditorFondsLoader;
import cz.kpsys.portaro.record.sec.BypassableCurrentAuthFondsLoader;
import cz.kpsys.portaro.record.sec.CachingEditableEditorFondsLoader;
import cz.kpsys.portaro.record.sec.CachingShowableEditorFondsLoader;
import cz.kpsys.portaro.record.sec.CurrentAuthFondsLoader;
import cz.kpsys.portaro.record.sec.EditorPermissionsBypassingCurrentAuthShowableFondsLoader;
import cz.kpsys.portaro.record.sec.EditorPermissionsConditionalCurrentAuthEditableFondsLoader;
import cz.kpsys.portaro.record.sec.FondToEditActionIdConverter;
import cz.kpsys.portaro.record.sec.FondToShowActionIdConverter;
import cz.kpsys.portaro.record.sec.UserFondsLoader;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoaderImpl;
import cz.kpsys.portaro.search.ResultConvertingPageSearchLoader;
import cz.kpsys.portaro.search.SearchingByIdLoader;
import cz.kpsys.portaro.security.SecurityAccessor;
import cz.kpsys.portaro.security.permission.ActionPermissionAccessor;
import cz.kpsys.portaro.security.permission.ActionPermissionAccessorDelegating;
import cz.kpsys.portaro.security.permission.ConditionallyPermittingActionPermissionAccessor;
import cz.kpsys.portaro.security.permission.DefaultPermissionEntity;
import cz.kpsys.portaro.security.permission.UserPermissionEntity;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.EmailUserNameGenerator;
import cz.kpsys.portaro.user.Gender;
import cz.kpsys.portaro.user.Institution;
import cz.kpsys.portaro.user.NativeNamedUser;
import cz.kpsys.portaro.user.NativeUserNameGenerator;
import cz.kpsys.portaro.user.OpenidPersonNameGenerator;
import cz.kpsys.portaro.user.Person;
import cz.kpsys.portaro.user.PhoneNumberUserNameGenerator;
import cz.kpsys.portaro.user.RoleNamesResolver;
import cz.kpsys.portaro.user.SearchingMultiTryingSuUserIdProvider;
import cz.kpsys.portaro.user.SearchingUserByUsernameLoader;
import cz.kpsys.portaro.user.SortablePersonNameGenerator;
import cz.kpsys.portaro.user.SpringDbNetIdLoader;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.UserByBasicUserLoader;
import cz.kpsys.portaro.user.UserByUsernameLoader;
import cz.kpsys.portaro.user.UserByUuidLoader;
import cz.kpsys.portaro.user.UserConstants;
import cz.kpsys.portaro.user.UserDepartmentsLoader;
import cz.kpsys.portaro.user.UserFunctions;
import cz.kpsys.portaro.user.UserLoader;
import cz.kpsys.portaro.user.UserLoaderDispatching;
import cz.kpsys.portaro.user.UserStringGenerator;
import cz.kpsys.portaro.user.UserType;
import cz.kpsys.portaro.user.UsernameSearchingUserIdProvider;
import cz.kpsys.portaro.user.UsernameUserNameGenerator;
import cz.kpsys.portaro.user.contact.SourceOfData;
import cz.kpsys.portaro.user.discount.DiscountApprovalState;
import cz.kpsys.portaro.user.prop.UserServicePropertySearchProperty;
import cz.kpsys.portaro.user.relation.RepresentableUserLoader;
import cz.kpsys.portaro.user.relation.RepresentableUserLoaderByUserRelationLoader;
import cz.kpsys.portaro.user.relation.UserRelationLoader;
import cz.kpsys.portaro.user.role.editor.EditLevel;
import cz.kpsys.portaro.user.role.editor.LibrarianGroup;
import cz.kpsys.portaro.user.role.reader.ReaderCategory;
import cz.kpsys.portaro.user.sec.CachingUserEditableDepartmentsLoader;
import cz.kpsys.portaro.user.sec.CachingUserReadableDepartmentsLoader;
import cz.kpsys.portaro.user.sec.SpringDbUserDepartmentsLoader;
import cz.kpsys.portaro.user.sec.UserDepartmentsLoaderSuEditLevelChecking;
import jakarta.persistence.EntityManager;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class UserConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserConfig.class);
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final StaticCacheFactory staticCacheFactory;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final Codebook<Department, Integer> departmentLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final CurrentAuthWebResolver currentAuthWebResolver;
    @NonNull
    private final HttpServletRequest request;
    @NonNull
    private final AllValuesProvider<Fond> enabledFondsProvider;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull List<Fond>> showableFondsDepartmentedProvider;
    private final @NonNull Provider<@Nullable Fond> desiderataFondProvider;
    @NonNull
    private final DatatypedAcceptableValuesRegistry allowedDatatypeToAllValuesProviderMap;
    @NonNull
    private final DatatypedAcceptableValuesRegistry allDatatypeToAllValuesProviderMap;
    @NonNull
    private final IdAndIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final DepartmentLocationRelationLoader departmentLocationRelationLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, Integer> userIdSearchLoader;
    @NonNull
    private final UserLoader nonCachedUserLoader;
    @NonNull
    private final UserLoader userLoader;
    @NonNull
    private final Codebook<LibrarianGroup, Integer> librarianGroupLoader;
    @NonNull
    private final SpringDbUserDepartmentsLoader editableUserDepartmentsByUserIdsLoader;
    @NonNull
    private final Codebook<ReaderCategory, String> readerCategoryLoader;
    @NonNull
    private final UserRelationLoader userRelationLoader;
    @NonNull
    private final UserByUuidLoader userByUuidLoader;
    @NonNull
    private final IdAndIdsLoadable<BasicUser, UUID> basicUserByUuidLoader;

    @Bean
    public UserStringGenerator sortableUserNameGenerator() {
        return new UserStringGenerator().addCustomGeneratorForType(Integer.valueOf(1010), Person.class, (UserStringGenerator.TypedGenerator)new SortablePersonNameGenerator()).addCustomGeneratorForType(Integer.valueOf(1020), NativeNamedUser.class, (UserStringGenerator.TypedGenerator)new NativeUserNameGenerator()).addCustomGeneratorForType(Integer.valueOf(1030), User.class, (UserStringGenerator.TypedGenerator)new UsernameUserNameGenerator()).addCustomGeneratorForType(Integer.valueOf(1040), User.class, (UserStringGenerator.TypedGenerator)new EmailUserNameGenerator()).addCustomGeneratorForType(Integer.valueOf(1050), User.class, (UserStringGenerator.TypedGenerator)new PhoneNumberUserNameGenerator()).addCustomGeneratorForType(Integer.valueOf(1060), Person.class, (UserStringGenerator.TypedGenerator)new OpenidPersonNameGenerator()).addCustomGeneratorForType(Integer.valueOf(Integer.MAX_VALUE), BasicUser.class, basicUser -> "User#%s".formatted(basicUser.getId()));
    }

    @Bean
    public ByIdLoadable<User, String> stringIdUserLoader() {
        return new UserLoaderDispatching((ByIdLoadable)this.userLoader, (ByIdLoadable)this.userByUuidLoader, this.currentAuthWebResolver, this.request);
    }

    @Bean
    public ByIdLoadable<BasicUser, String> stringIdBasicUserLoader() {
        return new UserLoaderDispatching((ByIdLoadable)this.basicUserLoader, (ByIdLoadable)this.basicUserByUuidLoader, this.currentAuthWebResolver, this.request);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, User> userSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)this.userIdSearchLoader, (AllByIdsLoadable)this.userLoader));
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, User> nonCachedUserSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)this.userIdSearchLoader, (AllByIdsLoadable)this.nonCachedUserLoader));
    }

    @Bean
    public UserByUsernameLoader userByUsernameLoader() {
        return new SearchingUserByUsernameLoader(this.userSearchLoader());
    }

    @Bean
    public ContextualProvider<Department, @NonNull Institution> institutionContextualProvider() {
        return this.nullableInstitutionContextualProvider().throwingWhenNull(ctx -> new MissingValueException("There is no institution linked with department %s. You must link your institution with department %s by linking recordId of institution (via uzivatele.id) with recordId of department (def_pujc.id) (or some department in parent hierarchy)".formatted(ctx, ctx.getId())));
    }

    @Bean
    public ContextualProvider<Department, Institution> nullableInstitutionContextualProvider() {
        SearchingByIdLoader userListPagingSearchingByIdLoader = SearchingByIdLoader.ofScalarSearchProperty(User.class, (Property)UserConstants.SearchParams.RECORD_ID, (ParameterizedSearchLoader)this.userSearchLoader());
        CastingByIdLoader institutionByLinkedDepartmentLoader = new CastingByIdLoader((ByIdLoadable)new IdConvertingByIdLoadable(department -> ListUtil.singletonListOrEmptyIfNull((Object)department.getRid()), (ByIdLoadable)userListPagingSearchingByIdLoader), Institution.class);
        return HierarchicalContextualProvider.of((HierarchyFinder)HierarchyFinderDepartmentedFactory.ofDepartment((ByIdLoadable)this.departmentLoader), arg_0 -> ((CastingByIdLoader)institutionByLinkedDepartmentLoader).findById(arg_0));
    }

    @Bean
    public Provider<@NonNull Integer> portaroUserIdProvider() {
        return new UsernameSearchingUserIdProvider(this.userIdSearchLoader, "OPAC");
    }

    @Bean
    public Provider<@NonNull User> portaroUserProvider() {
        return ProviderByIdProvider.of((ByIdLoadable)this.userLoader, (Provider)this.portaroUserIdProvider());
    }

    @Bean
    public Provider<@NonNull Integer> suUserIdProvider() {
        return new SearchingMultiTryingSuUserIdProvider((PageSearchLoader)this.userIdSearchLoader, "SU");
    }

    @Bean
    public Provider<@NonNull User> suUserProvider() {
        return ProviderByIdProvider.of((ByIdLoadable)this.userLoader, (Provider)this.suUserIdProvider());
    }

    @Bean
    public Provider<@NonNull Integer> appserverUserIdProvider() {
        return new UsernameSearchingUserIdProvider(this.userIdSearchLoader, "verbisappserver");
    }

    @Bean
    public RoleNamesResolver roleNamesResolver() {
        return new RoleNamesResolver();
    }

    @Bean
    public SecurityAccessor securityAccessor() {
        return new SecurityAccessor((CurrentAuthDepartmentsLoader)this.currentAuthEditableDepartmentsLoader(), this.departmentAccessor);
    }

    @Bean
    public CurrentAuthFondsLoader currentAuthShowableFondsLoader() {
        return new EditorPermissionsBypassingCurrentAuthShowableFondsLoader(this.currentAuthEditableFondsLoader(), (HierarchyLoader)this.departmentAccessor, this.editableDepartmentsAuthenticatedContextualProvider(), this.showableEditorFondsLoader(), this.showableFondsDepartmentedProvider);
    }

    @Bean
    public UserFondsLoader showableEditorFondsLoader() {
        ActionPermissionsEditorFondsLoader pure = new ActionPermissionsEditorFondsLoader((ActionPermissionAccessor)this.actionPermissionAccessor(), this.enabledFondsProvider, (Function)new FondToShowActionIdConverter(this.desiderataFondProvider.optionally()));
        CachingShowableEditorFondsLoader caching = new CachingShowableEditorFondsLoader((UserFondsLoader)pure);
        this.cacheService.registerCleaner(BasicUser.class.getSimpleName(), (CacheCleaner)caching);
        this.cacheService.registerSpringCacheCleaner(BasicUser.class.getSimpleName(), "showableEditorFonds");
        return caching;
    }

    @Bean
    public CurrentAuthFondsLoader currentAuthEditableFondsLoader() {
        EditorPermissionsConditionalCurrentAuthEditableFondsLoader pure = new EditorPermissionsConditionalCurrentAuthEditableFondsLoader((HierarchyLoader)this.departmentAccessor, this.editableDepartmentsAuthenticatedContextualProvider(), this.editableEditorFondsLoader());
        return new BypassableCurrentAuthFondsLoader((CurrentAuthFondsLoader)pure, this.enabledFondsProvider).bypassWhenAuth(UserAuthenticationFunctions.hasAdminAndLibrarianRole());
    }

    @Bean
    public UserFondsLoader editableEditorFondsLoader() {
        ActionPermissionsEditorFondsLoader pure = new ActionPermissionsEditorFondsLoader((ActionPermissionAccessor)this.actionPermissionAccessor(), this.enabledFondsProvider, (Function)new FondToEditActionIdConverter(this.desiderataFondProvider.optionally()));
        CachingEditableEditorFondsLoader caching = new CachingEditableEditorFondsLoader((UserFondsLoader)pure);
        this.cacheService.registerCleaner(BasicUser.class.getSimpleName(), (CacheCleaner)caching);
        this.cacheService.registerSpringCacheCleaner(BasicUser.class.getSimpleName(), "editableEditorFonds");
        return caching;
    }

    @Bean
    public AuthContextualDepartmentsLoader familyModeAuthContextualDepartmentsLoader() {
        return new FamilyModeAuthContextualDepartmentsLoader((CurrentAuthDepartmentsLoader)this.currentAuthEditableDepartmentsLoader(), this.departmentAccessor);
    }

    @Bean
    public BypassableCurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader() {
        CurrentAuthDepartmentsLoaderByUserDepartmentsLoader pure = new CurrentAuthDepartmentsLoaderByUserDepartmentsLoader(this.editableUserDepartmentsLoader(), this.departmentAccessor);
        return new BypassableCurrentAuthDepartmentsLoader((CurrentAuthDepartmentsLoader)pure, (AllValuesProvider)this.departmentLoader).bypassWhenAuth(UserAuthenticationFunctions.hasAdminAndLibrarianRole()).bypassWhenAuthUser(UserFunctions.isUser((Provider)this.portaroUserProvider()));
    }

    @Bean
    public UserDepartmentsLoader cachedEditableUserDepartmentsLoader() {
        CachingUserEditableDepartmentsLoader cached = new CachingUserEditableDepartmentsLoader((UserDepartmentsLoader)this.editableUserDepartmentsByUserIdsLoader);
        this.cacheService.registerCleaner(BasicUser.class.getSimpleName(), (CacheCleaner)cached);
        this.cacheService.registerSpringCacheCleaner(BasicUser.class.getSimpleName(), "userEditableDepartments");
        return cached;
    }

    @Bean
    public UserDepartmentsLoader editableUserDepartmentsLoader() {
        return new UserDepartmentsLoaderSuEditLevelChecking(this.cachedEditableUserDepartmentsLoader(), (UserByBasicUserLoader)this.userLoader, (AllValuesProvider)this.departmentLoader);
    }

    @Bean
    public AuthenticatedContextualProvider<Department, List<Department>> editableDepartmentsAuthenticatedContextualProvider() {
        return new EditableDepartmentsAuthenticatedContextualProvider((CurrentAuthDepartmentsLoader)this.currentAuthEditableDepartmentsLoader(), this.departmentAccessor);
    }

    @Bean
    public AuthenticatedContextualProvider<Department, List<Location>> editableLocationsAuthenticatedContextualProvider() {
        return new EditableLocationsAuthenticatedContextualProvider(this.editableDepartmentsAuthenticatedContextualProvider(), this.departmentLocationRelationLoader);
    }

    @Bean
    public UserDepartmentsLoader readableUserDepartmentsLoader() {
        SpringDbUserDepartmentsLoader pure = new SpringDbUserDepartmentsLoader(this.jdbcTemplate, this.queryFactory, this.departmentLoader, "vaz_cten_pujc", "fk_pujc", "fk_uziv_cten");
        CachingUserReadableDepartmentsLoader bean = new CachingUserReadableDepartmentsLoader((UserDepartmentsLoader)pure);
        this.cacheService.registerSpringCacheCleaner(BasicUser.class.getSimpleName(), "userReadableDepartments");
        this.cacheService.registerCleaner(BasicUser.class.getSimpleName(), (CacheCleaner)bean);
        return bean;
    }

    @Bean
    public ConditionallyPermittingActionPermissionAccessor actionPermissionAccessor() {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(2000L).build();
        ActionPermissionAccessorDelegating bean = new ActionPermissionAccessorDelegating(this.defaultPermissionDtoLoader(), this.userPermissionEntityLoader(), (UserByBasicUserLoader)this.userLoader, cache);
        this.cacheService.registerCleaner(BasicUser.class.getSimpleName(), (CacheCleaner)bean);
        return new ConditionallyPermittingActionPermissionAccessor((ActionPermissionAccessor)bean).whenUser(UserFunctions.hasSuEditLevel((UserByBasicUserLoader)this.userLoader)).permitAllActions().whenUser(UserFunctions.isUser((Provider)this.portaroUserProvider())).permitAllActions();
    }

    @Bean
    public Codebook<DefaultPermissionEntity, Integer> defaultPermissionDtoLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(DefaultPermissionEntity.class).staticCached(DefaultPermissionEntity.class.getSimpleName()).build();
    }

    @Bean
    public AllValuesProvider<UserPermissionEntity> userPermissionEntityLoader() {
        JpaAllValuesProvider loader = new JpaAllValuesProvider((JpaRepository)new SimpleJpaRepository(UserPermissionEntity.class, this.entityManager));
        StaticCache cachedLoader = this.staticCacheFactory.createStaticCache((AllValuesProvider)loader);
        this.cacheService.registerCleaner(BasicUser.class.getSimpleName(), () -> ((StaticCache)cachedLoader).clear());
        return cachedLoader;
    }

    @Bean
    public RepresentableUserLoader representableUserLoader() {
        return new RepresentableUserLoaderByUserRelationLoader(this.userRelationLoader);
    }

    @Bean
    public AllValuesProvider<String> userNetIdLoader() {
        return new SpringDbNetIdLoader(this.jdbcTemplate, this.queryFactory);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerModule() {
        this.allowedDatatypeToAllValuesProviderMap.registerEquals(UserConstants.Datatype.READER_CATEGORY, (AllValuesProvider)this.readerCategoryLoader);
        this.allDatatypeToAllValuesProviderMap.registerEquals(UserConstants.Datatype.READER_CATEGORY, (AllValuesProvider)this.readerCategoryLoader);
        this.converterRegisterer.registerForStringId(SourceOfData.class, (ByIdLoadable)SourceOfData.CODEBOOK).registerForIntegerId(LibrarianGroup.class, (ByIdLoadable)this.librarianGroupLoader).registerForIntegerId(EditLevel.class, EditLevel::fromValue).registerForStringId(ReaderCategory.class, (ByIdLoadable)this.readerCategoryLoader).registerForStringId(UserType.class, (ByIdLoadable)UserType.CODEBOOK).registerForStringId(Gender.class, (ByIdLoadable)Gender.CODEBOOK).registerForStringId(DiscountApprovalState.class, (ByIdLoadable)DiscountApprovalState.CODEBOOK).registerForValue(UserServicePropertySearchProperty.class).registerForIntegerIdWithCustomFromStringConversion(BasicUser.class, (ByIdLoadable)this.basicUserLoader, (Converter)new IdToObjectConverter(this.stringIdBasicUserLoader())).registerForIntegerIdWithCustomFromStringConversion(User.class, (ByIdLoadable)this.userLoader, (Converter)new IdToObjectConverter(this.stringIdUserLoader()));
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "entityManager", "cacheService", "staticCacheFactory", "codebookLoaderBuilderFactory", "converterRegisterer", "departmentLoader", "departmentAccessor", "currentAuthWebResolver", "request", "enabledFondsProvider", "showableFondsDepartmentedProvider", "desiderataFondProvider", "allowedDatatypeToAllValuesProviderMap", "allDatatypeToAllValuesProviderMap", "basicUserLoader", "departmentLocationRelationLoader", "userIdSearchLoader", "nonCachedUserLoader", "userLoader", "librarianGroupLoader", "editableUserDepartmentsByUserIdsLoader", "readerCategoryLoader", "userRelationLoader", "userByUuidLoader", "basicUserByUuidLoader"})
    @Generated
    public UserConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull EntityManager entityManager, @NonNull CacheService cacheService, @NonNull StaticCacheFactory staticCacheFactory, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull ConverterRegisterer converterRegisterer, @NonNull Codebook<Department, Integer> departmentLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull CurrentAuthWebResolver currentAuthWebResolver, @NonNull HttpServletRequest request, @NonNull AllValuesProvider<Fond> enabledFondsProvider, @NonNull @NonNull ContextualProvider<Department, @NonNull List<Fond>> showableFondsDepartmentedProvider, @NonNull Provider<@Nullable Fond> desiderataFondProvider, @NonNull DatatypedAcceptableValuesRegistry allowedDatatypeToAllValuesProviderMap, @NonNull DatatypedAcceptableValuesRegistry allDatatypeToAllValuesProviderMap, @NonNull IdAndIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull DepartmentLocationRelationLoader departmentLocationRelationLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, Integer> userIdSearchLoader, @NonNull UserLoader nonCachedUserLoader, @NonNull UserLoader userLoader, @NonNull Codebook<LibrarianGroup, Integer> librarianGroupLoader, @NonNull SpringDbUserDepartmentsLoader editableUserDepartmentsByUserIdsLoader, @NonNull Codebook<ReaderCategory, String> readerCategoryLoader, @NonNull UserRelationLoader userRelationLoader, @NonNull UserByUuidLoader userByUuidLoader, @NonNull IdAndIdsLoadable<BasicUser, UUID> basicUserByUuidLoader) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(staticCacheFactory, "staticCacheFactory is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(currentAuthWebResolver, "currentAuthWebResolver is marked non-null but is null");
        Objects.requireNonNull(request, "request is marked non-null but is null");
        Objects.requireNonNull(enabledFondsProvider, "enabledFondsProvider is marked non-null but is null");
        Objects.requireNonNull(showableFondsDepartmentedProvider, "showableFondsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(desiderataFondProvider, "desiderataFondProvider is marked non-null but is null");
        Objects.requireNonNull(allowedDatatypeToAllValuesProviderMap, "allowedDatatypeToAllValuesProviderMap is marked non-null but is null");
        Objects.requireNonNull(allDatatypeToAllValuesProviderMap, "allDatatypeToAllValuesProviderMap is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLocationRelationLoader, "departmentLocationRelationLoader is marked non-null but is null");
        Objects.requireNonNull(userIdSearchLoader, "userIdSearchLoader is marked non-null but is null");
        Objects.requireNonNull(nonCachedUserLoader, "nonCachedUserLoader is marked non-null but is null");
        Objects.requireNonNull(userLoader, "userLoader is marked non-null but is null");
        Objects.requireNonNull(librarianGroupLoader, "librarianGroupLoader is marked non-null but is null");
        Objects.requireNonNull(editableUserDepartmentsByUserIdsLoader, "editableUserDepartmentsByUserIdsLoader is marked non-null but is null");
        Objects.requireNonNull(readerCategoryLoader, "readerCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(userRelationLoader, "userRelationLoader is marked non-null but is null");
        Objects.requireNonNull(userByUuidLoader, "userByUuidLoader is marked non-null but is null");
        Objects.requireNonNull(basicUserByUuidLoader, "basicUserByUuidLoader is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.entityManager = entityManager;
        this.cacheService = cacheService;
        this.staticCacheFactory = staticCacheFactory;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.converterRegisterer = converterRegisterer;
        this.departmentLoader = departmentLoader;
        this.departmentAccessor = departmentAccessor;
        this.currentAuthWebResolver = currentAuthWebResolver;
        this.request = request;
        this.enabledFondsProvider = enabledFondsProvider;
        this.showableFondsDepartmentedProvider = showableFondsDepartmentedProvider;
        this.desiderataFondProvider = desiderataFondProvider;
        this.allowedDatatypeToAllValuesProviderMap = allowedDatatypeToAllValuesProviderMap;
        this.allDatatypeToAllValuesProviderMap = allDatatypeToAllValuesProviderMap;
        this.basicUserLoader = basicUserLoader;
        this.departmentLocationRelationLoader = departmentLocationRelationLoader;
        this.userIdSearchLoader = userIdSearchLoader;
        this.nonCachedUserLoader = nonCachedUserLoader;
        this.userLoader = userLoader;
        this.librarianGroupLoader = librarianGroupLoader;
        this.editableUserDepartmentsByUserIdsLoader = editableUserDepartmentsByUserIdsLoader;
        this.readerCategoryLoader = readerCategoryLoader;
        this.userRelationLoader = userRelationLoader;
        this.userByUuidLoader = userByUuidLoader;
        this.basicUserByUuidLoader = basicUserByUuidLoader;
    }
}

