/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.app.CatalogConstants;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.AuthenticationSetter;
import cz.kpsys.portaro.auth.Authenticator;
import cz.kpsys.portaro.auth.Authenticity;
import cz.kpsys.portaro.auth.ConditionalAuthenticator;
import cz.kpsys.portaro.auth.OnlyThrowingAccessDeniedHandler;
import cz.kpsys.portaro.auth.anonym.AnonymAuthConfig;
import cz.kpsys.portaro.auth.bankid.BankIDAuthConfig;
import cz.kpsys.portaro.auth.bankid.notify.BankIDNotifyConfig;
import cz.kpsys.portaro.auth.cas.CasAuthSettingKeys;
import cz.kpsys.portaro.auth.cas.CasAuthenticationRequest;
import cz.kpsys.portaro.auth.cas.CasAuthenticator;
import cz.kpsys.portaro.auth.cas.CasLogouter;
import cz.kpsys.portaro.auth.cas.CasSsoConsumer;
import cz.kpsys.portaro.auth.cas.CasSuccessAuthentication;
import cz.kpsys.portaro.auth.cas.TicketValidatorProtocolResolver;
import cz.kpsys.portaro.auth.credreg.CredentialsRegistrationAuthConfig;
import cz.kpsys.portaro.auth.current.resolver.CompositeUserAuthenticationAuthenticationResolver;
import cz.kpsys.portaro.auth.department.BooleanContextualProvidedRequestMatcher;
import cz.kpsys.portaro.auth.external.SSOAuthenticationFilter;
import cz.kpsys.portaro.auth.external.SsoConsumer;
import cz.kpsys.portaro.auth.ezak.EzakAuthConfig;
import cz.kpsys.portaro.auth.httpbasic.HttpbasicAuthConfig;
import cz.kpsys.portaro.auth.ldap.LdapAuthConfig;
import cz.kpsys.portaro.auth.logout.LogoutController;
import cz.kpsys.portaro.auth.logout.Logouter;
import cz.kpsys.portaro.auth.mojeid.MojeIDAuthConfig;
import cz.kpsys.portaro.auth.multifactor.MultifactorAuthConfig;
import cz.kpsys.portaro.auth.oauth2.authorizationcode.OAuth2AuthorizationCodeAuthConfig;
import cz.kpsys.portaro.auth.oauth2.authorizationserver.OAuth2AuthorizationServerConfig;
import cz.kpsys.portaro.auth.oauth2.jwt.JwtAuthConfig;
import cz.kpsys.portaro.auth.process.AuthoritiedSuccessAuthentication;
import cz.kpsys.portaro.auth.process.GenericAuthoritiedSuccessAuthentication;
import cz.kpsys.portaro.auth.saml2.idp.Saml2IdentityProviderConfig;
import cz.kpsys.portaro.auth.saml2.sp.Saml2ServiceProviderConfig;
import cz.kpsys.portaro.auth.sidechannel.SideChannelAuthConfig;
import cz.kpsys.portaro.auth.stringpair.StringpairAuthConfig;
import cz.kpsys.portaro.auth.switchuser.SwitchuserAuthConfig;
import cz.kpsys.portaro.auth.token.PairingAuthConfig;
import cz.kpsys.portaro.auth.token.TokenAuthConfig;
import cz.kpsys.portaro.auth.useragent.UserAgentAuthConfig;
import cz.kpsys.portaro.auth.view.AuthenticationSystemView;
import cz.kpsys.portaro.auth.view.AuthenticationSystemViewProvider;
import cz.kpsys.portaro.auth.view.LoginPageRedirectingAuthenticationSystemView;
import cz.kpsys.portaro.commons.barcode.BarCodeValidator;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.convert.StringToIntegerListConverter;
import cz.kpsys.portaro.commons.convert.StringToStringListConverter;
import cz.kpsys.portaro.commons.convert.StringToUuidConverter;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.ip.FromToIpAddressRange;
import cz.kpsys.portaro.commons.ip.IpAddress;
import cz.kpsys.portaro.commons.ip.IpAddressInRangeResolver;
import cz.kpsys.portaro.commons.ip.ListedIpAddressRange;
import cz.kpsys.portaro.commons.ip.StringToIpAddressConverter;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.ChainingStringProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.commons.web.WebResolver;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.file.FileAccessType;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.directory.AllIdsByDirectoryProvider;
import cz.kpsys.portaro.file.directory.DirectoryChainLoader;
import cz.kpsys.portaro.file.directory.DirectoryLoader;
import cz.kpsys.portaro.file.matcher.FileCategoryMatcher;
import cz.kpsys.portaro.file.matcher.FileMatchers;
import cz.kpsys.portaro.file.security.FileSecurityActions;
import cz.kpsys.portaro.file.security.SecuredFileDataStreamer;
import cz.kpsys.portaro.filter.EnhancingFilterLoader;
import cz.kpsys.portaro.filter.FilterLoader;
import cz.kpsys.portaro.filter.FilterLoaderByRowLoader;
import cz.kpsys.portaro.filter.FilterMatcherRelationDtoLoader;
import cz.kpsys.portaro.filter.FilterMatcherRelationDtoLoaderJpa;
import cz.kpsys.portaro.filter.FilterMatcherRelationEntity;
import cz.kpsys.portaro.filter.FirstExactFilter;
import cz.kpsys.portaro.filter.IdentifiedFilter;
import cz.kpsys.portaro.filter.MatcherFilter;
import cz.kpsys.portaro.filter.SpringDbFilterEntityLoader;
import cz.kpsys.portaro.hierarchy.HierarchyLoader;
import cz.kpsys.portaro.logging.TraceIdRepository;
import cz.kpsys.portaro.logging.TraceIdServletFilter;
import cz.kpsys.portaro.matcher.AlwaysMatchMatcher;
import cz.kpsys.portaro.matcher.LazyMatcher;
import cz.kpsys.portaro.matcher.Matcher;
import cz.kpsys.portaro.matcher.MatcherEntity;
import cz.kpsys.portaro.matcher.MatcherFactory;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.collection.FileRecordCollectionMatcher;
import cz.kpsys.portaro.record.collection.RecordCollectionContainQuery;
import cz.kpsys.portaro.record.detail.FieldTypeId;
import cz.kpsys.portaro.record.document.DocumentDirectoryLoader;
import cz.kpsys.portaro.record.matcher.FileDocumentMatcher;
import cz.kpsys.portaro.record.matcher.FileRecordSubfieldValueMatcher;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.ConfigurableUserByContextualIdentifierLoader;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.UserByContextualIdentifierLoader;
import cz.kpsys.portaro.user.matcher.AccessToItemAdaptingMatcher;
import cz.kpsys.portaro.user.matcher.AdministratorAllowingMatcher;
import cz.kpsys.portaro.user.matcher.BlockedUserMatcher;
import cz.kpsys.portaro.user.matcher.ConcreteUserMatcher;
import cz.kpsys.portaro.user.matcher.IpAddressMatcher;
import cz.kpsys.portaro.user.matcher.LoggedUserMatcher;
import cz.kpsys.portaro.user.matcher.ReaderCategoryMatcher;
import cz.kpsys.portaro.user.matcher.ValidRegistrationMatcher;
import cz.kpsys.portaro.user.sec.SecurityActions;
import cz.kpsys.portaro.web.UrlWebResolver;
import cz.kpsys.portaro.web.exception.ExceptionCatchingServletFilter;
import cz.kpsys.portaro.web.exception.ExceptionResponseLogger;
import cz.kpsys.portaro.web.log.MemoryIncreaseLoggingFilter;
import cz.kpsys.portaro.web.log.RequestStartLoggingFilter;
import cz.kpsys.portaro.web.log.ResponseTimeLoggingFilter;
import cz.kpsys.portaro.web.page.ExceptionModelAndViewResolver;
import cz.kpsys.portaro.web.server.ServerUrlConfiguration;
import cz.kpsys.portaro.web.url.EnforcingHttpsFilter;
import cz.kpsys.portaro.web.url.TrailingSlashRedirectingFilter;
import jakarta.persistence.EntityManager;
import jakarta.servlet.Filter;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.client.validation.TicketValidator;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.context.SecurityContextHolderFilter;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.ForwardedHeaderFilter;

@Configuration
@Import(value={AnonymAuthConfig.class, BankIDAuthConfig.class, BankIDNotifyConfig.class, CredentialsRegistrationAuthConfig.class, EzakAuthConfig.class, HttpbasicAuthConfig.class, LdapAuthConfig.class, MultifactorAuthConfig.class, OAuth2AuthorizationCodeAuthConfig.class, OAuth2AuthorizationServerConfig.class, MojeIDAuthConfig.class, PairingAuthConfig.class, JwtAuthConfig.class, Saml2IdentityProviderConfig.class, Saml2ServiceProviderConfig.class, SideChannelAuthConfig.class, StringpairAuthConfig.class, SwitchuserAuthConfig.class, TokenAuthConfig.class, UserAgentAuthConfig.class})
@EnableWebSecurity(debug=false)
public class SecurityConfig {
    public static final String ADMIN = "ADMIN";
    public static final String ACTUATOR = "ACTUATOR";
    public static final String LIBRARIAN = "LIBRARIAN";
    public static final String SERVICEMAN = "SERVICEMAN";
    @NonNull
    private final @NonNull Provider<@NonNull String> publicContextPath;
    private final @NonNull Provider<@NullableNotBlank String> rootServerUrlProvider;
    @NonNull
    private final TraceIdRepository traceIdRepository;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, User> userSearchLoader;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull BarCodeValidator> userBarCodeValidatorProvider;
    @NonNull
    private final HierarchyLoader<Department> departmentAccessor;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final WebResolver<Department> currentDepartmentWebResolver;
    @NonNull
    private final Provider<Department> currentDepartmentProvider;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final AuthenticationTrustResolver trustResolver;
    @NonNull
    private final SecurityContextRepository securityContextRepository;
    @NonNull
    private final LogoutController logoutController;
    @NonNull
    private final ByIdLoadable<User, String> stringIdUserLoader;
    @NonNull
    private final ServerUrlConfiguration serverUrlConfiguration;
    @NonNull
    private final ExceptionResponseLogger exceptionResponseLogger;
    @NonNull
    private final ExceptionModelAndViewResolver exceptionModelAndViewResolver;
    @NonNull
    private final UrlWebResolver serverUrlWebResolver;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final AllByIdsLoadable<Record, UUID> richRecordLoader;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final DirectoryLoader directoryLoader;
    @NonNull
    private final DirectoryChainLoader directoryChainLoader;
    @NonNull
    private final IpAddressInRangeResolver internalIpResolver;
    @NonNull
    private final AllIdsByDirectoryProvider allRecordIdsByDirectoryProvider;
    @NonNull
    private final FileDataStreamer fileDataStreamer;
    @NonNull
    private final FileDataStreamer fileTextDataStreamer;
    @NonNull
    private final ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader;
    @NonNull
    private final ByIdLoadable<FileAccessType, Integer> fileAccessTypeLoader;
    @NonNull
    private final Consumer<HttpSecurity> anonymAuthHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> jwtAuthHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> ezakAuthenticationHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> oauth2AuthorizationCodeAuthHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> saml2ServiceProviderHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> httpbasicAuthHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> tokenAuthHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> userAgentAuthHttpSecurityConfigurer;
    @NonNull
    private final Consumer<HttpSecurity> switchuserAuthHttpSecurityConfigurer;
    @NonNull
    private final CompositeUserAuthenticationAuthenticationResolver compositeUserAuthenticationAuthenticationResolver;
    @NonNull
    private final List<Class<? extends AuthoritiedSuccessAuthentication>> authenticationEventSavingTypes;
    @NonNull
    private final RecordCollectionContainQuery recordCollectionPersistentStorageContainQuery;
    @NonNull
    private final AuthenticationSystemViewProvider authSystemViewsListDepartmentedProvider;
    private static final String CAS_AUTH_PATH = "/login/cas";
    private static final String CAS_AUTH_PATH_OLD = "/login/jasig/authenticate";
    private static final String CAS_SERVICE_PARAMETER_NAME = "service";

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.setSharedObject(SecurityContextRepository.class, (Object)this.securityContextRepository);
        http.authenticationManager(authentication -> {
            throw new AuthenticationServiceException("Cannot use default authentication manager to authenticate %s".formatted(authentication));
        });
        http.headers(conf -> {
            conf.frameOptions(frameConf -> {
                if (((Boolean)this.settingLoader.getOnRootProvider(CoreSettingKeys.HTML_FRAME_EMBEDDING_ALLOWED).get()).booleanValue()) {
                    frameConf.disable();
                } else {
                    frameConf.sameOrigin();
                }
            });
            conf.contentTypeOptions(Customizer.withDefaults());
            conf.cacheControl(HeadersConfigurer.CacheControlConfig::disable);
        }).csrf(AbstractHttpConfigurer::disable).formLogin(AbstractHttpConfigurer::disable).httpBasic(AbstractHttpConfigurer::disable).anonymous(AbstractHttpConfigurer::disable).oauth2Login(AbstractHttpConfigurer::disable).saml2Login(AbstractHttpConfigurer::disable).logout(AbstractHttpConfigurer::disable).addFilterBefore((Filter)new TraceIdServletFilter(this.traceIdRepository), SecurityContextHolderFilter.class).addFilterAfter((Filter)new RequestStartLoggingFilter(), TraceIdServletFilter.class).addFilterAfter((Filter)new ResponseTimeLoggingFilter(), RequestStartLoggingFilter.class).addFilterAfter((Filter)new MemoryIncreaseLoggingFilter(), ResponseTimeLoggingFilter.class).addFilterAfter((Filter)new CharacterEncodingFilter(StandardCharsets.UTF_8.name(), true, true), MemoryIncreaseLoggingFilter.class).addFilterAfter((Filter)new ExceptionCatchingServletFilter(this.exceptionResponseLogger, this.exceptionModelAndViewResolver), CharacterEncodingFilter.class).addFilterAfter((Filter)new ForwardedHeaderFilter(), SecurityContextHolderFilter.class).addFilterAfter((Filter)new TrailingSlashRedirectingFilter((RequestMatcher)new NegatedRequestMatcher((RequestMatcher)new RequestHeaderRequestMatcher("X-Portaro-Skip-Trailing-Slash-Redirect")), this.publicContextPath, this.rootServerUrlProvider), ForwardedHeaderFilter.class).addFilterAfter((Filter)new EnforcingHttpsFilter((RequestMatcher)new NegatedRequestMatcher((RequestMatcher)new OrRequestMatcher(new RequestMatcher[]{new RequestHeaderRequestMatcher("X-Portaro-Skip-Https-Redirect"), PathPatternRequestMatcher.withDefaults().matcher("/.well-known/acme-challenge/**")})), this.serverUrlConfiguration, this.serverUrlWebResolver), TrailingSlashRedirectingFilter.class).exceptionHandling(conf -> {
            conf.accessDeniedHandler((AccessDeniedHandler)new OnlyThrowingAccessDeniedHandler());
            conf.withObjectPostProcessor((ObjectPostProcessor)new /* Unavailable Anonymous Inner Class!! */);
        }).addFilterAfter((Filter)this.casAuthenticationFilter(), AnonymousAuthenticationFilter.class).sessionManagement(conf -> {
            conf.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED);
            conf.sessionFixation().none();
            conf.sessionAuthenticationErrorUrl("/?showLogin=true");
        }).authorizeHttpRequests(conf -> {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher("/actuator/health/**"), PathPatternRequestMatcher.withDefaults().matcher("/actuator/info/**")})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher("/actuator/**")})).hasAnyRole(new String[]{ACTUATOR, ADMIN, SERVICEMAN, LIBRARIAN});
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher("/appserver/**")})).hasAnyRole(new String[]{ADMIN, SERVICEMAN});
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.requestMatchers(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher("/db/**")})).hasAnyRole(new String[]{ADMIN});
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)conf.anyRequest()).permitAll();
        });
        this.anonymAuthHttpSecurityConfigurer.accept(http);
        this.jwtAuthHttpSecurityConfigurer.accept(http);
        this.httpbasicAuthHttpSecurityConfigurer.accept(http);
        this.oauth2AuthorizationCodeAuthHttpSecurityConfigurer.accept(http);
        this.saml2ServiceProviderHttpSecurityConfigurer.accept(http);
        this.ezakAuthenticationHttpSecurityConfigurer.accept(http);
        this.tokenAuthHttpSecurityConfigurer.accept(http);
        this.userAgentAuthHttpSecurityConfigurer.accept(http);
        this.switchuserAuthHttpSecurityConfigurer.accept(http);
        return (SecurityFilterChain)http.build();
    }

    private SSOAuthenticationFilter<CasAuthenticationRequest, CasSuccessAuthentication> casAuthenticationFilter() {
        CasSsoConsumer consumer = new CasSsoConsumer(CAS_SERVICE_PARAMETER_NAME, this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_LOGIN_URL).throwingWhenNull().invalidWhen(String::isBlank), this.serverUrlWebResolver, CAS_AUTH_PATH, "redirect", this.serverUrlConfiguration, this.currentDepartmentWebResolver);
        SimpleUrlAuthenticationSuccessHandler successHandler = new SimpleUrlAuthenticationSuccessHandler();
        successHandler.setTargetUrlParameter("redirect");
        return new SSOAuthenticationFilter((RequestMatcher)new AndRequestMatcher(new RequestMatcher[]{new BooleanContextualProvidedRequestMatcher(this.currentDepartmentWebResolver, this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_ENABLED)), new OrRequestMatcher(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher(CAS_AUTH_PATH), PathPatternRequestMatcher.withDefaults().matcher(CAS_AUTH_PATH_OLD)})}), (SsoConsumer)consumer, this.casAuthenticator(), (AuthenticationSuccessHandler)successHandler, (AuthenticationSetter)this.authenticationHolder, (AuthenticationDetailsSource)new WebAuthenticationDetailsSource());
    }

    @Bean
    public Authenticator<CasAuthenticationRequest, CasSuccessAuthentication> casAuthenticator() {
        CasAuthenticator casAuthenticator = new CasAuthenticator(this.casTicketValidatorProvider(), this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_USER_ASSERTION_ATTRIBUTE), this.userByCasIdentifierLoader());
        ConditionalAuthenticator conditionalAuthenticator = new ConditionalAuthenticator(this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_ENABLED).toEnabledAsserter(value -> value, "CAS auth", null), (Authenticator)casAuthenticator);
        this.compositeUserAuthenticationAuthenticationResolver.withAuthenticatedUserResolverOf(CasSuccessAuthentication.class, GenericAuthoritiedSuccessAuthentication::getActiveUser).withAdditionalAuthoritiesResolverOf(CasSuccessAuthentication.class, AbstractAuthenticationToken::getAuthorities).withAuthenticityResolverOf(CasSuccessAuthentication.class, auth -> Authenticity.ONE_CONFIDENTAL_FACTOR_OR_BETTER);
        this.authenticationEventSavingTypes.add(CasSuccessAuthentication.class);
        return conditionalAuthenticator;
    }

    @Bean
    public ContextualProvider<Department, @NonNull TicketValidator> casTicketValidatorProvider() {
        return this.casSystemUrlProvider().andThenContextual((BiFunction)new TicketValidatorProtocolResolver(this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_TICKET_VALIDATOR_PROTOCOL), CAS_SERVICE_PARAMETER_NAME));
    }

    @Bean
    public CasLogouter casLogouter() {
        CasLogouter bean = new CasLogouter(CAS_SERVICE_PARAMETER_NAME, this.currentDepartmentWebResolver, this.casSystemUrlProvider(), this.serverUrlWebResolver);
        this.logoutController.addLogouter((Logouter)bean);
        return bean;
    }

    @Bean
    public ContextualProvider<Department, String> casSystemUrlProvider() {
        return this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_SYSTEM_URL).throwingWhenNull();
    }

    @Bean
    public UserByContextualIdentifierLoader<User> userByCasIdentifierLoader() {
        return new ConfigurableUserByContextualIdentifierLoader(this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_USER_IDENTIFIER), this.stringIdUserLoader, this.userSearchLoader, this.userBarCodeValidatorProvider, this.departmentAccessor);
    }

    @Bean
    public FilterLoader databasedFilterLoader() {
        MatcherFactory matcherFactory = new MatcherFactory();
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_ALWAYS_MATCH, dto -> new AlwaysMatchMatcher().withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_CONCRETE_USER, dto -> new ConcreteUserMatcher((List)new StringToIntegerListConverter(",").convert((Object)dto.getValue())).withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_ADMINISTRATOR_LOGGED_USER, dto -> new AdministratorAllowingMatcher().withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_IP_ADDRESS, dto -> {
            List ipAddresses = ListUtil.convert((Iterable)ListUtil.toList((String)dto.getValue(), (String)","), (Converter)new StringToIpAddressConverter());
            return new IpAddressMatcher((IpAddressInRangeResolver)new ListedIpAddressRange(ipAddresses)).withSourceOf(dto);
        });
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_IP_ADDRESS_RANGE, dto -> {
            List ipAddressPair = ListUtil.convert((Iterable)ListUtil.toList((String)dto.getValue(), (String)","), (Converter)new StringToIpAddressConverter());
            Assert.state((ipAddressPair.size() == 2 ? 1 : 0) != 0, (String)"IpAddressRange must have exactly 2 items");
            return new IpAddressMatcher((IpAddressInRangeResolver)new FromToIpAddressRange((IpAddress)ipAddressPair.get(0), (IpAddress)ipAddressPair.get(1))).withSourceOf(dto);
        });
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_INTERNAL_IP, dto -> new IpAddressMatcher(this.internalIpResolver).withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_LOGGED_USER, dto -> new LoggedUserMatcher().withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_BLOCKED_USER, dto -> new BlockedUserMatcher().withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_VALID_REGISTRATION, dto -> new ValidRegistrationMatcher().withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_READER_CATEGORY, dto -> new ReaderCategoryMatcher(new StringToStringListConverter().throwOnBlankItems().convert(dto.getValue())).withSourceOf(dto));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_FILE_ACCESS_TYPE, dto -> new AccessToItemAdaptingMatcher((Matcher)this.fileMatchers().accessTypeIs(dto, dto.getValue())));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_FILE_CATEGORY, dto -> new AccessToItemAdaptingMatcher((Matcher)new FileCategoryMatcher((Collection)new StringToIntegerListConverter().convert((Object)dto.getValue())).withSourceOf(dto)));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_FILE_DIRECTORY_INHERITING_ACCESS_TYPE, dto -> new AccessToItemAdaptingMatcher((Matcher)this.fileMatchers().thisOrParentDirectory((Matcher)this.fileMatchers().accessTypeIs(dto, dto.getValue()))));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_FILE_DOCUMENT, dto -> new AccessToItemAdaptingMatcher((Matcher)new FileDocumentMatcher((List)StringToUuidConverter.DELIMITED_LIST_CONVERTER.convert((Object)dto.getValue()), this.allRecordIdsByDirectoryProvider, this.directoryChainLoader).withSourceOf(dto)));
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_FILE_DOCUMENT_SUBFIELD_VALUE, dto -> {
            List keyValue = ListUtil.toList((String)dto.getValue(), (String)"=");
            return new AccessToItemAdaptingMatcher((Matcher)new FileRecordSubfieldValueMatcher(this.directoryChainLoader, this.allRecordIdsByDirectoryProvider, this.richRecordLoader, FieldTypeId.parseSubfield((String)((String)keyValue.get(0))), (String)keyValue.get(1)).withSourceOf(dto));
        });
        matcherFactory.register(CatalogConstants.MatcherTypes.MATCHER_FILE_DOCUMENT_COLLECTION, dto -> new AccessToItemAdaptingMatcher((Matcher)new FileRecordCollectionMatcher(new DocumentDirectoryLoader(this.directoryChainLoader, (ByIdLoadable)this.directoryLoader, this.allRecordIdsByDirectoryProvider), this.recordCollectionPersistentStorageContainQuery, StringToUuidConverter.INSTANCE.convert(dto.getValue())).withSourceOf(dto)));
        IdAndIdsLoadable matcherLoader = this.modelBeanBuilder.allByIdsLoader(MatcherEntity.class);
        FilterMatcherRelationDtoLoaderJpa filterMatcherRelationDtoLoader = new FilterMatcherRelationDtoLoaderJpa((JpaRepository)new SimpleJpaRepository(FilterMatcherRelationEntity.class, this.entityManager));
        SpringDbFilterEntityLoader filterEntityLoader = new SpringDbFilterEntityLoader(this.jdbcTemplate, this.queryFactory, (FilterMatcherRelationDtoLoader)filterMatcherRelationDtoLoader, (AllByIdsLoadable)matcherLoader);
        FilterLoaderByRowLoader bean = new FilterLoaderByRowLoader(filterEntityLoader, matcherFactory);
        this.cacheService.registerSpringCacheCleaner(IdentifiedFilter.class.getSimpleName(), "filterByRootId");
        return bean;
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public FilterLoader filterLoader() {
        FirstExactFilter showFilter = new FirstExactFilter(Integer.valueOf(1000001), List.of(MatcherFilter.ofDenyOnMatchElseNext((Integer)1000002, (Matcher)LazyMatcher.create(() -> ((FileMatchers)this.fileMatchers()).adminFileAccessTypeAndNotAdminLogged()), (Text)Texts.ofNative((String)"File is accessible only for administrators")), MatcherFilter.ofDenyOnMatchElseNext((Integer)1000003, (Matcher)LazyMatcher.create(() -> ((FileMatchers)this.fileMatchers()).editorFileAccessTypeAndNotEditorLogged()), (Text)Texts.ofNative((String)"File is accessible only for editors")), MatcherFilter.ofDenyOnMatchElseNext((Integer)1000004, (Matcher)LazyMatcher.create(() -> ((FileMatchers)this.fileMatchers()).loggedReadonlyFileAccessTypeAndNotLogged()), (Text)Texts.ofNative((String)"File is accessible only for logged users")), MatcherFilter.ofDenyOnMatchElseNext((Integer)1000005, (Matcher)LazyMatcher.create(() -> ((FileMatchers)this.fileMatchers()).loggedReadonlyFileDirAccessTypeAndNotLogged()), (Text)Texts.ofNative((String)"Whole directory of file is accessible only for logged users"))));
        FirstExactFilter exportFilter = new FirstExactFilter(Integer.valueOf(1000101), List.of(MatcherFilter.ofDenyOnMatchElseNext((Integer)1000102, (Matcher)LazyMatcher.create(() -> ((FileMatchers)this.fileMatchers()).anyReadonlyFileAccessTypeAndNotAdminLogged()), (Text)Texts.ofNative((String)"File is accessible only for read (cannot print or export)")), MatcherFilter.ofDenyOnMatchElseNext((Integer)1000103, (Matcher)LazyMatcher.create(() -> ((FileMatchers)this.fileMatchers()).anyReadonlyFileDirAccessTypeAndNotAdminLogged()), (Text)Texts.ofNative((String)"Whole directory of file is accessible only for read (cannot print or export)"))));
        FirstExactFilter thumbnailShowFilter = new FirstExactFilter(Integer.valueOf(1000201), List.of(MatcherFilter.ofDenyOnMatchElseNext((Integer)1000202, (Matcher)LazyMatcher.create(() -> ((FileMatchers)this.fileMatchers()).adminFileAccessTypeAndNotAdminLogged()), (Text)Texts.ofNative((String)"File is accessible only for administrators")), MatcherFilter.ofDenyOnMatchElseNext((Integer)1000203, (Matcher)LazyMatcher.create(() -> ((FileMatchers)this.fileMatchers()).editorFileAccessTypeAndNotEditorLogged()), (Text)Texts.ofNative((String)"File is accessible only for editors"))));
        return new EnhancingFilterLoader(Map.of(1, showFilter, 2, exportFilter, 5, thumbnailShowFilter), this.databasedFilterLoader());
    }

    @NonNull
    private FileMatchers fileMatchers() {
        return new FileMatchers(this.directoryChainLoader, this.fileAccessTypeLoader);
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public FileDataStreamer securedFileDataStreamer() {
        return new SecuredFileDataStreamer(this.fileDataStreamer, this.authenticationHolder, this.identifiedFileLoader, this.securityManager, this.currentDepartmentProvider, FileSecurityActions.FILE_SHOW);
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public FileDataStreamer securedFileTextDataStreamer() {
        return new SecuredFileDataStreamer(this.fileTextDataStreamer, this.authenticationHolder, this.identifiedFileLoader, this.securityManager, this.currentDepartmentProvider, FileSecurityActions.FILE_EXPORT);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerProviders() {
        this.authSystemViewsListDepartmentedProvider.ifAdd(arg_0 -> ((ContextualProvider)this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_ENABLED)).getOn(arg_0), (AuthenticationSystemView)new LoginPageRedirectingAuthenticationSystemView("cas", (Provider)ChainingStringProvider.ofFixedSuffix((Provider)this.publicContextPath, (String)"/login/cas?redirect={currentUrl}")), Integer.valueOf(300));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(SecurityActions.AUTH_SWITCH_ACTIVE_USER, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActive(), this.permissionFactory.subjectUserIsEvided(), (auth, ctx, targetUser) -> !auth.getActiveUser().equals(targetUser) ? PermissionResult.allow() : PermissionResult.pointless((Text)Texts.ofNative((String)"Cannot switch to yourself")), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN"}), (auth, ctx, targetUser) -> auth.getAuthenticatedUser().equals(targetUser) ? PermissionResult.allow() : PermissionResult.forbid(), this.permissionFactory.canRepresentUser()})}));
    }

    @ConstructorProperties(value={"publicContextPath", "rootServerUrlProvider", "traceIdRepository", "entityManager", "modelBeanBuilder", "userSearchLoader", "userBarCodeValidatorProvider", "departmentAccessor", "settingLoader", "currentDepartmentWebResolver", "currentDepartmentProvider", "authenticationHolder", "permissionRegistry", "permissionFactory", "securityManager", "trustResolver", "securityContextRepository", "logoutController", "stringIdUserLoader", "serverUrlConfiguration", "exceptionResponseLogger", "exceptionModelAndViewResolver", "serverUrlWebResolver", "jdbcTemplate", "queryFactory", "richRecordLoader", "cacheService", "directoryLoader", "directoryChainLoader", "internalIpResolver", "allRecordIdsByDirectoryProvider", "fileDataStreamer", "fileTextDataStreamer", "identifiedFileLoader", "fileAccessTypeLoader", "anonymAuthHttpSecurityConfigurer", "jwtAuthHttpSecurityConfigurer", "ezakAuthenticationHttpSecurityConfigurer", "oauth2AuthorizationCodeAuthHttpSecurityConfigurer", "saml2ServiceProviderHttpSecurityConfigurer", "httpbasicAuthHttpSecurityConfigurer", "tokenAuthHttpSecurityConfigurer", "userAgentAuthHttpSecurityConfigurer", "switchuserAuthHttpSecurityConfigurer", "compositeUserAuthenticationAuthenticationResolver", "authenticationEventSavingTypes", "recordCollectionPersistentStorageContainQuery", "authSystemViewsListDepartmentedProvider"})
    @Generated
    public SecurityConfig(@NonNull @NonNull Provider<@NonNull String> publicContextPath, @NonNull Provider<@NullableNotBlank String> rootServerUrlProvider, @NonNull TraceIdRepository traceIdRepository, @NonNull EntityManager entityManager, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull ParameterizedSearchLoader<MapBackedParams, User> userSearchLoader, @NonNull @NonNull ContextualProvider<Department, @NonNull BarCodeValidator> userBarCodeValidatorProvider, @NonNull HierarchyLoader<Department> departmentAccessor, @NonNull SettingLoader settingLoader, @NonNull WebResolver<Department> currentDepartmentWebResolver, @NonNull Provider<Department> currentDepartmentProvider, @NonNull AuthenticationHolder authenticationHolder, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull SecurityManager securityManager, @NonNull AuthenticationTrustResolver trustResolver, @NonNull SecurityContextRepository securityContextRepository, @NonNull LogoutController logoutController, @NonNull ByIdLoadable<User, String> stringIdUserLoader, @NonNull ServerUrlConfiguration serverUrlConfiguration, @NonNull ExceptionResponseLogger exceptionResponseLogger, @NonNull ExceptionModelAndViewResolver exceptionModelAndViewResolver, @NonNull UrlWebResolver serverUrlWebResolver, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull AllByIdsLoadable<Record, UUID> richRecordLoader, @NonNull CacheService cacheService, @NonNull DirectoryLoader directoryLoader, @NonNull DirectoryChainLoader directoryChainLoader, @NonNull IpAddressInRangeResolver internalIpResolver, @NonNull AllIdsByDirectoryProvider allRecordIdsByDirectoryProvider, @NonNull FileDataStreamer fileDataStreamer, @NonNull FileDataStreamer fileTextDataStreamer, @NonNull ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader, @NonNull ByIdLoadable<FileAccessType, Integer> fileAccessTypeLoader, @NonNull Consumer<HttpSecurity> anonymAuthHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> jwtAuthHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> ezakAuthenticationHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> oauth2AuthorizationCodeAuthHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> saml2ServiceProviderHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> httpbasicAuthHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> tokenAuthHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> userAgentAuthHttpSecurityConfigurer, @NonNull Consumer<HttpSecurity> switchuserAuthHttpSecurityConfigurer, @NonNull CompositeUserAuthenticationAuthenticationResolver compositeUserAuthenticationAuthenticationResolver, @NonNull List<Class<? extends AuthoritiedSuccessAuthentication>> authenticationEventSavingTypes, @NonNull RecordCollectionContainQuery recordCollectionPersistentStorageContainQuery, @NonNull AuthenticationSystemViewProvider authSystemViewsListDepartmentedProvider) {
        Objects.requireNonNull(publicContextPath, "publicContextPath is marked non-null but is null");
        Objects.requireNonNull(rootServerUrlProvider, "rootServerUrlProvider is marked non-null but is null");
        Objects.requireNonNull(traceIdRepository, "traceIdRepository is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(userSearchLoader, "userSearchLoader is marked non-null but is null");
        Objects.requireNonNull(userBarCodeValidatorProvider, "userBarCodeValidatorProvider is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(currentDepartmentWebResolver, "currentDepartmentWebResolver is marked non-null but is null");
        Objects.requireNonNull(currentDepartmentProvider, "currentDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(trustResolver, "trustResolver is marked non-null but is null");
        Objects.requireNonNull(securityContextRepository, "securityContextRepository is marked non-null but is null");
        Objects.requireNonNull(logoutController, "logoutController is marked non-null but is null");
        Objects.requireNonNull(stringIdUserLoader, "stringIdUserLoader is marked non-null but is null");
        Objects.requireNonNull(serverUrlConfiguration, "serverUrlConfiguration is marked non-null but is null");
        Objects.requireNonNull(exceptionResponseLogger, "exceptionResponseLogger is marked non-null but is null");
        Objects.requireNonNull(exceptionModelAndViewResolver, "exceptionModelAndViewResolver is marked non-null but is null");
        Objects.requireNonNull(serverUrlWebResolver, "serverUrlWebResolver is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(richRecordLoader, "richRecordLoader is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(directoryLoader, "directoryLoader is marked non-null but is null");
        Objects.requireNonNull(directoryChainLoader, "directoryChainLoader is marked non-null but is null");
        Objects.requireNonNull(internalIpResolver, "internalIpResolver is marked non-null but is null");
        Objects.requireNonNull(allRecordIdsByDirectoryProvider, "allRecordIdsByDirectoryProvider is marked non-null but is null");
        Objects.requireNonNull(fileDataStreamer, "fileDataStreamer is marked non-null but is null");
        Objects.requireNonNull(fileTextDataStreamer, "fileTextDataStreamer is marked non-null but is null");
        Objects.requireNonNull(identifiedFileLoader, "identifiedFileLoader is marked non-null but is null");
        Objects.requireNonNull(fileAccessTypeLoader, "fileAccessTypeLoader is marked non-null but is null");
        Objects.requireNonNull(anonymAuthHttpSecurityConfigurer, "anonymAuthHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(jwtAuthHttpSecurityConfigurer, "jwtAuthHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(ezakAuthenticationHttpSecurityConfigurer, "ezakAuthenticationHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(oauth2AuthorizationCodeAuthHttpSecurityConfigurer, "oauth2AuthorizationCodeAuthHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(saml2ServiceProviderHttpSecurityConfigurer, "saml2ServiceProviderHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(httpbasicAuthHttpSecurityConfigurer, "httpbasicAuthHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(tokenAuthHttpSecurityConfigurer, "tokenAuthHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(userAgentAuthHttpSecurityConfigurer, "userAgentAuthHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(switchuserAuthHttpSecurityConfigurer, "switchuserAuthHttpSecurityConfigurer is marked non-null but is null");
        Objects.requireNonNull(compositeUserAuthenticationAuthenticationResolver, "compositeUserAuthenticationAuthenticationResolver is marked non-null but is null");
        Objects.requireNonNull(authenticationEventSavingTypes, "authenticationEventSavingTypes is marked non-null but is null");
        Objects.requireNonNull(recordCollectionPersistentStorageContainQuery, "recordCollectionPersistentStorageContainQuery is marked non-null but is null");
        Objects.requireNonNull(authSystemViewsListDepartmentedProvider, "authSystemViewsListDepartmentedProvider is marked non-null but is null");
        this.publicContextPath = publicContextPath;
        this.rootServerUrlProvider = rootServerUrlProvider;
        this.traceIdRepository = traceIdRepository;
        this.entityManager = entityManager;
        this.modelBeanBuilder = modelBeanBuilder;
        this.userSearchLoader = userSearchLoader;
        this.userBarCodeValidatorProvider = userBarCodeValidatorProvider;
        this.departmentAccessor = departmentAccessor;
        this.settingLoader = settingLoader;
        this.currentDepartmentWebResolver = currentDepartmentWebResolver;
        this.currentDepartmentProvider = currentDepartmentProvider;
        this.authenticationHolder = authenticationHolder;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.securityManager = securityManager;
        this.trustResolver = trustResolver;
        this.securityContextRepository = securityContextRepository;
        this.logoutController = logoutController;
        this.stringIdUserLoader = stringIdUserLoader;
        this.serverUrlConfiguration = serverUrlConfiguration;
        this.exceptionResponseLogger = exceptionResponseLogger;
        this.exceptionModelAndViewResolver = exceptionModelAndViewResolver;
        this.serverUrlWebResolver = serverUrlWebResolver;
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.richRecordLoader = richRecordLoader;
        this.cacheService = cacheService;
        this.directoryLoader = directoryLoader;
        this.directoryChainLoader = directoryChainLoader;
        this.internalIpResolver = internalIpResolver;
        this.allRecordIdsByDirectoryProvider = allRecordIdsByDirectoryProvider;
        this.fileDataStreamer = fileDataStreamer;
        this.fileTextDataStreamer = fileTextDataStreamer;
        this.identifiedFileLoader = identifiedFileLoader;
        this.fileAccessTypeLoader = fileAccessTypeLoader;
        this.anonymAuthHttpSecurityConfigurer = anonymAuthHttpSecurityConfigurer;
        this.jwtAuthHttpSecurityConfigurer = jwtAuthHttpSecurityConfigurer;
        this.ezakAuthenticationHttpSecurityConfigurer = ezakAuthenticationHttpSecurityConfigurer;
        this.oauth2AuthorizationCodeAuthHttpSecurityConfigurer = oauth2AuthorizationCodeAuthHttpSecurityConfigurer;
        this.saml2ServiceProviderHttpSecurityConfigurer = saml2ServiceProviderHttpSecurityConfigurer;
        this.httpbasicAuthHttpSecurityConfigurer = httpbasicAuthHttpSecurityConfigurer;
        this.tokenAuthHttpSecurityConfigurer = tokenAuthHttpSecurityConfigurer;
        this.userAgentAuthHttpSecurityConfigurer = userAgentAuthHttpSecurityConfigurer;
        this.switchuserAuthHttpSecurityConfigurer = switchuserAuthHttpSecurityConfigurer;
        this.compositeUserAuthenticationAuthenticationResolver = compositeUserAuthenticationAuthenticationResolver;
        this.authenticationEventSavingTypes = authenticationEventSavingTypes;
        this.recordCollectionPersistentStorageContainQuery = recordCollectionPersistentStorageContainQuery;
        this.authSystemViewsListDepartmentedProvider = authSystemViewsListDepartmentedProvider;
    }
}

