/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.auth.context.AuthenticatedContextualFunction;
import cz.kpsys.portaro.auth.context.AuthenticatedContextualProvider;
import cz.kpsys.portaro.commons.cache.CacheBackedRepository;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheCleaningSaver;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.DynamicCache;
import cz.kpsys.portaro.commons.cache.GuavaTimedDynamicCache;
import cz.kpsys.portaro.commons.contextual.CompositeAllValuesContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualFunction;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.localization.MultiText;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.CompositeAddableAllValuesProvider;
import cz.kpsys.portaro.commons.object.CompositeAllValuesProvider;
import cz.kpsys.portaro.commons.object.ConvertingAllValuesProvider;
import cz.kpsys.portaro.commons.object.FallbackingSettableProvider;
import cz.kpsys.portaro.commons.object.Identified;
import cz.kpsys.portaro.commons.object.LabeledId;
import cz.kpsys.portaro.commons.object.LabeledIdentified;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.SameTypeSettableProvider;
import cz.kpsys.portaro.commons.object.StaticCodebook;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadableByIdLoaderAdapter;
import cz.kpsys.portaro.commons.object.repo.AllProvidingRepository;
import cz.kpsys.portaro.commons.object.repo.AllValuesProvidedCodebook;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdOptLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.CompositeByIdLoader;
import cz.kpsys.portaro.commons.object.repo.DefaultProvider;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.PostConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Repository;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.util.ObjectUtil;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.core.editor.DispatchingSearchValueEditorLoader;
import cz.kpsys.portaro.database.FlushingJpaSaver;
import cz.kpsys.portaro.datatype.DatatypableStringConverter;
import cz.kpsys.portaro.datatype.DatatypedAcceptableValuesRegistry;
import cz.kpsys.portaro.datatype.ScalarDatatype;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.exemplar.ExemplarConstants;
import cz.kpsys.portaro.file.FileConstants;
import cz.kpsys.portaro.file.FileSearchParams;
import cz.kpsys.portaro.hierarchy.HierarchyLoader;
import cz.kpsys.portaro.inventory.InventoryConstants;
import cz.kpsys.portaro.loan.LoanConstants;
import cz.kpsys.portaro.loan.reminder.LoanReminderConstants;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.messages.constants.MessageConstants;
import cz.kpsys.portaro.payment.PaymentConstants;
import cz.kpsys.portaro.record.RecordConstants;
import cz.kpsys.portaro.record.RecordHeaderToLuceneValueConverter;
import cz.kpsys.portaro.record.RecordIdFondPair;
import cz.kpsys.portaro.record.datasource.Datasource;
import cz.kpsys.portaro.record.document.SpringDbKat14YearExtremesLoader;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.isbn.IsbnChecker;
import cz.kpsys.portaro.record.isbn.IsbnDisjunctionAddingTermConverter;
import cz.kpsys.portaro.record.search.KeywordsParserAppserver;
import cz.kpsys.portaro.record.search.RawableSearchServiceCacheResolver;
import cz.kpsys.portaro.record.search.SubkindFieldTermToFondListConverter;
import cz.kpsys.portaro.record.search.restriction.AuthorityFieldsSearchParamsRestrictionModifier;
import cz.kpsys.portaro.record.search.restriction.CommonAuthorityParamsConjunctionModifier;
import cz.kpsys.portaro.record.search.restriction.CommonDocumentParamsConjunctionModifier;
import cz.kpsys.portaro.record.search.restriction.DocumentFieldsSearchParamsRestrictionModifier;
import cz.kpsys.portaro.record.search.restriction.FieldedQAddingConjunctionModifier;
import cz.kpsys.portaro.record.search.restriction.RawQueryAddingConjunctionModifier;
import cz.kpsys.portaro.record.search.restriction.RecordSearchParamsStringQueryBuilder;
import cz.kpsys.portaro.record.sec.CurrentAuthFondsLoader;
import cz.kpsys.portaro.search.CacheMode;
import cz.kpsys.portaro.search.CoreSearchParams;
import cz.kpsys.portaro.search.DefaultGettableAndSettableSearchParams;
import cz.kpsys.portaro.search.DetailLevel;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.MapToMapSearchParamsConverter;
import cz.kpsys.portaro.search.MappableSearchParamsRegistry;
import cz.kpsys.portaro.search.Paging;
import cz.kpsys.portaro.search.Search;
import cz.kpsys.portaro.search.SearchConstants;
import cz.kpsys.portaro.search.facet.FacetDefinitionType;
import cz.kpsys.portaro.search.facet.FacetScope;
import cz.kpsys.portaro.search.facet.FacetType;
import cz.kpsys.portaro.search.facet.FacetTypeCreator;
import cz.kpsys.portaro.search.facet.FacetTypeEntity;
import cz.kpsys.portaro.search.facet.FacetTypeFromEntityConverter;
import cz.kpsys.portaro.search.facet.FacetTypeSorting;
import cz.kpsys.portaro.search.facet.FacetTypeToEntityConverter;
import cz.kpsys.portaro.search.facet.FacetTypeUpdater;
import cz.kpsys.portaro.search.facet.SpringDbFacetTypeLoader;
import cz.kpsys.portaro.search.factory.SearchFactoryResolver;
import cz.kpsys.portaro.search.field.CustomSearchField;
import cz.kpsys.portaro.search.field.CustomSearchFieldEntity;
import cz.kpsys.portaro.search.field.DatatypeBySearchFieldLoader;
import cz.kpsys.portaro.search.field.EntityToCustomSearchFieldConverter;
import cz.kpsys.portaro.search.field.QueryFieldsBySearchFieldLoader;
import cz.kpsys.portaro.search.field.SearchField;
import cz.kpsys.portaro.search.field.StaticSearchFields;
import cz.kpsys.portaro.search.history.SearchHistoryImpl;
import cz.kpsys.portaro.search.keywords.SearchedKeywordsLoader;
import cz.kpsys.portaro.search.keywords.SearchedKeywordsSaver;
import cz.kpsys.portaro.search.keywords.SpringDbSearchedKeywordsLoader;
import cz.kpsys.portaro.search.keywords.SpringDbSearchedKeywordsSaver;
import cz.kpsys.portaro.search.lucene.FacetKeyIdentified;
import cz.kpsys.portaro.search.lucene.KeywordsParser;
import cz.kpsys.portaro.search.lucene.QToLuceneQueryConverterByPattern;
import cz.kpsys.portaro.search.params.DefaultParamsModifier;
import cz.kpsys.portaro.search.params.ParamsModifier;
import cz.kpsys.portaro.search.restriction.Restriction;
import cz.kpsys.portaro.search.restriction.convert.MatchingCompositeTermConverter;
import cz.kpsys.portaro.search.restriction.convert.RestrictionDeserializer;
import cz.kpsys.portaro.search.restriction.convert.RestrictionDeserializerWithSearchFields;
import cz.kpsys.portaro.search.restriction.convert.RestrictionSerializer;
import cz.kpsys.portaro.search.restriction.convert.SingleStringMatcherValueTermMatcher;
import cz.kpsys.portaro.search.restriction.deserialize.json.RestrictionDeserializerPostModifyingDecorator;
import cz.kpsys.portaro.search.restriction.matcher.GtEq;
import cz.kpsys.portaro.search.restriction.matcher.In;
import cz.kpsys.portaro.search.restriction.matcher.Lt;
import cz.kpsys.portaro.search.restriction.matcher.LtEq;
import cz.kpsys.portaro.search.restriction.modifier.RestrictionModifier;
import cz.kpsys.portaro.search.restriction.serialize.lucene.DatatypeBySearchFieldLoaderByLuceneQueryFieldLoader;
import cz.kpsys.portaro.search.restriction.serialize.lucene.DispatchingLuceneQueryFieldLoader;
import cz.kpsys.portaro.search.restriction.serialize.lucene.DispatchingLuceneSortFieldLoader;
import cz.kpsys.portaro.search.restriction.serialize.lucene.IdToLuceneValueConverter;
import cz.kpsys.portaro.search.restriction.serialize.lucene.IdentifiedToLuceneValueConverter;
import cz.kpsys.portaro.search.restriction.serialize.lucene.InstantToLuceneValueConverter;
import cz.kpsys.portaro.search.restriction.serialize.lucene.LocalDateToLuceneValueConverter;
import cz.kpsys.portaro.search.restriction.serialize.lucene.LuceneQueryField;
import cz.kpsys.portaro.search.restriction.serialize.lucene.RestrictionToLuceneQueryConverterBuilder;
import cz.kpsys.portaro.search.restriction.serialize.lucene.StringToLuceneValueConverter;
import cz.kpsys.portaro.search.restriction.serialize.lucene.UuidToLuceneValueConverter;
import cz.kpsys.portaro.search.view.CompositeSearchFormFactory;
import cz.kpsys.portaro.search.view.DepartmentedSearchFieldToViewableSearchFieldConverter;
import cz.kpsys.portaro.search.view.EmptySearchTextResolver;
import cz.kpsys.portaro.search.view.SearchTextResolver;
import cz.kpsys.portaro.search.view.SearchTitleResolver;
import cz.kpsys.portaro.search.view.SearchValueEditorLoader;
import cz.kpsys.portaro.search.view.ViewableSearchField;
import cz.kpsys.portaro.search.view.ViewableSearchFieldsContextualProvider;
import cz.kpsys.portaro.setting.FondedValues;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sorting.SortingItem;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.stats.StatsConstants;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.UserConstants;
import cz.kpsys.portaro.view.ViewFormat;
import cz.kpsys.portaro.view.ViewableItemsConverter;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.Range;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class SearchConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchConfig.class);
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final NamedParameterJdbcOperations notCriticalJdbcTemplate;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final DatatypableStringConverter datatypableStringConverter;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final SimpleModule objectMapperModule;
    @NonNull
    private final SettingLoader settingLoader;
    private final @NonNull ByIdLoadable<@Nullable AllValuesProvider<? extends LabeledIdentified<?>>, ScalarDatatype> acceptableValuesProviderLoader;
    @NonNull
    private final CurrentAuthFondsLoader currentAuthShowableFondsLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final ContextualProvider<Department, List<Location>> readableLocationsContextualProvider;
    @NonNull
    private final AllValuesProvider<Fond> enabledFondsProvider;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final DatatypedAcceptableValuesRegistry allowedDatatypeToAllValuesProviderMap;
    @NonNull
    private final DatatypedAcceptableValuesRegistry allDatatypeToAllValuesProviderMap;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final FormattingConversionService conversionService;
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final CacheManager cacheManager;
    @NonNull
    private final Function<String, List<Fond>> kindToEnabledFondsExpander;
    @NonNull
    private final Function<String, List<Fond>> subkindToEnabledFondsExpander;
    @NonNull
    private final Function<Fond, List<Fond>> enabledIncludableFondsExpander;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final Codebook<Fond, Integer> fondLoader;
    @NonNull
    private final ByIdLoadable<ScalarDatatype, String> fallbackingScalarDatatypeLoader;

    @Bean
    public SearchFactoryResolver searchFactoryResolver() {
        return new SearchFactoryResolver();
    }

    @Bean
    public SearchedKeywordsLoader searchedKeywordsLoader() {
        return new SpringDbSearchedKeywordsLoader(this.notCriticalJdbcTemplate, this.queryFactory, (Provider)StaticProvider.of((Object)3));
    }

    @Bean
    public SearchedKeywordsSaver searchedKeywordsSaver() {
        return new SpringDbSearchedKeywordsSaver(this.notCriticalJdbcTemplate, this.queryFactory, this.executorService);
    }

    @Bean
    public KeywordsParser keywordsParser() {
        return new KeywordsParserAppserver(this.mappingAppserver, ExemplarConstants.Datatype.SIGNATURE, ExemplarConstants.Datatype.ACCESS_NUMBER);
    }

    @Bean
    public CompositeAllValuesProvider<SearchField> searchFieldsProvider() {
        return CompositeAllValuesProvider.of((AllValuesProvider[])new AllValuesProvider[]{this.customSearchFieldLoader(), ConvertingAllValuesProvider.byItemConverter((AllValuesProvider)this.facetTypeLoader(), FacetType::toSearchField), StaticSearchFields.CODEBOOK});
    }

    @Bean
    public CompositeByIdLoader<SearchField, String> searchFieldLoader() {
        return CompositeByIdLoader.of((IdAndIdsLoadable[])new IdAndIdsLoadable[]{this.customSearchFieldLoader(), AllValuesProvidedCodebook.ofIdentified((AllValuesProvider)ConvertingAllValuesProvider.byItemConverter((AllValuesProvider)this.facetTypeLoader(), FacetType::toSearchField)), StaticSearchFields.CODEBOOK});
    }

    @Bean
    public StaticCodebook<ViewFormat, String> viewFormatLoader() {
        return StaticCodebook.ofDynamicSize(ViewFormat::format).add((Object)ViewFormat.STANDARD);
    }

    @Bean
    public Codebook<CustomSearchField, String> customSearchFieldLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(CustomSearchFieldEntity.class).convertedEachBy((Converter)new EntityToCustomSearchFieldConverter(this.fallbackingScalarDatatypeLoader)).staticCached(CustomSearchField.class.getSimpleName()).build();
    }

    @Bean
    public AuthenticatedContextualProvider<Department, List<ViewableSearchField>> viewableSearchFieldsProvider() {
        return new ViewableSearchFieldsContextualProvider(this.settingLoader.getDepartmentedProvider(SettingKeys.FORM_SEARCH_FIELDS), (ByIdLoadable)this.searchFieldLoader(), this.departmentedSearchFieldToViewableSearchFieldConverter());
    }

    @Bean
    public AuthenticatedContextualFunction<SearchField, Department, ViewableSearchField> departmentedSearchFieldToViewableSearchFieldConverter() {
        return new DepartmentedSearchFieldToViewableSearchFieldConverter(this.searchValueEditorLoader(), this.datatypeBySearchFieldLoader());
    }

    @Bean
    public DispatchingLuceneQueryFieldLoader luceneQueryFieldLoader() {
        HashMap<String, List<LuceneQueryField>> staticFields = new HashMap<String, List<LuceneQueryField>>();
        staticFields.put((String)StaticSearchFields.WHATEVER.getId(), List.of(LuceneQueryField.create((String)"PALL", (ScalarDatatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)StaticSearchFields.NAME.getId(), List.of(LuceneQueryField.create((String)"PNAZEV", (ScalarDatatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)RecordConstants.SearchFields.FOND.getId(), List.of(LuceneQueryField.create((String)"REZS_FOND", (ScalarDatatype)RecordConstants.Datatype.FOND)));
        staticFields.put((String)RecordConstants.SearchFields.RECORD_RELATED_RECORD.getId(), List.of(LuceneQueryField.create((String)"REL_RECORD", (ScalarDatatype)RecordConstants.Datatype.RECORD_HEADER)));
        staticFields.put((String)StaticSearchFields.DEPARTMENT.getId(), List.of(LuceneQueryField.create((String)"REZS_PUBLIC_DEP", (ScalarDatatype)CoreConstants.Datatype.DEPARTMENT)));
        staticFields.put((String)StaticSearchFields.UNRESTRICTED_DEPARTMENT.getId(), List.of(LuceneQueryField.create((String)"REZS_PUJC", (ScalarDatatype)CoreConstants.Datatype.DEPARTMENT)));
        staticFields.put((String)StaticSearchFields.DRAFT_DEPARTMENT.getId(), List.of(LuceneQueryField.create((String)"REZS_DRAFT_DEP", (ScalarDatatype)CoreConstants.Datatype.DEPARTMENT)));
        staticFields.put((String)ExemplarConstants.SearchFields.LOCATION.getId(), List.of(LuceneQueryField.create((String)"REZS_LOKACE", (ScalarDatatype)ExemplarConstants.Datatype.LOCATION)));
        staticFields.put((String)RecordConstants.SearchFields.DOCUMENT_FOND.getId(), List.of(LuceneQueryField.create((String)"REZS_FOND", (ScalarDatatype)RecordConstants.Datatype.DOCUMENT_FOND)));
        staticFields.put((String)RecordConstants.SearchFields.RECORD_STATUS.getId(), List.of(LuceneQueryField.create((String)"STATUS", (ScalarDatatype)RecordConstants.Datatype.RECORD_STATUS)));
        staticFields.put((String)RecordConstants.SearchFields.DOCUMENT_ISBN.getId(), List.of(LuceneQueryField.create((String)"P20", (ScalarDatatype)RecordConstants.Datatype.ISBN)));
        staticFields.put((String)RecordConstants.SearchFields.DOCUMENT_ISSN.getId(), List.of(LuceneQueryField.create((String)"P22", (ScalarDatatype)RecordConstants.Datatype.ISSN)));
        staticFields.put((String)RecordConstants.SearchFields.DOCUMENT_ISBN_OR_ISSN.getId(), List.of(LuceneQueryField.create((String)"P20", (ScalarDatatype)RecordConstants.Datatype.ISBN), LuceneQueryField.create((String)"P22", (ScalarDatatype)RecordConstants.Datatype.ISSN)));
        staticFields.put((String)RecordConstants.SearchFields.DOCUMENT_NAME.getId(), List.of(LuceneQueryField.create((String)"P245", (ScalarDatatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)ExemplarConstants.SearchFields.DOCUMENT_SIGNATURE.getId(), List.of(LuceneQueryField.create((String)"PSIGNATURA", (ScalarDatatype)ExemplarConstants.Datatype.SIGNATURE)));
        staticFields.put((String)ExemplarConstants.SearchFields.DOCUMENT_ACCESS_NUMBER.getId(), List.of(LuceneQueryField.create((String)"PPRIRCISLO", (ScalarDatatype)ExemplarConstants.Datatype.ACCESS_NUMBER)));
        staticFields.put((String)RecordConstants.SearchFields.RECORD_SOURCE_RECORD.getId(), List.of(LuceneQueryField.create((String)"P773", (ScalarDatatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)RecordConstants.SearchFields.AUTHOR.getId(), List.of(LuceneQueryField.create((String)"P100", (ScalarDatatype)CoreConstants.Datatype.TEXT), LuceneQueryField.create((String)"P110", (ScalarDatatype)CoreConstants.Datatype.TEXT), LuceneQueryField.create((String)"P111", (ScalarDatatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)RecordConstants.SearchFields.DOCUMENT_YEAR.getId(), List.of(LuceneQueryField.create((String)"REZS_ROK", (ScalarDatatype)CoreConstants.Datatype.NUMBER)));
        staticFields.put((String)RecordConstants.SearchFields.PUBLISHER.getId(), List.of(LuceneQueryField.create((String)"P260", (ScalarDatatype)CoreConstants.Datatype.TEXT), LuceneQueryField.create((String)"P264", (ScalarDatatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)StaticSearchFields.NOTE.getId(), List.of(LuceneQueryField.create((String)"P500", (ScalarDatatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)RecordConstants.SearchFields.AUTHORITY_NAME.getId(), List.of(LuceneQueryField.create((String)"P100", (ScalarDatatype)CoreConstants.Datatype.TEXT), LuceneQueryField.create((String)"P110", (ScalarDatatype)CoreConstants.Datatype.TEXT), LuceneQueryField.create((String)"P111", (ScalarDatatype)CoreConstants.Datatype.TEXT), LuceneQueryField.create((String)"P150", (ScalarDatatype)CoreConstants.Datatype.TEXT), LuceneQueryField.create((String)"P151", (ScalarDatatype)CoreConstants.Datatype.TEXT), LuceneQueryField.create((String)"P240", (ScalarDatatype)CoreConstants.Datatype.TEXT), LuceneQueryField.create((String)"P148", (ScalarDatatype)CoreConstants.Datatype.TEXT), LuceneQueryField.create((String)"P773", (ScalarDatatype)CoreConstants.Datatype.TEXT), LuceneQueryField.create((String)"P190", (ScalarDatatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)RecordConstants.SearchFields.CNA.getId(), List.of(LuceneQueryField.create((String)"P1", (ScalarDatatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)RecordConstants.SearchFields.AUTHORITY_FOND.getId(), List.of(LuceneQueryField.create((String)"REZS_FOND", (ScalarDatatype)RecordConstants.Datatype.AUTHORITY_FOND)));
        staticFields.put((String)RecordConstants.SearchFields.RECORD_ID.getId(), List.of(LuceneQueryField.create((String)"RECORD_ID", (ScalarDatatype)RecordConstants.Datatype.RECORD)));
        staticFields.put((String)RecordConstants.SearchFields.RECORD_CREATION_DATE.getId(), List.of(LuceneQueryField.create((String)"REZS_DATVYT", (ScalarDatatype)CoreConstants.Datatype.DATETIME)));
        staticFields.put((String)RecordConstants.SearchFields.RECORD_FILE_CATEGORY.getId(), List.of(LuceneQueryField.create((String)"REZS_TYP_FULLTEXT", (ScalarDatatype)FileConstants.Datatype.FILE_CATEGORY)));
        staticFields.put((String)LoanConstants.SearchFields.RECORD_LOAN_SOURCE.getId(), List.of(LuceneQueryField.create((String)"REZS_EXTERNI", (ScalarDatatype)CoreConstants.Datatype.TEXT)));
        staticFields.put((String)RecordConstants.SearchFields.TABLE_OF_CONTENT.getId(), List.of(LuceneQueryField.create((String)"PTOC", (ScalarDatatype)CoreConstants.Datatype.TEXT)));
        return new DispatchingLuceneQueryFieldLoader(staticFields, (ByIdOptLoadable)this.customSearchFieldLoader());
    }

    @Bean
    public DispatchingLuceneSortFieldLoader luceneSortFieldLoader() {
        return new DispatchingLuceneSortFieldLoader();
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    public AllProvidingRepository<Search<MapBackedParams, ?, ? extends Paging>, UUID> searchHistory() {
        return new SearchHistoryImpl();
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    public SameTypeSettableProvider<@NonNull Integer> documentDefaultPageSizeProvider() {
        return new FallbackingSettableProvider(this.settingLoader.getOnRootProvider(SettingKeys.DOCUMENT_SEARCH_PAGE_SIZE));
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    public SameTypeSettableProvider<Integer> authorityPageSizeProvider() {
        return new FallbackingSettableProvider(this.settingLoader.getOnRootProvider(SettingKeys.AUTHORITY_SEARCH_PAGE_SIZE));
    }

    @Bean
    public Codebook<FacetType, Integer> facetTypeLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbFacetTypeLoader(this.jdbcTemplate, this.queryFactory, (ByIdLoadable)this.facetTypeSortingLoader(), this.fallbackingScalarDatatypeLoader)).staticCached(FacetType.class.getSimpleName()).build();
    }

    @Bean
    public Saver<FacetType, FacetType> facetTypeSaver() {
        return CacheCleaningSaver.fromGenericCleaner((Saver)new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new FacetTypeToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(FacetTypeEntity.class, this.entityManager))), (Converter)new FacetTypeFromEntityConverter(this.facetTypeSortingLoader(), this.facetDefinitionTypeLoader(), this.facetScopeLoader(), this.fallbackingScalarDatatypeLoader)), (CacheCleaner)this.cacheService.createCleanerFor(FacetType.class.getSimpleName()));
    }

    @Bean
    public FacetTypeCreator facetTypeCreator() {
        return new FacetTypeCreator(this.facetTypeSaver(), this.defaultTransactionTemplateFactory.get(), this.facetTypeLoader());
    }

    @Bean
    public FacetTypeUpdater facetTypeUpdater() {
        return new FacetTypeUpdater(this.facetTypeSaver(), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public CompositeSearchFormFactory searchFormFactory() {
        return new CompositeSearchFormFactory();
    }

    @Bean
    public ViewableItemsConverter viewableItemsConverter() {
        return new ViewableItemsConverter();
    }

    @Bean
    public SearchTextResolver searchTitleResolver() {
        return new SearchTitleResolver(this.translator);
    }

    @Bean
    public SearchTextResolver searchSubtitleResolver() {
        return new EmptySearchTextResolver();
    }

    @Bean
    public Repository<Search<? extends MapBackedParams, ?, ? extends Paging>, UUID> searchRepository() {
        return CacheBackedRepository.ofIdentified((DynamicCache)GuavaTimedDynamicCache.ofIdentified((Duration)Duration.ofMinutes(10L), (boolean)false));
    }

    @Bean
    public SearchValueEditorLoader<Department> searchValueEditorLoader() {
        return new DispatchingSearchValueEditorLoader(this.acceptableValuesProviderLoader, this.readableLocationsContextualProvider, this.currentAuthShowableFondsLoader, this.departmentAccessor);
    }

    @Bean
    public DatatypeBySearchFieldLoader datatypeBySearchFieldLoader() {
        return new DatatypeBySearchFieldLoaderByLuceneQueryFieldLoader();
    }

    @Bean
    public CacheResolver rawableSearchServiceCacheResolver() {
        return new RawableSearchServiceCacheResolver(this.cacheManager);
    }

    @Bean
    public ParamsModifier<DefaultGettableAndSettableSearchParams> fondRelatedParamsExpander() {
        return new DefaultParamsModifier().withExpandingParam(CoreSearchParams.KIND, RecordConstants.SearchParams.FOND, this.kindToEnabledFondsExpander).withExpandingParam(CoreSearchParams.SUBKIND, RecordConstants.SearchParams.FOND, this.subkindToEnabledFondsExpander).withExpandingParam(RecordConstants.SearchParams.ROOT_FOND, RecordConstants.SearchParams.FOND, this.enabledIncludableFondsExpander);
    }

    @Bean
    public ContextualProvider<Department, Range<Integer>> documentYearExtremeRangeProvider() {
        return this.settingLoader.getDepartmentedProvider(SettingKeys.DOCUMENT_MIN_YEAR).andThenFastReturningNull(minYear -> Range.of((Comparable)minYear, (Comparable)Integer.valueOf(LocalDate.now().getYear()))).fallbacked((Provider)new SpringDbKat14YearExtremesLoader(this.jdbcTemplate, this.queryFactory).cached());
    }

    @Bean
    public Codebook<SortingItem, String> facetTypeSortingLoader() {
        return StaticCodebook.ofIdentified((Identified[])new SortingItem[]{FacetTypeSorting.SORTING_FREQ_DESC, FacetTypeSorting.SORTING_ALPH_ASC, FacetTypeSorting.SORTING_ALPH_DESC, FacetTypeSorting.SORTING_CHRONO_ASC, FacetTypeSorting.SORTING_CHRONO_DESC, FacetTypeSorting.SORTING_NUM_ASC, FacetTypeSorting.SORTING_NUM_DESC});
    }

    @Bean
    public Codebook<FacetScope, Integer> facetScopeLoader() {
        return FacetScope.CODEBOOK;
    }

    @Bean
    public Codebook<FacetDefinitionType, Integer> facetDefinitionTypeLoader() {
        return FacetDefinitionType.CODEBOOK;
    }

    @Bean
    public CompositeByIdLoader<SortingItem, String> searchSortingLoader() {
        CompositeByIdLoader loader = CompositeByIdLoader.of((IdAndIdsLoadable[])new IdAndIdsLoadable[]{this.recordSearchSortingLoader(), this.authoritySearchSortingLoader(), this.exemplarSearchSortingLoader(), this.facetTypeSortingLoader(), this.matchSearchSortingLoader()});
        loader.addFallback((IdAndIdsLoadable)new AllByIdsLoadableByIdLoaderAdapter(SortingItem::ofSimpleId));
        return loader;
    }

    @Bean
    public Provider<SortingItem> defaultRecordSearchSortingProvider() {
        return DefaultProvider.byFirst((Provider)this.settingLoader.getOnRootProvider(SettingKeys.SEARCH_SORTINGS));
    }

    @Bean
    public Codebook<SortingItem, String> recordSearchSortingLoader() {
        return AllValuesProvidedCodebook.ofIdentified(() -> (List)this.settingLoader.getOnRootProvider(SettingKeys.SEARCH_SORTINGS).get());
    }

    @Bean
    public Provider<SortingItem> defaultAuthoritySearchSortingProvider() {
        return DefaultProvider.byFirst((AllValuesProvider)this.authoritySearchSortingLoader());
    }

    @Bean
    public Codebook<SortingItem, String> authoritySearchSortingLoader() {
        return AllValuesProvidedCodebook.ofIdentified(() -> (List)this.settingLoader.getOnRootProvider(SettingKeys.AUTHORITY_SEARCH_SORTINGS).get());
    }

    @Bean
    public ContextualProvider<Department, @NonNull FondedValues<@NonNull List<SortingItem>>> departmentedFondedRecordSearchSortingsLoader() {
        return this.settingLoader.getDepartmentedFondedValuesProvider(SettingKeys.SEARCH_SORTINGS);
    }

    @Bean
    public ByIdLoadable<Datasource, String> datasourceLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)this.allDatasetsProvider()).build();
    }

    @Bean
    public CompositeAddableAllValuesProvider<Datasource> allDatasetsProvider() {
        return CompositeAddableAllValuesProvider.ofEmpty();
    }

    @Bean
    public CompositeAllValuesContextualProvider<Department, Datasource> allowedDatasetsProvider() {
        return new CompositeAllValuesContextualProvider();
    }

    @Bean
    public Provider<SortingItem> defaultExemplarSearchSortingProvider() {
        return DefaultProvider.byId((AllValuesProvider)this.exemplarSearchSortingLoader(), (Object)"accessNumber");
    }

    @Bean
    public Codebook<SortingItem, String> exemplarSearchSortingLoader() {
        return StaticCodebook.ofIdentified((Identified[])new SortingItem[]{SortingItem.ofSimpleAsc((String)"accessNumber"), SortingItem.ofSimpleDesc((String)"accessNumber"), SortingItem.ofSimpleDesc((String)"signature"), SortingItem.ofSimpleAsc((String)"discardNumber")});
    }

    @Bean
    public Provider<SortingItem> defaultMatchSearchSortingProvider() {
        return DefaultProvider.byId((AllValuesProvider)this.matchSearchSortingLoader(), (Object)"accessNumber");
    }

    @Bean
    public Codebook<SortingItem, String> matchSearchSortingLoader() {
        return StaticCodebook.ofIdentified((Identified[])new SortingItem[]{SortingItem.ofSimpleAsc((String)"accessNumber"), SortingItem.ofSimpleDesc((String)"accessNumber"), SortingItem.ofSimpleAsc((String)"signature"), SortingItem.ofSimpleDesc((String)"signature"), SortingItem.ofSimpleAsc((String)"barCode"), SortingItem.ofSimpleDesc((String)"barCode")});
    }

    @Bean
    public MapToMapSearchParamsConverter mapToMapSearchParamsConverter() {
        Set<String> notMappableButAllowedQueryParams = Set.of("pageNumber", "pageSize", "exports", "focusedFieldTypeId", "format", "locale", "cache", "detailLevel", "afterPosition", "beforePosition", "searchDate", "sorting", "activeTab", "viewFormat");
        return new MapToMapSearchParamsConverter(this.mappableSearchParamsRegistry(), notMappableButAllowedQueryParams);
    }

    @Bean
    public MappableSearchParamsRegistry mappableSearchParamsRegistry() {
        MappableSearchParamsRegistry mappableSearchParamsRegistry = new MappableSearchParamsRegistry((ConversionService)this.conversionService);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.KIND);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.SUBKIND);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.DEPARTMENT);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.NAME);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.Q);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.INITIATOR);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.DATASOURCE);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.DATASOURCE_GROUP);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.CENTRAL_INDEX_ENABLED);
        mappableSearchParamsRegistry.registerDatatyped(InventoryConstants.SearchParams.INVENTORY);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.TYPE);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.TITLE);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.FROM_DATE);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.INCLUDE_DRAFT);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.INCLUDE_DELETED);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.INCLUDE_ACTIVE);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.TO_DATE);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.QT);
        mappableSearchParamsRegistry.registerDatatyped(FileSearchParams.DIRECTORY);
        mappableSearchParamsRegistry.registerDatatyped(FileSearchParams.ROOT_DIRECTORY);
        mappableSearchParamsRegistry.registerDatatyped(FileSearchParams.FILE_CATEGORY);
        mappableSearchParamsRegistry.registerDatatyped(FileSearchParams.FILE_PROCESSING_STATE);
        mappableSearchParamsRegistry.registerDatatyped(FileSearchParams.FILENAME_EXTENSION);
        mappableSearchParamsRegistry.registerDatatyped(FileSearchParams.FILENAME);
        mappableSearchParamsRegistry.registerDatatyped(FileSearchParams.FORBIDDEN_FILE);
        mappableSearchParamsRegistry.registerDatatyped(FileSearchParams.FORBIDDEN_FILE_CATEGORY);
        mappableSearchParamsRegistry.registerDatatyped(FileSearchParams.MINIMAL_FILE_SIZE_KB);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.OPERATED_SUBKIND);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.OPERATED_ROOT_FOND);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.OPERATION_TYPE);
        mappableSearchParamsRegistry.registerDatatyped(PaymentConstants.SearchParams.INCLUSIVE_FROM_CREATION_DATE);
        mappableSearchParamsRegistry.registerDatatyped(PaymentConstants.SearchParams.EXCLUSIVE_TO_CREATION_DATE);
        mappableSearchParamsRegistry.registerDatatyped(PaymentConstants.SearchParams.CREATION_DATE);
        mappableSearchParamsRegistry.registerDatatyped(PaymentConstants.SearchParams.INCLUSIVE_FROM_PAY_DATE);
        mappableSearchParamsRegistry.registerDatatyped(PaymentConstants.SearchParams.EXCLUSIVE_TO_PAY_DATE);
        mappableSearchParamsRegistry.registerDatatyped(PaymentConstants.SearchParams.PAY_DATE);
        mappableSearchParamsRegistry.registerDatatyped(PaymentConstants.SearchParams.PAYMENT_STATE);
        mappableSearchParamsRegistry.registerDatatyped(PaymentConstants.SearchParams.PROVIDER);
        mappableSearchParamsRegistry.registerDatatyped(PaymentConstants.SearchParams.TRANSACTION_ID);
        mappableSearchParamsRegistry.registerDatatyped(PaymentConstants.SearchParams.OWNER);
        mappableSearchParamsRegistry.registerDatatyped(PaymentConstants.SearchParams.AMOUNT_TYPE);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.CREATOR);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.RAW_QUERY);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.FINAL_RAW_QUERY);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.FACET_RESTRICTION);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.FACETS_ENABLED);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.RIGHT_HAND_EXTENSION);
        mappableSearchParamsRegistry.registerDatatyped(CoreSearchParams.FIELD);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.PREFIX);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.DIACRITICAL_PREFIX);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.EXCLUDED_RECORD);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.RECORD);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.EXEMPLAR_STATUS);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.FORBIDDEN_EXEMPLAR);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.ACQUISITION_WAY);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.ROOT_FOND);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.FOND);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.FOND_TYPE);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.CONSTRAINTS_RECORD_FIELD_TYPE);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.RECORD_RELATED_RECORD);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.RECORD_RELATED_RECORD_FOND);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.EXCLUDED_RECORD_STATUS);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.INCLUDE_EXCLUDED);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.FIELD_TYPE_ID);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.INCLUDE_FAKE);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.LOCATION);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.EXEMPLAR_TYPE);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.INCREASE_YEAR);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.BAR_CODE);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.ACCESS_NUMBER);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.ACCESS_NUMBER_START);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.ACCESS_NUMBER_END);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.SIGNATURE);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.SIGNATURE_START);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.SIGNATURE_END);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.DISCARD_NUMBER_START);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.DISCARD_NUMBER_END);
        mappableSearchParamsRegistry.registerDatatyped(ExemplarConstants.SearchParams.BUNDLED_VOLUME_YEAR);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.USERNAME);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.USERNAME_IGNORE_CASE);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.EMAIL);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.LAST_NAME);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.CARD_NUMBER);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.BAR_CODE);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.CASE_INSENSITIVE_NET_ID);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.OPENID);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.RFID_USER_ID);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.READER_CATEGORY);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.USER_TYPE);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.INCLUDE_ANONYMIZED);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.EDIT_LEVEL);
        mappableSearchParamsRegistry.registerDatatyped(UserConstants.SearchParams.USER_SERVICE_PROP);
        mappableSearchParamsRegistry.registerDatatyped(LoanConstants.SearchParams.LENDER);
        mappableSearchParamsRegistry.registerDatatyped(LoanConstants.SearchParams.LOAN_STATE);
        mappableSearchParamsRegistry.registerDatatyped(LoanConstants.SearchParams.EXEMPLAR);
        mappableSearchParamsRegistry.registerDatatyped(LoanConstants.SearchParams.LOAN_REQUEST_ID);
        mappableSearchParamsRegistry.registerDatatyped(LoanConstants.SearchParams.SHIPMENT_ITEM);
        mappableSearchParamsRegistry.registerDatatyped(LoanConstants.SearchParams.LEND_FROM_DATE);
        mappableSearchParamsRegistry.registerDatatyped(LoanConstants.SearchParams.LEND_TO_DATE);
        mappableSearchParamsRegistry.registerDatatyped(LoanConstants.SearchParams.INCLUDE_NOT_SHIPPING);
        mappableSearchParamsRegistry.registerDatatyped(LoanConstants.SearchParams.EXEMPLAR_Q);
        mappableSearchParamsRegistry.registerDatatyped(LoanReminderConstants.SearchParams.LOAN_REMINDER_TYPE);
        mappableSearchParamsRegistry.registerDatatyped(LoanReminderConstants.SearchParams.SENT_INCLUDED);
        mappableSearchParamsRegistry.registerDatatyped(MessageConstants.SearchParams.CREATE_DATE);
        mappableSearchParamsRegistry.registerDatatyped(MessageConstants.SearchParams.SENDER_USER);
        mappableSearchParamsRegistry.registerDatatyped(MessageConstants.SearchParams.TARGET_USER);
        mappableSearchParamsRegistry.registerDatatyped(MessageConstants.SearchParams.SEVERITY);
        mappableSearchParamsRegistry.registerDatatyped(MessageConstants.SearchParams.TOPIC);
        mappableSearchParamsRegistry.registerDatatyped(MessageConstants.SearchParams.MESSAGE_MEDIUM);
        mappableSearchParamsRegistry.registerDatatyped(MessageConstants.SearchParams.MESSAGE);
        mappableSearchParamsRegistry.registerDatatyped(MessageConstants.SearchParams.MESSAGES);
        mappableSearchParamsRegistry.registerDatatyped(MessageConstants.SearchParams.MESSAGE_STATUS);
        mappableSearchParamsRegistry.registerDatatyped(MessageConstants.SearchParams.THREAD);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.CNA);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.ISBN);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.ISSN);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.ISBN_OR_ISSN);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.AUTHOR);
        mappableSearchParamsRegistry.registerDatatyped(RecordConstants.SearchParams.PUBLICATION_YEAR);
        mappableSearchParamsRegistry.registerDatatyped(InventoryConstants.SearchParams.MATCH_STATE);
        mappableSearchParamsRegistry.registerDatatyped(StatsConstants.SearchParams.TIME_GRANULARITY);
        mappableSearchParamsRegistry.registerDatatyped(InventoryConstants.SearchParams.INVENTORY_STATE);
        return mappableSearchParamsRegistry;
    }

    @Bean
    public RecordSearchParamsStringQueryBuilder<MapBackedParams> luceneSearchQueryBuilder() {
        return new RecordSearchParamsStringQueryBuilder(this.restrictionToLuceneQueryConverter(), this.fondLoader).withDocumentConjunctionModifier(MapBackedParams.class, (RestrictionModifier)new CommonDocumentParamsConjunctionModifier((HierarchyLoader)this.departmentAccessor, this.enabledFondsProvider, this.fondLoader)).withDocumentConjunctionModifier(MapBackedParams.class, (RestrictionModifier)new DocumentFieldsSearchParamsRestrictionModifier((ContextualFunction)new QToLuceneQueryConverterByPattern(this.settingLoader.getDepartmentedProvider(SettingKeys.GLOBAL_SEARCH_TEMPLATE_1), this.keywordsParser()))).withAuthorityConjunctionModifier(MapBackedParams.class, (RestrictionModifier)new CommonAuthorityParamsConjunctionModifier(this.enabledFondsProvider)).withAuthorityConjunctionModifier(MapBackedParams.class, (RestrictionModifier)new AuthorityFieldsSearchParamsRestrictionModifier((ContextualFunction)new QToLuceneQueryConverterByPattern(this.settingLoader.getDepartmentedProvider(SettingKeys.AUTHORITY_GLOBAL_SEARCH_QUERY_TEMPLATE), this.keywordsParser()))).withRestrictionModifierFor(MapBackedParams.class, (RestrictionModifier)new RawQueryAddingConjunctionModifier()).withRestrictionModifierFor(MapBackedParams.class, (RestrictionModifier)new FieldedQAddingConjunctionModifier((ByIdLoadable)this.searchFieldLoader()));
    }

    @Bean
    public Converter<Restriction<? extends SearchField>, String> restrictionToLuceneQueryConverter() {
        Converter luceneFieldRestrictionToQuery = new RestrictionToLuceneQueryConverterBuilder(this.keywordsParser(), (QueryFieldsBySearchFieldLoader)this.luceneQueryFieldLoader()).registerEqValueConverter(Integer.class, (Converter)new IdToLuceneValueConverter()).registerEqValueConverter(String.class, (Converter)new StringToLuceneValueConverter()).registerEqValueConverter(UUID.class, (Converter)new UuidToLuceneValueConverter()).registerEqValueConverter(LocalDate.class, (Converter)new LocalDateToLuceneValueConverter()).registerBetweenValueItemConverter(LocalDate.class, (Converter)new LocalDateToLuceneValueConverter()).registerEqValueConverter(Instant.class, (Converter)new InstantToLuceneValueConverter()).registerBetweenValueItemConverter(Instant.class, (Converter)new InstantToLuceneValueConverter()).registerEqValueConverter(RecordIdFondPair.class, (Converter)new RecordHeaderToLuceneValueConverter()).registerBetweenValueItemConverter(Identified.class, (Converter)new IdentifiedToLuceneValueConverter()).registerEqValueConverter(Identified.class, (Converter)new IdentifiedToLuceneValueConverter()).buildLuceneFieldRestrictionToQuery();
        Converter simpleSearchFieldRestrictionToLuceneFieldRestriction = new RestrictionToLuceneQueryConverterBuilder(this.keywordsParser(), (QueryFieldsBySearchFieldLoader)this.luceneQueryFieldLoader()).buildSearchFieldRestrictionToLuceneFieldRestriction();
        Converter searchFieldRestrictionToLuceneFieldRestriction = new RestrictionToLuceneQueryConverterBuilder(this.keywordsParser(), (QueryFieldsBySearchFieldLoader)this.luceneQueryFieldLoader()).configureRecursiveSearchFieldTermConverter(recursiveTermConverter -> {
            recursiveTermConverter.addByMatcherClass(In.class, (Converter)new RestrictionToLuceneQueryConverterBuilder.InMatcherTermToDisjunctionIntermediateConverter());
            recursiveTermConverter.addByMatcherClass(Lt.class, (Converter)new RestrictionToLuceneQueryConverterBuilder.LtMatcherToBetweenIntermediateConverter());
            recursiveTermConverter.addByMatcherClass(LtEq.class, (Converter)new RestrictionToLuceneQueryConverterBuilder.LtEqMatcherToBetweenIntermediateConverter());
            recursiveTermConverter.addByMatcherClass(GtEq.class, (Converter)new RestrictionToLuceneQueryConverterBuilder.GtEqMatcherToBetweenIntermediateConverter());
            recursiveTermConverter.addByField((Object)StaticSearchFields.SUBKIND, (Converter)new SubkindFieldTermToFondListConverter(this.enabledFondsProvider));
        }).configureNonRecursiveSearchFieldTermConverter(nonRecursiveTermConverter -> {
            nonRecursiveTermConverter.addFirst((MatchingCompositeTermConverter.TermMatcher)new SingleStringMatcherValueTermMatcher(IsbnChecker::isValidIsbn), new IsbnDisjunctionAddingTermConverter((Object)RecordConstants.SearchFields.DOCUMENT_ISBN).andThen(simpleSearchFieldRestrictionToLuceneFieldRestriction));
            nonRecursiveTermConverter.addFirst((MatchingCompositeTermConverter.TermMatcher)new SingleStringMatcherValueTermMatcher(IsbnChecker::isValidIssn), new IsbnDisjunctionAddingTermConverter((Object)RecordConstants.SearchFields.DOCUMENT_ISSN).andThen(simpleSearchFieldRestrictionToLuceneFieldRestriction));
        }).buildSearchFieldRestrictionToLuceneFieldRestriction();
        return searchFieldRestrictionToLuceneFieldRestriction.andThen(luceneFieldRestrictionToQuery);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerModule() {
        this.allowedDatatypeToAllValuesProviderMap.registerEquals(SearchConstants.Datatype.SEARCH_FIELD, (AllValuesProvider)this.searchFieldsProvider());
        this.allDatatypeToAllValuesProviderMap.registerEquals(SearchConstants.Datatype.SEARCH_FIELD, (AllValuesProvider)ConvertingAllValuesProvider.byItemConverter((AllValuesProvider)this.searchFieldsProvider(), searchField -> {
            MultiText text = MultiText.ofTexts((String)"{} ({})", (Text[])new Text[]{searchField.text(), Texts.ofNative((String)((String)ObjectUtil.firstNotNull((Object)searchField.sourceDescription(), (Object)"Unknown source")))});
            return new LabeledId((Serializable)((Object)((String)searchField.id())), (Text)text);
        }));
        this.converterRegisterer.registerForStringId(CacheMode.class, (ByIdLoadable)CacheMode.CODEBOOK).registerForStringId(DetailLevel.class, (ByIdLoadable)DetailLevel.CODEBOOK).registerForStringId(Datasource.class, this.datasourceLoader()).registerForStringId(FacetKeyIdentified.class, id -> new FacetKeyIdentified.StringIdToFacetKeyIdentifiedConverter().convert(id)).registerForIntegerId(FacetDefinitionType.class, (ByIdLoadable)FacetDefinitionType.CODEBOOK).registerForIntegerId(FacetScope.class, (ByIdLoadable)FacetScope.CODEBOOK).registerForStringId(SearchField.class, (ByIdLoadable)this.searchFieldLoader()).registerForStringId(SortingItem.class, (ByIdLoadable)this.searchSortingLoader()).registerForUuidId(Search.class, (ByIdLoadable)this.searchRepository()).registerForStringId(ViewFormat.class, (ByIdLoadable)this.viewFormatLoader());
        this.conversionService.addConverter(String.class, Restriction.class, source -> {
            try {
                return (Restriction)this.objectMapper.readValue(source, Restriction.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot deserialize json to %s".formatted(Restriction.class.getSimpleName()), e);
            }
        });
        this.objectMapperModule.addSerializer(Restriction.class, (JsonSerializer)new RestrictionSerializer()).addDeserializer(Restriction.class, (JsonDeserializer)new RestrictionDeserializerPostModifyingDecorator((RestrictionDeserializer)new RestrictionDeserializerWithSearchFields(), this.datatypableStringConverter, this.datatypeBySearchFieldLoader()));
    }

    @ConstructorProperties(value={"queryFactory", "jdbcTemplate", "notCriticalJdbcTemplate", "mappingAppserver", "executorService", "datatypableStringConverter", "cacheService", "codebookLoaderBuilderFactory", "objectMapperModule", "settingLoader", "acceptableValuesProviderLoader", "currentAuthShowableFondsLoader", "departmentAccessor", "readableLocationsContextualProvider", "enabledFondsProvider", "translator", "allowedDatatypeToAllValuesProviderMap", "allDatatypeToAllValuesProviderMap", "converterRegisterer", "conversionService", "objectMapper", "cacheManager", "kindToEnabledFondsExpander", "subkindToEnabledFondsExpander", "enabledIncludableFondsExpander", "defaultTransactionTemplateFactory", "entityManager", "fondLoader", "fallbackingScalarDatatypeLoader"})
    @Generated
    public SearchConfig(@NonNull QueryFactory queryFactory, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull NamedParameterJdbcOperations notCriticalJdbcTemplate, @NonNull MappingAppserverService mappingAppserver, @NonNull ExecutorService executorService, @NonNull DatatypableStringConverter datatypableStringConverter, @NonNull CacheService cacheService, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull SimpleModule objectMapperModule, @NonNull SettingLoader settingLoader, @NonNull ByIdLoadable<@Nullable AllValuesProvider<? extends LabeledIdentified<?>>, ScalarDatatype> acceptableValuesProviderLoader, @NonNull CurrentAuthFondsLoader currentAuthShowableFondsLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull ContextualProvider<Department, List<Location>> readableLocationsContextualProvider, @NonNull AllValuesProvider<Fond> enabledFondsProvider, @NonNull Translator<Department> translator, @NonNull DatatypedAcceptableValuesRegistry allowedDatatypeToAllValuesProviderMap, @NonNull DatatypedAcceptableValuesRegistry allDatatypeToAllValuesProviderMap, @NonNull ConverterRegisterer converterRegisterer, @NonNull FormattingConversionService conversionService, @NonNull ObjectMapper objectMapper, @NonNull CacheManager cacheManager, @NonNull Function<String, List<Fond>> kindToEnabledFondsExpander, @NonNull Function<String, List<Fond>> subkindToEnabledFondsExpander, @NonNull Function<Fond, List<Fond>> enabledIncludableFondsExpander, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull EntityManager entityManager, @NonNull Codebook<Fond, Integer> fondLoader, @NonNull ByIdLoadable<ScalarDatatype, String> fallbackingScalarDatatypeLoader) {
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(notCriticalJdbcTemplate, "notCriticalJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(executorService, "executorService is marked non-null but is null");
        Objects.requireNonNull(datatypableStringConverter, "datatypableStringConverter is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(objectMapperModule, "objectMapperModule is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(acceptableValuesProviderLoader, "acceptableValuesProviderLoader is marked non-null but is null");
        Objects.requireNonNull(currentAuthShowableFondsLoader, "currentAuthShowableFondsLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(readableLocationsContextualProvider, "readableLocationsContextualProvider is marked non-null but is null");
        Objects.requireNonNull(enabledFondsProvider, "enabledFondsProvider is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(allowedDatatypeToAllValuesProviderMap, "allowedDatatypeToAllValuesProviderMap is marked non-null but is null");
        Objects.requireNonNull(allDatatypeToAllValuesProviderMap, "allDatatypeToAllValuesProviderMap is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(conversionService, "conversionService is marked non-null but is null");
        Objects.requireNonNull(objectMapper, "objectMapper is marked non-null but is null");
        Objects.requireNonNull(cacheManager, "cacheManager is marked non-null but is null");
        Objects.requireNonNull(kindToEnabledFondsExpander, "kindToEnabledFondsExpander is marked non-null but is null");
        Objects.requireNonNull(subkindToEnabledFondsExpander, "subkindToEnabledFondsExpander is marked non-null but is null");
        Objects.requireNonNull(enabledIncludableFondsExpander, "enabledIncludableFondsExpander is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(fallbackingScalarDatatypeLoader, "fallbackingScalarDatatypeLoader is marked non-null but is null");
        this.queryFactory = queryFactory;
        this.jdbcTemplate = jdbcTemplate;
        this.notCriticalJdbcTemplate = notCriticalJdbcTemplate;
        this.mappingAppserver = mappingAppserver;
        this.executorService = executorService;
        this.datatypableStringConverter = datatypableStringConverter;
        this.cacheService = cacheService;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.objectMapperModule = objectMapperModule;
        this.settingLoader = settingLoader;
        this.acceptableValuesProviderLoader = acceptableValuesProviderLoader;
        this.currentAuthShowableFondsLoader = currentAuthShowableFondsLoader;
        this.departmentAccessor = departmentAccessor;
        this.readableLocationsContextualProvider = readableLocationsContextualProvider;
        this.enabledFondsProvider = enabledFondsProvider;
        this.translator = translator;
        this.allowedDatatypeToAllValuesProviderMap = allowedDatatypeToAllValuesProviderMap;
        this.allDatatypeToAllValuesProviderMap = allDatatypeToAllValuesProviderMap;
        this.converterRegisterer = converterRegisterer;
        this.conversionService = conversionService;
        this.objectMapper = objectMapper;
        this.cacheManager = cacheManager;
        this.kindToEnabledFondsExpander = kindToEnabledFondsExpander;
        this.subkindToEnabledFondsExpander = subkindToEnabledFondsExpander;
        this.enabledIncludableFondsExpander = enabledIncludableFondsExpander;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.entityManager = entityManager;
        this.fondLoader = fondLoader;
        this.fallbackingScalarDatatypeLoader = fallbackingScalarDatatypeLoader;
    }
}

