/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.activation.DepartmentActivator;
import cz.kpsys.portaro.department.creation.DepartmentCreator;
import cz.kpsys.portaro.department.deletion.DepartmentDeleter;
import cz.kpsys.portaro.department.editation.DepartmentUpdater;
import cz.kpsys.portaro.domaineddepartment.DomainedDepartmentCreator;
import cz.kpsys.portaro.domaineddepartment.UniquenessResolver;
import cz.kpsys.portaro.hierarchy.HierarchyLoader;
import cz.kpsys.portaro.location.DepartmentLocationRelationLoader;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.location.LocationWithDepartments;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.user.sec.SecurityActions;
import cz.kpsys.portaro.view.web.rest.placement.DepartmentApiController;
import cz.kpsys.portaro.view.web.rest.placement.LocationApiController;
import cz.kpsys.portaro.view.web.rest.placement.LocationRequest;
import cz.kpsys.portaro.view.web.rest.placement.LocationRequestToLocationWithDepartmentsConverter;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class PlacementViewConfig {
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final HierarchyLoader<Department> departmentAccessor;
    @NonNull
    private final Codebook<Location, Integer> locationLoader;
    @NonNull
    private final DepartmentLocationRelationLoader departmentLocationRelationLoader;
    @NonNull
    private final Saver<LocationWithDepartments, LocationWithDepartments> locationWithDepartmentsSaver;
    @NonNull
    private final Deleter<Location> locationDeleter;
    @NonNull
    private final DomainedDepartmentCreator domainedDepartmentCreator;
    @NonNull
    private final DepartmentActivator departmentActivator;
    @NonNull
    private final UniquenessResolver<String> serverUrlUniquenessResolver;
    @NonNull
    private final DepartmentCreator departmentcreator;
    @NonNull
    private final DepartmentUpdater departmentUpdater;
    @NonNull
    private final DepartmentDeleter departmentDeleter;

    @Bean
    public LocationApiController locationApiController() {
        return new LocationApiController(this.locationLoader, this.departmentLocationRelationLoader, this.locationWithDepartmentsSaver, this.locationDeleter, this.locationRequestToLocationWithDepartmentsConverter());
    }

    @Bean
    public DepartmentApiController departmentController() {
        return new DepartmentApiController(this.departmentAccessor, this.domainedDepartmentCreator, this.departmentActivator, this.serverUrlUniquenessResolver, this.departmentDeleter, this.departmentcreator, this.departmentUpdater);
    }

    @Bean
    public Converter<LocationRequest, LocationWithDepartments> locationRequestToLocationWithDepartmentsConverter() {
        return new LocationRequestToLocationWithDepartmentsConverter();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(SecurityActions.PLACEMENTS_SHOW, this.permissionFactory.editAction(Integer.valueOf(4410)));
        this.permissionRegistry.add(SecurityActions.PLACEMENT_CREATE, this.permissionFactory.editAction(Integer.valueOf(4411)));
        this.permissionRegistry.add(SecurityActions.LOCATION_EDIT, this.permissionFactory.editAction(Integer.valueOf(4412)));
        this.permissionRegistry.add(SecurityActions.LOCATION_DELETE, this.permissionFactory.editAction(Integer.valueOf(4413)));
        this.permissionRegistry.add(SecurityActions.DEPARTMENT_EDIT, this.permissionFactory.editAction(Integer.valueOf(4412)));
        this.permissionRegistry.add(SecurityActions.DEPARTMENT_DELETE, this.permissionFactory.editAction(Integer.valueOf(4413)));
    }

    @ConstructorProperties(value={"permissionRegistry", "permissionFactory", "departmentAccessor", "locationLoader", "departmentLocationRelationLoader", "locationWithDepartmentsSaver", "locationDeleter", "domainedDepartmentCreator", "departmentActivator", "serverUrlUniquenessResolver", "departmentcreator", "departmentUpdater", "departmentDeleter"})
    @Generated
    public PlacementViewConfig(@NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull HierarchyLoader<Department> departmentAccessor, @NonNull Codebook<Location, Integer> locationLoader, @NonNull DepartmentLocationRelationLoader departmentLocationRelationLoader, @NonNull Saver<LocationWithDepartments, LocationWithDepartments> locationWithDepartmentsSaver, @NonNull Deleter<Location> locationDeleter, @NonNull DomainedDepartmentCreator domainedDepartmentCreator, @NonNull DepartmentActivator departmentActivator, @NonNull UniquenessResolver<String> serverUrlUniquenessResolver, @NonNull DepartmentCreator departmentcreator, @NonNull DepartmentUpdater departmentUpdater, @NonNull DepartmentDeleter departmentDeleter) {
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(locationLoader, "locationLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLocationRelationLoader, "departmentLocationRelationLoader is marked non-null but is null");
        Objects.requireNonNull(locationWithDepartmentsSaver, "locationWithDepartmentsSaver is marked non-null but is null");
        Objects.requireNonNull(locationDeleter, "locationDeleter is marked non-null but is null");
        Objects.requireNonNull(domainedDepartmentCreator, "domainedDepartmentCreator is marked non-null but is null");
        Objects.requireNonNull(departmentActivator, "departmentActivator is marked non-null but is null");
        Objects.requireNonNull(serverUrlUniquenessResolver, "serverUrlUniquenessResolver is marked non-null but is null");
        Objects.requireNonNull(departmentcreator, "departmentcreator is marked non-null but is null");
        Objects.requireNonNull(departmentUpdater, "departmentUpdater is marked non-null but is null");
        Objects.requireNonNull(departmentDeleter, "departmentDeleter is marked non-null but is null");
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.departmentAccessor = departmentAccessor;
        this.locationLoader = locationLoader;
        this.departmentLocationRelationLoader = departmentLocationRelationLoader;
        this.locationWithDepartmentsSaver = locationWithDepartmentsSaver;
        this.locationDeleter = locationDeleter;
        this.domainedDepartmentCreator = domainedDepartmentCreator;
        this.departmentActivator = departmentActivator;
        this.serverUrlUniquenessResolver = serverUrlUniquenessResolver;
        this.departmentcreator = departmentcreator;
        this.departmentUpdater = departmentUpdater;
        this.departmentDeleter = departmentDeleter;
    }
}

