/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.appserver.config.AppserverCustomSettingsRefresher;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheCleaningDeleter;
import cz.kpsys.portaro.commons.cache.CacheCleaningSaver;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.convert.StringToIntegerConverter;
import cz.kpsys.portaro.commons.object.IdSettable;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadableByIdLoaderAdapter;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.GenericHookableDeleter;
import cz.kpsys.portaro.commons.object.repo.GenericHookableSaver;
import cz.kpsys.portaro.commons.object.repo.PostConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.TransactionalDeleter;
import cz.kpsys.portaro.commons.object.repo.TransactionalSaver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.database.FlushingMultiJpaSaver;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.hierarchy.HierarchyLoader;
import cz.kpsys.portaro.location.DepartmentLocationRelation;
import cz.kpsys.portaro.location.DepartmentLocationRelationDeleter;
import cz.kpsys.portaro.location.DepartmentLocationRelationEntity;
import cz.kpsys.portaro.location.DepartmentLocationRelationFromEntityConverter;
import cz.kpsys.portaro.location.DepartmentLocationRelationLoader;
import cz.kpsys.portaro.location.DepartmentLocationRelationToEntityConverter;
import cz.kpsys.portaro.location.EntityToLocationConverter;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.location.LocationDeleter;
import cz.kpsys.portaro.location.LocationEntity;
import cz.kpsys.portaro.location.LocationToEntityConverter;
import cz.kpsys.portaro.location.LocationWithDepartments;
import cz.kpsys.portaro.location.LocationWithDepartmentsDelegatingSaver;
import cz.kpsys.portaro.location.ReadableLocationsContextualProvider;
import cz.kpsys.portaro.location.SpringDbDepartmentLocationRelationLoader;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class PlacementConfig {
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final NamedParameterJdbcOperations notAutoCommittingJdbcTemplate;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final ObjectMapper xmlMapper;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final SettingLoader settingLoader;

    @Bean
    public Codebook<Location, Integer> locationLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(LocationEntity.class, "order").convertedEachBy((Converter)new EntityToLocationConverter()).staticCached(Location.class.getSimpleName()).build();
    }

    @Bean
    public ContextualProvider<Department, List<Location>> readableLocationsContextualProvider() {
        return new ReadableLocationsContextualProvider((HierarchyLoader)this.departmentAccessor, this.departmentLocationRelationLoader());
    }

    @Bean
    public DepartmentLocationRelationLoader departmentLocationRelationLoader() {
        return new SpringDbDepartmentLocationRelationLoader(this.jdbcTemplate, this.queryFactory, (AllByIdsLoadable)new AllByIdsLoadableByIdLoaderAdapter(this.departmentLoader), (AllByIdsLoadable)new AllByIdsLoadableByIdLoaderAdapter((ByIdLoadable)this.locationLoader()));
    }

    @Bean
    public Saver<Location, Location> locationSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new LocationToEntityConverter()).idSetting(LocationEntity.class, (Converter)new StringToIntegerConverter(), IdSettable::setId).withClearedCacheName(Location.class.getSimpleName()).build();
    }

    @Bean
    public DepartmentLocationRelationDeleter departmentLocationRelationDeleter(@NonNull Runnable saveTransactionAuthenticator) {
        Objects.requireNonNull(saveTransactionAuthenticator, "saveTransactionAuthenticator is marked non-null but is null");
        return new DepartmentLocationRelationDeleter(this.queryFactory, this.notAutoCommittingJdbcTemplate, saveTransactionAuthenticator);
    }

    @Bean
    public Saver<LocationWithDepartments, LocationWithDepartments> locationWithDepartmentsSaver(@NonNull Runnable saveTransactionAuthenticator) {
        Objects.requireNonNull(saveTransactionAuthenticator, "saveTransactionAuthenticator is marked non-null but is null");
        return CacheCleaningSaver.fromGenericCleaner((Saver)new TransactionalSaver((Saver)new LocationWithDepartmentsDelegatingSaver(this.departmentLocationRelationDeleter(saveTransactionAuthenticator), this.locationSaver(), this.departmentLocationRelationSaver(saveTransactionAuthenticator)), this.defaultTransactionTemplateFactory.get()), (CacheCleaner)this.appserverLocationsRefresher());
    }

    @Bean
    public Saver<List<DepartmentLocationRelation>, List<DepartmentLocationRelation>> departmentLocationRelationSaver(@NonNull Runnable saveTransactionAuthenticator) {
        Objects.requireNonNull(saveTransactionAuthenticator, "saveTransactionAuthenticator is marked non-null but is null");
        return new GenericHookableSaver((Saver)new TransactionalSaver((Saver)new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new DepartmentLocationRelationToEntityConverter(), (Saver)new FlushingMultiJpaSaver((JpaRepository)new SimpleJpaRepository(DepartmentLocationRelationEntity.class, this.entityManager))), (Converter)new DepartmentLocationRelationFromEntityConverter((AllByIdsLoadable)new AllByIdsLoadableByIdLoaderAdapter(this.departmentLoader), (AllByIdsLoadable)this.locationLoader())), this.defaultTransactionTemplateFactory.get())).addPreHook(saveTransactionAuthenticator);
    }

    @Bean
    public AppserverCustomSettingsRefresher appserverLocationsRefresher() {
        return new AppserverCustomSettingsRefresher(this.xmlMapper, this.mappingAppserver, this.settingLoader.getOnRootProvider(SettingKeys.APPSERVER_ENABLED), List.of("def_lokace", "def_pujc_lok")).afterTransactionCommit();
    }

    @Bean
    public Deleter<Location> locationDeleter(@NonNull Runnable saveTransactionAuthenticator) {
        Objects.requireNonNull(saveTransactionAuthenticator, "saveTransactionAuthenticator is marked non-null but is null");
        GenericHookableDeleter saver = new GenericHookableDeleter((Deleter)new CacheCleaningDeleter((Deleter)new TransactionalDeleter((Deleter)new LocationDeleter(this.notAutoCommittingJdbcTemplate, this.queryFactory), this.defaultTransactionTemplateFactory.get()), this.cacheService.createCleanerFor(Location.class.getSimpleName())));
        saver.addPreHook(saveTransactionAuthenticator);
        return saver;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForIntegerId(Location.class, (ByIdLoadable)this.locationLoader());
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "cacheService", "departmentLoader", "departmentAccessor", "saverBuilderFactory", "converterRegisterer", "defaultTransactionTemplateFactory", "entityManager", "notAutoCommittingJdbcTemplate", "codebookLoaderBuilderFactory", "xmlMapper", "mappingAppserver", "settingLoader"})
    @Generated
    public PlacementConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull CacheService cacheService, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull ConverterRegisterer converterRegisterer, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull EntityManager entityManager, @NonNull NamedParameterJdbcOperations notAutoCommittingJdbcTemplate, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull ObjectMapper xmlMapper, @NonNull MappingAppserverService mappingAppserver, @NonNull SettingLoader settingLoader) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(notAutoCommittingJdbcTemplate, "notAutoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(xmlMapper, "xmlMapper is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.cacheService = cacheService;
        this.departmentLoader = departmentLoader;
        this.departmentAccessor = departmentAccessor;
        this.saverBuilderFactory = saverBuilderFactory;
        this.converterRegisterer = converterRegisterer;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.entityManager = entityManager;
        this.notAutoCommittingJdbcTemplate = notAutoCommittingJdbcTemplate;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.xmlMapper = xmlMapper;
        this.mappingAppserver = mappingAppserver;
        this.settingLoader = settingLoader;
    }
}

