/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.DynamicCache;
import cz.kpsys.portaro.commons.cache.GuavaTimedDynamicCache;
import cz.kpsys.portaro.commons.object.BasicIdentified;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.record.CachedInternalRecordLoader;
import cz.kpsys.portaro.record.CachedKindedInternalRecordLoader;
import cz.kpsys.portaro.record.InternalRecordLoader;
import cz.kpsys.portaro.record.KindedInternalRecordLoader;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordStatus;
import cz.kpsys.portaro.record.SpringDbAllDatabasedRichRecordsByIdsLoader;
import cz.kpsys.portaro.record.SpringDbKindedAllDatabasedRecordsByIdsLoader;
import cz.kpsys.portaro.record.authority.RichAuthorityRowMapper;
import cz.kpsys.portaro.record.document.RichDocumentRowMapper;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class InternalRecordLoadConfig {
    @NonNull
    private final NamedParameterJdbcOperations notAutoCommittingJdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final Codebook<Fond, Integer> fondLoader;
    @NonNull
    private final Codebook<RecordStatus, Integer> recordStatusLoader;
    @NonNull
    private final CacheService cacheService;

    @Bean
    public SpringDbAllDatabasedRichRecordsByIdsLoader uncachedInternalRecordAllByIdsLoader() {
        RichDocumentRowMapper documentRowMapper = new RichDocumentRowMapper((ByIdLoadable)this.fondLoader, (ByIdLoadable)this.recordStatusLoader);
        RichAuthorityRowMapper authorityRowMapper = new RichAuthorityRowMapper((ByIdLoadable)this.fondLoader, (ByIdLoadable)this.recordStatusLoader);
        return new SpringDbAllDatabasedRichRecordsByIdsLoader(this.notAutoCommittingJdbcTemplate, this.queryFactory, (RowMapper)documentRowMapper, (RowMapper)authorityRowMapper);
    }

    @Bean
    public InternalRecordLoader internalRecordAllByIdsLoader() {
        return new CachedInternalRecordLoader(this.recordCache(), (InternalRecordLoader)this.uncachedInternalRecordAllByIdsLoader());
    }

    @Bean
    public KindedInternalRecordLoader kindedInternalRecordAllByIdsLoader() {
        return new CachedKindedInternalRecordLoader(this.recordCache(), (KindedInternalRecordLoader)new SpringDbKindedAllDatabasedRecordsByIdsLoader((RowMapper)this.uncachedInternalRecordAllByIdsLoader(), this.notAutoCommittingJdbcTemplate, this.queryFactory));
    }

    @Bean
    public DynamicCache<Record> recordCache() {
        GuavaTimedDynamicCache bean = new GuavaTimedDynamicCache(BasicIdentified::getId, Duration.ofSeconds(10L), false);
        this.cacheService.registerCleaner(Record.class.getSimpleName(), () -> ((GuavaTimedDynamicCache)bean).clear());
        return bean;
    }

    @ConstructorProperties(value={"notAutoCommittingJdbcTemplate", "queryFactory", "fondLoader", "recordStatusLoader", "cacheService"})
    @Generated
    public InternalRecordLoadConfig(@NonNull NamedParameterJdbcOperations notAutoCommittingJdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull Codebook<Fond, Integer> fondLoader, @NonNull Codebook<RecordStatus, Integer> recordStatusLoader, @NonNull CacheService cacheService) {
        Objects.requireNonNull(notAutoCommittingJdbcTemplate, "notAutoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(recordStatusLoader, "recordStatusLoader is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        this.notAutoCommittingJdbcTemplate = notAutoCommittingJdbcTemplate;
        this.queryFactory = queryFactory;
        this.fondLoader = fondLoader;
        this.recordStatusLoader = recordStatusLoader;
        this.cacheService = cacheService;
    }
}

