/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.appserver.GenericTableWriteSaver;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.TableWriteGenerator;
import cz.kpsys.portaro.auth.context.AuthenticatedContextualProvider;
import cz.kpsys.portaro.auth.context.TypedAuthenticatedContextualObjectModifier;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.contextual.ContextIgnoringContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.ProvidedProxiedList;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.TtlCachedProvider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdOptLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.GenericHookableSaver;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.TransactionalSaver;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.commons.util.ObjectUtil;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.database.FlushingJpaSaver;
import cz.kpsys.portaro.database.IntegerValueDatabaseLoader;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.department.DepartmentEntity;
import cz.kpsys.portaro.department.DepartmentSaveTableWriteGenerator;
import cz.kpsys.portaro.department.DepartmentToEntityConverter;
import cz.kpsys.portaro.department.activation.DefaultDepartmentActivator;
import cz.kpsys.portaro.department.activation.DepartmentActivator;
import cz.kpsys.portaro.department.creation.DefaultDepartmentCreator;
import cz.kpsys.portaro.department.creation.DepartmentCreationRequest;
import cz.kpsys.portaro.department.creation.DepartmentCreator;
import cz.kpsys.portaro.department.deletion.DefaultDepartmentDeleter;
import cz.kpsys.portaro.department.deletion.DepartmentDeleter;
import cz.kpsys.portaro.department.editation.DefaultDepartmentUpdater;
import cz.kpsys.portaro.department.editation.DepartmentEditationRequest;
import cz.kpsys.portaro.department.editation.DepartmentRecordUpdater;
import cz.kpsys.portaro.department.editation.DepartmentUpdater;
import cz.kpsys.portaro.domaineddepartment.DefaultDomainedDepartmentCreator;
import cz.kpsys.portaro.domaineddepartment.DepartmentCreatedResponseCurrentPageDialogResolver;
import cz.kpsys.portaro.domaineddepartment.DomainedDepartmentCreationRequest;
import cz.kpsys.portaro.domaineddepartment.DomainedDepartmentCreationRequestToDepartmentConverter;
import cz.kpsys.portaro.domaineddepartment.DomainedDepartmentCreator;
import cz.kpsys.portaro.domaineddepartment.ServerUrlUniquenessResolver;
import cz.kpsys.portaro.domaineddepartment.UniquenessResolver;
import cz.kpsys.portaro.event.Eventer;
import cz.kpsys.portaro.form.valueeditor.text.TextValueEditorModifier;
import cz.kpsys.portaro.formconfig.formfield.FormFieldsNamesContextualFunction;
import cz.kpsys.portaro.formconfig.valueeditor.AcceptableValuesResolver;
import cz.kpsys.portaro.formconfig.valueeditor.AuthenticatedAcceptableValuesResolver;
import cz.kpsys.portaro.hierarchy.HierarchyLoadScope;
import cz.kpsys.portaro.localization.Localization;
import cz.kpsys.portaro.localization.LocalizationDeleter;
import cz.kpsys.portaro.location.DepartmentLocationRelationDeleter;
import cz.kpsys.portaro.location.DepartmentLocationRelationLoader;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.location.LocationWithDepartments;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordStatusResolver;
import cz.kpsys.portaro.record.deletion.RecordHoldingDeletionCommand;
import cz.kpsys.portaro.record.edit.RecordEditationFactory;
import cz.kpsys.portaro.record.edit.RecordEditationHelper;
import cz.kpsys.portaro.record.edit.RecordEntryFieldTypeIdResolver;
import cz.kpsys.portaro.record.holding.RecordHoldingLoader;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingLoader;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.setting.SettingTypeId;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.deletion.UserDeletionCommand;
import cz.kpsys.portaro.user.edit.UserEditationFactory;
import cz.kpsys.portaro.web.page.CompositeCurrentPageDialogsResolver;
import cz.kpsys.portaro.web.page.CurrentPageDialogResolver;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class DepartmentEditConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DepartmentEditConfig.class);
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final Runnable saveTransactionAuthenticator;
    @NonNull
    private final Saver<CustomSetting<String>, ?> customSettingSaver;
    @NonNull
    private final Saver<LocationWithDepartments, LocationWithDepartments> locationWithDepartmentsSaver;
    @NonNull
    private final AllValuesProvider<Location> locationLoader;
    @NonNull
    private final Eventer eventer;
    @NonNull
    private final Codebook<Department, Integer> departmentLoader;
    @NonNull
    private final CompositeCurrentPageDialogsResolver currentPageDialogsResolver;
    @NonNull
    private final CustomSettingLoader customSettingLoader;
    private final @NonNull Provider<@NullableNotBlank String> rootServerUrlProvider;
    @NonNull
    private final DepartmentLocationRelationLoader departmentLocationRelationLoader;
    @NonNull
    private final Deleter<Location> locationDeleter;
    @NonNull
    private final AllValuesProvider<Localization> localizationLoader;
    @NonNull
    private final Saver<Localization, Localization> localizationSaver;
    @NonNull
    private final Deleter<CustomSetting<String>> customSettingDeleter;
    @NonNull
    private final DepartmentLocationRelationDeleter departmentLocationRelationDeleter;
    @NonNull
    private final RecordHoldingLoader recordHoldingLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, User> userSearchLoader;
    @NonNull
    private final Deleter<UserDeletionCommand> userDeleter;
    @NonNull
    private final UserEditationFactory userEditationFactory;
    @NonNull
    private final Deleter<RecordHoldingDeletionCommand> recordHoldingDeleter;
    @NonNull
    private final AuthenticatedContextualProvider<Department, List<Department>> editableDepartmentsAuthenticatedContextualProvider;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final NamedParameterJdbcOperations notAutoCommittingJdbcTemplate;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final LocalizationDeleter localizationDeleter;
    @NonNull
    private final ByIdLoadable<Record, UUID> recordLoader;
    @NonNull
    private final RecordEditationFactory recordEditationFactory;
    @NonNull
    private final RecordEntryFieldTypeIdResolver recordEntryFieldTypeIdResolver;
    @NonNull
    private final RecordEditationHelper recordEditationHelper;
    @NonNull
    private final RecordStatusResolver recordStatusResolver;

    @Bean
    public AcceptableValuesResolver<DomainedDepartmentCreationRequest, Department> domainedDepartmentCreationAllowedParentDepartmentsResolver() {
        return (request, ctx) -> {
            if (((Boolean)this.settingLoader.getOnRoot(SettingKeys.DEPARTMENT_CREATION_ACCEPTABLE_PARENT_DEPARTMENTS_SHOW_ALL_CHILDS)).booleanValue()) {
                return this.departmentAccessor.getChildren(ctx);
            }
            List departmentIds = (List)this.settingLoader.getOnRoot(SettingKeys.DEPARTMENT_CREATION_ACCEPTABLE_PARENT_DEPARTMENTS);
            return ListUtil.filterAndSortByRule((Collection)this.departmentAccessor.getAll(), (Collection)departmentIds);
        };
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<DomainedDepartmentCreationRequest> domainedDepartmentCreationRequestDefaulter() {
        return new DomainedDepartmentCreationRequest.DomainedDepartmentCreationRequestDefaulter(this.domainedDepartmentCreationAllowedParentDepartmentsResolver());
    }

    @Bean
    public TextValueEditorModifier<DomainedDepartmentCreationRequest> departmentCreationServerUrlEditorModifier() {
        return new DomainedDepartmentCreationRequest.DepartmentCreationServerUrlEditorModifier(this.rootServerUrlProvider.throwingWhenNull(), this.settingLoader.getDepartmentedProvider(SettingKeys.DEPARTMENT_CREATION_CUSTOM_PARENT_DOMAIN_ENABLED), this.settingLoader.getDepartmentedProvider(SettingKeys.DEPARTMENT_CREATION_CUSTOM_PARENT_DOMAIN_VALUE).throwingWhenNull());
    }

    @Bean
    public DomainedDepartmentCreator domainedDepartmentCreator() {
        return new DefaultDomainedDepartmentCreator(new DomainedDepartmentCreationRequestToDepartmentConverter((AllValuesProvider)this.departmentLoader), this.departmentSaver(), (ByIdOptLoadable)this.departmentLoader, this.customSettingSaver, this.locationWithDepartmentsSaver, this.locationLoader, (SettingTypeId)CoreSettingKeys.SERVER_URL, this.eventer, this.customSettingLoader);
    }

    @Bean
    public DepartmentActivator departmentActivator() {
        return new DefaultDepartmentActivator((ByIdLoadable)this.departmentLoader, this.departmentSaver(), this.eventer);
    }

    @Bean
    public UniquenessResolver<String> serverUrlUniquenessResolver() {
        return new ServerUrlUniquenessResolver((List)new ProvidedProxiedList((Provider)TtlCachedProvider.ofSeconds((long)10L, () -> new ArrayList(this.settingLoader.getContextToValueMap(CoreSettingKeys.SERVER_URL).values()))));
    }

    @Bean
    public Saver<Department, DepartmentEntity> departmentJpaSaver() {
        GenericHookableSaver saver = new GenericHookableSaver((Saver)new TransactionalSaver((Saver)new PreConvertingSaver((Converter)new DepartmentToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(DepartmentEntity.class, this.entityManager))), this.defaultTransactionTemplateFactory.get()));
        saver.addPreHook(this.saveTransactionAuthenticator);
        CacheCleaner cacheCleaner = this.cacheService.createCleanerFor(Department.class.getSimpleName());
        saver.addPostSuccessHook(() -> ((CacheCleaner)cacheCleaner).clearCache());
        return saver;
    }

    @Bean
    public Saver<Department, DepartmentEntity> departmentSaver() {
        GenericHookableSaver saver = new GenericHookableSaver((Saver)new PreConvertingSaver((Converter)new DepartmentToEntityConverter(), (Saver)GenericTableWriteSaver.of((TableWriteGenerator)new DepartmentSaveTableWriteGenerator(), (DmlAppserverService)this.dmlAppserverService, (CacheCleaner[])new CacheCleaner[]{this.cacheService.createCleanerFor(Department.class.getSimpleName())})));
        saver.addPreHook(this.saveTransactionAuthenticator);
        return saver;
    }

    @Bean
    public DepartmentCreator departmentCreator() {
        return new DefaultDepartmentCreator((ContextualProvider)ContextIgnoringContextualProvider.of((Provider)IntegerValueDatabaseLoader.ofMaxPlusOne((NamedParameterJdbcOperations)this.notAutoCommittingJdbcTemplate, (QueryFactory)this.queryFactory, (String)"def_pujc", (String)"id_pujc")), this.departmentSaver(), (AllValuesProvider)this.departmentLoader, this.eventer);
    }

    @Bean
    public DepartmentUpdater departmentUpdater() {
        return new DefaultDepartmentUpdater((ByIdLoadable)this.departmentLoader, this.departmentSaver(), this.departmentRecordUpdater(), this.recordLoader, this.recordStatusResolver);
    }

    @Bean
    public DepartmentRecordUpdater departmentRecordUpdater() {
        return new DepartmentRecordUpdater(this.recordLoader, this.recordEditationFactory, this.recordEntryFieldTypeIdResolver, this.recordEditationHelper);
    }

    @Bean
    public AuthenticatedAcceptableValuesResolver<DepartmentEditationRequest, Department> departmentEditationAllowedParentDepartmentsResolver() {
        return (request, currentDepartment, currentAuth) -> {
            List allDepartments = (List)this.editableDepartmentsAuthenticatedContextualProvider.getOn((Object)currentAuth, (Object)currentDepartment);
            List subDepartmentsOfEditedDepartment = this.departmentAccessor.getAllByScope((Object)request.department(), HierarchyLoadScope.SUBTREE);
            return ListUtil.removeAll((Collection)allDepartments, (Collection)subDepartmentsOfEditedDepartment);
        };
    }

    @Bean
    public FormFieldsNamesContextualFunction<DepartmentEditationRequest, Department> departmentEditationRequestRequiredPropsProvider() {
        List<String> potentiallyRequiredFields = List.of("parentDepartment", "order");
        return (departmentEditationRequest, ctx) -> {
            List declaredFields = ObjectUtil.getFieldNameStream(DepartmentEditationRequest.class).toList();
            if (departmentEditationRequest.department().equals(ctx)) {
                return ListUtil.removeAll(declaredFields, (Collection)potentiallyRequiredFields);
            }
            return declaredFields;
        };
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<DepartmentCreationRequest> departmentCreationRequestDefaulter() {
        return new DepartmentCreationRequest.DepartmentCreationRequestDefaulter(this.editableDepartmentsAuthenticatedContextualProvider);
    }

    @Bean
    public DepartmentDeleter departmentDeleter() {
        return new DefaultDepartmentDeleter(this.departmentAccessor, this.departmentLocationRelationLoader, this.locationDeleter, this.localizationLoader, this.localizationSaver, this.departmentSaver(), this.eventer, this.customSettingDeleter, this.customSettingLoader, this.departmentLocationRelationDeleter, this.recordHoldingLoader, this.userSearchLoader, this.userDeleter, this.userEditationFactory, this.recordHoldingDeleter, (Deleter)this.localizationDeleter);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerCurrentPageDialogs() {
        this.currentPageDialogsResolver.add(Integer.valueOf(1000), (CurrentPageDialogResolver)new DepartmentCreatedResponseCurrentPageDialogResolver());
    }

    @ConstructorProperties(value={"departmentAccessor", "settingLoader", "saveTransactionAuthenticator", "customSettingSaver", "locationWithDepartmentsSaver", "locationLoader", "eventer", "departmentLoader", "currentPageDialogsResolver", "customSettingLoader", "rootServerUrlProvider", "departmentLocationRelationLoader", "locationDeleter", "localizationLoader", "localizationSaver", "customSettingDeleter", "departmentLocationRelationDeleter", "recordHoldingLoader", "userSearchLoader", "userDeleter", "userEditationFactory", "recordHoldingDeleter", "editableDepartmentsAuthenticatedContextualProvider", "queryFactory", "entityManager", "defaultTransactionTemplateFactory", "notAutoCommittingJdbcTemplate", "cacheService", "dmlAppserverService", "localizationDeleter", "recordLoader", "recordEditationFactory", "recordEntryFieldTypeIdResolver", "recordEditationHelper", "recordStatusResolver"})
    @Generated
    public DepartmentEditConfig(@NonNull DepartmentAccessor departmentAccessor, @NonNull SettingLoader settingLoader, @NonNull Runnable saveTransactionAuthenticator, @NonNull Saver<CustomSetting<String>, ?> customSettingSaver, @NonNull Saver<LocationWithDepartments, LocationWithDepartments> locationWithDepartmentsSaver, @NonNull AllValuesProvider<Location> locationLoader, @NonNull Eventer eventer, @NonNull Codebook<Department, Integer> departmentLoader, @NonNull CompositeCurrentPageDialogsResolver currentPageDialogsResolver, @NonNull CustomSettingLoader customSettingLoader, @NonNull Provider<@NullableNotBlank String> rootServerUrlProvider, @NonNull DepartmentLocationRelationLoader departmentLocationRelationLoader, @NonNull Deleter<Location> locationDeleter, @NonNull AllValuesProvider<Localization> localizationLoader, @NonNull Saver<Localization, Localization> localizationSaver, @NonNull Deleter<CustomSetting<String>> customSettingDeleter, @NonNull DepartmentLocationRelationDeleter departmentLocationRelationDeleter, @NonNull RecordHoldingLoader recordHoldingLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, User> userSearchLoader, @NonNull Deleter<UserDeletionCommand> userDeleter, @NonNull UserEditationFactory userEditationFactory, @NonNull Deleter<RecordHoldingDeletionCommand> recordHoldingDeleter, @NonNull AuthenticatedContextualProvider<Department, List<Department>> editableDepartmentsAuthenticatedContextualProvider, @NonNull QueryFactory queryFactory, @NonNull EntityManager entityManager, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull NamedParameterJdbcOperations notAutoCommittingJdbcTemplate, @NonNull CacheService cacheService, @NonNull DmlAppserverService dmlAppserverService, @NonNull LocalizationDeleter localizationDeleter, @NonNull ByIdLoadable<Record, UUID> recordLoader, @NonNull RecordEditationFactory recordEditationFactory, @NonNull RecordEntryFieldTypeIdResolver recordEntryFieldTypeIdResolver, @NonNull RecordEditationHelper recordEditationHelper, @NonNull RecordStatusResolver recordStatusResolver) {
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(saveTransactionAuthenticator, "saveTransactionAuthenticator is marked non-null but is null");
        Objects.requireNonNull(customSettingSaver, "customSettingSaver is marked non-null but is null");
        Objects.requireNonNull(locationWithDepartmentsSaver, "locationWithDepartmentsSaver is marked non-null but is null");
        Objects.requireNonNull(locationLoader, "locationLoader is marked non-null but is null");
        Objects.requireNonNull(eventer, "eventer is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(currentPageDialogsResolver, "currentPageDialogsResolver is marked non-null but is null");
        Objects.requireNonNull(customSettingLoader, "customSettingLoader is marked non-null but is null");
        Objects.requireNonNull(rootServerUrlProvider, "rootServerUrlProvider is marked non-null but is null");
        Objects.requireNonNull(departmentLocationRelationLoader, "departmentLocationRelationLoader is marked non-null but is null");
        Objects.requireNonNull(locationDeleter, "locationDeleter is marked non-null but is null");
        Objects.requireNonNull(localizationLoader, "localizationLoader is marked non-null but is null");
        Objects.requireNonNull(localizationSaver, "localizationSaver is marked non-null but is null");
        Objects.requireNonNull(customSettingDeleter, "customSettingDeleter is marked non-null but is null");
        Objects.requireNonNull(departmentLocationRelationDeleter, "departmentLocationRelationDeleter is marked non-null but is null");
        Objects.requireNonNull(recordHoldingLoader, "recordHoldingLoader is marked non-null but is null");
        Objects.requireNonNull(userSearchLoader, "userSearchLoader is marked non-null but is null");
        Objects.requireNonNull(userDeleter, "userDeleter is marked non-null but is null");
        Objects.requireNonNull(userEditationFactory, "userEditationFactory is marked non-null but is null");
        Objects.requireNonNull(recordHoldingDeleter, "recordHoldingDeleter is marked non-null but is null");
        Objects.requireNonNull(editableDepartmentsAuthenticatedContextualProvider, "editableDepartmentsAuthenticatedContextualProvider is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(notAutoCommittingJdbcTemplate, "notAutoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(localizationDeleter, "localizationDeleter is marked non-null but is null");
        Objects.requireNonNull(recordLoader, "recordLoader is marked non-null but is null");
        Objects.requireNonNull(recordEditationFactory, "recordEditationFactory is marked non-null but is null");
        Objects.requireNonNull(recordEntryFieldTypeIdResolver, "recordEntryFieldTypeIdResolver is marked non-null but is null");
        Objects.requireNonNull(recordEditationHelper, "recordEditationHelper is marked non-null but is null");
        Objects.requireNonNull(recordStatusResolver, "recordStatusResolver is marked non-null but is null");
        this.departmentAccessor = departmentAccessor;
        this.settingLoader = settingLoader;
        this.saveTransactionAuthenticator = saveTransactionAuthenticator;
        this.customSettingSaver = customSettingSaver;
        this.locationWithDepartmentsSaver = locationWithDepartmentsSaver;
        this.locationLoader = locationLoader;
        this.eventer = eventer;
        this.departmentLoader = departmentLoader;
        this.currentPageDialogsResolver = currentPageDialogsResolver;
        this.customSettingLoader = customSettingLoader;
        this.rootServerUrlProvider = rootServerUrlProvider;
        this.departmentLocationRelationLoader = departmentLocationRelationLoader;
        this.locationDeleter = locationDeleter;
        this.localizationLoader = localizationLoader;
        this.localizationSaver = localizationSaver;
        this.customSettingDeleter = customSettingDeleter;
        this.departmentLocationRelationDeleter = departmentLocationRelationDeleter;
        this.recordHoldingLoader = recordHoldingLoader;
        this.userSearchLoader = userSearchLoader;
        this.userDeleter = userDeleter;
        this.userEditationFactory = userEditationFactory;
        this.recordHoldingDeleter = recordHoldingDeleter;
        this.editableDepartmentsAuthenticatedContextualProvider = editableDepartmentsAuthenticatedContextualProvider;
        this.queryFactory = queryFactory;
        this.entityManager = entityManager;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.notAutoCommittingJdbcTemplate = notAutoCommittingJdbcTemplate;
        this.cacheService = cacheService;
        this.dmlAppserverService = dmlAppserverService;
        this.localizationDeleter = localizationDeleter;
        this.recordLoader = recordLoader;
        this.recordEditationFactory = recordEditationFactory;
        this.recordEntryFieldTypeIdResolver = recordEntryFieldTypeIdResolver;
        this.recordEditationHelper = recordEditationHelper;
        this.recordStatusResolver = recordStatusResolver;
    }
}

