/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.modules;

import cz.kpsys.portaro.action.ActionSaver;
import cz.kpsys.portaro.auth.UserAuthentication;
import cz.kpsys.portaro.commons.convert.StringToIntegerConverter;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.IdSettable;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.PostConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.database.FlushingJpaSaver;
import cz.kpsys.portaro.database.IntegerValueDatabaseLoader;
import cz.kpsys.portaro.exemplar.volume.Volume;
import cz.kpsys.portaro.export.Exporter;
import cz.kpsys.portaro.export.ExporterResolver;
import cz.kpsys.portaro.export.XlsFileExporterByCsvExporter;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.LoadedIdentifiedFile;
import cz.kpsys.portaro.file.LoadedIdentifiedFileLoaderDelegating;
import cz.kpsys.portaro.file.security.IdentifiedFileSaveCommand;
import cz.kpsys.portaro.finance.Currency;
import cz.kpsys.portaro.pops.AgreementDeleter;
import cz.kpsys.portaro.pops.AgreementDeletionCommand;
import cz.kpsys.portaro.pops.DemandApiController;
import cz.kpsys.portaro.pops.DemandLoader;
import cz.kpsys.portaro.pops.DemandLoaderSecurityHelper;
import cz.kpsys.portaro.pops.DemandLoaderSecurityHelperImpl;
import cz.kpsys.portaro.pops.EntitiesToDemandsConverter;
import cz.kpsys.portaro.pops.EntitiesToOffersConverter;
import cz.kpsys.portaro.pops.EntitiesToTendersConverter;
import cz.kpsys.portaro.pops.Offer;
import cz.kpsys.portaro.pops.OfferApiController;
import cz.kpsys.portaro.pops.OfferCreator;
import cz.kpsys.portaro.pops.OfferDeleter;
import cz.kpsys.portaro.pops.OfferDeletionCommand;
import cz.kpsys.portaro.pops.OfferEntity;
import cz.kpsys.portaro.pops.OfferFromEntityConverter;
import cz.kpsys.portaro.pops.OfferLoader;
import cz.kpsys.portaro.pops.OfferSaveCommand;
import cz.kpsys.portaro.pops.OfferSaver;
import cz.kpsys.portaro.pops.OfferToEntityConverter;
import cz.kpsys.portaro.pops.PopsSecurityActions;
import cz.kpsys.portaro.pops.SpringDbDemandLoader;
import cz.kpsys.portaro.pops.SpringDbOfferLoader;
import cz.kpsys.portaro.pops.Tender;
import cz.kpsys.portaro.pops.TenderApiController;
import cz.kpsys.portaro.pops.TenderEntity;
import cz.kpsys.portaro.pops.TenderLoader;
import cz.kpsys.portaro.pops.TenderLoaderDelegating;
import cz.kpsys.portaro.pops.TenderToRowConverter;
import cz.kpsys.portaro.pops.agreement.Agreement;
import cz.kpsys.portaro.pops.agreement.AgreementApiController;
import cz.kpsys.portaro.pops.agreement.AgreementConfirmer;
import cz.kpsys.portaro.pops.agreement.AgreementCreator;
import cz.kpsys.portaro.pops.agreement.AgreementDeconfirmer;
import cz.kpsys.portaro.pops.agreement.AgreementEntity;
import cz.kpsys.portaro.pops.agreement.AgreementFileVerifier;
import cz.kpsys.portaro.pops.agreement.AgreementFromEntityConverter;
import cz.kpsys.portaro.pops.agreement.AgreementLoader;
import cz.kpsys.portaro.pops.agreement.AgreementProcessor;
import cz.kpsys.portaro.pops.agreement.AgreementSaveCommand;
import cz.kpsys.portaro.pops.agreement.AgreementSaver;
import cz.kpsys.portaro.pops.agreement.AgreementStyle;
import cz.kpsys.portaro.pops.agreement.AgreementToEntityConverter;
import cz.kpsys.portaro.pops.agreement.ButtonAgreementCreator;
import cz.kpsys.portaro.pops.agreement.FileAgreementCreator;
import cz.kpsys.portaro.pops.agreement.FileAgreementCreatorITextPdf;
import cz.kpsys.portaro.pops.agreement.FileAgreementCreatorSavingProxy;
import cz.kpsys.portaro.pops.agreement.ITextPdfAgreementFileVerifier;
import cz.kpsys.portaro.pops.agreement.OfferingStateApiController;
import cz.kpsys.portaro.pops.agreement.OfferingStateResolver;
import cz.kpsys.portaro.pops.agreement.SignedAgreementUploader;
import cz.kpsys.portaro.pops.agreement.SignedFileVerifyingAgreementConfirmer;
import cz.kpsys.portaro.pops.agreement.SpringDbAgreementLoader;
import cz.kpsys.portaro.pops.export.CsvFileTenderDemandsExporter;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.ViewableRecord;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.template.Templates;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.role.supplier.SupplierRole;
import cz.kpsys.portaro.view.ViewableItemsTypedConverter;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
public class PopsConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PopsConfig.class);
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final AllByIdsLoadable<Record, UUID> richRecordLoader;
    @NonNull
    private final IdAndIdsLoadable<Record, UUID> nonDetailedRichRecordLoader;
    @NonNull
    private final AllByIdsLoadable<Volume, Integer> volumeLoader;
    @NonNull
    private final IdAndIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final @NonNull Provider<@NonNull Currency> defaultCurrencyProvider;
    @NonNull
    private final ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader;
    @NonNull
    private final FileDataStreamer fileDataStreamer;
    @NonNull
    private final Saver<IdentifiedFileSaveCommand, IdentifiedFile> loadedIdentifiedFileSaver;
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final ExporterResolver exporterResolver;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final Provider<Integer> portaroUserIdProvider;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final ActionSaver actionSaver;
    @NonNull
    private final ViewableItemsTypedConverter<Record, ViewableRecord> recordsToViewableRecordItemsWithoutExportsConverter;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final NamedParameterJdbcOperations notAutoCommittingJdbcTemplate;

    @Bean
    public TenderApiController tenderApiController() {
        log.debug("Enabling POPS module");
        return new TenderApiController(this.tenderLoader(), this.tenderSaver(), this.tenderDeleter());
    }

    @Bean
    public OfferApiController offerApiController() {
        return new OfferApiController(this.offerLoader(), this.offerDeleter(), this.defaultCurrencyProvider, this.offerCreator(), this.securityManager);
    }

    @Bean
    public DemandApiController demandApiController() {
        return new DemandApiController(this.securityManager, this.demandLoaderSecurityHelper(), this.tenderLoader(), this.recordsToViewableRecordItemsWithoutExportsConverter);
    }

    @Bean
    public AgreementApiController agreementApiController() {
        return new AgreementApiController(this.tenderLoader(), this.fileAgreementCreator(), this.agreementProcessor(), this.signedAgreementUploader());
    }

    @Bean
    public OfferingStateApiController offeringStateApiController() {
        return new OfferingStateApiController(this.tenderLoader(), this.offeringStateResolver());
    }

    @Bean
    public AgreementConfirmer agreementConfirmer() {
        return new SignedFileVerifyingAgreementConfirmer((AgreementFileVerifier)new ITextPdfAgreementFileVerifier(), this.agreementSaver(), this.settingLoader.getOnRootProvider(SettingKeys.AGREEMENT_STYLE));
    }

    @Bean
    public FileAgreementCreator fileAgreementCreator() {
        Provider agreementFileSigningEnabled = () -> this.settingLoader.getOnRootProvider(SettingKeys.AGREEMENT_STYLE).get() == AgreementStyle.FILE_SIGNING;
        return new FileAgreementCreatorSavingProxy((FileAgreementCreator)new FileAgreementCreatorITextPdf(this.demandLoader(), agreementFileSigningEnabled, this.nonDetailedRichRecordLoader), this.agreementSaver(), this.portaroUserIdProvider, agreementFileSigningEnabled);
    }

    @Bean
    public Saver<AgreementSaveCommand, Agreement> agreementSaver() {
        return new AgreementSaver((Saver)new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new AgreementToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(AgreementEntity.class, this.entityManager))), (Converter)new AgreementFromEntityConverter(this.loadedIdentifiedFileLoader())), this.loadedIdentifiedFileSaver);
    }

    @Bean
    public AgreementCreator buttonAgreementCreator() {
        return new ButtonAgreementCreator(this.agreementSaver(), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public AgreementProcessor agreementProcessor() {
        return new AgreementProcessor(this.buttonAgreementCreator(), this.agreementConfirmer(), this.defaultTransactionTemplateFactory.get(), this.agreementLoader());
    }

    @Bean
    public SignedAgreementUploader signedAgreementUploader() {
        return new SignedAgreementUploader(this.defaultTransactionTemplateFactory.get(), this.agreementConfirmer(), this.agreementSaver(), this.agreementLoader(), this.tenderLoader());
    }

    @Bean
    public OfferingStateResolver offeringStateResolver() {
        return new OfferingStateResolver(this.agreementLoader(), this.offerLoader(), this.settingLoader.getOnRootProvider(SettingKeys.AGREEMENT_STYLE));
    }

    @Bean
    public AgreementLoader agreementLoader() {
        return new SpringDbAgreementLoader(this.jdbcTemplate, this.queryFactory, this.loadedIdentifiedFileLoader());
    }

    @Bean
    public ByIdLoadable<LoadedIdentifiedFile, Long> loadedIdentifiedFileLoader() {
        return new LoadedIdentifiedFileLoaderDelegating(this.identifiedFileLoader, this.fileDataStreamer);
    }

    @Bean
    public Deleter<AgreementDeletionCommand> agreementDeleter() {
        return new AgreementDeleter(this.agreementSaver());
    }

    @Bean
    public TenderLoader tenderLoader() {
        Codebook tenderCodebook = this.codebookLoaderBuilderFactory.create().providedByJpa(TenderEntity.class, "createDate").converted((Converter)new EntitiesToTendersConverter((AllByIdsLoadable)this.basicUserLoader)).staticCached(Tender.class.getSimpleName()).build();
        return new TenderLoaderDelegating(tenderCodebook);
    }

    @Bean
    public Saver<Tender, Tender> tenderSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new TenderToRowConverter()).idSetting(TenderEntity.class, (Converter)new StringToIntegerConverter(), IdSettable::setId).withClearedCacheName(TenderEntity.class.getSimpleName()).build();
    }

    @Bean
    public Deleter<Tender> tenderDeleter() {
        return this.modelBeanBuilder.hibernateSoftDeleter(TenderEntity.class, (Converter)new TenderToRowConverter()).withClearedCacheName(TenderEntity.class.getSimpleName()).build();
    }

    @Bean
    public OfferLoader offerLoader() {
        return new SpringDbOfferLoader(this.jdbcTemplate, this.queryFactory, (Converter)new EntitiesToOffersConverter((AllByIdsLoadable)this.nonDetailedRichRecordLoader, (AllByIdsLoadable)this.basicUserLoader));
    }

    @Bean
    public Saver<OfferSaveCommand, Offer> offerSaver() {
        return new OfferSaver((Saver)new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new OfferToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(OfferEntity.class, this.entityManager))), (Converter)new OfferFromEntityConverter((ByIdLoadable)this.basicUserLoader, (ByIdLoadable)this.nonDetailedRichRecordLoader)), this.agreementLoader(), this.agreementDeconfirmer());
    }

    @Bean
    public OfferCreator offerCreator() {
        return new OfferCreator(this.offerSaver(), this.defaultTransactionTemplateFactory.get(), Provider.of((Supplier)IntegerValueDatabaseLoader.ofSequenceValue((String)"SEQ_ID_NABIDKY", (NamedParameterJdbcOperations)this.notAutoCommittingJdbcTemplate, (QueryFactory)this.queryFactory)), this.securityManager, this.demandLoader(), this.offerLoader(), this.actionSaver, (ByIdLoadable)this.nonDetailedRichRecordLoader);
    }

    @Bean
    public Deleter<OfferDeletionCommand> offerDeleter() {
        return new OfferDeleter(this.offerSaver(), this.actionSaver, this.demandLoader(), this.offerLoader(), this.securityManager, this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public AgreementDeconfirmer agreementDeconfirmer() {
        TransactionTemplate transactionTemplate = this.defaultTransactionTemplateFactory.get();
        return command -> transactionTemplate.executeWithoutResult(transactionStatus -> this.agreementDeleter().delete((Object)new AgreementDeletionCommand(command.agreement(), command.currentAuth(), command.ctx())));
    }

    @Bean
    public DemandLoader demandLoader() {
        return new SpringDbDemandLoader(this.jdbcTemplate, this.queryFactory, this.offerLoader(), (Converter)new EntitiesToDemandsConverter(this.richRecordLoader, this.volumeLoader, (ByIdLoadable)this.tenderLoader()));
    }

    @Bean
    public DemandLoaderSecurityHelper demandLoaderSecurityHelper() {
        return new DemandLoaderSecurityHelperImpl(this.securityManager, this.demandLoader());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerExports() {
        CsvFileTenderDemandsExporter tenderOffersCsvExporter = new CsvFileTenderDemandsExporter("tender-demands.csv", Templates.TEMPLATE_TENDER_OFFERS_CSV, this.templateEngine, this.demandLoader());
        this.exporterResolver.addStatic("CsvFileTenderDemands", (Exporter)tenderOffersCsvExporter);
        XlsFileExporterByCsvExporter tenderOffersXlsExporter = new XlsFileExporterByCsvExporter("tender-demands.xls", (Exporter)tenderOffersCsvExporter);
        this.exporterResolver.addStatic("XlsFileTenderDemands", (Exporter)tenderOffersXlsExporter);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForIntegerId(Tender.class, (ByIdLoadable)this.tenderLoader());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        PermissionResolver currentEvidedAuthenticActiveCanRepresentOfferSupplier = PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActive(), (auth, department, offer) -> {
            UUID userAuthority = (UUID)auth.getActiveUser().getRid();
            boolean userCanRepresentCompanyOfThisOffer = userAuthority != null && userAuthority.equals(offer.getSupplierAuthority().getId());
            return PermissionResult.ifCan((boolean)userCanRepresentCompanyOfThisOffer);
        }});
        this.permissionRegistry.add(PopsSecurityActions.POPS_TENDER_SHOW, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{(auth, ctx, tender) -> tender.getPhase() >= 2 ? PermissionResult.allow() : PermissionResult.cannot((UserAuthentication)auth, (Text)Texts.ofNative((String)"Cannot show not-opened tender")), this.permissionFactory.edit()}));
        this.permissionRegistry.add(PopsSecurityActions.POPS_TENDER_SAVE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{PermissionResolver.adaptingSubject(Tender::getCreator, (PermissionResolver)this.permissionFactory.currentIsSubjectUser()), this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN"})}));
        this.permissionRegistry.add(PopsSecurityActions.POPS_TENDER_DELETE, (PermissionResolver)PermissionResolver.adaptingSubject(Tender::getCreator, (PermissionResolver)this.permissionFactory.currentIsSubjectUser()));
        this.permissionRegistry.add(PopsSecurityActions.POPS_ALL_OFFERS_SHOW, this.permissionFactory.edit());
        this.permissionRegistry.add(PopsSecurityActions.POPS_SUPPLIER_OFFERS_SHOW, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser(), this.permissionFactory.subjectUserIsEvidedActiveWithRole(SupplierRole.class)}));
        this.permissionRegistry.add(PopsSecurityActions.POPS_OFFER_SHOW, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.edit(), currentEvidedAuthenticActiveCanRepresentOfferSupplier}));
        this.permissionRegistry.add(PopsSecurityActions.POPS_OFFER_SAVE, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN"}), currentEvidedAuthenticActiveCanRepresentOfferSupplier}));
        this.permissionRegistry.add(PopsSecurityActions.POPS_OFFER_DELETE, this.permissionRegistry.getLazy(PopsSecurityActions.POPS_OFFER_SAVE));
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "modelBeanBuilder", "codebookLoaderBuilderFactory", "saverBuilderFactory", "settingLoader", "richRecordLoader", "nonDetailedRichRecordLoader", "volumeLoader", "basicUserLoader", "defaultCurrencyProvider", "identifiedFileLoader", "fileDataStreamer", "loadedIdentifiedFileSaver", "templateEngine", "exporterResolver", "converterRegisterer", "portaroUserIdProvider", "permissionRegistry", "securityManager", "permissionFactory", "actionSaver", "recordsToViewableRecordItemsWithoutExportsConverter", "defaultTransactionTemplateFactory", "entityManager", "notAutoCommittingJdbcTemplate"})
    @Generated
    public PopsConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull SettingLoader settingLoader, @NonNull AllByIdsLoadable<Record, UUID> richRecordLoader, @NonNull IdAndIdsLoadable<Record, UUID> nonDetailedRichRecordLoader, @NonNull AllByIdsLoadable<Volume, Integer> volumeLoader, @NonNull IdAndIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull @NonNull Provider<@NonNull Currency> defaultCurrencyProvider, @NonNull ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader, @NonNull FileDataStreamer fileDataStreamer, @NonNull Saver<IdentifiedFileSaveCommand, IdentifiedFile> loadedIdentifiedFileSaver, @NonNull TemplateEngine templateEngine, @NonNull ExporterResolver exporterResolver, @NonNull ConverterRegisterer converterRegisterer, @NonNull Provider<Integer> portaroUserIdProvider, @NonNull PermissionRegistry permissionRegistry, @NonNull SecurityManager securityManager, @NonNull PermissionFactory permissionFactory, @NonNull ActionSaver actionSaver, @NonNull ViewableItemsTypedConverter<Record, ViewableRecord> recordsToViewableRecordItemsWithoutExportsConverter, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull EntityManager entityManager, @NonNull NamedParameterJdbcOperations notAutoCommittingJdbcTemplate) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(richRecordLoader, "richRecordLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedRichRecordLoader, "nonDetailedRichRecordLoader is marked non-null but is null");
        Objects.requireNonNull(volumeLoader, "volumeLoader is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(defaultCurrencyProvider, "defaultCurrencyProvider is marked non-null but is null");
        Objects.requireNonNull(identifiedFileLoader, "identifiedFileLoader is marked non-null but is null");
        Objects.requireNonNull(fileDataStreamer, "fileDataStreamer is marked non-null but is null");
        Objects.requireNonNull(loadedIdentifiedFileSaver, "loadedIdentifiedFileSaver is marked non-null but is null");
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(exporterResolver, "exporterResolver is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(portaroUserIdProvider, "portaroUserIdProvider is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(actionSaver, "actionSaver is marked non-null but is null");
        Objects.requireNonNull(recordsToViewableRecordItemsWithoutExportsConverter, "recordsToViewableRecordItemsWithoutExportsConverter is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(notAutoCommittingJdbcTemplate, "notAutoCommittingJdbcTemplate is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.modelBeanBuilder = modelBeanBuilder;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.saverBuilderFactory = saverBuilderFactory;
        this.settingLoader = settingLoader;
        this.richRecordLoader = richRecordLoader;
        this.nonDetailedRichRecordLoader = nonDetailedRichRecordLoader;
        this.volumeLoader = volumeLoader;
        this.basicUserLoader = basicUserLoader;
        this.defaultCurrencyProvider = defaultCurrencyProvider;
        this.identifiedFileLoader = identifiedFileLoader;
        this.fileDataStreamer = fileDataStreamer;
        this.loadedIdentifiedFileSaver = loadedIdentifiedFileSaver;
        this.templateEngine = templateEngine;
        this.exporterResolver = exporterResolver;
        this.converterRegisterer = converterRegisterer;
        this.portaroUserIdProvider = portaroUserIdProvider;
        this.permissionRegistry = permissionRegistry;
        this.securityManager = securityManager;
        this.permissionFactory = permissionFactory;
        this.actionSaver = actionSaver;
        this.recordsToViewableRecordItemsWithoutExportsConverter = recordsToViewableRecordItemsWithoutExportsConverter;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.entityManager = entityManager;
        this.notAutoCommittingJdbcTemplate = notAutoCommittingJdbcTemplate;
    }
}

