/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.appserver.config.AppserverConfigService;
import cz.kpsys.portaro.appserver.config.AppserverCustomSettingsRefresher;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheCleaningDeleter;
import cz.kpsys.portaro.commons.cache.CacheCleaningSaver;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.GenericHookableDeleter;
import cz.kpsys.portaro.commons.object.repo.GenericHookableSaver;
import cz.kpsys.portaro.commons.object.repo.PreConvertingDeleter;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.TransactionalDeleter;
import cz.kpsys.portaro.commons.object.repo.TransactionalSaver;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.database.FlushingJpaDeleter;
import cz.kpsys.portaro.database.FlushingJpaSaver;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.setting.ConditionalTransactionAuthenticator;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingEntity;
import cz.kpsys.portaro.setting.CustomSettingEntityId;
import cz.kpsys.portaro.setting.CustomSettingToEntityConverter;
import cz.kpsys.portaro.setting.RelogUserProcedureTransactionAuthenticator;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.setting.TransactionAuthenticator;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class SettingUpdateConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SettingUpdateConfig.class);
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final DataSource notAutocommitDataSource;
    @NonNull
    private final ObjectMapper xmlMapper;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final Provider<Integer> portaroUserIdProvider;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final DatabaseProperties databaseProperties;

    @Bean
    public Runnable saveTransactionAuthenticator() {
        ConditionalTransactionAuthenticator transactionAuthenticator = new ConditionalTransactionAuthenticator(() -> this.databaseProperties.getType().equals("firebird"), (TransactionAuthenticator)new RelogUserProcedureTransactionAuthenticator((JdbcOperations)new JdbcTemplate(this.notAutocommitDataSource), this.portaroUserIdProvider));
        return () -> ((TransactionAuthenticator)transactionAuthenticator).authenticate();
    }

    @Bean
    public JpaRepository<CustomSettingEntity, CustomSettingEntityId> customSettingJpaRepository() {
        return new SimpleJpaRepository(CustomSettingEntity.class, this.entityManager);
    }

    @Bean
    public AppserverConfigService appserverConfigService() {
        return new AppserverConfigService(this.xmlMapper, this.mappingAppserver, this.settingLoader.getOnRootProvider(SettingKeys.APPSERVER_ENABLED));
    }

    @Bean
    public AppserverCustomSettingsRefresher appserverCustomSettingsRefresher() {
        return new AppserverCustomSettingsRefresher(this.xmlMapper, this.mappingAppserver, this.settingLoader.getOnRootProvider(SettingKeys.APPSERVER_ENABLED), List.of("ini_file")).afterTransactionCommit();
    }

    @Bean
    public Saver<CustomSetting<String>, CustomSettingEntity> customSettingSaver() {
        GenericHookableSaver saver = new GenericHookableSaver((Saver)new PreConvertingSaver((Converter)new CustomSettingToEntityConverter(), (Saver)new FlushingJpaSaver(this.customSettingJpaRepository())));
        saver.addPreHook(this.saveTransactionAuthenticator());
        TransactionalSaver transactionalSaver = new TransactionalSaver((Saver)saver, this.defaultTransactionTemplateFactory.get());
        return CacheCleaningSaver.fromGenericCleaners((Saver)transactionalSaver, List.of(this.cacheService.createCleanerFor(CustomSetting.class.getSimpleName()), (CacheCleaner)this.settingLoader, this.appserverCustomSettingsRefresher()));
    }

    @Bean
    public Deleter<CustomSetting<String>> customSettingDeleter() {
        GenericHookableDeleter deleter = new GenericHookableDeleter((Deleter)new PreConvertingDeleter((Converter)new CustomSettingToEntityConverter(), (Deleter)new FlushingJpaDeleter(this.customSettingJpaRepository())));
        deleter.addPreHook(entity -> {
            this.saveTransactionAuthenticator().run();
            return entity;
        });
        TransactionalDeleter transactionalDeleter = new TransactionalDeleter((Deleter)deleter, this.defaultTransactionTemplateFactory.get());
        return new CacheCleaningDeleter((Deleter)transactionalDeleter, List.of(this.cacheService.createCleanerFor(CustomSetting.class.getSimpleName()), (CacheCleaner)this.settingLoader, this.appserverCustomSettingsRefresher()));
    }

    @ConstructorProperties(value={"settingLoader", "entityManager", "defaultTransactionTemplateFactory", "notAutocommitDataSource", "xmlMapper", "mappingAppserver", "portaroUserIdProvider", "cacheService", "databaseProperties"})
    @Generated
    public SettingUpdateConfig(@NonNull SettingLoader settingLoader, @NonNull EntityManager entityManager, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull DataSource notAutocommitDataSource, @NonNull ObjectMapper xmlMapper, @NonNull MappingAppserverService mappingAppserver, @NonNull Provider<Integer> portaroUserIdProvider, @NonNull CacheService cacheService, @NonNull DatabaseProperties databaseProperties) {
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(notAutocommitDataSource, "notAutocommitDataSource is marked non-null but is null");
        Objects.requireNonNull(xmlMapper, "xmlMapper is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(portaroUserIdProvider, "portaroUserIdProvider is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(databaseProperties, "databaseProperties is marked non-null but is null");
        this.settingLoader = settingLoader;
        this.entityManager = entityManager;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.notAutocommitDataSource = notAutocommitDataSource;
        this.xmlMapper = xmlMapper;
        this.mappingAppserver = mappingAppserver;
        this.portaroUserIdProvider = portaroUserIdProvider;
        this.cacheService = cacheService;
        this.databaseProperties = databaseProperties;
    }
}

