/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.convert.ListToModifiedListConverter;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.hierarchy.HierarchyLoader;
import cz.kpsys.portaro.record.holding.DelegatingRecordHoldingLoader;
import cz.kpsys.portaro.record.holding.DelegatingRecordHoldingSourceLoader;
import cz.kpsys.portaro.record.holding.DeletedHoldingsFilteringRecordHoldingLoader;
import cz.kpsys.portaro.record.holding.EntityToRecordHoldingConverter;
import cz.kpsys.portaro.record.holding.EntityToRecordHoldingSourceConverter;
import cz.kpsys.portaro.record.holding.RecordHolding;
import cz.kpsys.portaro.record.holding.RecordHoldingEntityLoader;
import cz.kpsys.portaro.record.holding.RecordHoldingLoader;
import cz.kpsys.portaro.record.holding.RecordHoldingSourceEntityLoader;
import cz.kpsys.portaro.record.holding.RecordHoldingSourceLoader;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

@Configuration
public class RecordHoldingConfig {
    @NonNull
    private final RepositoryFactorySupport jpaRepositoryFactory;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final HierarchyLoader<Department> departmentAccessor;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;

    @Bean
    public RecordHoldingEntityLoader recordHoldingEntityLoader() {
        return (RecordHoldingEntityLoader)this.jpaRepositoryFactory.getRepository(RecordHoldingEntityLoader.class);
    }

    @Bean
    public RecordHoldingLoader includingDeletedRecordHoldingLoader() {
        ListToModifiedListConverter entitiesToRecordHoldingConverter = new ListToModifiedListConverter((Converter)new EntityToRecordHoldingConverter(this.departmentLoader));
        return new DelegatingRecordHoldingLoader(this.recordHoldingEntityLoader(), (Converter)entitiesToRecordHoldingConverter, this.departmentAccessor);
    }

    @Bean
    public RecordHoldingLoader recordHoldingLoader() {
        return new DeletedHoldingsFilteringRecordHoldingLoader(this.includingDeletedRecordHoldingLoader());
    }

    @Bean
    public RecordHoldingSourceEntityLoader recordHoldingSourceEntityLoader() {
        return (RecordHoldingSourceEntityLoader)this.jpaRepositoryFactory.getRepository(RecordHoldingSourceEntityLoader.class);
    }

    @Bean
    public RecordHoldingSourceLoader recordHoldingSourceLoader() {
        ListToModifiedListConverter entitiesToRecordHoldingSourceConverter = new ListToModifiedListConverter((Converter)new EntityToRecordHoldingSourceConverter());
        return new DelegatingRecordHoldingSourceLoader(this.recordHoldingSourceEntityLoader(), (Converter)entitiesToRecordHoldingSourceConverter);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForUuidId(RecordHolding.class, (ByIdLoadable)this.recordHoldingLoader());
    }

    @ConstructorProperties(value={"jpaRepositoryFactory", "converterRegisterer", "departmentAccessor", "departmentLoader"})
    @Generated
    public RecordHoldingConfig(@NonNull RepositoryFactorySupport jpaRepositoryFactory, @NonNull ConverterRegisterer converterRegisterer, @NonNull HierarchyLoader<Department> departmentAccessor, @NonNull ByIdLoadable<Department, Integer> departmentLoader) {
        Objects.requireNonNull(jpaRepositoryFactory, "jpaRepositoryFactory is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        this.jpaRepositoryFactory = jpaRepositoryFactory;
        this.converterRegisterer = converterRegisterer;
        this.departmentAccessor = departmentAccessor;
        this.departmentLoader = departmentLoader;
    }
}

