/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.localization.ContextualLocaleLocalizer;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.mail.Mailer;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.loan.LoanSettingKeys;
import cz.kpsys.portaro.mail.MailMessageSendingSavingMailService;
import cz.kpsys.portaro.mail.MailParticipantSpecifier;
import cz.kpsys.portaro.mail.MailService;
import cz.kpsys.portaro.mail.MailerMailService;
import cz.kpsys.portaro.markdown.htmlconvert.MarkdownToHtmlConverter;
import cz.kpsys.portaro.messages.dto.Message;
import cz.kpsys.portaro.messages.dto.MessageSending;
import cz.kpsys.portaro.messages.dto.MessageSendingEmailAddress;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.contact.ContactManager;
import cz.kpsys.portaro.user.locale.UserLocaleResolver;
import cz.kpsys.portaro.view.web.rest.mail.MailApiController;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MailConfig {
    @NonNull
    private final Mailer<Department> mailer;
    @NonNull
    private final ContactManager contactManager;
    @NonNull
    private final ContextualLocaleLocalizer<Department> localizer;
    @NonNull
    private final FileDataStreamer securedFileDataStreamer;
    @NonNull
    private final UserLocaleResolver userLocaleResolver;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final Saver<Message, ?> messageSaver;
    @NonNull
    private final Saver<MessageSending, ?> messageSendingSaver;
    @NonNull
    private final Saver<MessageSendingEmailAddress, ?> messageSendingEmailAddressSaver;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final MarkdownToHtmlConverter markdownToHtmlConverter;

    @Bean
    public MailApiController mailApiController() {
        return new MailApiController(this.mailService(), this.markdownToHtmlConverter);
    }

    @Bean
    public MailService mailService() {
        MailerMailService nonInternalParticipantMailService = new MailerMailService(this.mailer, this.mailParticipantSpecifier(), this.contactManager, this.localizer, this.securedFileDataStreamer);
        return new MailMessageSendingSavingMailService(this.mailParticipantSpecifier(), (MailService)nonInternalParticipantMailService, this.messageSaver, this.messageSendingSaver, this.messageSendingEmailAddressSaver, this.contactManager, this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public MailParticipantSpecifier mailParticipantSpecifier() {
        return new MailParticipantSpecifier(this.settingLoader.getDepartmentedProvider(CoreSettingKeys.DEFAULT_LOCALE), this.userLocaleResolver, this.translator, this.systemEmailProvider(), this.settingLoader.getDepartmentedProvider(LoanSettingKeys.ORDERS_RECIPIENT_EMAIL).throwingWhenNull());
    }

    @Bean
    public ContextualProvider<Department, @NonNull String> systemEmailProvider() {
        return this.settingLoader.getDepartmentedProvider(SettingKeys.SMTP_FROM_LIBRARY_MAILS_REPLY_TO_ADDRESS).fallbacked(this.settingLoader.getDepartmentedProvider(SettingKeys.SMTP_SENDER_ADDRESS).throwingWhenNull());
    }

    @ConstructorProperties(value={"mailer", "contactManager", "localizer", "securedFileDataStreamer", "userLocaleResolver", "translator", "settingLoader", "messageSaver", "messageSendingSaver", "messageSendingEmailAddressSaver", "defaultTransactionTemplateFactory", "markdownToHtmlConverter"})
    @Generated
    public MailConfig(@NonNull Mailer<Department> mailer, @NonNull ContactManager contactManager, @NonNull ContextualLocaleLocalizer<Department> localizer, @NonNull FileDataStreamer securedFileDataStreamer, @NonNull UserLocaleResolver userLocaleResolver, @NonNull Translator<Department> translator, @NonNull SettingLoader settingLoader, @NonNull Saver<Message, ?> messageSaver, @NonNull Saver<MessageSending, ?> messageSendingSaver, @NonNull Saver<MessageSendingEmailAddress, ?> messageSendingEmailAddressSaver, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull MarkdownToHtmlConverter markdownToHtmlConverter) {
        Objects.requireNonNull(mailer, "mailer is marked non-null but is null");
        Objects.requireNonNull(contactManager, "contactManager is marked non-null but is null");
        Objects.requireNonNull(localizer, "localizer is marked non-null but is null");
        Objects.requireNonNull(securedFileDataStreamer, "securedFileDataStreamer is marked non-null but is null");
        Objects.requireNonNull(userLocaleResolver, "userLocaleResolver is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(messageSaver, "messageSaver is marked non-null but is null");
        Objects.requireNonNull(messageSendingSaver, "messageSendingSaver is marked non-null but is null");
        Objects.requireNonNull(messageSendingEmailAddressSaver, "messageSendingEmailAddressSaver is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(markdownToHtmlConverter, "markdownToHtmlConverter is marked non-null but is null");
        this.mailer = mailer;
        this.contactManager = contactManager;
        this.localizer = localizer;
        this.securedFileDataStreamer = securedFileDataStreamer;
        this.userLocaleResolver = userLocaleResolver;
        this.translator = translator;
        this.settingLoader = settingLoader;
        this.messageSaver = messageSaver;
        this.messageSendingSaver = messageSendingSaver;
        this.messageSendingEmailAddressSaver = messageSendingEmailAddressSaver;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.markdownToHtmlConverter = markdownToHtmlConverter;
    }
}

