/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import cz.kpsys.portaro.commons.contextual.ContextIgnoringContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.database.AdhocQueryer;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.sql.generator.DbSpecificsFactory;
import cz.kpsys.portaro.util.database.DeleteWebCrawlersRunner;
import cz.kpsys.portaro.util.database.Katx1RecordFieldMigrationDbProcCaller;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class DatafixBatchConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatafixBatchConfig.class);
    @NonNull
    private final DatabaseProperties dbUpdateDatabaseProperties;
    @NonNull
    private final @NonNull Provider<@NonNull ZoneId> databaseColumnsTimeZoneProvider;
    @NonNull
    private final DbSpecificsFactory dbSpecificsFactory;

    @Bean
    public Task<Void> deleteWebCrawlersTask() {
        return Tasks.recurring((String)"delete-web-crawlers-task", (Schedule)Schedules.fixedDelay((Duration)Duration.ofDays(1L))).execute((taskInstance, executionContext) -> this.deleteWebCrawlersRunner().run());
    }

    @Bean
    public Runnable deleteWebCrawlersRunner() {
        return new DeleteWebCrawlersRunner(AdhocQueryer.createAlwaysEnabled((Provider)this.databaseColumnsTimeZoneProvider, (ContextualProvider)ContextIgnoringContextualProvider.of((Object)this.dbUpdateDatabaseProperties), (DbSpecificsFactory)this.dbSpecificsFactory));
    }

    @Scheduled(initialDelay=5L, fixedDelay=5L, timeUnit=TimeUnit.SECONDS)
    public void doAdhocDatafixes() {
        try {
            this.migrator().run();
        }
        catch (Exception e) {
            log.error("Exception while katX_1 -> record_field migration", (Throwable)e);
        }
    }

    @Bean
    public Katx1RecordFieldMigrationDbProcCaller migrator() {
        return new Katx1RecordFieldMigrationDbProcCaller(this.dbUpdateDatabaseProperties, this.databaseColumnsTimeZoneProvider);
    }

    @ConstructorProperties(value={"dbUpdateDatabaseProperties", "databaseColumnsTimeZoneProvider", "dbSpecificsFactory"})
    @Generated
    public DatafixBatchConfig(@NonNull DatabaseProperties dbUpdateDatabaseProperties, @NonNull @NonNull Provider<@NonNull ZoneId> databaseColumnsTimeZoneProvider, @NonNull DbSpecificsFactory dbSpecificsFactory) {
        Objects.requireNonNull(dbUpdateDatabaseProperties, "dbUpdateDatabaseProperties is marked non-null but is null");
        Objects.requireNonNull(databaseColumnsTimeZoneProvider, "databaseColumnsTimeZoneProvider is marked non-null but is null");
        Objects.requireNonNull(dbSpecificsFactory, "dbSpecificsFactory is marked non-null but is null");
        this.dbUpdateDatabaseProperties = dbUpdateDatabaseProperties;
        this.databaseColumnsTimeZoneProvider = databaseColumnsTimeZoneProvider;
        this.dbSpecificsFactory = dbSpecificsFactory;
    }
}

