/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.auth.context.TypedAuthenticatedContextualObjectModifier;
import cz.kpsys.portaro.commons.contextual.ContextualFunction;
import cz.kpsys.portaro.commons.localization.ContextualLocaleLocalizer;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.LabeledId;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.phonenumber.PhoneNumberValidator;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.formconfig.formfield.FormFieldsNamesContextualFunction;
import cz.kpsys.portaro.formconfig.valueeditor.AcceptableValuesResolver;
import cz.kpsys.portaro.loan.Loan;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.contact.ContactManager;
import cz.kpsys.portaro.verbisbox.VerbisboxSecurityActions;
import cz.kpsys.portaro.verbisbox.shipment.BatchRichItemInsightToViewableConverter;
import cz.kpsys.portaro.verbisbox.shipment.ChangeBundleBoxFormRequest;
import cz.kpsys.portaro.verbisbox.shipment.ContextualAvailableBundlesForMovingItemLoader;
import cz.kpsys.portaro.verbisbox.shipment.ContextualToViewableShipmentInsightConverter;
import cz.kpsys.portaro.verbisbox.shipment.ItemsMoveFormRequest;
import cz.kpsys.portaro.verbisbox.shipment.ToViewableUserConverter;
import cz.kpsys.portaro.verbisbox.state.ToViewableStationStateConverter;
import cz.kpsys.portaro.verbisbox.station.BoxStation;
import cz.kpsys.portaro.verbisbox.station.BoxStationApiController;
import cz.kpsys.portaro.verbisbox.station.BoxStationEntity;
import cz.kpsys.portaro.verbisbox.station.BoxStationFinder;
import cz.kpsys.portaro.verbisbox.station.EntitiesToBoxStationsConverter;
import cz.kpsys.portaro.verbisbox.station.FullScanningBoxStationFinder;
import cz.kpsys.portaro.verbisboxer.manager.ContextualVerbisboxerManagerApiClient;
import cz.kpsys.portaro.verbisboxer.manager.VerbisboxerManagerApiSettingKeys;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class BoxConfig {
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, Loan> loanSearchLoader;
    @NonNull
    private final ContextualVerbisboxerManagerApiClient<Department> contextualVerbisboxerManagerApiClient;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final ContextualLocaleLocalizer<Department> localizer;
    @NonNull
    private final ByIdLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final ContactManager contactManager;
    @NonNull
    private final PhoneNumberValidator phoneNumberValidator;

    @Bean
    public BoxStationApiController boxStationApiController() {
        return new BoxStationApiController(this.boxStationCodebook(), this.contextualVerbisboxerManagerApiClient, (Converter)this.toViewableStationStateConverter(), (ContextualFunction)this.toViewableShipmentInsightConverter(), this.securityManager, this.localizer, this.contactManager, this.phoneNumberValidator);
    }

    @Bean
    public BoxStationFinder boxStationFinder() {
        return new FullScanningBoxStationFinder(this.boxStationCodebook(), this.departmentAccessor);
    }

    @Bean
    public Codebook<BoxStation, UUID> boxStationCodebook() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(BoxStationEntity.class).converted((Converter)new EntitiesToBoxStationsConverter(this.departmentLoader)).staticCached(BoxStation.class.getSimpleName()).build();
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<ItemsMoveFormRequest> itemsMoveFormRequestDefaulter() {
        return new ItemsMoveFormRequest.ItemsMoveFormRequestDefaulter();
    }

    @Bean
    public AcceptableValuesResolver<ItemsMoveFormRequest, LabeledId<UUID>> itemsMoveFormRequestBundleResolver() {
        return new ItemsMoveFormRequest.ItemsMoveFormRequestBundleResolver(this.contextualAvailableBundlesForItemLoader());
    }

    @Bean
    public ContextualAvailableBundlesForMovingItemLoader contextualAvailableBundlesForItemLoader() {
        return new ContextualAvailableBundlesForMovingItemLoader(this.contextualVerbisboxerManagerApiClient);
    }

    @Bean
    public FormFieldsNamesContextualFunction<ItemsMoveFormRequest, Department> itemsMoveFormRequestEnabledPropsProvider() {
        return new ItemsMoveFormRequest.ItemsMoveFormRequestEnabledPropsProvider(this.contextualAvailableBundlesForItemLoader());
    }

    @Bean
    public AcceptableValuesResolver<ChangeBundleBoxFormRequest, LabeledId<UUID>> changeBundleBoxFormBoxResolver() {
        return new ChangeBundleBoxFormRequest.ChangeBundleBoxFormBoxResolver(this.contextualVerbisboxerManagerApiClient);
    }

    @Bean
    public ToViewableUserConverter toViewableUserConverter() {
        return new ToViewableUserConverter(this.basicUserLoader);
    }

    @Bean
    public ToViewableStationStateConverter toViewableStationStateConverter() {
        return new ToViewableStationStateConverter((Converter)this.batchRichItemInsightToViewableConverter(), (Converter)this.toViewableUserConverter());
    }

    @Bean
    public BatchRichItemInsightToViewableConverter batchRichItemInsightToViewableConverter() {
        return new BatchRichItemInsightToViewableConverter(this.loanSearchLoader);
    }

    @Bean
    public ContextualToViewableShipmentInsightConverter toViewableShipmentInsightConverter() {
        return new ContextualToViewableShipmentInsightConverter((Converter)this.batchRichItemInsightToViewableConverter(), (Converter)this.toViewableUserConverter(), this.contextualVerbisboxerManagerApiClient);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForUuidId(BoxStation.class, (ByIdLoadable)this.boxStationCodebook());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(VerbisboxSecurityActions.BOX_STATIONS_SHOW, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.enabled(this.settingLoader.getDepartmentedProvider(VerbisboxerManagerApiSettingKeys.VERBISBOXER_ENABLED), Texts.ofNative((String)"Verbisbox is not enabled")), this.permissionFactory.edit()}));
        this.permissionRegistry.add(VerbisboxSecurityActions.BOX_STATION_SHOW, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{PermissionResolver.withoutSubject((PermissionResolver)this.permissionRegistry.getLazy(VerbisboxSecurityActions.BOX_STATIONS_SHOW)), PermissionResolver.adaptingSubject(BoxStation::getDepartment, (PermissionResolver)this.permissionFactory.editSubjectWithDepartment())}));
    }

    @ConstructorProperties(value={"converterRegisterer", "codebookLoaderBuilderFactory", "departmentLoader", "loanSearchLoader", "contextualVerbisboxerManagerApiClient", "permissionRegistry", "securityManager", "settingLoader", "permissionFactory", "localizer", "basicUserLoader", "departmentAccessor", "contactManager", "phoneNumberValidator"})
    @Generated
    public BoxConfig(@NonNull ConverterRegisterer converterRegisterer, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, Loan> loanSearchLoader, @NonNull ContextualVerbisboxerManagerApiClient<Department> contextualVerbisboxerManagerApiClient, @NonNull PermissionRegistry permissionRegistry, @NonNull SecurityManager securityManager, @NonNull SettingLoader settingLoader, @NonNull PermissionFactory permissionFactory, @NonNull ContextualLocaleLocalizer<Department> localizer, @NonNull ByIdLoadable<BasicUser, Integer> basicUserLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull ContactManager contactManager, @NonNull PhoneNumberValidator phoneNumberValidator) {
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(loanSearchLoader, "loanSearchLoader is marked non-null but is null");
        Objects.requireNonNull(contextualVerbisboxerManagerApiClient, "contextualVerbisboxerManagerApiClient is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(localizer, "localizer is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(contactManager, "contactManager is marked non-null but is null");
        Objects.requireNonNull(phoneNumberValidator, "phoneNumberValidator is marked non-null but is null");
        this.converterRegisterer = converterRegisterer;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.departmentLoader = departmentLoader;
        this.loanSearchLoader = loanSearchLoader;
        this.contextualVerbisboxerManagerApiClient = contextualVerbisboxerManagerApiClient;
        this.permissionRegistry = permissionRegistry;
        this.securityManager = securityManager;
        this.settingLoader = settingLoader;
        this.permissionFactory = permissionFactory;
        this.localizer = localizer;
        this.basicUserLoader = basicUserLoader;
        this.departmentAccessor = departmentAccessor;
        this.contactManager = contactManager;
        this.phoneNumberValidator = phoneNumberValidator;
    }
}

