/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro;

import com.github.kagkarlsson.scheduler.boot.autoconfigure.DbSchedulerAutoConfiguration;
import cz.kpsys.portaro.auth.UserAuthentication;
import cz.kpsys.portaro.department.Department;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.security.OAuthFlow;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.media.StringSchema;
import java.time.Duration;
import java.time.YearMonth;
import no.bekk.dbscheduler.uistarter.autoconfigure.UiApiAutoConfiguration;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.autoconfigure.security.oauth2.resource.servlet.OAuth2ResourceServerAutoConfiguration;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.PropertySource;

@SpringBootApplication(exclude={DbSchedulerAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, FreeMarkerAutoConfiguration.class, MailSenderAutoConfiguration.class, DataSourceAutoConfiguration.class, JacksonAutoConfiguration.class, BatchAutoConfiguration.class, OAuth2ResourceServerAutoConfiguration.class, UiApiAutoConfiguration.class})
@ComponentScan(basePackages={"cz.kpsys.portaro.config", "cz.kpsys.portaro.view.web", "cz.kpsys.portaro.view.web.rest"})
@EnableCaching
@PropertySource(value={"classpath:git.properties"}, ignoreResourceNotFound=true)
@OpenAPIDefinition(info=@Info(title="Verbis API", description="Definition of Verbis JSON APIs", contact=@Contact(name="Jan Pachol", email="jan.pachol@systemist.cz")), tags={@Tag(name="inventory", description="Endpoints for managing inventory captures")}, security={@SecurityRequirement(name="auth-oauth")})
@SecurityScheme(name="auth-oauth", type=SecuritySchemeType.OAUTH2, flows=@OAuthFlows(clientCredentials=@OAuthFlow(tokenUrl="/oauth/token")))
public class PortaroWebApplication {
    static {
        SpringDocUtils.getConfig().addRequestWrapperToIgnore(new Class[]{UserAuthentication.class, Department.class});
        SpringDocUtils.getConfig().replaceWithSchema(YearMonth.class, new StringSchema().format("yearmonth").pattern("^\\d{4}-\\d{2}$").example((Object)"2024-12"));
        SpringDocUtils.getConfig().replaceWithSchema(Duration.class, new StringSchema().format("duration").example((Object)"PT117H49M"));
    }
}

