<#ftl outputFormat="HTML">
<#import "../../../freemarker/_localization.ftl" as loc>

<div id="konto" class="container normalniContentSMezerouNahore">

    <!-- userId {{ac.user.id}} -->

    <div class="row">
        <div class="col-md-12">
            <h1 style="display: inline-block" >
                <span data-qa="user-account-name">{{ac.user.printableName}}</span>
                <small ng-show="ac.user.readerRole.readerCategory" class="reader-readercategory-subheader">{{ac.user.readerRole.readerCategory|loc}}</small>
                <br />
                <small ng-show="ac.user.email">{{ac.user.email}}</small>
                <small ng-show="ac.user.username" class="reader-username-subheader"><code>{{ac.user.username}}</code></small>
            </h1>
        </div>
    </div>


    <div class="row">
        <div class="col-md-6 col-lg-5">

            <div>
                <span ng-show="ac.user.readerRole.blocked" class="label label-danger reader-tag" data-qa="reader-role-label-blocked">${loc.loc("ctenar.TransactionsBlocked")?noEsc}</span>
                <span ng-show="ac.user.readerRole.registrationExpired" class="label label-danger reader-tag" data-qa="reader-role-label-registration-expired">${loc.loc("ctenar.RegistrationExpired")?noEsc}</span>
                <span ng-show="ac.user.role.includes('ROLE_READER')" class="label label-info reader-tag" data-qa="reader-role-label-reader">${loc.loc("user.Reader")?noEsc}</span>
                <span ng-show="ac.user.role.includes('ROLE_LIBRARIAN')" class="label label-info reader-tag" data-qa="reader-role-label-librarian">${loc.loc("user.Librarian")?noEsc}</span>
                <span ng-show="ac.user.role.includes('ROLE_LIBRARY')" class="label label-info reader-tag" data-qa="reader-role-label-library">${loc.loc("user.MvsLibrary")?noEsc}</span>
                <span ng-show="ac.user.role.includes('ROLE_SUPPLIER')" class="label label-info reader-tag" data-qa="reader-role-label-supplier">${loc.loc("user.Supplier")?noEsc}</span>
            </div>

            <div id="user-detail-additional-content-container" style="margin-top: 20px; margin-bottom: 20px">
                <table style="width: 100%" class="table table-condensed">
                    <tr ng-show="ac.user.readerRole.readerCategory" class="reader-readerCategory-row">
                        <td>${loc.loc("ctenar.readerCategory")?noEsc}</td>
                        <td><strong>{{ac.user.readerRole.readerCategory|loc}}</strong></td>
                    </tr>
                    <tr ng-show="ac.user.readerRole.cardNumber" class="reader-cardNumber-row">
                        <td>${loc.loc("ctenar.cardNumber")?noEsc}</td>
                        <td>{{ac.user.readerRole.cardNumber}}</td>
                    </tr>
                    <tr ng-show="ac.user.readerRole.barCode" class="reader-barCode-row">
                        <td>${loc.loc("ctenar.barCode")?noEsc}</td>
                        <td>{{ac.user.readerRole.barCode}}</td>
                    </tr>
                    <tr class="reader-registrationDate-row">
                        <td>${loc.loc("konto.datumRegistrace")?noEsc}</td>
                        <td>{{ac.user.readerRole.registrationDate | jpDate:'d.M.yyyy'}}</td>
                    </tr>
                    <tr class="reader-expirationDate-row">
                        <td>${loc.loc("konto.datumVyprseniPlatnostiRegistrace")?noEsc}</td>
                        <td data-qa="reader-expirationDate-value">{{ac.user.readerRole.registrationExpirationDate | jpDate:'d.M.yyyy'}}</td>
                    </tr>
                    <tr ng-if="ac.user.schoolClass" class="reader-school-class-row">
                        <td>${loc.loc("ctenar.schoolClass")?noEsc}</td>
                        <td data-qa="reader-school-class-value">{{ac.user.schoolClass}}</td>
                    </tr>
                    <tr ng-if="ac.permissions.UsersShow" ng-show="ac.user.readerRole.note" class="reader-note-row">
                        <td>${loc.loc("ctenar.note")?noEsc}</td>
                        <td>{{ac.user.readerRole.note}}</td>
                    </tr>
                    <tr ng-if="ac.delayedReturnPenalty.sum > 0" class="reader-delayedReturnPenalty-row">
                        <td>${loc.loc("konto.SoucetPokutZaAktualniVypujcky")?noEsc}</td>
                        <td>{{ac.delayedReturnPenalty.sum}}Kč</td>
                    </tr>
                    <tr ng-repeat-start="editorAccount in ac.user.editorAccounts" class="librarian-permission-level-row">
                        <td>${loc.loc("user.LibrarianEditLevel")?noEsc}</td>
                        <td>{{editorAccount.editLevel|loc}}</td>
                    </tr>
                    <tr class="librarian-group-row">
                        <td>${loc.loc("user.UserGroup")?noEsc}</td>
                        <td>{{editorAccount.group|loc}}</td>
                    </tr>
                    <tr ng-repeat-end class="librarian-validation-code-row">
                        <td>${loc.loc("user.ValidationCode")?noEsc}</td>
                        <td>{{editorAccount.validationCode}}</td>
                    </tr>
                </table>
            </div>

            <div ng-if="ac.detailManager.showLibrarianMessage && ac.permissions.ShowLibrarianMessage && ac.user.readerRole.librarianMessage" style="margin-top: 20px; margin-bottom: 20px" class="panel panel-info librarian-message-panel">
                <div class="panel-heading">${loc.loc("user.edit.librarianMessage")?noEsc}</div>
                <div class="panel-body">
                    {{ac.user.readerRole.librarianMessage}}
                </div>
            </div>

            <div ng-if="ac.user.contacts.length > 0" style="margin-top: 20px; margin-bottom: 20px" class="panel panel-default user-contacts-panel">
                <div class="panel-heading">${loc.loc("commons.Contacts")?noEsc}</div>
                <ul class="list-group">
                    <li ng-repeat="contact in ac.user.contacts" class="list-group-item">
                        <div class="pull-right">
                            <span ng-show="contact.source.id !== 'internal'" class="badge">{{contact.source|loc}}</span>
                            <span class="label label-default">{{contact.type|loc}}</span>
                        </div>
                        <div>
                            <span>{{contact.value}}</span>
                        </div>
                    </li>
                </ul>
            </div>


            <div ng-if="ac.user.addresses.length > 0" style="margin-top: 20px; margin-bottom: 20px" class="panel panel-default user-addresses-panel">
                <div class="panel-heading">${loc.loc("commons.Adresa")?noEsc}</div>
                <ul class="list-group">
                    <li ng-repeat="userAddress in ac.user.addresses" class="list-group-item">
                        <div class="pull-right">
                            <span ng-show="userAddress.source.id !== 'internal'" class="badge">{{userAddress.source|loc}}</span>
                            <span ng-show="userAddress.permanent" class="label label-default">${loc.loc("commons.address.permanent")?noEsc}</span>
                            <span ng-show="userAddress.mailing" class="label label-default">${loc.loc("commons.address.postal")?noEsc}</span>
                        </div>
                        <div>
                            {{userAddress.address.street}}<br />
                            {{userAddress.address.city}}<br />
                            {{userAddress.address.country|loc}}<br />
                            {{userAddress.address.postalCode}}
                        </div>
                    </li>
                </ul>
            </div>

        </div>


        <div class="main-panel-pravy col-md-6 col-lg-offset-3 col-lg-4" ng-if="ac.detailManager.moneyShowing">
            <kp-user-finance-panel
                    owner="ac.user"
                    enabled-payment-provider-names="ac.detailManager.enabledPaymentProviderNames"
                    user-can-delete-payment="ac.permissions.PaymentDelete"
                    user-can-delete-debt="ac.permissions.DebtDelete"
            ></kp-user-finance-panel>
        </div>

    </div>


    <div class="row">
        <div class="col-sm-12" style="margin-bottom: 40px;">

            <#-- zmena hesla -->
            <button type="button" class="btn btn-default password-change-button" ng-if="ac.permissions.UserPasswordChange" ng-click="ac.showPasswordChangeForm()">
                ${loc.loc("konto.zmenaHesla")?noEsc}
            </button>

            <#-- smazani prihlasovacich udaju (z opac_pin) -->
            <button type="button" class="btn btn-default" ng-if="ac.permissions.UserCredentialsDelete" ng-click="ac.deleteCredentials()" data-qa="delete-user-credentials-button">
                ${loc.loc("ctenar.SmazatUzivatelskeJmenoAHeslo")?noEsc}
            </button>

            <#-- MVS -->
            <button type="button" class="btn btn-default" ng-if="ac.permissions.LoanRequestMvsRemote" ng-show="ac.detailManager.mvsShowing" ng-click="ac.sendRemoteMvs()" data-qa="send-mvs-request-button">
                ${loc.loc("commons.odeslatMvsZadanku")?noEsc}
            </button>

            <div class="btn-group">
                <#-- prodlouzit vse -->
                <button type="button" class="btn btn-default renewAllAtOnceButton" ng-if="ac.permissions.LoanRenew" ng-show="ac.detailManager.renewAllShowing"
                        ng-disabled="!ac.loanList.enableRenewAllButton()" ng-click="ac.renewAllLoans()" data-qa="renew-all-button">
                    ${loc.loc("loan.RenewAllAtOnce")?noEsc}
                </button>

                <#-- vypujcit knihu -->
                <button type="button" class="btn btn-default" ng-if="ac.permissions.LoanLend" ng-click="ac.showLendingForm()" data-qa="rent-book-button">
                    ${loc.loc("loan.VypujcitKnihu")?noEsc}
                </button>

                <#-- vratit knihu -->
                <button type="button" class="btn btn-default" ng-if="ac.permissions.LoanReturnAny" ng-disabled="!ac.loanList.enableReturnButton()" ng-click="ac.showReturningForm()" data-qa="return-book-button">
                    ${loc.loc("loan.VratitKnihu")?noEsc}
                </button>
            </div>

            <#-- prodlouzeni registrace -->
            <button type="button" class="btn btn-default" ng-if="ac.permissions.UserRegistrationPeriodExtend" ng-click="ac.extendRegistration()" data-qa="extend-registration-button">
                ${loc.loc("ctenar.ProdlouzitRegistraci")?noEsc}
            </button>

            <#-- editace uzivatele -->
            <button type="button" class="btn btn-default" ng-if="ac.permissions.UserEdit" ng-show="ac.detailManager.userEditationShowing"
                    ng-click="ac.editUser()" data-qa="edit-user-button">
                ${loc.loc("commons.editovat")?noEsc}
            </button>

            <div class="print-btn-group btn-group" ng-if="ac.permissions.UserRegistrationAgreementPrint || ac.permissions.PaymentsReceiptPrint">
                <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" data-qa="print-dropdown-button">
                    ${loc.loc("commons.tisk")?noEsc}<span class="caret"></span>
                </button>
                <ul class="dropdown-menu" role="menu">
                    <#-- tisk potvrzeni registrace -->
                    <li ng-if="ac.permissions.UserRegistrationAgreementPrint && ac.detailManager.showUserRegistrationAgreementPrintButton">
                        <a href="" ng-click="ac.printRegistrationAgreement()" data-qa="print-reader-registration-button">
                            ${loc.loc("konto.RegistrationAgreement")?noEsc}
                        </a>
                    </li>
                    <#-- tisk potvrzení o zaplacení -->
                    <li ng-if="ac.permissions.PaymentsReceiptPrint && ac.detailManager.showUserReceiptOfPaymentPrintButton">
                        <a href="" ng-click="ac.printReceiptOfPayment()" data-qa="print-payment-receipt-button">
                            ${loc.loc("konto.ReceiptOfPayment")?noEsc}
                        </a>
                    </li>
                </ul>
            </div>

            <#-- user preferences -->
            <button class="show-user-preferences-btn btn btn-default" ng-if="ac.permissions.UserPreferencesEdit" ng-click="ac.userPreferences()">
                ${loc.loc("commons.UzivatelskeNastaveni")?noEsc}
            </button>

            <button class="btn btn-default" type="button" ng-click="ac.sendEmail()" ng-show="ac.permissions.SendEmailToUser && ac.user.email">
                ${loc.loc("mail.SendEmail")}
            </button>

            <button class="btn btn-default" type="button" ng-click="ac.sendSms()" ng-show="ac.permissions.SendSmsToUser && ac.hasSmsNumber">
                ${loc.loc("sms.SendSms")}
            </button>

            <#-- impersonate user -->
            <a class="impersonate-btn btn btn-default" ng-if="ac.permissions.AuthSwitchActiveUser" kp-href="/login/impersonate?user={{ac.user.id}}" ng-click="ac.clearPermissionsCache()">
                Přihlásit se za uživatele
            </a>

        </div>
    </div>

    <div class="row" ng-if="ac.user.role.includes('ROLE_READER') || ac.user.role.includes('ROLE_LIBRARY')">
        <div class="col-sm-12" ng-if="ac.detailManager.loansShowing" style="margin-bottom: 100px;">
            <uib-tabset role="tablist">


                <uib-tab select="ac.loadLoans()" id="tab-loans" role="tab" aria-selected="{{ac.activeLoanTypeTab === 'loans'}}" aria-controls="panel-loans">
                    <uib-tab-heading aria-live="polite">
                        ${loc.loc("loan.Vypujcky")?noEsc} <span class="text-muted" ng-bind="ac.loanList.size"></span>
                    </uib-tab-heading>
                    <div class="panel panel-default" id="panel-loans" role="tabpanel" aria-labelledby="tab-loans" aria-live="polite">
                        <div ng-show="ac.loanList.state === 'NORMAL' && ac.loanList.items.length === 0" class="panel-body text-muted text-center">
                            ${loc.loc("commons.ZadnePolozky")?noEsc}
                        </div>
                        <div ng-show="ac.loanList.items.length > 0" class="table-responsive">
                            <table class="greenHeaderTable table table-condensed table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th class="col_documentName">${loc.loc("commons.nazevDokumentu")?noEsc}</th>
                                        <th class="col_lendDate">${loc.loc("loan.DatumVypujceni")?noEsc}</th>
                                        <th class="col_dueDate">${loc.loc("loan.TerminVraceni")?noEsc}</th>
                                        <th class="col_lastRenewal">${loc.loc("konto.posledniProlongace")?noEsc}</th>
                                        <th class="col_overdueNoticesCount">${loc.loc("konto.pocetUpominek")?noEsc}</th>
                                        <th class="col_loanCategory">${loc.loc("exemplar.loanCategory")?noEsc}</th>
                                        <th class="col_location">${loc.loc("exemplar.location")?noEsc}</th>
                                        <th class="col_department">${loc.loc("ctenar.rental")?noEsc}</th>
                                        <th class="col_renew" ng-if="ac.loanList.showRenewalColumn()">${loc.loc("loan.Prodlouzit")?noEsc}</th>
                                        <th class="col_return" ng-if="ac.detailManager.canReturnAny">${loc.loc("loan.Vratit")?noEsc}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="loan in ac.loanList.items"
                                        ng-class="{'ending-loan': loan.endingLoan, 'expired-loan': loan.expiredLoan}"
                                        title="${loc.loc("commons.Identifikator")?noEsc} {{loan.id}}">

                                        <td class="col_documentName">
                                            <kp-svelte-component-wrapper component="::ac.kpDocumentMiniComponent" props="::{document: loan.document, exemplar: loan.exemplar}"></kp-svelte-component-wrapper>
                                            <div ng-show="loan.chunkable && loan.quantity > 0">
                                                Vypůjčeno {{loan.quantity}} kusů
                                            </div>
                                            <div ng-show="(loan.timeslotOccupations || []).length > 0" style="margin-left: 40px;">
                                                <div ng-repeat="timeslotOccupation in loan.timeslotOccupations">{{timeslotOccupation.dateRange.fromDate | jpDate: 'd.M. HH:mm'}} - {{timeslotOccupation.dateRange.toDate | jpDate: 'd.M. HH:mm'}}</div>
                                            </div>
                                        </td>
                                        <td class="col_lendDate" ng-bind="loan.lendDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_dueDate" ng-bind="loan.dueDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_lastRenewal" ng-bind="loan.lastRenewalDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_overdueNoticesCount" ng-bind="loan.overdueNoticesCount"></td>
                                        <td class="col_loanCategory" ng-bind="loan.loanCategory|loc"></td>
                                        <td class="col_location" ng-bind="loan.location|loc"></td>
                                        <td class="col_department" ng-bind="loan.department|loc"></td>
                                        <td class="col_renew" ng-if="ac.loanList.showRenewalColumn()">
                                            <span ng-show="!loan.renewalRequest">
                                                <button ng-show="loan.renewability.renewable" type="button" class="btn btn-default btn-sm" ng-click="ac.renewLoan(loan)">
                                                    <span class="glyphicon glyphicon-repeat"></span> {{'${loc.loc("loan.ProdlouzitOXDni")?noEsc}' | strParams : loan.renewability.numberOfDays}}
                                                </button>
                                                <small ng-show="!loan.renewability.renewable" class="text-muted" ng-bind="loan.renewability|loc"></small>
                                            </span>
                                            <span ng-show="loan.renewalRequest">
                                                <span ng-show="loan.renewalRequest.state === 'PROCESSING'" jp-loading="xs"></span>
                                                <span ng-show="loan.renewalRequest.state === 'NORMAL'" class="text-success" ng-bind="loan.renewalRequest | loc"></span>
                                            </span>
                                        </td>
                                        <td ng-if="ac.detailManager.canReturnAny" class="col_return">
                                            <button type="button" class="btn btn-default btn-sm" ng-click="ac.returnLoan(loan)" title="Vrátit">
                                                <span class="glyphicon glyphicon-share-alt"></span> ${loc.loc("loan.Vratit")?noEsc}
                                            </button>
                                        </td>

                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="table-sole" ng-show="!ac.loanList.isLoadedAll()">
                            <button ng-show="ac.loanList.state === 'NORMAL'" type="button" class="btn btn-default btn-xs btn-block"
                                    ng-click="ac.loanList.loadNext()">
                                ${loc.loc("vysledky.NacistDalsi")?noEsc}
                            </button>
                            <div jp-loading="xs" ng-show="ac.loanList.state === 'PROCESSING'"></div>
                        </div>
                    </div>
                </uib-tab>


                <uib-tab select="ac.loadWaitingLoans()" id="tab-waiting-loans" role="tab" aria-selected="{{ac.activeLoanTypeTab === 'waiting-loans'}}" aria-controls="panel-waiting-loans">
                    <uib-tab-heading aria-live="polite">
                        ${loc.loc("loan.WaitingLoans")?noEsc} <span class="text-muted" ng-bind="ac.waitingLoanList.size"></span>
                    </uib-tab-heading>
                    <div class="panel panel-default" id="panel-waiting-loans" role="tabpanel" aria-labelledby="tab-waiting-loans" aria-live="polite">
                        <div ng-show="ac.waitingLoanList.state === 'NORMAL' && ac.waitingLoanList.items.length === 0"
                             class="panel-body text-muted text-center">
                            ${loc.loc("commons.ZadnePolozky")?noEsc}
                        </div>
                        <div ng-show="ac.waitingLoanList.items.length > 0" class="table-responsive">
                            <table class="greenHeaderTable table table-condensed table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th class="col_documentName">${loc.loc("commons.nazevDokumentu")?noEsc}</th>
                                        <th class="col_location">${loc.loc("exemplar.location")?noEsc}</th>
                                        <th class="col_reservationDate">${loc.loc("loan.DatumRezervace")?noEsc}</th>
                                        <th class="col_reservationDeadlineDate">${loc.loc("loan.CekatDo")?noEsc}</th>
                                        <th class="col_reservationState">${loc.loc("commons.stav")?noEsc}</th>
                                        <th class="col_loanCancelling col_reservationCancelling"
                                            ng-if="ac.detailManager.canCancelAny">${loc.loc("commons.zrusit")?noEsc}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="loan in ac.waitingLoanList.items" title="${loc.loc("commons.Identifikator")?noEsc} {{loan.id}}">

                                        <td class="col_documentName">
                                            <kp-svelte-component-wrapper component="::ac.kpDocumentMiniComponent" props="::{document: loan.document, exemplar: loan.exemplar}"></kp-svelte-component-wrapper>
                                            <div ng-show="(loan.timeslotOccupations || []).length > 0" style="margin-left: 40px;">
                                                <div ng-repeat="timeslotOccupation in loan.timeslotOccupations">{{timeslotOccupation.dateRange.fromDate | jpDate: 'd.M. HH:mm'}} - {{timeslotOccupation.dateRange.toDate | jpDate: 'd.M. HH:mm'}}</div>
                                            </div>
                                        </td>
                                        <td class="col_location" ng-bind="loan.location|loc"></td>
                                        <td class="col_reservationDate" ng-bind="loan.reservationDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_reservationDeadlineDate" ng-bind="loan.reservationDeadlineDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_reservationState" ng-bind="loan.stateText"></td>
                                        <td class="col_loanCancelling col_reservationCancelling" ng-if="ac.detailManager.canCancelAny">
                                            <span ng-show="loan.cancelability.cancelable">
                                                <button type="button" class="btn btn-default btn-sm" ng-click="ac.cancelLoan(loan)">
                                                    <span class="glyphicon glyphicon-remove"></span> ${loc.loc("commons.zrusit")?noEsc}
                                                </button>
                                            </span>
                                            <span ng-show="!loan.cancelability.cancelable" class="text-muted">
                                                {{loan.cancelability|loc}}
                                            </span>
                                        </td>

                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="table-sole" ng-show="!ac.waitingLoanList.isLoadedAll()">
                            <button ng-show="ac.waitingLoanList.state === 'NORMAL'" type="button" class="btn btn-default btn-xs btn-block"
                                    ng-click="ac.waitingLoanList.loadNext()">
                                ${loc.loc("vysledky.NacistDalsi")?noEsc}
                            </button>
                            <div jp-loading="xs" ng-show="ac.waitingLoanList.state === 'PROCESSING'"></div>
                        </div>
                    </div>
                </uib-tab>


                <uib-tab select="ac.loadEndedLoans()" id="tab-ended-loans" role="tab" aria-selected="{{ac.activeLoanTypeTab === 'ended-loans'}}" aria-controls="panel-ended-loans">
                    <uib-tab-heading aria-live="polite">
                        ${loc.loc("loan.Vracene")?noEsc} <span class="text-muted" ng-bind="ac.endedLoanList.size"></span>
                    </uib-tab-heading>
                    <div class="panel panel-default" id="panel-ended-loans" role="tabpanel" aria-labelledby="tab-ended-loans" aria-live="polite">
                        <div ng-show="ac.endedLoanList.state === 'NORMAL' && ac.endedLoanList.items.length === 0" class="panel-body text-muted text-center">
                            ${loc.loc("commons.ZadnePolozky")?noEsc}
                        </div>
                        <div ng-show="ac.endedLoanList.items.length > 0" class="table-responsive">
                            <table class="greenHeaderTable table table-condensed table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th class="col_documentName">${loc.loc("commons.nazevDokumentu")?noEsc}</th>
                                        <th class="col_lendDate">${loc.loc("loan.DatumVypujceni")?noEsc}</th>
                                        <th class="col_returnDate">${loc.loc("loan.DatumVraceni")?noEsc}</th>
                                        <th class="col_type">${loc.loc("loan.TypVypujcky")?noEsc}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="loan in ac.endedLoanList.items" title="${loc.loc("commons.Identifikator")?noEsc} {{loan.id}}">

                                        <td class="col_documentName">
                                            <kp-svelte-component-wrapper component="::ac.kpDocumentMiniComponent" props="::{document: loan.document, exemplar: loan.exemplar}"></kp-svelte-component-wrapper>
                                            <div ng-show="(loan.timeslotOccupations || []).length > 0" style="margin-left: 40px;">
                                                <div ng-repeat="timeslotOccupation in loan.timeslotOccupations">{{timeslotOccupation.dateRange.fromDate | jpDate: 'd.M. HH:mm'}} - {{timeslotOccupation.dateRange.toDate | jpDate: 'd.M. HH:mm'}}</div>
                                            </div>
                                        </td>
                                        <td class="col_lendDate" ng-bind="loan.lendDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_returnDate" ng-bind="loan.endDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_type" ng-bind="loan.stateText"></td>

                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="table-sole" ng-show="!ac.endedLoanList.isLoadedAll()">
                            <button ng-show="ac.endedLoanList.state === 'NORMAL'" type="button" class="btn btn-default btn-xs btn-block"
                                    ng-click="ac.endedLoanList.loadNext()">
                                ${loc.loc("vysledky.NacistDalsi")?noEsc}
                            </button>
                            <div jp-loading="xs" ng-show="ac.endedLoanList.state === 'PROCESSING'"></div>
                        </div>
                    </div>
                </uib-tab>


                <uib-tab ng-if="!ac.user.role.includes('ROLE_LIBRARY')" select="ac.loadMvsLoans()" id="tab-mvs-loans" role="tab" aria-selected="{{ac.activeLoanTypeTab === 'mvs-loans'}}" aria-controls="panel-mvs-loans">
                    <uib-tab-heading aria-live="polite">
                        ${loc.loc("loan.MVS")?noEsc} <span class="text-muted" ng-bind="ac.mvsLoanList.size"></span>
                    </uib-tab-heading>
                    <div class="panel panel-default" id="panel-mvs-loans" role="tabpanel" aria-labelledby="tab-mvs-loans" aria-live="polite">
                        <div ng-show="ac.mvsLoanList.state === 'NORMAL' && ac.mvsLoanList.items.length === 0" class="panel-body text-muted text-center">
                            ${loc.loc("commons.ZadnePolozky")?noEsc}
                        </div>
                        <div ng-show="ac.mvsLoanList.items.length > 0" class="table-responsive">
                            <table class="greenHeaderTable table table-condensed table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th class="col_documentName">${loc.loc("commons.nazevDokumentu")?noEsc}</th>
                                        <th class="col_mvs_state">${loc.loc("commons.stav")?noEsc}</th>
                                        <td class="col_mvs_executor">${loc.loc("mvs.executor")?noEsc}</td>
                                        <th class="col_mvs_filling_date">${loc.loc("mvs.datumPodani")?noEsc}</th>
                                        <th class="col_mvs_reference_number">${loc.loc("mvs.jednaciCislo")?noEsc}</th>
                                        <th class="col_mvs_adoption_date">${loc.loc("mvs.datumPrijeti")?noEsc}</th>
                                        <th class="col_mvs_execution_date">${loc.loc("mvs.datumVyrizeni")?noEsc}</th>
                                        <th class="col_mvs_send_back_date">${loc.loc("mvs.datumOdeslaniZpet")?noEsc}</th>
                                        <th class="col_mvs_price">${loc.loc("commons.cena")?noEsc}</th>
                                        <th class="col_mvs_order_date">${loc.loc("mvs.datumObjednani")?noEsc}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="loan in ac.mvsLoanList.items">

                                        <td class="col_documentName">
                                            <kp-svelte-component-wrapper component="::ac.kpDocumentMiniComponent" props="::{document: loan.document}"></kp-svelte-component-wrapper>
                                        </td>
                                        <td class="col_mvs_state" ng-bind="loan.state | loc"></td>
                                        <td class="col_mvs_executor">
                                                                            <a kp-href="/#!/users/{{loan.executor.id}}">
                                                {{loan.executor | loc}}
                                            </a>
                                        </td>
                                        <td class="col_mvs_filling_date" ng-bind="loan.fillingDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_mvs_reference_number" ng-bind="loan.referenceNumber"></td>
                                        <td class="col_mvs_acceptance_date" ng-bind="loan.acceptanceDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_mvs_execution_date" ng-bind="loan.executionDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_mvs_send_back_date" ng-bind="loan.sendBackDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_mvs_price" ng-bind="loan.price"></td>
                                        <td class="col_mvs_order_date" ng-bind="loan.orderDate | jpDate:'d.M.yyyy'"></td>

                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="table-sole" ng-show="!ac.mvsLoanList.isLoadedAll()">
                            <button ng-show="ac.mvsLoanList.state === 'NORMAL'" type="button" class="btn btn-default btn-xs btn-block"
                                    ng-click="ac.mvsLoanList.loadNext()">
                                ${loc.loc("vysledky.NacistDalsi")?noEsc}
                            </button>
                            <div jp-loading="xs" ng-show="ac.mvsLoanList.state === 'PROCESSING'"></div>
                        </div>
                    </div>
                </uib-tab>


                <uib-tab ng-if="ac.user.role.includes('ROLE_LIBRARY')" select="ac.loadLibraryPassiveMvsLoans()" id="tab-library-passive-mvs-loans" role="tab" aria-selected="{{ac.activeLoanTypeTab === 'library-passive-mvs-loans'}}" aria-controls="panel-library-passive-mvs-loans">
                    <uib-tab-heading aria-live="polite">
                        <span ng-bind="'${loc.loc("loan.MvsZadankyNaX")?noEsc}' | strParams:(ac.user.sigla || ac.user.text) | characters:30"></span>
                        <span class="text-muted" ng-bind="ac.libraryPassiveMvsLoanList.size"></span>
                    </uib-tab-heading>
                    <div class="panel panel-default" id="panel-library-passive-mvs-loans" role="tabpanel" aria-labelledby="tab-library-passive-mvs-loans" aria-live="polite">
                        <div ng-show="ac.libraryPassiveMvsLoanList.state === 'NORMAL' && ac.libraryPassiveMvsLoanList.items.length === 0"
                             class="panel-body text-muted text-center">
                            ${loc.loc("commons.ZadnePolozky")?noEsc}
                        </div>
                        <div ng-show="ac.libraryPassiveMvsLoanList.items.length > 0" class="table-responsive">
                            <table class="greenHeaderTable table table-condensed table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th class="col_documentName">${loc.loc("commons.nazevDokumentu")?noEsc}</th>
                                        <th class="col_requester">${loc.loc("commons.Zadatel")?noEsc}</th>
                                        <th class="col_mvs_state">${loc.loc("commons.stav")?noEsc}</th>
                                        <th class="col_mvs_filling_date">${loc.loc("mvs.datumPodani")?noEsc}</th>
                                        <th class="col_mvs_reference_number">${loc.loc("mvs.jednaciCislo")?noEsc}</th>
                                        <th class="col_mvs_adoption_date">${loc.loc("mvs.datumPrijeti")?noEsc}</th>
                                        <th class="col_mvs_execution_date">${loc.loc("mvs.datumVyrizeni")?noEsc}</th>
                                        <th class="col_mvs_send_back_date">${loc.loc("mvs.datumOdeslaniZpet")?noEsc}</th>
                                        <th class="col_mvs_price">${loc.loc("commons.cena")?noEsc}</th>
                                        <th class="col_mvs_order_date">${loc.loc("mvs.datumObjednani")?noEsc}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="loan in ac.libraryPassiveMvsLoanList.items">

                                        <td class="col_documentName">
                                            <kp-svelte-component-wrapper component="::ac.kpDocumentMiniComponent" props="::{document: loan.document}"></kp-svelte-component-wrapper>
                                        </td>
                                        <td class="col_requester">
                                            <a kp-href="/#!/users/{{loan.requester.id}}">
                                                {{loan.requester | loc}}
                                            </a>
                                        </td>
                                        <td class="col_mvs_state" ng-bind="loan.state | loc"></td>
                                        <td class="col_mvs_filling_date" ng-bind="loan.fillingDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_mvs_reference_number" ng-bind="loan.referenceNumber"></td>
                                        <td class="col_mvs_acceptance_date" ng-bind="loan.acceptanceDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_mvs_execution_date" ng-bind="loan.executionDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_mvs_send_back_date" ng-bind="loan.sendBackDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_mvs_price" ng-bind="loan.price"></td>
                                        <td class="col_mvs_order_date" ng-bind="loan.orderDate | jpDate:'d.M.yyyy'"></td>

                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="table-sole" ng-show="!ac.libraryPassiveMvsLoanList.isLoadedAll()">
                            <button ng-show="ac.libraryPassiveMvsLoanList.state === 'NORMAL'" type="button" class="btn btn-default btn-xs btn-block"
                                    ng-click="ac.libraryPassiveMvsLoanList.loadNext()">
                                ${loc.loc("vysledky.NacistDalsi")?noEsc}
                            </button>
                            <div jp-loading="xs" ng-show="ac.libraryPassiveMvsLoanList.state === 'PROCESSING'"></div>
                        </div>
                    </div>
                </uib-tab>


                <uib-tab ng-if="ac.user.role.includes('ROLE_LIBRARY')" select="ac.loadLibraryActiveMvsLoans()" id="tab-library-active-mvs-loans" role="tab" aria-selected="{{ac.activeLoanTypeTab === 'library-active-mvs-loans'}}" aria-controls="panel-library-active-mvs-loans">
                    <uib-tab-heading aria-live="polite">
                        <span ng-bind="'${loc.loc("loan.MvsZadankyZX")?noEsc}' | strParams: (ac.user.sigla || ac.user.text) | characters:30"></span>
                        <span class="text-muted" ng-bind="ac.libraryActiveMvsLoanList.size"></span>
                    </uib-tab-heading>
                    <div class="panel panel-default" id="panel-library-active-mvs-loans" role="tabpanel" aria-labelledby="tab-library-active-mvs-loans" aria-live="polite">
                        <div ng-show="ac.libraryActiveMvsLoanList.state === 'NORMAL' && ac.libraryActiveMvsLoanList.items.length === 0"
                             class="panel-body text-muted text-center">
                            ${loc.loc("commons.ZadnePolozky")?noEsc}
                        </div>
                        <div ng-show="ac.libraryActiveMvsLoanList.items.length > 0" class="table-responsive">
                            <table class="greenHeaderTable table table-condensed table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th class="col_documentName">${loc.loc("commons.nazevDokumentu")?noEsc}</th>
                                        <th class="col_mvs_filling_date">${loc.loc("mvs.datumPodani")?noEsc}</th>
                                        <th class="col_mvs_reference_number">${loc.loc("mvs.jednaciCislo")?noEsc}</th>
                                        <th class="col_mvs_adoption_date">${loc.loc("mvs.datumPrijeti")?noEsc}</th>
                                        <th class="col_mvs_execution_date">${loc.loc("mvs.datumVyrizeni")?noEsc}</th>
                                        <th class="col_mvs_send_back_date">${loc.loc("mvs.datumOdeslaniZpet")?noEsc}</th>
                                        <th class="col_mvs_price">${loc.loc("commons.cena")?noEsc}</th>
                                        <th class="col_mvs_order_date">${loc.loc("mvs.datumObjednani")?noEsc}</th>
                                        <th class="col_mvs_state">${loc.loc("commons.stav")?noEsc}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="loan in ac.libraryActiveMvsLoanList.items">

                                        <td class="col_documentName">
                                            <kp-svelte-component-wrapper component="::ac.kpDocumentMiniComponent" props="::{document: loan.document}"></kp-svelte-component-wrapper>
                                        </td>
                                        <td class="col_mvs_filling_date" ng-bind="loan.fillingDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_mvs_reference_number" ng-bind="loan.referenceNumber"></td>
                                        <td class="col_mvs_acceptance_date" ng-bind="loan.acceptanceDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_mvs_execution_date" ng-bind="loan.executionDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_mvs_send_back_date" ng-bind="loan.sendBackDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_mvs_price" ng-bind="loan.price"></td>
                                        <td class="col_mvs_order_date" ng-bind="loan.orderDate | jpDate:'d.M.yyyy'"></td>
                                        <td class="col_mvs_state" ng-bind="loan.state|loc"></td>

                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="table-sole" ng-show="!ac.libraryActiveMvsLoanList.isLoadedAll()">
                            <button ng-show="ac.libraryActiveMvsLoanList.state === 'NORMAL'" type="button" class="btn btn-default btn-xs btn-block"
                                    ng-click="ac.libraryActiveMvsLoanList.loadNext()">
                                ${loc.loc("vysledky.NacistDalsi")?noEsc}
                            </button>
                            <div jp-loading="xs" ng-show="ac.libraryActiveMvsLoanList.state === 'PROCESSING'"></div>
                        </div>
                    </div>
                </uib-tab>


            </uib-tabset>

        </div>
    </div>


<div class="row">
    <aside class="main-panel-pravy col-sm-4">
        <kp-svelte-component-wrapper component="::ac.kpFavouritesPanelComponent"></kp-svelte-component-wrapper>
    </aside>

    <aside class="main-panel-pravy col-sm-4">
        <kp-sdi-requests-panel user-id="ac.user.id"></kp-sdi-requests-panel>
    </aside>

</div>

    <div class="upperFooter row col-sm-12">
        <a kp-href="/search-history">${loc.loc("hledani.ZobrazitHledaneDotazy")?noEsc}</a>
        |
        <jp-links links="ac.detailManager.exportLinks"
                  jp-show-if-empty="false"
                  jp-dropdown-button-text="'Export'"
                  jp-button-size="xs"
                  class="export-btn user-export">
        </jp-links>
    </div>

</div>
