<#ftl outputFormat="HTML">

<div class="selectable-record-card">

    <div class="panel panel-default" ng-class="{'panel-primary': $ctrl.isSelected}">

        <div class="panel-body">

            <div class="card-content">

                <div class="record-cover" ng-if="$ctrl.canShowCover()">
                    <#-- target null to disable click on cover           -->
                    <kp-svelte-component-wrapper component="::$ctrl.kpCoverComponent" props="::{record: $ctrl.record, target: null, fillTo: 'width'}"></kp-svelte-component-wrapper>
                </div>

                <div class="record-info" ng-if="$ctrl.record.exports.portaroSearchItemParagraph">
                    <div class="fond-label pull-right">
                        <span class="label label-info">{{::$ctrl.record.fond | loc}}</span>
                    </div>
                    <div ng-if="!$ctrl.record.valid" class="pull-right">
                        <span class="label label-danger">Nevalidní</span>
                    </div>

                    <div class="nazevZaznamu">
                        <a kp-href="/records/{{::$ctrl.record.id}}" target="_blank" ng-hide="$ctrl.isExternal()">{{::$ctrl.record.name}}</a>
                        <span ng-show="$ctrl.isExternal()">{{::$ctrl.record.name}}</span>
                    </div>

                    <div class="record-subtitle">{{::$ctrl.record.subTitle}}</div>

                    <div class="list-item-document-autor">
                        <span ng-repeat="author in $ctrl.record.mainAuthors" ng-show="author.id">
                            <a kp-href="/records/{{::author.id}}" target="_blank">{{::author | loc}}</a>
                            <span ng-if="!$last"> - </span>
                        </span>
                    </div>

                    <jp-custom-paragraph content="$ctrl.record.exports.portaroSearchItemParagraph" class="paragraph-template list-item-document-paragraph-template"></jp-custom-paragraph>
                </div>

                <div class="record-info" ng-if="!$ctrl.record.exports.portaroSearchItemParagraph">
                    <div ng-if="!$ctrl.record.valid" class="pull-right">
                        <span class="label label-danger">Nevalidní</span>
                    </div>

                    <div class="record-name">
                        <strong>{{::$ctrl.record.name}}</strong>
                    </div>

                    <div ng-if="$ctrl.isDocument()">
                        <div class="record-subtitle"> {{::$ctrl.record.subTitle}}</div>

                        <span>{{::$ctrl.record.isbn.value}}</span>

                        <div class="list-item-document-autor">
                            <span ng-repeat="author in $ctrl.record.mainAuthors" ng-show="author.id">
                                {{::author | loc}} <span ng-if="!$last"> - </span>
                            </span>
                        </div>
                    </div>

                </div>

            </div>

        </div>
    </div>

</div>






