<#ftl outputFormat="HTML">
<#import "../../../../freemarker/_localization.ftl" as loc>

<div ng-if="$ctrl.file" class="media-viewer-current-container stretch-height" ng-class="{'notForPrint': !$ctrl.file.printable}">
    <div ng-if="$ctrl.showBrowsingButtons">
        <button class="btn-previous btn btn-default glyphicon glyphicon-chevron-left" type="button" ng-show="$ctrl.hasPrevious()" ng-click="$ctrl.onPreviousDeferred.resolve()"></button>
    </div>

    <div ng-if="$ctrl.showBrowsingButtons">
        <button class="btn-next btn btn-default glyphicon glyphicon-chevron-right" type="button" ng-show="$ctrl.hasNext()" ng-click="$ctrl.onNextDeferred.resolve()"></button>
    </div>

    <div class="media-viewer-current stretch-height" ng-if="!$ctrl.file.viewForms.includes('UNKNOWN') && !$ctrl.file.error" ng-switch="$ctrl.viewMode">
        <div class="original stretch-height" ng-switch-when="ORIGINAL">

            <div class="image stretch-height" ng-if="$ctrl.isImage && !$ctrl.file.error">
                <kp-zoomable-image src="$ctrl.file.url" on-error="$ctrl.file.error = true" is-protected="!$ctrl.file.exportable"></kp-zoomable-image>
            </div>

            <div class="pdf stretch-height" ng-if="$ctrl.isPdf">
                <kp-pdf-viewer
                        class="stretch-height"
                        file-url="$ctrl.file.url"
                        file-size="$ctrl.file.size"
                        current-page="$ctrl.currentPage"
                        scale="scale"
                        fit="fit"
                        pdf-control-id="pdf"
                        on-current-page-change="$ctrl.currentPageChanged($currentPage)"
                        on-page-count-change="pageCount = $pageCount; $ctrl.onPageCountChange({$pageCount: $pageCount})"
                        on-scale-change="scale = $scale"
                        on-fit-change="fit = $fit"
                        on-document-errored="$ctrl.file.error = $error"
                >
                </kp-pdf-viewer>
            </div>

            <div class="media stretch-height" ng-if="$ctrl.isMedia">
                <kp-video-viewer-event-wrapper>
                    <kp-video-viewer src="$ctrl.CONTEXT_PATH+'/files/' + $ctrl.file.id" aspect-ratio="'16:9'"></kp-video-viewer>
                </kp-video-viewer-event-wrapper>
            </div>

            <div class="not-image" ng-if="!$ctrl.isImage && !$ctrl.isPdf">
                <#-- text:default -->
                <pre class="media-viewer-current-content-textual"
                     ng-if="!$ctrl.editMode && $ctrl.file.viewForms.includes('PLAIN_TEXT') && $ctrl.file.viewForms.includes('RICH_DOCUMENT')"
                     ng-include="$ctrl.CONTEXT_PATH+'/files/' + $ctrl.file.id">
                </pre>
                <#-- text:default -->
                <kp-file-editor ng-if="$ctrl.editMode && $ctrl.file.viewForms.includes('PLAIN_TEXT')" file="$ctrl.file" on-editor-init="$ctrl.fileEditor = $editor"></kp-file-editor>
                <#-- text:rich -->
                <iframe ng-if="$ctrl.editMode && $ctrl.file.viewForms.includes('RICH_DOCUMENT')" ng-src="{{$ctrl.file.url}}"></iframe>
            </div>
        </div>

        <pre class="textual-view-form" ng-switch-when="TEXTUAL">
            <div ng-include="$ctrl.CONTEXT_PATH+'/files/' + $ctrl.file.id + '/text'"></div>
        </pre>
    </div>

    <div class="unknown-view-form" ng-if="$ctrl.file.viewForms.includes('UNKNOWN')">
        <div class="message">
            ${loc.loc("mediaviewer.CannotDisplayFileUnknownViewform")?noEsc}
        </div>

        <div>
            <a class="btn btn-default btn-lg" download="{{$ctrl.file.filename}}" title="${loc.loc("commons.Stahnout")?noEsc}" kp-href="/files/{{$ctrl.file.id}}?inline=false">
                <span class="glyphicon glyphicon-save"></span>
                <br>
                <span>${loc.loc("commons.Stahnout")?noEsc}</span>
            </a>
        </div>
    </div>

    <div class="text-warn text-center error-message" ng-if="$ctrl.file.error">${loc.loc("mediaviewer.CannotDisplayFileError")?noEsc}</div>
</div>
