<#ftl outputFormat="HTML">
<#import "../../../../freemarker/_localization.ftl" as loc>

<div class="media-viewer-files-container dropzone" ngf-drop="$ctrl.uploadFile($files)" ngf-multiple="true">
    <ul class="list-group" ng-ref="$ctrl.scrollContainer" in-view-container>
        <li id="file-{{file.id}}"
            class="list-group-item"
            title="{{::file.name}}"
            ng-repeat="file in $ctrl.files track by file.id"
            ng-class="{'current': $ctrl.currentFile.id === file.id}"
            ng-click="$ctrl.onSelect({$file: file})"
            in-view="loadFile = $inview">

            <div style="margin-right: 0.5em;">
                <kp-svelte-component-wrapper component="::$ctrl.checkboxComponent"
                                             props="{checked: $ctrl.selection.contains(file)}"
                                             ng-on-change="$ctrl.selectFile(file)"
                                             ng-on-click="$event.stopPropagation()">
                </kp-svelte-component-wrapper>
            </div>

            <div class="file text-ellipsis" href="">
                <div class="text-ellipsis" ng-if="::file.viewForms.includes('THUMBNAIL')">
                    <kp-lazy-load-img url="file.url + '?height=60'" load="loadFile"></kp-lazy-load-img>
                    {{::file.name}}
                </div>

                <span ng-if="::!file.viewForms.includes('THUMBNAIL')">{{::file.name}}</span>
            </div>
        </li>
    </ul>

    <div class="action-panel" ng-if="$ctrl.selection.getAll().length > 0">
        <div class="text-ellipsis">Vybrané soubory ({{$ctrl.selection.getAll().length}})</div> <#-- TODO: Lokalizace -->
        <ul>
            <li class="text-ellipsis">
                <a href="" ng-if="$ctrl.isAllMailable($ctrl.selection.getAll())" ng-click="$ctrl.mail($ctrl.selection.getAll())">
                    Poslat emailem <#-- TODO: Lokalizace -->
                </a>
            </li>
            <li class="text-ellipsis">
                <a href="" ng-if="$ctrl.isAllPrintable($ctrl.selection.getAll())" ng-click="$ctrl.print($ctrl.selection.getAll())">
                    Vytisknout <#-- TODO: Lokalizace -->
                </a>
            </li>
            <li class="text-ellipsis">
                <a href="" ng-if="$ctrl.editingEnabled" ng-click="$ctrl.edit($ctrl.selection.getAll())">
                    Upravit metadata <#-- TODO: Lokalizace -->
                </a>
            </li>
            <li class="text-ellipsis">
                <a href="" ng-if="$ctrl.editingEnabled" ng-click="$ctrl.remove($ctrl.selection.getAll())">
                    Smazat <#-- TODO: Lokalizace -->
                </a>
            </li>
            <li class="text-ellipsis">
                <a href="" ng-click="$ctrl.selection.clear()">
                    Zrušit <#-- TODO: Lokalizace -->
                </a>
            </li>
        </ul>
    </div>

    <div class="footer" ng-if="$ctrl.editingEnabled">
        <ul class="menu">
            <li class="text-ellipsis">
                <a href="" ngf-select="$ctrl.uploadFile($files)" ngf-multiple="true">Nahrát soubor(y)</a> <#-- TODO: Lokalizace -->
            </li>
            <li class="text-ellipsis">
                <a href="" ng-click="$ctrl.createFile()">Vytvořit textový soubor</a> <#-- TODO: Lokalizace -->
            </li>
        </ul>
    </div>
</div>