<#ftl outputFormat="HTML">
<#import "../../../freemarker/_localization.ftl" as loc>


<div class="container messages">
    <h1>${loc.loc("commons.lokalizacniHlasky")?noEsc}</h1>
    <button type="button" class="btn btn-primary btn-sm pull-right" ng-click="$ctrl.createNewMessage()">
        <span class="glyphicon glyphicon-plus"></span>Vytvořit nový překlad
    </button>

    <form class="form-inline" style="margin-top: 20px; margin-bottom: 20px;">
        <div class="form-group">
            <input class="form-control" ng-model="$ctrl.searchQuery" ng-minlength="3" size="60" placeholder="Zadejte část textu nebo klíče"/>
        </div>
        <button type="submit" class="btn btn-primary" ng-click=" $ctrl.search($ctrl.searchQuery)">${loc.loc("commons.hledat")?noEsc}</button>
    </form>

    <div style="margin-top: 20px; margin-bottom: 20px;">
        <span ng-repeat="c in $ctrl.categories" style="display: inline-block; margin: 1px;">
                <button type="button" class="btn btn-default btn-xs" ng-class="{'active': $ctrl.activeCategories[c.id]}" ng-click="$ctrl.showCategory(c)">{{c.id}}</button>
        </span>
    </div>

    <div ng-show="$ctrl.messages" class="table-responsive">

        <table class="table table-hover">
            <thead>
            <tr>
                <th>Message code</th>
                <th>Dep</th>
                <th ng-repeat="lang in $ctrl.languages">{{lang.id}}</th>
            </tr>
            </thead>
            <tbody>
            <tr ng-repeat="message in $ctrl.messages">
                <td style="white-space: nowrap;">
                    <div jp-visible-on-hover-parent="1" style="position: absolute; margin-left: 5px; margin-top: -18px;">
                        <button type="button" class="btn btn-default btn-xs" ng-click="$ctrl.deleteMessage(message)">Delete message</button>
                    </div>
                    <span>{{message.code}}</span>
                </td>
                <td>
                    {{message.depId}}
                </td>
                <td ng-repeat="translation in $ctrl.getTranslationsByLanguages(message, $ctrl.languages) track by $index">
                    <div>
                        <div jp-visible-on-hover-parent="2" style="position: absolute; margin-left: 5px; margin-top: -18px;">
                            <button type="button" class="btn btn-default btn-xs" ng-click="$ctrl.editMessage(message)"><span class="glyphicon glyphicon-pencil"></span></button>
                            <button ng-show="translation.value !== null" type="button" class="btn btn-default btn-xs" ng-click="$ctrl.deleteTranslation(translation)">Delete</button>
                        </div>
                        <span>{{translation.value}}</span>
                    </div>
                </td>
            </tr>
            </tbody>
        </table>

    </div>
</div>
