<#ftl outputFormat="HTML">
<#import "../../../../../../freemarker/_localization.ftl" as loc>

<div class="panel-heading">
    <strong>${loc.loc("loan.Rezervace")?noEsc}</strong>
    <span class="label label-info">${loc.loc("loan.Absencni")?noEsc}</span>
</div>

<div class="panel-body">
    <p ng-if="group.requestItems.length === 1">
        <kp-svelte-component-wrapper
                component="::$ctrl.kpPluralizeTextComponent"
                props="::{
                        count: option.capability.buildings.length,
                        oneCountText: '${loc.loc("loan.DokumentJeKZarezervovaniNaBudove")?esc}',
                        moreText: '${loc.loc("loan.DokumentJeKZarezervovaniNaBudovach")?esc}'}">
        </kp-svelte-component-wrapper>
    </p>
    <p ng-if="group.requestItems.length > 1">
        <kp-svelte-component-wrapper
                component="::$ctrl.kpPluralizeTextComponent"
                props="::{
                        count: option.capability.buildings.length,
                        oneCountText: '${loc.loc("loan.DokumentyJsouKZarezervovaniNaBudove")?esc}',
                        moreText: '${loc.loc("loan.DokumentyJsouKZarezervovaniNaBudovach")?esc}'}">
        </kp-svelte-component-wrapper>
    </p>



    <div ng-if="$ctrl.showLoginFirstButton(option)">
        <p class="loan-request-option-buildings-list">
            <strong>{{option.capability.buildings|prop:'text'|inline:', '}}</strong>
        </p>
        <div class="loan-request-option-footer">
            <button type="button" class="btn btn-warning btn-login-first" ng-click="$ctrl.sendRequest('standardReservationRequest', option, group)">${loc.loc("commons.NejdrivePrihlasit")?noEsc}</button>
        </div>
    </div>

    <div ng-if="!$ctrl.showLoginFirstButton(option)">
        <div ng-if="option.capability.buildings.length === 1">
            <p class="loan-request-option-buildings-list">
                <strong>{{option.formObject.desiredBuildings[0]|loc}}</strong>
            </p>
        </div>
        <div style="margin-top: 20px;">
            <kp-svelte-component-wrapper component="::$ctrl.kpUniversalFormComponent"
                                         props="{formSettings: option.form, model: option.formObject, forceShowErrors: submitted}"
                                         get-svelte-component="$ctrl.connectFormController($svelteComponentInstant, 'standardReservabilityForm')"
                                         ng-on-submit="submitted = true">
            </kp-svelte-component-wrapper>
        </div>

        <div class="loan-request-option-footer">
            <button type="button"
                    class="btn btn-primary"
                    ng-disabled="!$ctrl.isValidReservation(option.formObject) || $ctrl.standardReservabilityForm.formInvalid"
                    ng-click="$ctrl.sendRequest('standardReservationRequest', option, group)">
                ${loc.loc("commons.rezervovat")?noEsc}
            </button>
        </div>
    </div>
</div>