<#ftl outputFormat="HTML">
<#import "../_localization.ftl" as loc>


<div class="row">

    <div class="col-xs-4">
        <div><strong>{{record.record|loc|characters:50}}</strong></div>
        <div><span>{{record.location|loc}}</span></div>
    </div>

    <div class="col-xs-4">
        <div><span>${loc.loc('exemplar.AccessNumber.abbr')}: {{record.accessNumber}}, ${loc.loc('exemplar.BarCode.abbr')}: {{record.barCode}}, Sign: {{record.signature}}</span></div>
        <div><span>{{record.customValue|loc}}</span></div>
        <div><span>{{record.loanCategory|loc}}</span></div>
    </div>

    <div class="col-xs-4" style="text-align: right;">
        <div>
            <span ng-class="{
                        'label': true,
                        'label-danger': record.matchState.id === 0,
                        'label-success': record.matchState.id === 1 || record.matchState.id === 2,
                        'label-warning': record.matchState.id === 3 || record.matchState.id === 4,
                        'label-info': record.matchState.id === 5
                    }"
                  style="text-transform: uppercase;">
                {{record.matchState|loc}}
            </span>
        </div>
        <div ng-if="record.previousInventory"><span class="text-muted">Předchozí revize <a kp-href="/search?type=match-search&kind=match&inventory={{record.previousInventory.id}}">{{record.previousInventory|loc}}</a></span></div>
    </div>

</div>