<#ftl outputFormat="HTML">
<#import "../_localization.ftl" as loc>


<div class="loan-request-dialog" ng-controller="ModalLoanRequestFormController as $ctrl" ng-init="$ctrl.init(model, modalWindowActions.cancel, modalWindowActions.submitPromise, modalWindowActions.closeAndReopen, modalWindowActions.reopen)">

    <div class="modal-header">
        <strong>${loc.loc("loan.Vypujcit")?noEsc}</strong>
    </div>

    <div class="modal-body">

        <div ng-if="$ctrl.form.groups.length === 0">
            <div class="col-xs-12 text-center">
                <strong>${loc.loc("loan.NelzeVypujcit")?noEsc}</strong>
            </div>
        </div>

        <div class="modal-body-block" ng-repeat="group in $ctrl.form.groups">
            <div class="row modal-body-block-header">
                <div class="col-xs-12">
                    <strong ng-repeat="item in group.requestItems">
                        {{item.document.name}}
                        <span ng-show="item.exemplar">
                            {{item.exemplar.signature}} {{item.exemplar.bundledVolumeNumber}} {{item.exemplar.bundledVolumeYear}}
                        </span>
                        <span ng-if="!$last">, </span>
                    </strong>
                </div>
            </div>

            <div class="row modal-body-block-body" ng-if="group.responses">
                <div class="col-xs-12">
                    <ul class="loan-request-list">
                        <li ng-repeat="response in group.responses" ng-bind-html="response.text"></li>
                    </ul>
                </div>
            </div>

            <div class="row loan-request-option-group modal-body-block-body" ng-if="!group.responses">

                <div ng-if="group.options.length === 0">
                    <strong>${loc.loc("loan.NelzeVypujcit")?noEsc}</strong>
                </div>

                <div class="loan-request-option-container" ng-repeat="option in group.options">

                    <div class="panel panel-default loan-request-option"
                         ng-class="$ctrl.capabilityNameToTemplateUrlMapping[option.capability.name].cssClass"
                         ng-include="$ctrl.capabilityNameToTemplateUrlMapping[option.capability.name].templateUrl">
                    </div>

                </div>
            </div>
        </div>

    </div>

    <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal" ng-click="$ctrl.closeForm()">
            ${loc.loc("commons.zavrit")?noEsc}
        </button>
    </div>

</div>