/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.web;

import cz.kpsys.portaro.acme.AcmeApiController;
import cz.kpsys.portaro.acme.AcmeHttpChallengeController;
import cz.kpsys.portaro.acme.AcmeService;
import cz.kpsys.portaro.acme.AcmeTemplate;
import cz.kpsys.portaro.acme.CertAndKeySaverToPemCustomFiles;
import cz.kpsys.portaro.acme.CertificateValidityChecker;
import cz.kpsys.portaro.acme.CertificateValidityCheckerImpl;
import cz.kpsys.portaro.acme.HttpsDataReloader;
import cz.kpsys.portaro.acme.HttpsDataReloaderByRestart;
import cz.kpsys.portaro.acme.IniSavingChallengeKeySetter;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.contextual.ContextIgnoringContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.DecoratableContextualProvider;
import cz.kpsys.portaro.commons.contextual.StaticContextualDelegatingProvider;
import cz.kpsys.portaro.commons.io.ResourceProviderByResourceLoader;
import cz.kpsys.portaro.commons.logging.Logged;
import cz.kpsys.portaro.commons.object.ProvidedProxiedList;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.TtlCachedProvider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.SystemInstitution;
import cz.kpsys.portaro.file.FileAccessType;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.custom.CustomFile;
import cz.kpsys.portaro.file.custom.CustomFileSaveAccessor;
import cz.kpsys.portaro.file.custom.RootCustomDirectoryAccessor;
import cz.kpsys.portaro.file.directory.DirectoryLoader;
import cz.kpsys.portaro.file.directory.ParentableDirectory;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingLoader;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.setting.SettingTypeId;
import cz.kpsys.portaro.shutdown.ApplicationRestarter;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class AcmeConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AcmeConfig.class);
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final Saver<CustomSetting<String>> customSettingSaver;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider;
    @NonNull
    private final RootCustomDirectoryAccessor rootCustomDirectoryAccessor;
    @NonNull
    private final Saver<ParentableDirectory> directorySaver;
    @NonNull
    private final DirectoryLoader directoryLoader;
    @NonNull
    private final Saver<IdentifiedFile> loadedIdentifiedFileSaver;
    @NonNull
    private final Provider<Integer> portaroUserIdProvider;
    @NonNull
    private final ByIdLoadable<CustomFile, String> customFileLoader;
    @NonNull
    private final ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader;
    @NonNull
    private final ApplicationRestarter applicationRestarter;
    @NonNull
    private final ResourceLoader keystoreResourceLoader;
    @NonNull
    private final Provider<Department> realRootDepartmentProvider;
    @NonNull
    private final Provider<FileAccessType> defaultFileAccessTypeProvider;
    @NonNull
    private final CustomSettingLoader customSettingLoader;

    @Bean
    public AcmeHttpChallengeController acmeHttpChallengeController() {
        StaticContextualDelegatingProvider rootDepKeyProvider = new StaticContextualDelegatingProvider(this.settingLoader.getDepartmentedProvider(SettingKeys.ACME_CHALLENGE_KEY), this.realRootDepartmentProvider);
        ContextIgnoringContextualProvider depIgnoringKeyProvider = new ContextIgnoringContextualProvider((Provider)rootDepKeyProvider);
        DecoratableContextualProvider cachePreCleaningKeyProvider = new DecoratableContextualProvider((ContextualProvider)depIgnoringKeyProvider).withPreHook(d -> this.cacheService.invalidateAllCaches());
        return new AcmeHttpChallengeController((ContextualProvider)cachePreCleaningKeyProvider);
    }

    @Bean
    public AcmeApiController acmeApiController() {
        return new AcmeApiController(this.acmeService(), this.automaticRenewingCertificateValidityChecker());
    }

    @Bean
    public AcmeService acmeService() {
        return new AcmeService(new AcmeTemplate(), this.realRootDepartmentProvider, (List)new ProvidedProxiedList((Provider)TtlCachedProvider.ofSeconds((long)10L, () -> new ArrayList(this.settingLoader.getContextToValueMap(SettingKeys.SERVER_URL).values()))), this.systemInstitutionProvider, (Consumer)new IniSavingChallengeKeySetter(this.customSettingSaver, (SettingTypeId)SettingKeys.ACME_CHALLENGE_KEY, (Integer)((Department)this.realRootDepartmentProvider.get()).getId(), this.customSettingLoader), (Saver)new CertAndKeySaverToPemCustomFiles(new CustomFileSaveAccessor(this.rootCustomDirectoryAccessor, this.directorySaver, this.directoryLoader, this.customFileLoader, this.identifiedFileLoader, this.loadedIdentifiedFileSaver, this.defaultFileAccessTypeProvider), "cert", "acme-fullchain.pem", "acme-privkey.pem", this.portaroUserIdProvider)).withAfterRenew(() -> this.certAndPrivateKeyReloader().reload());
    }

    @Bean
    public HttpsDataReloader certAndPrivateKeyReloader() {
        return () -> {
            if (((Boolean)this.settingLoader.getOnRoot(SettingKeys.INTERNAL_HTTPS_ENABLED)).booleanValue()) {
                this.httpsDataReloader().reload();
            }
        };
    }

    @Bean
    public HttpsDataReloader httpsDataReloader() {
        return new HttpsDataReloaderByRestart(this.applicationRestarter);
    }

    @Bean
    public CertificateValidityChecker automaticRenewingCertificateValidityChecker() {
        return new CertificateValidityCheckerImpl((Provider)new ResourceProviderByResourceLoader(this.keystoreResourceLoader, (Supplier)this.settingLoader.getOnRootProvider(SettingKeys.ACME_CERTIFICATE_LOCATION)), Duration.of(25L, ChronoUnit.DAYS), duration -> this.acmeService().renew());
    }

    @Logged
    @Scheduled(cron="0 0 4 * * *")
    @SchedulerLock(name="AcmeConfig_checkCertificateValidity", lockAtLeastFor="PT10M", lockAtMostFor="PT20M")
    public void checkCertificateValidity() {
        if (((Boolean)this.settingLoader.getOnRoot(SettingKeys.ACME_AUTO)).booleanValue()) {
            this.automaticRenewingCertificateValidityChecker().check();
        }
    }

    @ConstructorProperties(value={"cacheService", "settingLoader", "customSettingSaver", "systemInstitutionProvider", "rootCustomDirectoryAccessor", "directorySaver", "directoryLoader", "loadedIdentifiedFileSaver", "portaroUserIdProvider", "customFileLoader", "identifiedFileLoader", "applicationRestarter", "keystoreResourceLoader", "realRootDepartmentProvider", "defaultFileAccessTypeProvider", "customSettingLoader"})
    @Generated
    public AcmeConfig(@NonNull CacheService cacheService, @NonNull SettingLoader settingLoader, @NonNull Saver<CustomSetting<String>> customSettingSaver, @NonNull @NonNull ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider, @NonNull RootCustomDirectoryAccessor rootCustomDirectoryAccessor, @NonNull Saver<ParentableDirectory> directorySaver, @NonNull DirectoryLoader directoryLoader, @NonNull Saver<IdentifiedFile> loadedIdentifiedFileSaver, @NonNull Provider<Integer> portaroUserIdProvider, @NonNull ByIdLoadable<CustomFile, String> customFileLoader, @NonNull ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader, @NonNull ApplicationRestarter applicationRestarter, @NonNull ResourceLoader keystoreResourceLoader, @NonNull Provider<Department> realRootDepartmentProvider, @NonNull Provider<FileAccessType> defaultFileAccessTypeProvider, @NonNull CustomSettingLoader customSettingLoader) {
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(customSettingSaver, "customSettingSaver is marked non-null but is null");
        Objects.requireNonNull(systemInstitutionProvider, "systemInstitutionProvider is marked non-null but is null");
        Objects.requireNonNull(rootCustomDirectoryAccessor, "rootCustomDirectoryAccessor is marked non-null but is null");
        Objects.requireNonNull(directorySaver, "directorySaver is marked non-null but is null");
        Objects.requireNonNull(directoryLoader, "directoryLoader is marked non-null but is null");
        Objects.requireNonNull(loadedIdentifiedFileSaver, "loadedIdentifiedFileSaver is marked non-null but is null");
        Objects.requireNonNull(portaroUserIdProvider, "portaroUserIdProvider is marked non-null but is null");
        Objects.requireNonNull(customFileLoader, "customFileLoader is marked non-null but is null");
        Objects.requireNonNull(identifiedFileLoader, "identifiedFileLoader is marked non-null but is null");
        Objects.requireNonNull(applicationRestarter, "applicationRestarter is marked non-null but is null");
        Objects.requireNonNull(keystoreResourceLoader, "keystoreResourceLoader is marked non-null but is null");
        Objects.requireNonNull(realRootDepartmentProvider, "realRootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(defaultFileAccessTypeProvider, "defaultFileAccessTypeProvider is marked non-null but is null");
        Objects.requireNonNull(customSettingLoader, "customSettingLoader is marked non-null but is null");
        this.cacheService = cacheService;
        this.settingLoader = settingLoader;
        this.customSettingSaver = customSettingSaver;
        this.systemInstitutionProvider = systemInstitutionProvider;
        this.rootCustomDirectoryAccessor = rootCustomDirectoryAccessor;
        this.directorySaver = directorySaver;
        this.directoryLoader = directoryLoader;
        this.loadedIdentifiedFileSaver = loadedIdentifiedFileSaver;
        this.portaroUserIdProvider = portaroUserIdProvider;
        this.customFileLoader = customFileLoader;
        this.identifiedFileLoader = identifiedFileLoader;
        this.applicationRestarter = applicationRestarter;
        this.keystoreResourceLoader = keystoreResourceLoader;
        this.realRootDepartmentProvider = realRootDepartmentProvider;
        this.defaultFileAccessTypeProvider = defaultFileAccessTypeProvider;
        this.customSettingLoader = customSettingLoader;
    }
}

