/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.modules;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.ext.report.server.ConditionalReportServerLoader;
import cz.kpsys.portaro.ext.report.server.DynamicDepartmentedReportServerClient;
import cz.kpsys.portaro.ext.report.server.ReportServerApiController;
import cz.kpsys.portaro.ext.report.server.ReportServerLoader;
import cz.kpsys.portaro.ext.report.server.ReportServerSecurityActions;
import cz.kpsys.portaro.ext.report.server.ReportServerSettingsKeys;
import cz.kpsys.portaro.ext.report.server.SimpleReportServerLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import feign.RequestInterceptor;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
public class ReportServerConfig {
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final RequestInterceptor userAgentAddingInterceptor;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final ObjectFactory<HttpMessageConverters> messageConverters;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final SecurityManager securityManager;

    @Bean
    public ReportServerApiController reportServerApiController() {
        return new ReportServerApiController(this.reportServerLoader());
    }

    @Bean
    public ReportServerLoader reportServerLoader() {
        return new ConditionalReportServerLoader(this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_ENABLED), (ReportServerLoader)new SimpleReportServerLoader(this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_ROOT_FOLDER).throwingWhenNull(), this.dynamicDepartmentedReportServerClient()));
    }

    @Bean
    public DynamicDepartmentedReportServerClient dynamicDepartmentedReportServerClient() {
        return new DynamicDepartmentedReportServerClient(this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_API_URL).throwingWhenNull(), this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_READER_CLIENT_ID).throwingWhenNull(), this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_READER_CLIENT_TOKEN).throwingWhenNull(), this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_EDITOR_CLIENT_ID).throwingWhenNull(), this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_EDITOR_CLIENT_TOKEN).throwingWhenNull(), this.userAgentAddingInterceptor, this.objectMapper, this.messageConverters, this.securityManager);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        ContextualProvider reportServerEnableProvider = this.settingLoader.getDepartmentedProvider(ReportServerSettingsKeys.REPORT_SERVER_ENABLED);
        this.permissionRegistry.add(ReportServerSecurityActions.REPORT_SERVER_ADMIN_EXPORT, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.enabled(reportServerEnableProvider, Texts.ofNative((String)"Report server is not enabled")), this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"})}));
        this.permissionRegistry.add(ReportServerSecurityActions.REPORT_SERVER_EXPORT, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.enabled(reportServerEnableProvider, Texts.ofNative((String)"Report server is not enabled")), this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN", "ROLE_READER"})}));
    }

    @ConstructorProperties(value={"objectMapper", "userAgentAddingInterceptor", "settingLoader", "messageConverters", "permissionRegistry", "permissionFactory", "securityManager"})
    @Generated
    public ReportServerConfig(@NonNull ObjectMapper objectMapper, @NonNull RequestInterceptor userAgentAddingInterceptor, @NonNull SettingLoader settingLoader, @NonNull ObjectFactory<HttpMessageConverters> messageConverters, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull SecurityManager securityManager) {
        Objects.requireNonNull(objectMapper, "objectMapper is marked non-null but is null");
        Objects.requireNonNull(userAgentAddingInterceptor, "userAgentAddingInterceptor is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(messageConverters, "messageConverters is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        this.objectMapper = objectMapper;
        this.userAgentAddingInterceptor = userAgentAddingInterceptor;
        this.settingLoader = settingLoader;
        this.messageConverters = messageConverters;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.securityManager = securityManager;
    }
}

