/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.modules;

import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import cz.kpsys.portaro.commons.object.Identified;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticCodebook;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.exemplar.edit.EditedExemplar;
import cz.kpsys.portaro.importer.DepartmentedExistingDocumentLoader;
import cz.kpsys.portaro.importer.DepartmentedImportDocumentSaver;
import cz.kpsys.portaro.importer.DepartmentedImporter;
import cz.kpsys.portaro.importer.DocumentWithExemplarSaver;
import cz.kpsys.portaro.importer.ImportApiController;
import cz.kpsys.portaro.importer.ImportDocumentSaver;
import cz.kpsys.portaro.importer.ImportDocumentToRecordEditationConverter;
import cz.kpsys.portaro.importer.ImportDocumentWithExemplarToExemplarRequestConverter;
import cz.kpsys.portaro.importer.ImportRequestMapper;
import cz.kpsys.portaro.importer.LoadingAndSavingDepartmentedImporter;
import cz.kpsys.portaro.importer.csv.JacksonCsvImportRequestMapper;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RichRecord;
import cz.kpsys.portaro.record.document.RichDocument;
import cz.kpsys.portaro.record.edit.RecordEditationFactory;
import cz.kpsys.portaro.record.holding.RecordHoldingCreator;
import cz.kpsys.portaro.record.sec.CurrentAuthEditableFondsLoader;
import cz.kpsys.portaro.search.ItemCustomizableContextualSearchFunction;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarRequest;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarRequestDefaulter;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class ImporterConfig {
    @NonNull
    private final CurrentAuthEditableFondsLoader currentAuthEditableFondsLoader;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final RecordEditationFactory recordEditationFactory;
    @NonNull
    private final RecordHoldingCreator recordHoldingCreator;
    @NonNull
    private final Saver<EditedExemplar> exemplarSaver;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, RichRecord> nonDetailedRecordSearchSqlLoader;
    @NonNull
    private final ItemCustomizableContextualSearchFunction<Record, Department, Integer> subtreeDepartmentedRecordExemplarsCountResolver;
    @NonNull
    private final Converter<ExemplarRequest, List<Exemplar>> exemplarRequestToExemplarsConverter;
    @NonNull
    private final ExemplarRequestDefaulter importingExemplarRequestDefaulter;
    @NonNull
    private final ByIdLoadable<RichDocument, UUID> nonDetailedDocumentLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final Provider<Department> realRootDepartmentProvider;

    @Bean
    public static CsvMapper csvMapper() {
        return new CsvMapper().enable(CsvParser.Feature.WRAP_AS_ARRAY).enable(CsvParser.Feature.TRIM_SPACES);
    }

    @Bean
    public ImportDocumentWithExemplarToExemplarRequestConverter importRecordToExemplarRequestConverter() {
        return new ImportDocumentWithExemplarToExemplarRequestConverter(this.nonDetailedDocumentLoader, this.importingExemplarRequestDefaulter);
    }

    @Bean
    public ImportDocumentToRecordEditationConverter importRecordToRecordEditationConverter() {
        return new ImportDocumentToRecordEditationConverter(this.recordEditationFactory, this.currentAuthEditableFondsLoader);
    }

    public DepartmentedExistingDocumentLoader departmentedExistingDocumentLoader() {
        return new DepartmentedExistingDocumentLoader(this.nonDetailedRecordSearchSqlLoader, this.departmentAccessor);
    }

    @Bean
    public ImportApiController importApiController() {
        return new ImportApiController(this.loadingAndSavingDepartmentedImporter());
    }

    @Bean
    public Codebook<ImportRequestMapper, String> importRequestMapper() {
        return new StaticCodebook((Identified[])new ImportRequestMapper[]{new JacksonCsvImportRequestMapper(ImporterConfig.csvMapper())});
    }

    @Bean
    public DepartmentedImportDocumentSaver departmentedImportDocumentSaver() {
        return new DepartmentedImportDocumentSaver(this.importDocumentSaver(), this.documentWithExemplarSaver(), this.departmentedExistingDocumentLoader(), this.realRootDepartmentProvider);
    }

    @Bean
    public DepartmentedImporter loadingAndSavingDepartmentedImporter() {
        return new LoadingAndSavingDepartmentedImporter(this.departmentedImportDocumentSaver());
    }

    @Bean
    public DocumentWithExemplarSaver documentWithExemplarSaver() {
        return new DocumentWithExemplarSaver(this.importRecordToExemplarRequestConverter(), this.subtreeDepartmentedRecordExemplarsCountResolver, this.exemplarRequestToExemplarsConverter, this.exemplarSaver);
    }

    @Bean
    public ImportDocumentSaver importDocumentSaver() {
        return new ImportDocumentSaver(this.importRecordToRecordEditationConverter(), this.recordHoldingCreator);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForStringId(ImportRequestMapper.class, (ByIdLoadable)this.importRequestMapper());
    }

    @ConstructorProperties(value={"currentAuthEditableFondsLoader", "converterRegisterer", "recordEditationFactory", "recordHoldingCreator", "exemplarSaver", "nonDetailedRecordSearchSqlLoader", "subtreeDepartmentedRecordExemplarsCountResolver", "exemplarRequestToExemplarsConverter", "importingExemplarRequestDefaulter", "nonDetailedDocumentLoader", "departmentAccessor", "realRootDepartmentProvider"})
    @Generated
    public ImporterConfig(@NonNull CurrentAuthEditableFondsLoader currentAuthEditableFondsLoader, @NonNull ConverterRegisterer converterRegisterer, @NonNull RecordEditationFactory recordEditationFactory, @NonNull RecordHoldingCreator recordHoldingCreator, @NonNull Saver<EditedExemplar> exemplarSaver, @NonNull ParameterizedSearchLoader<MapBackedParams, RichRecord> nonDetailedRecordSearchSqlLoader, @NonNull ItemCustomizableContextualSearchFunction<Record, Department, Integer> subtreeDepartmentedRecordExemplarsCountResolver, @NonNull Converter<ExemplarRequest, List<Exemplar>> exemplarRequestToExemplarsConverter, @NonNull ExemplarRequestDefaulter importingExemplarRequestDefaulter, @NonNull ByIdLoadable<RichDocument, UUID> nonDetailedDocumentLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull Provider<Department> realRootDepartmentProvider) {
        Objects.requireNonNull(currentAuthEditableFondsLoader, "currentAuthEditableFondsLoader is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(recordEditationFactory, "recordEditationFactory is marked non-null but is null");
        Objects.requireNonNull(recordHoldingCreator, "recordHoldingCreator is marked non-null but is null");
        Objects.requireNonNull(exemplarSaver, "exemplarSaver is marked non-null but is null");
        Objects.requireNonNull(nonDetailedRecordSearchSqlLoader, "nonDetailedRecordSearchSqlLoader is marked non-null but is null");
        Objects.requireNonNull(subtreeDepartmentedRecordExemplarsCountResolver, "subtreeDepartmentedRecordExemplarsCountResolver is marked non-null but is null");
        Objects.requireNonNull(exemplarRequestToExemplarsConverter, "exemplarRequestToExemplarsConverter is marked non-null but is null");
        Objects.requireNonNull(importingExemplarRequestDefaulter, "importingExemplarRequestDefaulter is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentLoader, "nonDetailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(realRootDepartmentProvider, "realRootDepartmentProvider is marked non-null but is null");
        this.currentAuthEditableFondsLoader = currentAuthEditableFondsLoader;
        this.converterRegisterer = converterRegisterer;
        this.recordEditationFactory = recordEditationFactory;
        this.recordHoldingCreator = recordHoldingCreator;
        this.exemplarSaver = exemplarSaver;
        this.nonDetailedRecordSearchSqlLoader = nonDetailedRecordSearchSqlLoader;
        this.subtreeDepartmentedRecordExemplarsCountResolver = subtreeDepartmentedRecordExemplarsCountResolver;
        this.exemplarRequestToExemplarsConverter = exemplarRequestToExemplarsConverter;
        this.importingExemplarRequestDefaulter = importingExemplarRequestDefaulter;
        this.nonDetailedDocumentLoader = nonDetailedDocumentLoader;
        this.departmentAccessor = departmentAccessor;
        this.realRootDepartmentProvider = realRootDepartmentProvider;
    }
}

