/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.zaxxer.hikari.pool.HikariPool;
import cz.kpsys.portaro.appserver.AppserverAuthorizerByKey;
import cz.kpsys.portaro.appserver.AuthorizedAppserverService;
import cz.kpsys.portaro.appserver.BasicAppserverService;
import cz.kpsys.portaro.appserver.mapping.BasicMappingAppserverService;
import cz.kpsys.portaro.appserver.properties.AppserverPropertiesLoader;
import cz.kpsys.portaro.auth.GenericAuthenticationFilter;
import cz.kpsys.portaro.auth.credreg.DefaultCredentialsRegistrationService;
import cz.kpsys.portaro.auth.licence.SerialAndUserValidationCodeCheckingUserLicenceChecker;
import cz.kpsys.portaro.auth.process.AuthorizationHeaderTokenFinder;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.GuavaTimedDynamicCache;
import cz.kpsys.portaro.commons.cache.StaticCacheFullImpl;
import cz.kpsys.portaro.commons.concurrent.ExecutorServiceHelper;
import cz.kpsys.portaro.commons.contextual.ContextualConsumer;
import cz.kpsys.portaro.commons.crypto.KeyStoreAccessor;
import cz.kpsys.portaro.commons.io.DownloadFileStreamReader;
import cz.kpsys.portaro.commons.localization.HierarchyTraversingTranslator;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ItemNotFoundException;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.database.ClearDynamicDataCaller;
import cz.kpsys.portaro.core.application.PortaroVersion;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.exemplar.AccessNumberSequenceItemLoaderDelegating;
import cz.kpsys.portaro.ext.bakalari.BakalariClient;
import cz.kpsys.portaro.ext.edookit.EdookitClient;
import cz.kpsys.portaro.ext.edupage.EdupageClient;
import cz.kpsys.portaro.ext.report.server.ReportServerClient;
import cz.kpsys.portaro.ext.unis.UnisClient;
import cz.kpsys.portaro.file.FileAccessType;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.SecuredFileDataStreamer;
import cz.kpsys.portaro.file.cover.CoverDownloader;
import cz.kpsys.portaro.file.cover.CoverSearchManager;
import cz.kpsys.portaro.file.cover.CoversTransferService;
import cz.kpsys.portaro.file.cover.SpringDbCoversToSearchLoader;
import cz.kpsys.portaro.file.cover.UnfoundCoverDeleter;
import cz.kpsys.portaro.file.directory.DirectoryLoader;
import cz.kpsys.portaro.file.directory.ParentableDirectory;
import cz.kpsys.portaro.file.importer.FileImportService;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.logging.ClientSessionRepository;
import cz.kpsys.portaro.logging.SimpleLogger;
import cz.kpsys.portaro.record.detail.AppserverRecordDetailLoader;
import cz.kpsys.portaro.record.detail.appservermarc.MarcXmlToDetailConverterImpl;
import cz.kpsys.portaro.record.document.RecordDelegatingDocumentLoader;
import cz.kpsys.portaro.record.search.AppserverSearchEngine;
import cz.kpsys.portaro.search.AbstractStandardSearch;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.PageSearchLoaderSearch;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.shutdown.ApplicationRestarter;
import cz.kpsys.portaro.sql.generator.Query;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.edit.UserEditationRequestApplier;
import cz.kpsys.portaro.user.payment.provider.csobgw.CsobGwClient;
import cz.kpsys.portaro.user.role.reader.ReaderRole;
import cz.kpsys.portaro.user.sec.PermissionRegistrySecurityManager;
import cz.kpsys.portaro.user.sec.SecurityActions;
import cz.kpsys.portaro.view.web.SecurityManagerApiController;
import cz.kpsys.portaro.view.web.rest.CacheApiController;
import cz.kpsys.portaro.view.web.rest.LogApiController;
import cz.kpsys.portaro.view.web.rest.ServerInfoApiController;
import cz.kpsys.portaro.view.web.rest.UtilApiController;
import cz.kpsys.portaro.web.GenericController;
import cz.kpsys.portaro.web.exception.CompositeWebClientRequestExceptionResponseLogger;
import cz.kpsys.portaro.web.log.RequestStartLoggingFilter;
import cz.kpsys.portaro.web.log.ResponseTimeLoggingFilter;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.ConversionService;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.method.support.InvocableHandlerMethod;

@Configuration
public class UtilConfig {
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final CoverSearchManager coverSearchManager;
    @NonNull
    private final UnfoundCoverDeleter unfoundCoverDeleter;
    @NonNull
    private final CoversTransferService coversTransferService;
    @NonNull
    private final Saver<ParentableDirectory> directorySaver;
    @NonNull
    private final DirectoryLoader directoryLoader;
    @NonNull
    private final Saver<IdentifiedFile> loadedIdentifiedFileSaver;
    @NonNull
    private final PageSearchLoader<MapBackedParams, IdentifiedFile> fileSearchLoader;
    @NonNull
    private final ApplicationRestarter applicationRestarter;
    @NonNull
    private final ConversionService conversionService;
    @NonNull
    private final ByIdLoadable<FileAccessType, Integer> fileAccessTypeLoader;
    @NonNull
    private final ClientSessionRepository clientSessionRepository;
    @NonNull
    private final DatabaseProperties dbUpdateDatabaseProperties;
    @NonNull
    private final Provider<ZoneId> databaseColumnsTimeZoneProvider;
    @NonNull
    private final Provider<User> suUserProvider;
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final Date startTime;
    @NonNull
    private final AppserverPropertiesLoader appserverPropertiesLoader;
    @NonNull
    private final PortaroVersion portaroVersion;
    @NonNull
    private final @NonNull Supplier<@NonNull Licence> licenceProvider;
    @NonNull
    private final DatabaseProperties databaseProperties;

    @Bean
    public UtilApiController utilApiController() {
        return new UtilApiController(this.coverSearchManager, this.unfoundCoverDeleter, this.coversTransferService, new FileImportService(this.directorySaver, this.directoryLoader, this.loadedIdentifiedFileSaver, this.fileSearchLoader, () -> (FileAccessType)this.fileAccessTypeLoader.getById((Object)FileAccessType.PERMIT_ID)), this.applicationRestarter, this.clientSessionRepository, this.commandRunner());
    }

    @Bean
    public CacheApiController cacheApiController() {
        return new CacheApiController(this.cacheService);
    }

    @Bean
    public ServerInfoApiController serverInfoApiController() {
        return new ServerInfoApiController(this.startTime, this.appserverPropertiesLoader, this.coverSearchManager, this.portaroVersion, this.licenceProvider, this.databaseProperties);
    }

    @Bean
    public LogApiController logApiController() {
        return new LogApiController(List.of(new SimpleLogger(BasicAppserverService.class), new SimpleLogger(AuthorizedAppserverService.class), new SimpleLogger(BasicMappingAppserverService.class), new SimpleLogger(AppserverAuthorizerByKey.class), new SimpleLogger(Query.class), new SimpleLogger(HierarchyTraversingTranslator.class), new SimpleLogger(CacheService.class), new SimpleLogger(StaticCacheFullImpl.class), new SimpleLogger(GuavaTimedDynamicCache.class), new SimpleLogger(HikariPool.class), new SimpleLogger(RestTemplate.class), new SimpleLogger(CompositeWebClientRequestExceptionResponseLogger.class), new SimpleLogger(GenericController.class), new SimpleLogger(ResponseTimeLoggingFilter.class), new SimpleLogger(RequestStartLoggingFilter.class), new SimpleLogger(PermissionRegistrySecurityManager.class), new SimpleLogger(RecordDelegatingDocumentLoader.class), new SimpleLogger(AppserverRecordDetailLoader.class), new SimpleLogger(MarcXmlToDetailConverterImpl.class), new SimpleLogger(AccessNumberSequenceItemLoaderDelegating.class), new SimpleLogger(SecuredFileDataStreamer.class), new SimpleLogger(CoverDownloader.class), new SimpleLogger(SpringDbCoversToSearchLoader.class), new SimpleLogger(DownloadFileStreamReader.class), new SimpleLogger(KeyStoreAccessor.class), new SimpleLogger(ReaderRole.class), new SimpleLogger(UserEditationRequestApplier.class), new SimpleLogger(DefaultCredentialsRegistrationService.class), new SimpleLogger(GenericAuthenticationFilter.class), new SimpleLogger(AuthorizationHeaderTokenFinder.class), new SimpleLogger(AppserverSearchEngine.class), new SimpleLogger(PageSearchLoaderSearch.class), new SimpleLogger(AbstractStandardSearch.class), new SimpleLogger(SerialAndUserValidationCodeCheckingUserLicenceChecker.class), new SimpleLogger(Licence.class), new SimpleLogger("cz.kpsys.portaro.ncip"), new SimpleLogger("cz.kpsys.portaro.oai.provider"), new SimpleLogger("cz.kpsys.portaro.user.auth"), new SimpleLogger("org.springframework.web"), new SimpleLogger(InvocableHandlerMethod.class), new SimpleLogger("org.springframework.web.client"), new SimpleLogger("org.springframework.security"), new SimpleLogger("org.apache.http"), new SimpleLogger("org.openid4java"), new SimpleLogger("org.jasig"), new SimpleLogger("org.springframework.ldap"), new SimpleLogger("cz.kpsys.portaro.frontend"), new SimpleLogger(BakalariClient.class), new SimpleLogger(EdookitClient.class), new SimpleLogger(EdupageClient.class), new SimpleLogger(ReportServerClient.class), new SimpleLogger(UnisClient.class), new SimpleLogger(CsobGwClient.class)));
    }

    @Bean
    public SecurityManagerApiController securityManagerApiController() {
        return new SecurityManagerApiController(this.conversionService, this.permissionRegistry);
    }

    @Bean
    public ContextualConsumer<String, Department> commandRunner() {
        ContextualConsumer terminateRunningTasksCaller = (input, department) -> new ExecutorServiceHelper(this.executorService).awaitCompletion(Duration.ofSeconds(15L));
        ClearDynamicDataCaller clearDynamicDataCaller = new ClearDynamicDataCaller(new ExecutorServiceHelper(this.executorService), this.suUserProvider, this.dbUpdateDatabaseProperties, this.databaseColumnsTimeZoneProvider);
        Map<String, ClearDynamicDataCaller> commands = Map.of("terminate-running-tasks", terminateRunningTasksCaller, "clear-dynamic-data", clearDynamicDataCaller);
        return (command, ctx) -> {
            if (!commands.containsKey(command)) {
                throw new ItemNotFoundException((Object)"service command", command);
            }
            ((ContextualConsumer)commands.get(command)).acceptOn(command, ctx);
        };
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(SecurityActions.SERVICE_COMMAND_RUN, this.permissionFactory.currentEvidedAuthenticActiveWithAllRoles(new String[]{"ROLE_ADMIN"}));
        this.permissionRegistry.add(SecurityActions.UTIL_SHOW, this.permissionFactory.adminOrLibrarianWithServicePrivilegesOnEditableDep());
        this.permissionRegistry.add(SecurityActions.SETTINGS_EDIT, this.permissionFactory.adminOrLibrarianWithServicePrivilegesOnEditableDep());
        this.permissionRegistry.add(SecurityActions.LOCALIZATION_EDIT, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.adminOrLibrarianWithServicePrivilegesOnEditableDep(), this.permissionFactory.editAction(Integer.valueOf(4640))}));
        this.permissionRegistry.add(SecurityActions.DESIGN_EDIT, this.permissionFactory.adminOrLibrarianWithServicePrivilegesOnEditableDep());
        this.permissionRegistry.add(SecurityActions.FILES_MANAGE, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
        this.permissionRegistry.add(SecurityActions.MEDIA_VIEWER_EDIT, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionRegistry.get(SecurityActions.DESIGN_EDIT), this.permissionRegistry.get(SecurityActions.FILES_MANAGE)}));
        this.permissionRegistry.add(SecurityActions.ACTIVE_CLIENT_SESSIONS_SHOW, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
        this.permissionRegistry.add(SecurityActions.FACETS_EDIT, this.permissionFactory.adminOrLibrarianWithServicePrivilegesOnEditableDep());
        this.permissionRegistry.add(SecurityActions.FACET_EDIT, this.permissionFactory.adminOrLibrarianWithServicePrivilegesOnEditableDep());
        this.permissionRegistry.add(SecurityActions.LOG_SHOW, this.permissionFactory.currentEvidedAuthenticActiveWithAllRoles(new String[]{"ROLE_ADMIN"}));
        this.permissionRegistry.add(SecurityActions.SYSTEM_GC, this.permissionFactory.currentEvidedAuthenticActiveWithAllRoles(new String[]{"ROLE_ADMIN"}));
        this.permissionRegistry.add(SecurityActions.SYSTEM_RESTART, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN", "ROLE_SERVICEMAN", "ROLE_ACTUATOR"}));
    }

    @ConstructorProperties(value={"cacheService", "permissionRegistry", "permissionFactory", "coverSearchManager", "unfoundCoverDeleter", "coversTransferService", "directorySaver", "directoryLoader", "loadedIdentifiedFileSaver", "fileSearchLoader", "applicationRestarter", "conversionService", "fileAccessTypeLoader", "clientSessionRepository", "dbUpdateDatabaseProperties", "databaseColumnsTimeZoneProvider", "suUserProvider", "executorService", "startTime", "appserverPropertiesLoader", "portaroVersion", "licenceProvider", "databaseProperties"})
    @Generated
    public UtilConfig(@NonNull CacheService cacheService, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull CoverSearchManager coverSearchManager, @NonNull UnfoundCoverDeleter unfoundCoverDeleter, @NonNull CoversTransferService coversTransferService, @NonNull Saver<ParentableDirectory> directorySaver, @NonNull DirectoryLoader directoryLoader, @NonNull Saver<IdentifiedFile> loadedIdentifiedFileSaver, @NonNull PageSearchLoader<MapBackedParams, IdentifiedFile> fileSearchLoader, @NonNull ApplicationRestarter applicationRestarter, @NonNull ConversionService conversionService, @NonNull ByIdLoadable<FileAccessType, Integer> fileAccessTypeLoader, @NonNull ClientSessionRepository clientSessionRepository, @NonNull DatabaseProperties dbUpdateDatabaseProperties, @NonNull Provider<ZoneId> databaseColumnsTimeZoneProvider, @NonNull Provider<User> suUserProvider, @NonNull ExecutorService executorService, @NonNull Date startTime, @NonNull AppserverPropertiesLoader appserverPropertiesLoader, @NonNull PortaroVersion portaroVersion, @NonNull @NonNull Supplier<@NonNull Licence> licenceProvider, @NonNull DatabaseProperties databaseProperties) {
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(coverSearchManager, "coverSearchManager is marked non-null but is null");
        Objects.requireNonNull(unfoundCoverDeleter, "unfoundCoverDeleter is marked non-null but is null");
        Objects.requireNonNull(coversTransferService, "coversTransferService is marked non-null but is null");
        Objects.requireNonNull(directorySaver, "directorySaver is marked non-null but is null");
        Objects.requireNonNull(directoryLoader, "directoryLoader is marked non-null but is null");
        Objects.requireNonNull(loadedIdentifiedFileSaver, "loadedIdentifiedFileSaver is marked non-null but is null");
        Objects.requireNonNull(fileSearchLoader, "fileSearchLoader is marked non-null but is null");
        Objects.requireNonNull(applicationRestarter, "applicationRestarter is marked non-null but is null");
        Objects.requireNonNull(conversionService, "conversionService is marked non-null but is null");
        Objects.requireNonNull(fileAccessTypeLoader, "fileAccessTypeLoader is marked non-null but is null");
        Objects.requireNonNull(clientSessionRepository, "clientSessionRepository is marked non-null but is null");
        Objects.requireNonNull(dbUpdateDatabaseProperties, "dbUpdateDatabaseProperties is marked non-null but is null");
        Objects.requireNonNull(databaseColumnsTimeZoneProvider, "databaseColumnsTimeZoneProvider is marked non-null but is null");
        Objects.requireNonNull(suUserProvider, "suUserProvider is marked non-null but is null");
        Objects.requireNonNull(executorService, "executorService is marked non-null but is null");
        Objects.requireNonNull(startTime, "startTime is marked non-null but is null");
        Objects.requireNonNull(appserverPropertiesLoader, "appserverPropertiesLoader is marked non-null but is null");
        Objects.requireNonNull(portaroVersion, "portaroVersion is marked non-null but is null");
        Objects.requireNonNull(licenceProvider, "licenceProvider is marked non-null but is null");
        Objects.requireNonNull(databaseProperties, "databaseProperties is marked non-null but is null");
        this.cacheService = cacheService;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.coverSearchManager = coverSearchManager;
        this.unfoundCoverDeleter = unfoundCoverDeleter;
        this.coversTransferService = coversTransferService;
        this.directorySaver = directorySaver;
        this.directoryLoader = directoryLoader;
        this.loadedIdentifiedFileSaver = loadedIdentifiedFileSaver;
        this.fileSearchLoader = fileSearchLoader;
        this.applicationRestarter = applicationRestarter;
        this.conversionService = conversionService;
        this.fileAccessTypeLoader = fileAccessTypeLoader;
        this.clientSessionRepository = clientSessionRepository;
        this.dbUpdateDatabaseProperties = dbUpdateDatabaseProperties;
        this.databaseColumnsTimeZoneProvider = databaseColumnsTimeZoneProvider;
        this.suUserProvider = suUserProvider;
        this.executorService = executorService;
        this.startTime = startTime;
        this.appserverPropertiesLoader = appserverPropertiesLoader;
        this.portaroVersion = portaroVersion;
        this.licenceProvider = licenceProvider;
        this.databaseProperties = databaseProperties;
    }
}

