/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheCleaningDeleter;
import cz.kpsys.portaro.commons.cache.CacheCleaningSaver;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.GenericHookableDeleter;
import cz.kpsys.portaro.commons.object.repo.GenericHookableSaver;
import cz.kpsys.portaro.commons.object.repo.PreConvertingDeleter;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.ProgrammaticalTransactionalDeleter;
import cz.kpsys.portaro.commons.object.repo.ProgrammaticalTransactionalSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.database.FlushingJpaDeleter;
import cz.kpsys.portaro.database.FlushingJpaSaver;
import cz.kpsys.portaro.setting.AppserverCustomSettingsRefresher;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingEntity;
import cz.kpsys.portaro.setting.CustomSettingEntityId;
import cz.kpsys.portaro.setting.CustomSettingToEntityConverter;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.setting.TransactionAuthenticator;
import cz.kpsys.portaro.setting.UserContextRepository;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class SettingUpdateConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SettingUpdateConfig.class);
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final PlatformTransactionManager transactionManager;
    @NonNull
    private final ObjectMapper xmlMapper;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final Provider<Integer> portaroUserIdProvider;
    @NonNull
    private final CacheService cacheService;

    @Bean
    public JpaRepositoryFactoryBean<UserContextRepository, CustomSettingEntity, UUID> userContextRepositoryBean() {
        return new JpaRepositoryFactoryBean(UserContextRepository.class);
    }

    @Bean
    public UserContextRepository userContextRepository() {
        return (UserContextRepository)this.userContextRepositoryBean().getObject();
    }

    @Bean
    public Runnable saveTransactionAuthenticator() {
        TransactionAuthenticator transactionAuthenticator = new TransactionAuthenticator(this.portaroUserIdProvider, this.userContextRepository());
        return () -> ((TransactionAuthenticator)transactionAuthenticator).authenticate();
    }

    @Bean
    public JpaRepository<CustomSettingEntity, CustomSettingEntityId> customSettingJpaRepository() {
        return new SimpleJpaRepository(CustomSettingEntity.class, this.entityManager);
    }

    @Bean
    public Saver<CustomSetting<String>> customSettingSaver() {
        GenericHookableSaver saver = new GenericHookableSaver((Saver)new PreConvertingSaver((Converter)new CustomSettingToEntityConverter(), (Saver)new FlushingJpaSaver(this.customSettingJpaRepository())));
        saver.addPreHook(entity -> {
            this.saveTransactionAuthenticator().run();
            return entity;
        });
        return new CacheCleaningSaver((Saver)ProgrammaticalTransactionalSaver.create((Saver)saver, (PlatformTransactionManager)this.transactionManager), List.of(this.cacheService.createCleanerFor(CustomSetting.class.getSimpleName()), (CacheCleaner)this.settingLoader, new AppserverCustomSettingsRefresher(this.xmlMapper, this.mappingAppserver, this.settingLoader.getOnRootProvider(SettingKeys.APPSERVER_ENABLED))));
    }

    @Bean
    public Deleter<CustomSetting<String>> customSettingDeleter() {
        GenericHookableDeleter deleter = new GenericHookableDeleter((Deleter)new PreConvertingDeleter((Converter)new CustomSettingToEntityConverter(), (Deleter)new FlushingJpaDeleter(this.customSettingJpaRepository())));
        deleter.addPreHook(entity -> {
            this.saveTransactionAuthenticator().run();
            return entity;
        });
        return new CacheCleaningDeleter((Deleter)ProgrammaticalTransactionalDeleter.create((Deleter)deleter, (PlatformTransactionManager)this.transactionManager), List.of(this.cacheService.createCleanerFor(CustomSetting.class.getSimpleName()), (CacheCleaner)this.settingLoader, new AppserverCustomSettingsRefresher(this.xmlMapper, this.mappingAppserver, this.settingLoader.getOnRootProvider(SettingKeys.APPSERVER_ENABLED))));
    }

    @ConstructorProperties(value={"settingLoader", "entityManager", "transactionManager", "xmlMapper", "mappingAppserver", "portaroUserIdProvider", "cacheService"})
    @Generated
    public SettingUpdateConfig(@NonNull SettingLoader settingLoader, @NonNull EntityManager entityManager, @NonNull PlatformTransactionManager transactionManager, @NonNull ObjectMapper xmlMapper, @NonNull MappingAppserverService mappingAppserver, @NonNull Provider<Integer> portaroUserIdProvider, @NonNull CacheService cacheService) {
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(transactionManager, "transactionManager is marked non-null but is null");
        Objects.requireNonNull(xmlMapper, "xmlMapper is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(portaroUserIdProvider, "portaroUserIdProvider is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        this.settingLoader = settingLoader;
        this.entityManager = entityManager;
        this.transactionManager = transactionManager;
        this.xmlMapper = xmlMapper;
        this.mappingAppserver = mappingAppserver;
        this.portaroUserIdProvider = portaroUserIdProvider;
        this.cacheService = cacheService;
    }
}

