/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.domaineddepartment.DepartmentActivator;
import cz.kpsys.portaro.domaineddepartment.DomainedDepartmentCreator;
import cz.kpsys.portaro.domaineddepartment.UniquenessResolver;
import cz.kpsys.portaro.location.DepartmentLocationRelationLoader;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.location.LocationWithDepartments;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.user.sec.SecurityActions;
import cz.kpsys.portaro.view.web.rest.DepartmentApiController;
import cz.kpsys.portaro.view.web.rest.LocationApiController;
import cz.kpsys.portaro.view.web.rest.LocationRequest;
import cz.kpsys.portaro.view.web.rest.LocationRequestToLocationWithDepartmentsConverter;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class PlacementViewConfig {
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final AllValuesProvider<Department> departmentLoader;
    @NonNull
    private final Codebook<Location, Integer> locationLoader;
    @NonNull
    private final DepartmentLocationRelationLoader departmentLocationRelationLoader;
    @NonNull
    private final Saver<LocationWithDepartments> locationWithDepartmentsSaver;
    @NonNull
    private final Deleter<Location> locationDeleter;
    @NonNull
    private final DomainedDepartmentCreator domainedDepartmentCreator;
    @NonNull
    private final DepartmentActivator departmentActivator;
    @NonNull
    private final UniquenessResolver<String> serverUrlUniquenessResolver;

    @Bean
    public LocationApiController locationApiController() {
        return new LocationApiController(this.locationLoader, this.departmentLocationRelationLoader, this.locationWithDepartmentsSaver, this.locationDeleter, this.locationRequestToLocationWithDepartmentsConverter());
    }

    @Bean
    public DepartmentApiController departmentController() {
        return new DepartmentApiController(this.departmentLoader, this.departmentLocationRelationLoader, this.domainedDepartmentCreator, this.departmentActivator, this.serverUrlUniquenessResolver);
    }

    @Bean
    public Converter<LocationRequest, LocationWithDepartments> locationRequestToLocationWithDepartmentsConverter() {
        return new LocationRequestToLocationWithDepartmentsConverter();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(SecurityActions.PLACEMENTS_SHOW, this.permissionFactory.editAction(Integer.valueOf(4410)));
        this.permissionRegistry.add(SecurityActions.PLACEMENT_CREATE, this.permissionFactory.editAction(Integer.valueOf(4411)));
        this.permissionRegistry.add(SecurityActions.PLACEMENT_EDIT, this.permissionFactory.editAction(Integer.valueOf(4412)));
        this.permissionRegistry.add(SecurityActions.PLACEMENT_DELETE, this.permissionFactory.editAction(Integer.valueOf(4413)));
    }

    @ConstructorProperties(value={"permissionRegistry", "permissionFactory", "departmentLoader", "locationLoader", "departmentLocationRelationLoader", "locationWithDepartmentsSaver", "locationDeleter", "domainedDepartmentCreator", "departmentActivator", "serverUrlUniquenessResolver"})
    @Generated
    public PlacementViewConfig(@NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull AllValuesProvider<Department> departmentLoader, @NonNull Codebook<Location, Integer> locationLoader, @NonNull DepartmentLocationRelationLoader departmentLocationRelationLoader, @NonNull Saver<LocationWithDepartments> locationWithDepartmentsSaver, @NonNull Deleter<Location> locationDeleter, @NonNull DomainedDepartmentCreator domainedDepartmentCreator, @NonNull DepartmentActivator departmentActivator, @NonNull UniquenessResolver<String> serverUrlUniquenessResolver) {
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(locationLoader, "locationLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLocationRelationLoader, "departmentLocationRelationLoader is marked non-null but is null");
        Objects.requireNonNull(locationWithDepartmentsSaver, "locationWithDepartmentsSaver is marked non-null but is null");
        Objects.requireNonNull(locationDeleter, "locationDeleter is marked non-null but is null");
        Objects.requireNonNull(domainedDepartmentCreator, "domainedDepartmentCreator is marked non-null but is null");
        Objects.requireNonNull(departmentActivator, "departmentActivator is marked non-null but is null");
        Objects.requireNonNull(serverUrlUniquenessResolver, "serverUrlUniquenessResolver is marked non-null but is null");
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.departmentLoader = departmentLoader;
        this.locationLoader = locationLoader;
        this.departmentLocationRelationLoader = departmentLocationRelationLoader;
        this.locationWithDepartmentsSaver = locationWithDepartmentsSaver;
        this.locationDeleter = locationDeleter;
        this.domainedDepartmentCreator = domainedDepartmentCreator;
        this.departmentActivator = departmentActivator;
        this.serverUrlUniquenessResolver = serverUrlUniquenessResolver;
    }
}

