/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.appserver.GenericTableWriteSaver;
import cz.kpsys.portaro.appserver.SimpleHardDeleterAppserver;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.TableWriteGenerator;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.convert.StringToIntegerConverter;
import cz.kpsys.portaro.commons.object.IdSettable;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadableByIdLoaderAdapter;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.department.DepartmentEntity;
import cz.kpsys.portaro.department.DepartmentSaveTableWriteGenerator;
import cz.kpsys.portaro.department.HierarchyContextsByModeLoader;
import cz.kpsys.portaro.location.AllowedLocationsContextualProvider;
import cz.kpsys.portaro.location.DepartmentLocationRelation;
import cz.kpsys.portaro.location.DepartmentLocationRelationLoader;
import cz.kpsys.portaro.location.DepartmentLocationRelationSaveTableWriteGenerator;
import cz.kpsys.portaro.location.EntityToLocationConverter;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.location.LocationDeletionTableWriteGenerator;
import cz.kpsys.portaro.location.LocationEntity;
import cz.kpsys.portaro.location.LocationToEntityConverter;
import cz.kpsys.portaro.location.LocationWithDepartments;
import cz.kpsys.portaro.location.LocationWithDepartmentsDelegatingSaver;
import cz.kpsys.portaro.location.SpringDbDepartmentLocationRelationLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class PlacementConfig {
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final ConverterRegisterer converterRegisterer;

    @Bean
    public Saver<DepartmentEntity> departmentEntitySaver() {
        return GenericTableWriteSaver.of((TableWriteGenerator)new DepartmentSaveTableWriteGenerator(), (DmlAppserverService)this.dmlAppserverService, (CacheCleaner[])new CacheCleaner[]{this.cacheService.createCleanerFor(Department.class.getSimpleName())});
    }

    @Bean
    public Codebook<Location, Integer> locationLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(LocationEntity.class, "order").convertedEachBy((Converter)new EntityToLocationConverter()).staticCached(Location.class.getSimpleName()).build();
    }

    @Bean
    public ContextualProvider<Department, List<Location>> allowedLocationsContextualProvider() {
        return new AllowedLocationsContextualProvider((HierarchyContextsByModeLoader)this.departmentAccessor, this.departmentLocationRelationLoader());
    }

    @Bean
    public DepartmentLocationRelationLoader departmentLocationRelationLoader() {
        return new SpringDbDepartmentLocationRelationLoader(this.jdbcTemplate, this.queryFactory, (AllByIdsLoadable)new AllByIdsLoadableByIdLoaderAdapter(this.departmentLoader), (AllByIdsLoadable)new AllByIdsLoadableByIdLoaderAdapter((ByIdLoadable)this.locationLoader()));
    }

    @Bean
    public Saver<Location> locationSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new LocationToEntityConverter()).idSetting(LocationEntity.class, (Converter)new StringToIntegerConverter(), IdSettable::setId).withClearedCacheName(Location.class.getSimpleName()).build();
    }

    @Bean
    public Saver<LocationWithDepartments> locationWithDepartmentsSaver() {
        return new LocationWithDepartmentsDelegatingSaver(this.dmlAppserverService, this.locationSaver(), this.departmentLocationRelationSaver());
    }

    @Bean
    public Saver<List<DepartmentLocationRelation>> departmentLocationRelationSaver() {
        return GenericTableWriteSaver.of((TableWriteGenerator)new DepartmentLocationRelationSaveTableWriteGenerator(), (DmlAppserverService)this.dmlAppserverService, (CacheCleaner[])new CacheCleaner[0]);
    }

    @Bean
    public Deleter<Location> locationDeleter() {
        return new SimpleHardDeleterAppserver((TableWriteGenerator)new LocationDeletionTableWriteGenerator(), this.dmlAppserverService).withCacheCleaner(this.cacheService.createCleanerFor(Location.class.getSimpleName()));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForIntegerId(Location.class, (ByIdLoadable)this.locationLoader());
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "dmlAppserverService", "cacheService", "departmentLoader", "departmentAccessor", "codebookLoaderBuilderFactory", "saverBuilderFactory", "converterRegisterer"})
    @Generated
    public PlacementConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull DmlAppserverService dmlAppserverService, @NonNull CacheService cacheService, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull ConverterRegisterer converterRegisterer) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.dmlAppserverService = dmlAppserverService;
        this.cacheService = cacheService;
        this.departmentLoader = departmentLoader;
        this.departmentAccessor = departmentAccessor;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.saverBuilderFactory = saverBuilderFactory;
        this.converterRegisterer = converterRegisterer;
    }
}

