/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.appserver.GenericTableWriteSaver;
import cz.kpsys.portaro.appserver.SimpleHardDeleterAppserver;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.TableWriteGenerator;
import cz.kpsys.portaro.appserver.mapping.AppserverResponseHandler;
import cz.kpsys.portaro.appserver.mapping.AppserverSaveResponseHandler;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.image.ImageResizer;
import cz.kpsys.portaro.commons.image.ImageResizerScalr;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.io.ResourceDownloader;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.pdf.PdfMerger;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.file.FileAccessType;
import cz.kpsys.portaro.file.FileConfig;
import cz.kpsys.portaro.file.FileIndexConfig;
import cz.kpsys.portaro.file.FileProcessingState;
import cz.kpsys.portaro.file.FileSettingKeys;
import cz.kpsys.portaro.file.FileStreamerConfig;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.IdentifiedFileDeletionTableWriteGenerator;
import cz.kpsys.portaro.file.IdentifiedFileSaveTableWriteGenerator;
import cz.kpsys.portaro.file.ImageDownloader;
import cz.kpsys.portaro.file.custom.CodebookDelegatingRootCustomDirectoryAccessor;
import cz.kpsys.portaro.file.custom.CustomFile;
import cz.kpsys.portaro.file.custom.CustomFileLoaderByFileLoader;
import cz.kpsys.portaro.file.custom.CustomFileResourceWithoutDepartmentPrefixProtocolResolver;
import cz.kpsys.portaro.file.custom.EntitiesToRootCustomDirectoriesConverter;
import cz.kpsys.portaro.file.custom.HierarchyTraversingCustomFileLoader;
import cz.kpsys.portaro.file.custom.RootCustomDirectory;
import cz.kpsys.portaro.file.custom.RootCustomDirectoryAccessor;
import cz.kpsys.portaro.file.custom.RootCustomDirectoryEntity;
import cz.kpsys.portaro.file.custom.RootCustomDirectorySaveTableWriteGenerator;
import cz.kpsys.portaro.file.directory.Directory;
import cz.kpsys.portaro.file.directory.DirectoryDeletionTableWriteGenerator;
import cz.kpsys.portaro.file.directory.DirectoryInsightLoader;
import cz.kpsys.portaro.file.directory.DirectoryInsightLoaderByFileSearch;
import cz.kpsys.portaro.file.directory.DirectoryLoader;
import cz.kpsys.portaro.file.directory.DirectorySaveTableWriteGenerator;
import cz.kpsys.portaro.file.directory.ParentableDirectory;
import cz.kpsys.portaro.file.filecategory.FileCategory;
import cz.kpsys.portaro.file.text.FileTextIndexConfig;
import cz.kpsys.portaro.file.text.FileTextStreamerConfig;
import cz.kpsys.portaro.filter.Filter;
import cz.kpsys.portaro.filter.FilterLoader;
import cz.kpsys.portaro.filter.LazyFilter;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.user.sec.SecurityActions;
import cz.kpsys.portaro.view.web.ImageResizerController;
import cz.kpsys.portaro.view.web.stream.PdfByIdentifiedFilesMerger;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.ProtocolResolver;

@Configuration
@Import(value={FileConfig.class, FileIndexConfig.class, FileStreamerConfig.class, FileTextStreamerConfig.class, FileTextIndexConfig.class})
@Lazy
public class FileImplConfig {
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final ImageDownloader imageDownloader;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final FilterLoader filterLoader;
    @NonNull
    private final HttpServletRequest httpServletRequest;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final ConfigurableApplicationContext applicationContext;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final DirectoryLoader directoryLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, IdentifiedFile> fileSearchLoader;
    @NonNull
    private final ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader;
    @NonNull
    private final Codebook<FileAccessType, Integer> fileAccessTypeLoader;
    @NonNull
    private final Codebook<FileCategory, Integer> fileCategoryLoader;
    @NonNull
    private final FileDataStreamer fileDataStreamer;

    @Bean
    public Provider<Boolean> fileIndexingEnabledProvider() {
        return this.settingLoader.getOnRootProvider(FileSettingKeys.PORTARO_INDEXING_ENABLED);
    }

    @Bean
    public DirectoryInsightLoader directoryInsightLoader() {
        return new DirectoryInsightLoaderByFileSearch(this.directoryLoader, (PageSearchLoader)this.fileSearchLoader);
    }

    @Bean
    public ImageResizerController imageResizerController() {
        return new ImageResizerController(this.imageDownloader, this.imageResizer(), this.resourceDownloader());
    }

    @Bean
    public ImageResizer imageResizer() {
        return new ImageResizerScalr(true);
    }

    @Bean
    public ResourceDownloader resourceDownloader() {
        return new ResourceDownloader();
    }

    @Bean
    public PdfMerger pdfMerger() {
        return new PdfMerger();
    }

    @Bean
    public PdfByIdentifiedFilesMerger pdfByIdentifiedFilesMerger() {
        return new PdfByIdentifiedFilesMerger(this.pdfMerger(), this.fileDataStreamer);
    }

    @Bean
    public ByIdLoadable<CustomFile, String> hierarchyTraversingCustomFileLoader() {
        return new HierarchyTraversingCustomFileLoader(this.departmentAccessor, (ByIdLoadable)this.customFileLoader());
    }

    @Bean
    public Codebook<CustomFile, String> customFileLoader() {
        CustomFileLoaderByFileLoader bean = new CustomFileLoaderByFileLoader((AllValuesProvider)this.rootCustomdirectoryLoader(), this.directoryLoader, this.fileSearchLoader);
        Codebook codebook = this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)bean).staticCached(CustomFile.class.getSimpleName()).build();
        this.applicationContext.addProtocolResolver((ProtocolResolver)new CustomFileResourceWithoutDepartmentPrefixProtocolResolver((ByIdLoadable)codebook, this.fileDataStreamer, this.rootDepartmentProvider));
        return codebook;
    }

    @Bean
    public Saver<RootCustomDirectory> rootCustomDirectorySaver() {
        return GenericTableWriteSaver.of((TableWriteGenerator)new RootCustomDirectorySaveTableWriteGenerator(), (DmlAppserverService)this.dmlAppserverService, (CacheCleaner[])new CacheCleaner[]{this.cacheService.createCleanerFor(RootCustomDirectory.class.getSimpleName())});
    }

    @Bean
    public Codebook<RootCustomDirectory, Integer> rootCustomdirectoryLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(RootCustomDirectoryEntity.class, "departmentId").converted((Converter)new EntitiesToRootCustomDirectoriesConverter((AllByIdsLoadable)this.directoryLoader)).staticCached(RootCustomDirectory.class.getSimpleName()).build();
    }

    @Bean
    public RootCustomDirectoryAccessor rootCustomDirectoryAccessor() {
        return new CodebookDelegatingRootCustomDirectoryAccessor(this.rootCustomdirectoryLoader());
    }

    @Bean
    public Deleter<IdentifiedFile> identifiedFileDeleter() {
        return new SimpleHardDeleterAppserver((TableWriteGenerator)new IdentifiedFileDeletionTableWriteGenerator(), this.dmlAppserverService);
    }

    @Bean
    public Saver<IdentifiedFile> pureLoadedIdentifiedFileSaver() {
        return GenericTableWriteSaver.ofIdSettable((TableWriteGenerator)new IdentifiedFileSaveTableWriteGenerator(), (DmlAppserverService)this.dmlAppserverService, (AppserverResponseHandler)AppserverSaveResponseHandler.forConcreteColumnLongId((String)"fulltext_soubory", (String)"id_fulltext"), List.of(this.cacheService.createCleanerFor(CustomFile.class.getSimpleName()), this.cacheService.createCleanerFor(IdentifiedFile.class.getSimpleName())));
    }

    @Bean
    public Saver<ParentableDirectory> directorySaver() {
        return GenericTableWriteSaver.ofIdSettable((TableWriteGenerator)new DirectorySaveTableWriteGenerator(), (DmlAppserverService)this.dmlAppserverService, (AppserverResponseHandler)AppserverSaveResponseHandler.forConcreteColumnIntegerId((String)"fulltext_skupiny", (String)"id_fulltext_skupiny"), List.of());
    }

    @Bean
    public Deleter<ParentableDirectory> directoryDeleter() {
        return new SimpleHardDeleterAppserver((TableWriteGenerator)new DirectoryDeletionTableWriteGenerator(), this.dmlAppserverService);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForIntegerId(Directory.class, (ByIdLoadable)this.directoryLoader).registerForLongId(IdentifiedFile.class, this.identifiedFileLoader).registerForIntegerId(FileAccessType.class, (ByIdLoadable)this.fileAccessTypeLoader).registerForIntegerId(FileCategory.class, (ByIdLoadable)this.fileCategoryLoader).registerForIntegerId(FileProcessingState.class, (ByIdLoadable)FileProcessingState.CODEBOOK).registerForIntegerId(ParentableDirectory.class, (ByIdLoadable)this.directoryLoader);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        LazyFilter showFilter = new LazyFilter(Integer.valueOf(1), this.filterLoader);
        LazyFilter printFilter = new LazyFilter(Integer.valueOf(2), this.filterLoader);
        this.permissionRegistry.add(SecurityActions.FILES_MANAGE, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
        this.permissionRegistry.add(SecurityActions.FILES_SHOW, (auth, ctx, unused) -> PermissionResult.allow());
        this.permissionRegistry.add(SecurityActions.FILE_SHOW, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{PermissionResolver.withoutSubject((PermissionResolver)this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"})), this.permissionFactory.webAccessFilter((Filter)showFilter, this.httpServletRequest)}));
        this.permissionRegistry.add(SecurityActions.FILE_TEXT_SHOW, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{PermissionResolver.withoutSubject((PermissionResolver)this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"})), this.permissionFactory.webAccessFilter((Filter)printFilter, this.httpServletRequest)}));
    }

    @ConstructorProperties(value={"dmlAppserverService", "cacheService", "settingLoader", "departmentAccessor", "imageDownloader", "permissionRegistry", "permissionFactory", "filterLoader", "httpServletRequest", "codebookLoaderBuilderFactory", "converterRegisterer", "applicationContext", "rootDepartmentProvider", "directoryLoader", "fileSearchLoader", "identifiedFileLoader", "fileAccessTypeLoader", "fileCategoryLoader", "fileDataStreamer"})
    @Generated
    public FileImplConfig(@NonNull DmlAppserverService dmlAppserverService, @NonNull CacheService cacheService, @NonNull SettingLoader settingLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull ImageDownloader imageDownloader, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull FilterLoader filterLoader, @NonNull HttpServletRequest httpServletRequest, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull ConverterRegisterer converterRegisterer, @NonNull ConfigurableApplicationContext applicationContext, @NonNull Provider<Department> rootDepartmentProvider, @NonNull DirectoryLoader directoryLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, IdentifiedFile> fileSearchLoader, @NonNull ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader, @NonNull Codebook<FileAccessType, Integer> fileAccessTypeLoader, @NonNull Codebook<FileCategory, Integer> fileCategoryLoader, @NonNull FileDataStreamer fileDataStreamer) {
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(imageDownloader, "imageDownloader is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(filterLoader, "filterLoader is marked non-null but is null");
        Objects.requireNonNull(httpServletRequest, "httpServletRequest is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(applicationContext, "applicationContext is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(directoryLoader, "directoryLoader is marked non-null but is null");
        Objects.requireNonNull(fileSearchLoader, "fileSearchLoader is marked non-null but is null");
        Objects.requireNonNull(identifiedFileLoader, "identifiedFileLoader is marked non-null but is null");
        Objects.requireNonNull(fileAccessTypeLoader, "fileAccessTypeLoader is marked non-null but is null");
        Objects.requireNonNull(fileCategoryLoader, "fileCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(fileDataStreamer, "fileDataStreamer is marked non-null but is null");
        this.dmlAppserverService = dmlAppserverService;
        this.cacheService = cacheService;
        this.settingLoader = settingLoader;
        this.departmentAccessor = departmentAccessor;
        this.imageDownloader = imageDownloader;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.filterLoader = filterLoader;
        this.httpServletRequest = httpServletRequest;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.converterRegisterer = converterRegisterer;
        this.applicationContext = applicationContext;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.directoryLoader = directoryLoader;
        this.fileSearchLoader = fileSearchLoader;
        this.identifiedFileLoader = identifiedFileLoader;
        this.fileAccessTypeLoader = fileAccessTypeLoader;
        this.fileCategoryLoader = fileCategoryLoader;
        this.fileDataStreamer = fileDataStreamer;
    }
}

