/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import cz.kpsys.portaro.CompositeObjectUrlIdResolver;
import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.ExternalLogFields;
import cz.kpsys.portaro.FeatureNotEnabledException;
import cz.kpsys.portaro.FieldsNotResolvableException;
import cz.kpsys.portaro.alert.CompositeAlertProvider;
import cz.kpsys.portaro.alert.ExceptionedAlert;
import cz.kpsys.portaro.app.CatalogConstants;
import cz.kpsys.portaro.app.ssl.HttpsKeysSource;
import cz.kpsys.portaro.app.webutil.StartEventListener;
import cz.kpsys.portaro.appserver.AppserverAccessException;
import cz.kpsys.portaro.appserver.AppserverResponseParsingException;
import cz.kpsys.portaro.appserver.AppserverService;
import cz.kpsys.portaro.appserver.AppserverTransferException;
import cz.kpsys.portaro.appserver.GenericTableWriteSaver;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.MappingAppserverDmlAppserverService;
import cz.kpsys.portaro.appserver.dml.TableWriteGenerator;
import cz.kpsys.portaro.appserver.mapping.BasicMappingAppserverService;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.BadLoginCredentialsException;
import cz.kpsys.portaro.auth.InsufficientlyAuthenticatedException;
import cz.kpsys.portaro.auth.cas.CasAuthSettingKeys;
import cz.kpsys.portaro.auth.cas.CasTicketValidatorProtocol;
import cz.kpsys.portaro.auth.credreg.CredentialsRegistrationSettingKeys;
import cz.kpsys.portaro.auth.current.CurrentAuthProvider;
import cz.kpsys.portaro.auth.current.CurrentAuthWebResolver;
import cz.kpsys.portaro.auth.current.CurrentAuthWebResolverByHolder;
import cz.kpsys.portaro.auth.current.resolver.CompositeUserAuthenticationAuthenticationResolver;
import cz.kpsys.portaro.auth.current.resolver.UserAuthenticationAuthenticationResolver;
import cz.kpsys.portaro.auth.external.ExternalAuthenticationCancelException;
import cz.kpsys.portaro.auth.ezak.EzakAuthSettingKeys;
import cz.kpsys.portaro.auth.internal.InternalLoginCredentialsProperties;
import cz.kpsys.portaro.auth.ldap.LdapAuthSettingKeys;
import cz.kpsys.portaro.auth.multifactor.MultifactorAuthSettingKeys;
import cz.kpsys.portaro.auth.oauth2.authorizationcode.OAuth2AuthorizationCodeAuthSettingKeys;
import cz.kpsys.portaro.auth.openid.OpenIdAuthSettingKeys;
import cz.kpsys.portaro.auth.saml2.idp.Saml2IdentityProviderSettingKeys;
import cz.kpsys.portaro.auth.saml2.sp.Saml2ServiceProviderSettingKeys;
import cz.kpsys.portaro.auth.sidechannel.SideChannelAuthSettingKeys;
import cz.kpsys.portaro.commons.barcode.BarCodeType;
import cz.kpsys.portaro.commons.barcode.BarCodeValidator;
import cz.kpsys.portaro.commons.barcode.BarCodeValidatorByBarCodeTypeProvider;
import cz.kpsys.portaro.commons.barcode.Code39BarcodeValidator;
import cz.kpsys.portaro.commons.barcode.EanBarcodeValidator;
import cz.kpsys.portaro.commons.barcode.ItfBarcodeValidator;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.contextual.ContextIgnoringContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.TemporarilyCachedContextualProvider;
import cz.kpsys.portaro.commons.convert.ChainingConverter;
import cz.kpsys.portaro.commons.convert.ConversionTableConverter;
import cz.kpsys.portaro.commons.convert.EToEConverter;
import cz.kpsys.portaro.commons.convert.IdToObjectConverter;
import cz.kpsys.portaro.commons.convert.JsonToObjectConverter;
import cz.kpsys.portaro.commons.convert.ListToModifiedListConverter;
import cz.kpsys.portaro.commons.convert.LocaleToStringConverter;
import cz.kpsys.portaro.commons.convert.StringToAnyListConverter;
import cz.kpsys.portaro.commons.convert.StringToBooleanConverter;
import cz.kpsys.portaro.commons.convert.StringToDoubleConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerAnyMapConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerListConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerToAnyConverter;
import cz.kpsys.portaro.commons.convert.StringToLocaleConverter;
import cz.kpsys.portaro.commons.convert.StringToNotBlankStringConverter;
import cz.kpsys.portaro.commons.convert.StringToStringListConverter;
import cz.kpsys.portaro.commons.convert.StringToUuidConverter;
import cz.kpsys.portaro.commons.crypto.MessageCryptor;
import cz.kpsys.portaro.commons.date.DateRange;
import cz.kpsys.portaro.commons.date.DateRangeToBase64StringConverter;
import cz.kpsys.portaro.commons.date.DateToIsoStringConverter;
import cz.kpsys.portaro.commons.date.IsoStringToDateConverter;
import cz.kpsys.portaro.commons.date.IsoStringToInstantConverter;
import cz.kpsys.portaro.commons.io.FileZipper;
import cz.kpsys.portaro.commons.io.FileZipperImpl;
import cz.kpsys.portaro.commons.io.StringToFileConverter;
import cz.kpsys.portaro.commons.ip.CombinedIpAddressRange;
import cz.kpsys.portaro.commons.ip.EmptyIpAddressRange;
import cz.kpsys.portaro.commons.ip.IpAddressInRangeResolver;
import cz.kpsys.portaro.commons.ip.ListedIpAddressRange;
import cz.kpsys.portaro.commons.ip.StringToIpAddressConverter;
import cz.kpsys.portaro.commons.ip.StringToRozsahIpAdresConverter;
import cz.kpsys.portaro.commons.json.ByIntConverterJsonDeserializer;
import cz.kpsys.portaro.commons.json.ByStringConverterJsonDeserializer;
import cz.kpsys.portaro.commons.json.ConverterToStringJsonSerializer;
import cz.kpsys.portaro.commons.localization.CompositeUserFriendlyExceptionTextResolver;
import cz.kpsys.portaro.commons.localization.HierarchyTraversingTranslator;
import cz.kpsys.portaro.commons.localization.LocalizationId;
import cz.kpsys.portaro.commons.localization.MultiText;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.localization.TranslatorDelegatingMessageSource;
import cz.kpsys.portaro.commons.localization.UserFriendlyException;
import cz.kpsys.portaro.commons.localization.UserFriendlyExceptionTextResolver;
import cz.kpsys.portaro.commons.logging.Logged;
import cz.kpsys.portaro.commons.mail.AttachmentsZippingMailer;
import cz.kpsys.portaro.commons.mail.JavaMailSenderFactory;
import cz.kpsys.portaro.commons.mail.JavaMailSenderMailer;
import cz.kpsys.portaro.commons.mail.Mailer;
import cz.kpsys.portaro.commons.mail.SmtpTransportStrategy;
import cz.kpsys.portaro.commons.mail.ToDatabaseLoggingMailer;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.CachedProvider;
import cz.kpsys.portaro.commons.object.FallbackedProvider;
import cz.kpsys.portaro.commons.object.Labeled;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.ProviderByIdProvider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.commons.object.TimeGranularity;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.ConvertingCodebook;
import cz.kpsys.portaro.commons.object.repo.FilteringCodebook;
import cz.kpsys.portaro.commons.object.repo.ItemIsInUseModifyException;
import cz.kpsys.portaro.commons.object.repo.ItemNotFoundException;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.system.OsCheck;
import cz.kpsys.portaro.commons.system.PlatformUtils;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.commons.util.StringUtil;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.commons.web.CookieValueWebResolver;
import cz.kpsys.portaro.commons.web.HttpHeaderValueWebResolver;
import cz.kpsys.portaro.commons.web.ProvidedWebResolver;
import cz.kpsys.portaro.commons.web.WebResolver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.MvcAndJsonConverterRegisterer;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.conversation.ActionRequestUrlGenerator;
import cz.kpsys.portaro.core.application.PortaroVersion;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.department.DepartmentAccessorImpl;
import cz.kpsys.portaro.department.DepartmentEntity;
import cz.kpsys.portaro.department.EntityToDepartmentConverter;
import cz.kpsys.portaro.department.HierarchicalDepartmentLoaderByDepartmentLoader;
import cz.kpsys.portaro.department.RealRootDepartmentProvider;
import cz.kpsys.portaro.department.SpringDbDepartmentEntityLoader;
import cz.kpsys.portaro.department.StaticSystemInstitution;
import cz.kpsys.portaro.department.SystemInstitution;
import cz.kpsys.portaro.exemplar.ExemplarConstants;
import cz.kpsys.portaro.exemplar.ExemplarSettingKeys;
import cz.kpsys.portaro.ext.bakalari.BakalariSettingKeys;
import cz.kpsys.portaro.ext.edookit.EdookitSettingKeys;
import cz.kpsys.portaro.ext.edupage.EdupageSettingKeys;
import cz.kpsys.portaro.ext.ifis.IfisSettingKeys;
import cz.kpsys.portaro.ext.report.server.ReportServerSettingsKeys;
import cz.kpsys.portaro.ext.sol.SolSettingKeys;
import cz.kpsys.portaro.ext.synchronizer.SynchronizerSettingKeys;
import cz.kpsys.portaro.ext.unis.UnisSettingKeys;
import cz.kpsys.portaro.ext.unob.UnobSettingKeys;
import cz.kpsys.portaro.file.FileSettingKeys;
import cz.kpsys.portaro.form.editor2.ValueEditorType;
import cz.kpsys.portaro.form.editor2.bool.BooleanValueEditorType;
import cz.kpsys.portaro.form.editor2.date.DateValueEditorGranularity;
import cz.kpsys.portaro.form.editor2.text.TextValueEditorType;
import cz.kpsys.portaro.loan.LoanSettingKeys;
import cz.kpsys.portaro.localization.Localization;
import cz.kpsys.portaro.localization.LocalizationLoaderDelegatingLocalizationFormatsMapLoader;
import cz.kpsys.portaro.localization.LocalizationsSaver;
import cz.kpsys.portaro.localization.LocalizationsSaverAppserver;
import cz.kpsys.portaro.localization.LocalizedTextDeserializer;
import cz.kpsys.portaro.localization.LocalizingTextJsonSerializer;
import cz.kpsys.portaro.localization.SpringDbLocalizationLoader;
import cz.kpsys.portaro.logging.ActionSaver;
import cz.kpsys.portaro.logging.SpringDbActionSaver;
import cz.kpsys.portaro.mail.MailSendingTableWriteGenerator;
import cz.kpsys.portaro.ncip.NcipSettingKeys;
import cz.kpsys.portaro.oai.provider.impl.OaiSettingKeys;
import cz.kpsys.portaro.opening.StringToTimeRangeConverter;
import cz.kpsys.portaro.pops.agreement.AgreementStyle;
import cz.kpsys.portaro.record.comment.CommentStyle;
import cz.kpsys.portaro.record.export.RecordExportSettingKeys;
import cz.kpsys.portaro.record.link.SearchElsewhereItem;
import cz.kpsys.portaro.record.view.StringToFieldTypeFilterConverter;
import cz.kpsys.portaro.search.config.SearchLoaderBuilderFactory;
import cz.kpsys.portaro.search.sorting.StringToSortOrderConverter;
import cz.kpsys.portaro.security.NotLoggedInException;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.security.appserver.UserAddingAppserverService;
import cz.kpsys.portaro.setting.AllBySectionsLoader;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.DefaultSettingLoader;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.setting.SettingTypeDto;
import cz.kpsys.portaro.setting.SettingsRepo;
import cz.kpsys.portaro.shutdown.ApplicationRestarter;
import cz.kpsys.portaro.shutdown.ApplicationRestarterByShutdown;
import cz.kpsys.portaro.shutdown.ApplicationShutdowner;
import cz.kpsys.portaro.shutdown.ApplicationShutdownerByContextInterruptAndSystemExit;
import cz.kpsys.portaro.shutdown.RestartingPolicy;
import cz.kpsys.portaro.sip2.Sip2SettingKeys;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.JsonOnlyForRolePropertyFilter;
import cz.kpsys.portaro.user.UserSettingKeys;
import cz.kpsys.portaro.user.edit.form.IllegalFormSettingsException;
import cz.kpsys.portaro.user.payment.provider.PaymentProviderSettingKeys;
import cz.kpsys.portaro.user.payment.provider.csobgw.CsobGwSettingKeys;
import cz.kpsys.portaro.user.payment.provider.manual.ManualPaymentProviderSettingKeys;
import cz.kpsys.portaro.user.role.reader.PrintType;
import cz.kpsys.portaro.user.sec.PermissionRegistrySecurityManager;
import cz.kpsys.portaro.verbisboxer.manager.VerbisboxerManagerApiSettingKeys;
import cz.kpsys.portaro.view.web.CatalogWebSettingsKeys;
import cz.kpsys.portaro.view.web.currentdepartment.CompositeCurrentDepartmentWebResolver;
import cz.kpsys.portaro.view.web.currentdepartment.CookieCurrentDepartmentSaver;
import cz.kpsys.portaro.view.web.currentdepartment.CurrentDepartmentProvider;
import cz.kpsys.portaro.view.web.currentdepartment.CurrentDepartmentSaver;
import cz.kpsys.portaro.view.web.currentdepartment.RequestUrlCurrentDepartmentWebResolver;
import cz.kpsys.portaro.view.web.ratelimit.RateLimitExceededException;
import cz.kpsys.portaro.view.web.rest.LocalizationRequest;
import cz.kpsys.portaro.view.web.rest.LocalizationRequestToLocalizationConverter;
import cz.kpsys.portaro.view.web.rest.LocalizationResponse;
import cz.kpsys.portaro.view.web.rest.LocalizationToLocalizationResponse;
import cz.kpsys.portaro.view.web.rest.LocalizationsApiController;
import cz.kpsys.portaro.web.CurrentDepartmentServerUrlProvidingUrlWebResolver;
import cz.kpsys.portaro.web.UrlWebResolver;
import cz.kpsys.portaro.web.exception.CompositeExceptionHttpStatusResolver;
import cz.kpsys.portaro.web.locale.CompositeLocaleResolver;
import cz.kpsys.portaro.web.locale.CookieOptionalLocaleResolver;
import cz.kpsys.portaro.web.locale.LocaleSetter;
import cz.kpsys.portaro.web.locale.OptionalLocaleResolver;
import cz.kpsys.portaro.web.locale.ProvidedOptionalLocaleResolver;
import cz.kpsys.portaro.web.locale.RequestAttributeOptionalLocaleResolver;
import cz.kpsys.portaro.web.locale.RequestHeaderOptionalLocaleResolver;
import cz.kpsys.portaro.web.locale.RequestUrlParameterOptionalLocaleResolver;
import cz.kpsys.portaro.web.server.ServerUrlConfiguration;
import cz.kpsys.portaro.web.server.ServerUrlToPublicContextPathConverter;
import jakarta.persistence.EntityManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolationException;
import java.beans.ConstructorProperties;
import java.io.File;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.HttpStatus;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.LocaleResolver;

@Configuration
public class CoreConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoreConfig.class);
    @Value(value="${portaro.rootDepartment}")
    private int rootDepartment;
    @NonNull
    private final @NonNull Provider<@NonNull Integer> realRootDepartmentIdProvider;
    @NonNull
    private final PortaroVersion portaroVersion;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final AllBySectionsLoader<CustomSetting<String>> envVariablesAwareCustomSettingLoader;
    @NonNull
    private final AllBySectionsLoader<SettingTypeDto<String>> settingTypeLoader;
    @NonNull
    private final AppserverService authorizedAppserverService;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final CompositeAlertProvider alertProvider;
    @NonNull
    private final ConfigurableApplicationContext context;
    @NonNull
    private final ExternalLogFields externalLogFields;
    @NonNull
    private final HttpServletRequest httpServletRequest;
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerExternalLogField() {
        this.externalLogFields.setStartedPhase();
        this.externalLogFields.setPortaroUrl((String)this.rootServerUrlProvider().get());
        this.externalLogFields.setSerialCode((String)this.settingLoader().getOnRootProvider(SettingKeys.SERIAL_CODE).get());
        this.externalLogFields.setLibraryName((String)this.settingLoader().getOnRootProvider(SettingKeys.LIBRARY_NAME).get());
        this.externalLogFields.setLibraryCity((String)this.settingLoader().getOnRootProvider(SettingKeys.LIBRARY_CITY).get());
    }

    @Logged
    @Scheduled(cron="0 20 4 * * *")
    public void restartOrRefreshSystem() {
        RestartingPolicy when;
        try {
            when = (RestartingPolicy)this.settingLoader().getOnRoot(SettingKeys.PERIODIAL_RESTARTING);
        }
        catch (Exception e) {
            log.error("Cannot resolve periodical restarting policy, fallback to {}", (Object)RestartingPolicy.ALWAYS_IF_WINDOWS, (Object)e);
            when = RestartingPolicy.ALWAYS_IF_WINDOWS;
        }
        if (when == RestartingPolicy.ALWAYS || when == RestartingPolicy.ALWAYS_IF_WINDOWS && PlatformUtils.getOperatingSystemType() == OsCheck.OSType.WINDOWS) {
            this.applicationRestarter().restart();
        } else {
            this.cacheService.invalidateAllCaches();
        }
    }

    @Bean(destroyMethod="")
    public ApplicationShutdowner applicationShutdowner() {
        return new ApplicationShutdownerByContextInterruptAndSystemExit(this.context);
    }

    @Bean
    public ApplicationRestarter applicationRestarter() {
        return new ApplicationRestarterByShutdown(this.applicationShutdowner());
    }

    @Bean
    public String contextPath() {
        return "";
    }

    @Bean
    public UserFriendlyExceptionTextResolver userFriendlyExceptionTextResolver() {
        CompositeUserFriendlyExceptionTextResolver resolver = new CompositeUserFriendlyExceptionTextResolver();
        return resolver.with(EmptyResultDataAccessException.class, e -> Texts.ofMessageCoded((String)"commons.NotFound")).with(AccessDeniedException.class, e -> Texts.ofMessageCoded((String)"commons.AccessDenied")).with(UserFriendlyException.class, Labeled::getText).with(ItemIsInUseModifyException.class, e -> Texts.ofMessageCoded((String)"commons.NelzeSmazatPolozkaJePouzivana")).with(BadSqlGrammarException.class, e -> Texts.ofMessageCoded((String)"commons.DataLoadError")).with(AppserverAccessException.class, e -> Texts.ofMessageCoded((String)"commons.DataLoadError")).with(ResourceAccessException.class, e -> Texts.ofMessageCoded((String)"commons.DataLoadError")).with(AppserverResponseParsingException.class, e -> Texts.ofMessageCoded((String)"commons.DataLoadError")).with(AppserverTransferException.class, e -> Texts.ofMessageCoded((String)"commons.DataLoadError")).with(IllegalFormSettingsException.class, e -> Texts.ofArgumentedMessageCoded((String)"error.illegalFormSettings", (Object[])new Object[]{e.getMessage()})).with(ConstraintViolationException.class, e -> {
            List texts = ListUtil.convert((Iterable)e.getConstraintViolations(), constraintViolation -> MultiText.ofTexts((String)"{}: {}", (Text[])new Text[]{Texts.ofNative((String)constraintViolation.getPropertyPath().toString()), Texts.ofCurlyBracesFormat((String)constraintViolation.getMessageTemplate())}));
            return MultiText.ofTexts((List)texts).withDelimiter(", ");
        }).withUnwrap(MethodArgumentTypeMismatchException.class).withUnwrap(ConversionFailedException.class);
    }

    @Bean
    public CompositeExceptionHttpStatusResolver exceptionHttpStatusResolver() {
        return new CompositeExceptionHttpStatusResolver().with(NotLoggedInException.class, HttpStatus.UNAUTHORIZED).with(InsufficientlyAuthenticatedException.class, HttpStatus.FORBIDDEN).with(InsufficientAuthenticationException.class, HttpStatus.FORBIDDEN).with(ExternalAuthenticationCancelException.class, HttpStatus.BAD_REQUEST).with(cz.kpsys.portaro.security.AccessDeniedException.class, HttpStatus.FORBIDDEN).with(AccessDeniedException.class, HttpStatus.FORBIDDEN).with(FieldsNotResolvableException.class, HttpStatus.BAD_REQUEST).with(MethodArgumentNotValidException.class, HttpStatus.BAD_REQUEST).with(ConstraintViolationException.class, HttpStatus.BAD_REQUEST).with(BadLoginCredentialsException.class, HttpStatus.BAD_REQUEST).with(EmptyResultDataAccessException.class, HttpStatus.NOT_FOUND).with(ItemNotFoundException.class, HttpStatus.NOT_FOUND).with(MethodArgumentTypeMismatchException.class, HttpStatus.NOT_FOUND).with(HttpRequestMethodNotSupportedException.class, HttpStatus.NOT_FOUND).with(RateLimitExceededException.class, HttpStatus.TOO_MANY_REQUESTS).with(FeatureNotEnabledException.class, HttpStatus.FORBIDDEN);
    }

    @Bean
    public LocalizationsApiController localizationsApiController() {
        return new LocalizationsApiController(this.localizationLoader(), this.localizationsSaver(), this.settingLoader().getOnRootProvidedList(SettingKeys.ENABLED_LOCALES), this.localizationRequestToLocalizationConverter(), this.localizationToLocalizationResponseConverter(), this.stringToLocaleConverter(), this.securityManager());
    }

    @Bean
    public Converter<LocalizationRequest, Localization> localizationRequestToLocalizationConverter() {
        return new LocalizationRequestToLocalizationConverter();
    }

    @Bean
    public Converter<Localization, LocalizationResponse> localizationToLocalizationResponseConverter() {
        return new LocalizationToLocalizationResponse();
    }

    @Bean
    public LocaleResolver portaroLocaleResolver() {
        LocaleToStringConverter localeToStringConverter = new LocaleToStringConverter();
        StringToLocaleConverter stringToLocaleConverter = new StringToLocaleConverter();
        return new CompositeLocaleResolver().with((OptionalLocaleResolver)new RequestAttributeOptionalLocaleResolver()).with((OptionalLocaleResolver)new RequestUrlParameterOptionalLocaleResolver("locale", (Converter)stringToLocaleConverter)).with((OptionalLocaleResolver)new CookieOptionalLocaleResolver("cz.kpsys.portaro.locale", (Converter)stringToLocaleConverter, (Converter)localeToStringConverter)).with((OptionalLocaleResolver)new RequestHeaderOptionalLocaleResolver()).with((OptionalLocaleResolver)new ProvidedOptionalLocaleResolver(this.settingLoader().getOnRootProvider(CoreSettingKeys.DEFAULT_LOCALE))).withSetter((LocaleSetter)new CookieOptionalLocaleResolver("cz.kpsys.portaro.locale", (Converter)stringToLocaleConverter, (Converter)localeToStringConverter));
    }

    @Bean
    public WebResolver<Locale> localeWebResolver() {
        return request -> Optional.of(this.portaroLocaleResolver().resolveLocale(request));
    }

    @Bean
    public FormattingConversionService conversionService() {
        DefaultFormattingConversionService bean = new DefaultFormattingConversionService();
        IdToObjectConverter integerToDepartmentConverter = new IdToObjectConverter((ByIdLoadable)this.departmentLoader());
        IdToObjectConverter integerToPrintTypeConverter = new IdToObjectConverter((ByIdLoadable)PrintType.CODEBOOK);
        IdToObjectConverter integerToTimeGranularityConverter = new IdToObjectConverter((ByIdLoadable)TimeGranularity.CODEBOOK);
        bean.addConverter(Integer.class, Department.class, (Converter)integerToDepartmentConverter);
        bean.addConverter(Integer.class, PrintType.class, (Converter)integerToPrintTypeConverter);
        bean.addConverter(Integer.class, TimeGranularity.class, (Converter)integerToTimeGranularityConverter);
        bean.addConverter(String.class, Boolean.class, (Converter)StringToBooleanConverter.returningNullWhenNullSource());
        bean.addConverter(String.class, File.class, (Converter)new StringToFileConverter());
        bean.addConverter(String.class, PrintType.class, (Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)integerToPrintTypeConverter));
        bean.addConverter(String.class, Department.class, (Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)integerToDepartmentConverter));
        bean.addConverter(String.class, TimeGranularity.class, (Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)integerToTimeGranularityConverter));
        bean.addConverter(String.class, Date.class, (Converter)new IsoStringToDateConverter());
        bean.addConverter(String.class, Instant.class, (Converter)new IsoStringToInstantConverter());
        bean.addConverter(Date.class, String.class, (Converter)new DateToIsoStringConverter());
        bean.addConverter(DateRange.class, String.class, (Converter)new DateRangeToBase64StringConverter(this.objectMapper));
        return bean;
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public ConverterRegisterer converterRegisterer() {
        return new MvcAndJsonConverterRegisterer((FormatterRegistry)this.conversionService(), this.objectMapperModule());
    }

    @Bean
    public SimpleModule objectMapperModule() {
        SimpleModule objectMapperModule = new SimpleModule("GlobalMapperModule");
        objectMapperModule.addSerializer(Text.class, (JsonSerializer)new LocalizingTextJsonSerializer(this.translator(), this.localeWebResolver(), this.currentDepartmentWebResolver(), this.httpServletRequest)).addSerializer(TextValueEditorType.class, (JsonSerializer)new ConverterToStringJsonSerializer(TextValueEditorType.class, TextValueEditorType.TO_JSON_CONVERTER)).addSerializer(DateValueEditorGranularity.class, (JsonSerializer)new ConverterToStringJsonSerializer(DateValueEditorGranularity.class, DateValueEditorGranularity.TO_JSON_CONVERTER)).addSerializer(BooleanValueEditorType.class, (JsonSerializer)new ConverterToStringJsonSerializer(BooleanValueEditorType.class, BooleanValueEditorType.TO_JSON_CONVERTER)).addSerializer(ValueEditorType.class, (JsonSerializer)new ConverterToStringJsonSerializer(ValueEditorType.class, ValueEditorType.TO_JSON_CONVERTER)).addDeserializer(File.class, (JsonDeserializer)new ByStringConverterJsonDeserializer(File.class, (Converter)new StringToFileConverter())).addDeserializer(Text.class, (JsonDeserializer)new LocalizedTextDeserializer()).addDeserializer(TimeGranularity.class, (JsonDeserializer)new ByIntConverterJsonDeserializer(TimeGranularity.class, (Converter)new IdToObjectConverter((ByIdLoadable)TimeGranularity.CODEBOOK))).addDeserializer(Department.class, (JsonDeserializer)new ByIntConverterJsonDeserializer(Department.class, (Converter)new IdToObjectConverter((ByIdLoadable)this.departmentLoader()))).addDeserializer(PrintType.class, (JsonDeserializer)new ByIntConverterJsonDeserializer(PrintType.class, (Converter)new IdToObjectConverter((ByIdLoadable)PrintType.CODEBOOK)));
        this.objectMapper.registerModule((Module)objectMapperModule);
        return objectMapperModule;
    }

    @Bean
    public CompositeUserAuthenticationAuthenticationResolver compositeUserAuthenticationAuthenticationResolver() {
        return new CompositeUserAuthenticationAuthenticationResolver();
    }

    @Bean
    public AuthenticationHolder authenticationHolder() {
        AuthenticationHolder authenticationHolder = new AuthenticationHolder((UserAuthenticationAuthenticationResolver)this.compositeUserAuthenticationAuthenticationResolver());
        this.objectMapper.setFilterProvider((FilterProvider)new SimpleFilterProvider().addFilter("jsonOnlyForRoleFilter", (PropertyFilter)new JsonOnlyForRolePropertyFilter(authenticationHolder)));
        authenticationHolder.addOnEvidedSuccessListener(authentication -> this.applicationEventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent((Authentication)authentication, AuthenticationHolder.class)));
        return authenticationHolder;
    }

    @Bean
    public CurrentAuthWebResolver currentAuthWebResolver() {
        return new CurrentAuthWebResolverByHolder((CurrentAuthProvider)this.authenticationHolder());
    }

    @Bean
    public Codebook<DepartmentEntity, Integer> departmentEntityLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbDepartmentEntityLoader(this.jdbcTemplate, this.queryFactory)).staticCached(Department.class.getSimpleName()).build();
    }

    @Bean
    public Codebook<Department, Integer> departmentLoader() {
        FilteringCodebook notDeletedCodebook = FilteringCodebook.filteredGetAllOnly((Codebook)this.departmentEntityLoader(), departmentEntity -> departmentEntity.getDeletionEventId() == null);
        ListToModifiedListConverter entitiesToModelsConverter = new ListToModifiedListConverter((Converter)new EntityToDepartmentConverter());
        return new ConvertingCodebook((Codebook)notDeletedCodebook, (Converter)entitiesToModelsConverter);
    }

    @Bean
    public DepartmentAccessor departmentAccessor() {
        return new DepartmentAccessorImpl(this.departmentLoader(), this.hierachicalDepartmentLoader());
    }

    @Bean
    public HierarchicalDepartmentLoaderByDepartmentLoader hierachicalDepartmentLoader() {
        return new HierarchicalDepartmentLoaderByDepartmentLoader(this.departmentLoader());
    }

    @Bean
    public Provider<@NonNull Integer> rootDepartmentIdProvider() {
        if (this.rootDepartment != -1) {
            return StaticProvider.of((Object)this.rootDepartment);
        }
        return this.realRootDepartmentIdProvider;
    }

    @Bean
    public Provider<@NonNull Department> rootDepartmentProvider() {
        return ProviderByIdProvider.of((ByIdLoadable)this.departmentLoader(), (Provider)this.rootDepartmentIdProvider()).withDefaultSupport(this.realRootDepartmentProvider(), (Object[])new Integer[]{-1});
    }

    @Bean
    public Provider<@NonNull Department> realRootDepartmentProvider() {
        return new RealRootDepartmentProvider((AllValuesProvider)this.departmentLoader());
    }

    @Bean
    public Provider<@NullableNotBlank String> rootServerUrlProvider() {
        return this.settingLoader().getOnRootProvider(SettingKeys.SERVER_URL);
    }

    @Bean
    public ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider() {
        return this.settingLoader().getDepartmentedProvider(SettingKeys.SERVER_URL);
    }

    @Bean
    public Provider<@NonNull String> rootSerialCodeProvider() {
        return this.settingLoader().getOnRootProvider(SettingKeys.SERIAL_CODE);
    }

    @Bean
    public ContextualProvider<Department, @NonNull String> serialCodeProvider() {
        return this.settingLoader().getDepartmentedProvider(SettingKeys.SERIAL_CODE);
    }

    @Bean
    public SettingLoader settingLoader() {
        DefaultSettingLoader bean = new DefaultSettingLoader((ByIdLoadable)this.departmentLoader(), this.rootDepartmentProvider(), this.realRootDepartmentProvider(), new SettingsRepo((ByIdLoadable)this.departmentLoader()), this.settingTypeLoader, this.envVariablesAwareCustomSettingLoader);
        this.alertProvider.withProvider(() -> bean.getLastReloadExceptions().stream().map(e -> new ExceptionedAlert(e.getText(), "DANGER", (Throwable)e)).collect(Collectors.toUnmodifiableList()));
        this.cacheService.registerCleaner((CacheCleaner)bean);
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SERVER_URL, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.PERIODIAL_RESTARTING, (Converter)new ConversionTableConverter(RestartingPolicy.CONVERSION_TABLE));
        bean.registerKeyThrowingWhenNullSource(SettingKeys.FORCE_HTTPS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SERVER_REVERSE_PROXY, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SERVER_LISTEN_IP, (Converter)new StringToIpAddressConverter());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.INTERNAL_IP_ADDRESS_RANGE, (Converter)new StringToRozsahIpAdresConverter(), EmptyIpAddressRange::new);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.INTERNAL_IP_ADDRESSES, (Converter)StringToAnyListConverter.create((Converter)new StringToIpAddressConverter()), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.EXTERNAL_IP_ADDRESSES, (Converter)StringToAnyListConverter.create((Converter)new StringToIpAddressConverter()), List::of);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.ACME_AUTO, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.ACME_CERTIFICATE_LOCATION, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.ACME_PRIVATE_KEY_LOCATION, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.ACME_CHALLENGE_KEY, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.INTERNAL_HTTPS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.INTERNAL_HTTPS_PORT, (Converter)new StringToIntegerConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.INTERNAL_HTTPS_KEYS_SOURCE, (Converter)new ConversionTableConverter(HttpsKeysSource.CONVERSION_TABLE));
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.INTERNAL_HTTPS_CERTIFICATE_LOCATION, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.INTERNAL_HTTPS_CA_CERTIFICATE_LOCATION, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.INTERNAL_HTTPS_PRIVATE_KEY_LOCATION, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.INTERNAL_HTTPS_PRIVATE_KEY_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.INTERNAL_HTTPS_KEYSTORE_LOCATION, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.INTERNAL_HTTPS_KEYSTORE_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.INTERNAL_HTTPS_KEYSTORE_KEY_ALIAS, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.ENABLED_LOCALES, (Converter)StringToAnyListConverter.create((Converter)new StringToLocaleConverter()));
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.FORBIDDEN_MENU_ITEMS, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.BUILT_IN_COVERS_BY_FONDS, (Converter)new StringToIntegerAnyMapConverter((Converter)new EToEConverter()), Map::of);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.CAMERA_SCANNER_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.APPSERVER_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SERIAL_CODE, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.KPSYS_API_KEY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LICENCE_KEY, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.CENTRAL_INDEX_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.SERVICES, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.DEPARTMENT_CREATION_ACCEPTABLE_PARENT_DEPARTMENTS_SHOW_ALL_CHILDS, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.DEPARTMENT_CREATION_ACCEPTABLE_PARENT_DEPARTMENTS, (Converter)new StringToIntegerListConverter(), List::of);
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LIBRARY_NAME, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LIBRARY_STREET, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LIBRARY_POSTAL_CODE, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LIBRARY_CITY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LIBRARY_EMAIL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.LIBRARY_PHONE_NUMBER, (Converter)new EToEConverter());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.LIBRARY_OPENING_MONDAY, (Converter)StringToAnyListConverter.create((Converter)new StringToTimeRangeConverter(), (String)","), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.LIBRARY_OPENING_TUESDAY, (Converter)StringToAnyListConverter.create((Converter)new StringToTimeRangeConverter(), (String)","), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.LIBRARY_OPENING_WEDNESDAY, (Converter)StringToAnyListConverter.create((Converter)new StringToTimeRangeConverter(), (String)","), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.LIBRARY_OPENING_THURSDAY, (Converter)StringToAnyListConverter.create((Converter)new StringToTimeRangeConverter(), (String)","), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.LIBRARY_OPENING_FRIDAY, (Converter)StringToAnyListConverter.create((Converter)new StringToTimeRangeConverter(), (String)","), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.LIBRARY_OPENING_SATURDAY, (Converter)StringToAnyListConverter.create((Converter)new StringToTimeRangeConverter(), (String)","), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.LIBRARY_OPENING_SUNDAY, (Converter)StringToAnyListConverter.create((Converter)new StringToTimeRangeConverter(), (String)","), List::of);
        bean.registerKeyThrowingWhenNullSource(CoreSettingKeys.DEFAULT_LOCALE, (Converter)new StringToLocaleConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SMTP_USE_SENDER_AND_FROM, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_FROM_LIBRARY_MAILS_REPLY_TO_ADDRESS, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SMTP_TRANSPORT_STRATEGY, (Converter)new ConversionTableConverter(SmtpTransportStrategy.CONVERSION_TABLE));
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SMTP_AUTHENTICATION_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_SENDER_ADDRESS, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_SENDER_NAME, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_SERVER_ADDRESS, (Converter)new EToEConverter());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.SMTP_SERVER_PORT, (Converter)new StringToIntegerConverter(), () -> 25);
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_SERVER_USERNAME, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SMTP_SERVER_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SMS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.USER_INTERNAL_LOGIN_CREDENTIALS_PROPERTIES, (Converter)new ChainingConverter((Converter)new StringToStringListConverter(",;").ignoring("-"), (Converter)new ListToModifiedListConverter(InternalLoginCredentialsProperties::parse)), List::of);
        bean.registerKeyThrowingWhenNullSource(CasAuthSettingKeys.CAS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(CasAuthSettingKeys.CAS_SYSTEM_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(CasAuthSettingKeys.CAS_LOGIN_URL, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(CasAuthSettingKeys.CAS_TICKET_VALIDATOR_PROTOCOL, (Converter)new ConversionTableConverter(CasTicketValidatorProtocol.CONVERSION_TABLE));
        bean.registerKeyThrowingWhenNullSource(CasAuthSettingKeys.CAS_USER_IDENTIFIER, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(CasAuthSettingKeys.CAS_USER_ASSERTION_ATTRIBUTE, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(EzakAuthSettingKeys.EZAK_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(EzakAuthSettingKeys.EZAK_SYSTEM_URL, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(LdapAuthSettingKeys.LDAP_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(LdapAuthSettingKeys.LDAP_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(LdapAuthSettingKeys.LDAP_USER_SEARCH_FILTER_TEMPLATE, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(LdapAuthSettingKeys.LDAP_BASE_DNS, (Converter)new StringToStringListConverter(";"));
        bean.registerKeyThrowingWhenNullSource(LdapAuthSettingKeys.LDAP_CERTIFICATE_VERIFICATION_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(LdapAuthSettingKeys.LDAP_CONTEXT_CONNECT_USER_DN, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(LdapAuthSettingKeys.LDAP_CONTEXT_CONNECT_USER_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(OpenIdAuthSettingKeys.MOJE_ID_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(MultifactorAuthSettingKeys.SECOND_FACTOR_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SideChannelAuthSettingKeys.EMAIL_AUTH_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SideChannelAuthSettingKeys.EMAIL_AUTH_TESTING_MODE, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(OAuth2AuthorizationCodeAuthSettingKeys.GOOGLE_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(OAuth2AuthorizationCodeAuthSettingKeys.GOOGLE_CLIENT_ID, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(OAuth2AuthorizationCodeAuthSettingKeys.GOOGLE_CLIENT_SECRET, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(OAuth2AuthorizationCodeAuthSettingKeys.FACEBOOK_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(OAuth2AuthorizationCodeAuthSettingKeys.FACEBOOK_CLIENT_ID, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(OAuth2AuthorizationCodeAuthSettingKeys.FACEBOOK_CLIENT_SECRET, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(Saml2IdentityProviderSettingKeys.SAML2_IDENTITY_PROVIDER_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(Saml2IdentityProviderSettingKeys.SAML2_IDENTITY_PROVIDER_ENTITY_ID, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(Saml2IdentityProviderSettingKeys.SAML2_IDENTITY_PROVIDER_ATTRIBUTES_CONFIRMATION_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(Saml2IdentityProviderSettingKeys.SAML2_IDENTITY_PROVIDER_AUTH_REQUEST_SIGNATURE_REQUIRED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(Saml2IdentityProviderSettingKeys.SAML2_IDENTITY_PROVIDER_CONTACT_PERSON_ID, (Converter)new StringToIntegerConverter());
        bean.registerKeyReturningNullWhenNullSource(Saml2IdentityProviderSettingKeys.SAML2_IDENTITY_PROVIDER_SCOPE_DOMAIN, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(Saml2IdentityProviderSettingKeys.SAML2_IDENTITY_PROVIDER_EDUGAIN_REGISTRATION_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(Saml2IdentityProviderSettingKeys.SAML2_IDENTITY_PROVIDER_USER_LIBRARY_ID_USER_IDENTIFIER, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(Saml2ServiceProviderSettingKeys.SAML2_SERVICE_PROVIDER_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(Saml2ServiceProviderSettingKeys.SAML2_SERVICE_PROVIDER_IDP_ENTITY_ID, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(Saml2ServiceProviderSettingKeys.SAML2_SERVICE_PROVIDER_IDP_SSO_LOCATION, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(Saml2ServiceProviderSettingKeys.SAML2_SERVICE_PROVIDER_IDP_CERTIFICATE, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(Saml2ServiceProviderSettingKeys.SAML2_SERVICE_PROVIDER_USER_IDENTIFYING_ATTRIBUTE_NAME, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.USER_MAIL_ACTIVATION_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.USER_REQUIRED_FIELDS, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.USER_REQUIRED_FIELDS_FOR_LIBRARIAN, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.USER_SELF_CREATION_FIELDS, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.USER_SELF_CREATION_FIELDS_BY_CATEGORY, (Converter)new JsonToObjectConverter((TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.USER_SELF_EDITATION_FIELDS, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.READER_EDITABLE_FIELDS_BY_EDITOR, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyThrowingWhenNullSource(CredentialsRegistrationSettingKeys.USER_CREDENTIALS_REGISTRATION_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningValueWhenNullSource(CredentialsRegistrationSettingKeys.USER_CREDENTIALS_REGISTRATION_IDENTIFIER_PROPS, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyThrowingWhenNullSource(UserSettingKeys.USER_PASSWORD_REGEX, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(UserSettingKeys.USER_BARCODE_CORE_MAX_LENGTH, (Converter)new StringToIntegerConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.MONEY_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.FULL_REGISTRATION_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.FORGOTTEN_CREDENTIALS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningValueWhenNullSource(OpenIdAuthSettingKeys.MOJE_ID_REQUIRED_PROPS, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyReturningValueWhenNullSource(OpenIdAuthSettingKeys.MOJE_ID_TRUSTED_PROPS, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DEFAULT_BY_READER_FULL_REGISTRATION_READER_CATEGORY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DEFAULT_EDITOR_ACCOUNT_GROUP, (Converter)new StringToIntegerConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SHOW_USER_REGISTRATION_AGREEMENT_PRINT_BUTTON, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SHOW_USER_RECEIPT_OF_PAYMENT_PRINT_BUTTON, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SHOW_USER_PREFERENCES_BUTTON, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.READER_SELF_REGISTRATION_EXTEND_FOR_ALL_USERS, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.AUTOGENERATE_USER_CARD_NUMBER, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.AUTOGENERATE_USER_BARCODE, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningValueWhenNullSource(UserSettingKeys.USER_BARCODE_PREFIX, (Converter)new EToEConverter(), () -> "");
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.READER_SELF_REGISTRATION_EXTEND_READER_CATEGORIES, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SHOW_TERMS_AND_CONDITIONS_IF_EXTENDING_REGISTRATION, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SHOW_USER_STATEMENT_IF_EXTENDING_REGISTRATION, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.REGISTRATION_PERIOD_EXTENSION_THRESHOLD_DAYS, (Converter)new StringToIntegerConverter());
        bean.registerKeyThrowingWhenNullSource(UserSettingKeys.EMPLOYEE_READER_CATEGORIES, (Converter)new StringToStringListConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.USER_BARCODE_TYPES, (Converter)StringToAnyListConverter.create((Converter)new ConversionTableConverter(BarCodeType.CONVERSION_TABLE)));
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.FORBIDDEN_RECORDS, StringToUuidConverter.DELIMITED_LIST_CONVERTER, List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.FORBIDDEN_RECORD_STATUSES, (Converter)new StringToIntegerListConverter(), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.AUTHORITY_FONDS, (Converter)new StringToIntegerListConverter(), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.DOCUMENT_FONDS, (Converter)new StringToIntegerListConverter(), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.BUILDINGS_DEFAULT, (Converter)new StringToIntegerListConverter(), List::of);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.RECORD_MARC_TAB_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.AUTHORITY_DETAIL_TAB_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.DOCUMENT_DETAIL_TAB_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.DOCUMENT_EXEMPLARS_TAB_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SHOW_ALL_RECORD_FIELDS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.ONLY_USED_AUTHORITIES_SHOW_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.AUTHORITY_TEMPLATE, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DOCUMENT_UNDER_COVER_TEMPLATE, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DOCUMENT_NEXT_TO_HEADER_TEMPLATE, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DOCUMENT_NEXT_TO_COVER_TEMPLATE, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SIMILAR_DOCUMENTS_LIMIT, (Converter)new StringToIntegerConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.AUTHORITY_HIERARCHY_ROOT, (Converter)StringToUuidConverter.INSTANCE);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.CITATION_SERVICE, (Converter)new EToEConverter());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.CITATION_DOCTYPES_BY_FONDS, (Converter)new StringToIntegerAnyMapConverter((Converter)new EToEConverter()), Map::of);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.COMMENT_STYLE, (Converter)new ConversionTableConverter(CommentStyle.CONVERSION_TABLE));
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SEARCH_ELSEWHERE_ITEMS, SearchElsewhereItem.createConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.DOCUMENT_DETAIL_FIELDS_FILTER, (Converter)new StringToFieldTypeFilterConverter());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.RECORD_DETAIL_FIELDS_FILTERS_BY_FONDS, (Converter)new StringToIntegerAnyMapConverter((Converter)new StringToFieldTypeFilterConverter()), Map::of);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SHOW_EDITED_INDICATORS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SHOW_EDITED_FIELD_IDENTIFIERS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.PUBLISHING_DOCUMENT_FINISHED_CATALOGIZATION, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.DOCUMENT_ARTICLES_TAB_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.DOCUMENT_PARTS_CONTAINING_FIELD_NUMBERS, (Converter)new StringToIntegerListConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.RATING_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.NEWS_SLIDER_BUILDINGS, (Converter)new StringToIntegerListConverter(), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.NEWS_EXEMPLAR_STATUSES, (Converter)new StringToIntegerListConverter(), List::of);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.NEWS_WITH_COVER_PREFERING_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.MOST_LENT_DOCUMENTS_WITH_PERIODICALS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.GLOBAL_SEARCH_TEMPLATE_1, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SEARCH_DOCUMENT_TEMPLATE, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SEARCH_DOCUMENT_MORE_TEMPLATE, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.NEWS_TEMPLATE, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.SEARCH_AUTHORITY_TEMPLATE, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.AUTHORITY_GLOBAL_SEARCH_QUERY_TEMPLATE, (Converter)new EToEConverter());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.AUTHORITY_INDEX_PREFIXES_BY_FONDS, (Converter)new StringToIntegerAnyMapConverter((Converter)new EToEConverter()), Map::of);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.BASIC_MODE_SEARCH_FIELDS_COUNT, (Converter)new StringToIntegerConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.FORM_SEARCH_FIELDS, (Converter)new StringToStringListConverter().throwOnBlankItems());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.DOCUMENT_SEARCH_PAGE_SIZE, (Converter)new StringToIntegerConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.AUTHORITY_SEARCH_PAGE_SIZE, (Converter)new StringToIntegerConverter());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.FACETS, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.DEFAULT_EXPANDED_FACETS, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.FACET_KEYS_MAX_COUNT, (Converter)new StringToIntegerConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DOCUMENT_MIN_YEAR, (Converter)new StringToIntegerConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.NEWS_SLIDER_PRESEARCHED_COUNT, (Converter)new StringToIntegerConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.NEWS_SLIDER_SHOWED_COUNT, (Converter)new StringToIntegerConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.NEWS_SEARCH_MAX_AGE, (Converter)new StringToIntegerConverter());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.DOCUMENT_SEARCH_SORTINGS, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.AUTHORITY_SEARCH_SORTINGS, (Converter)new StringToStringListConverter(), List::of);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.ENABLED_LOCAL_DATASETS, (Converter)new StringToStringListConverter().throwOnBlankItems());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SHOW_ALL_ZSERVERS, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.ENABLED_ZSERVERS, (Converter)new StringToIntegerListConverter());
        bean.registerKeyThrowingWhenNullSource(RecordExportSettingKeys.ATTACHMENTS_IN_MARC_EXPORT_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.GLOBAL_SEARCH_INPUT_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.FORBIDDEN_EXEMPLARS, (Converter)new StringToIntegerListConverter(), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.EXEMPLAR_STATUSES, (Converter)new StringToIntegerListConverter(), List::of);
        bean.registerKeyReturningValueWhenNullSource(ExemplarSettingKeys.EXEMPLAR_STATUSES_EXPORT, (Converter)new StringToIntegerListConverter(), List::of);
        bean.registerKeyThrowingWhenNullSource(ExemplarSettingKeys.EXPORT_EXEMPLAR_FIELD_NUMBER, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(ExemplarSettingKeys.PORTARO_GENERATED_EXPORT_EXEMPLARS, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.BUILDING_SCOPE_ACCESS_NUMBERS_UNIQUENESS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.TITLE_SIGNATURES_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.EXEMPLAR_TABS_BY_BUILDINGS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.DISCARD_NUMBERS_WITHIN_BUILDING_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.EXEMPLAR_DATA_IN_RECORD_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.REGAL_MAP_PROPERTY, (Converter)new ConversionTableConverter(ExemplarConstants.COLUMNS_AND_PROPS_MAP));
        bean.registerKeyThrowingWhenNullSource(SettingKeys.EXEMPLAR_BAR_CODE_MAX_LENGTH, (Converter)new StringToIntegerConverter());
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.ISSUE_COLUMNS, (Converter)StringToAnyListConverter.create((Converter)new ConversionTableConverter(ExemplarConstants.COLUMNS_AND_PROPS_MAP)), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.EXEMPLAR_DEFAULT_COLUMNS, (Converter)StringToAnyListConverter.create((Converter)new ConversionTableConverter(ExemplarConstants.COLUMNS_AND_PROPS_MAP)), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.EXEMPLAR_COLUMNS_BY_FONDS, (Converter)new StringToIntegerAnyMapConverter((Converter)StringToAnyListConverter.create((Converter)new ConversionTableConverter(ExemplarConstants.COLUMNS_AND_PROPS_MAP))), Map::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.EDITABLE_ISSUE_PROPS, (Converter)StringToAnyListConverter.create((Converter)new ConversionTableConverter(ExemplarConstants.COLUMNS_AND_PROPS_MAP)), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.EDITABLE_EXEMPLAR_PROPS, (Converter)StringToAnyListConverter.create((Converter)new ConversionTableConverter(ExemplarConstants.COLUMNS_AND_PROPS_MAP)), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.EXEMPLAR_SORT_PROPS, (Converter)StringToAnyListConverter.create((Converter)new StringToSortOrderConverter((Converter)new ConversionTableConverter(ExemplarConstants.COLUMNS_AND_PROPS_MAP))), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.BINDING_SORT_PROPS, (Converter)StringToAnyListConverter.create((Converter)new StringToSortOrderConverter((Converter)new ConversionTableConverter(ExemplarConstants.COLUMNS_AND_PROPS_MAP))), List::of);
        bean.registerKeyReturningValueWhenNullSource(SettingKeys.ISSUE_SORT_PROPS, (Converter)StringToAnyListConverter.create((Converter)new StringToSortOrderConverter((Converter)new ConversionTableConverter(ExemplarConstants.COLUMNS_AND_PROPS_MAP))), List::of);
        bean.registerKeyThrowingWhenNullSource(SettingKeys.EXEMPLAR_BARCODE_TYPES, (Converter)StringToAnyListConverter.create((Converter)new ConversionTableConverter(BarCodeType.CONVERSION_TABLE)));
        bean.registerKeyThrowingWhenNullSource(SettingKeys.LOANS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.ORDERING_TYPE, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.RESERVING_TYPE, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.DELAYED_LOANS_RENEWAL_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.DEBTOR_LOANS_RENEWAL_BY_READER_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.EXPIRED_READER_LOANS_RENEWAL_BY_READER_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.RENEWAL_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.PROCESSED_ORDERS_CANCELLING_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SENT_RESERVATIONS_CANCELLING_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.MVS_ACTIVE_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.MVS_PASSIVE_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.LENDER_READER_VERIFYING_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.EDITABLE_SUBDEPARTMENTS_ONLY_LOANS_SHOW_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.LOANS_PROVIDED_TO_DEPARTMENTS, (Converter)new StringToIntegerListConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.DEFAULT_LOAN_REQUEST_INTEREST_DAYS, (Converter)new StringToIntegerConverter());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.DEFAULT_MVS_REQUEST_INTEREST_DAYS, (Converter)new StringToIntegerConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.ORDERS_RECIPIENT_EMAIL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.EXTERNAL_RESOURCES_FOND, (Converter)new StringToIntegerConverter().nullIfEmpty());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.RESERVATION_DATE_TO_REQUIRED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(LoanSettingKeys.LENDING_CHECK_DIFFERENT_DEPARTMENT, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(LoanSettingKeys.LENDING_CHECK_DIFFERENT_LOCATION, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(LoanSettingKeys.RETURNING_CHECK_DIFFERENT_DEPARTMENT, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(LoanSettingKeys.RETURNING_CHECK_DIFFERENT_LOCATION, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(LoanSettingKeys.SHOW_LIBRARIAN_MESSAGE, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(PaymentProviderSettingKeys.FORBIDDEN_GATEWAY_PAYMENT_TYPES, (Converter)new StringToIntegerListConverter());
        bean.registerKeyThrowingWhenNullSource(PaymentProviderSettingKeys.GATEWAY_ALLOWED_USER_IDS, (Converter)new StringToIntegerListConverter());
        bean.registerKeyReturningNullWhenNullSource(PaymentProviderSettingKeys.TERMS_AND_CONDITIONS_URL, (Converter)new StringToNotBlankStringConverter());
        bean.registerKeyThrowingWhenNullSource(PaymentProviderSettingKeys.GOPAY_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(PaymentProviderSettingKeys.GOPAY_API_URL, (Converter)new StringToNotBlankStringConverter());
        bean.registerKeyReturningNullWhenNullSource(PaymentProviderSettingKeys.GOPAY_CLIENT_ID, (Converter)new StringToNotBlankStringConverter());
        bean.registerKeyReturningNullWhenNullSource(PaymentProviderSettingKeys.GOPAY_CLIENT_SECRET, (Converter)new StringToNotBlankStringConverter());
        bean.registerKeyReturningNullWhenNullSource(PaymentProviderSettingKeys.GOPAY_GO_ID, (Converter)new StringToNotBlankStringConverter());
        bean.registerKeyThrowingWhenNullSource(PaymentProviderSettingKeys.GPWEBPAY_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(PaymentProviderSettingKeys.GPWEBPAY_ORDER_URL, (Converter)new StringToNotBlankStringConverter());
        bean.registerKeyReturningNullWhenNullSource(PaymentProviderSettingKeys.GPWEBPAY_MERCHANT_NUMBER, (Converter)new StringToNotBlankStringConverter());
        bean.registerKeyThrowingWhenNullSource(CsobGwSettingKeys.CSOBGW_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(CsobGwSettingKeys.CSOBGW_PROD_ENVIROMENT, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(CsobGwSettingKeys.CSOBGW_MERCHANT_ID, (Converter)new StringToNotBlankStringConverter());
        bean.registerKeyThrowingWhenNullSource(ManualPaymentProviderSettingKeys.TERMINAL_VIRTUAL_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.SHOW_ANONYMIZATION_QUESTION_DIALOG, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SettingKeys.AGREEMENT_STYLE, (Converter)new ConversionTableConverter(AgreementStyle.CONVERSION_TABLE));
        bean.registerKeyReturningNullWhenNullSource(OaiSettingKeys.DOCUMENT_ID_PATTERN, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(OaiSettingKeys.AUTHORITY_ID_PATTERN, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(OaiSettingKeys.PAGE_SIZE, (Converter)new StringToIntegerConverter());
        bean.registerKeyThrowingWhenNullSource(RecordExportSettingKeys.CPK_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DEFAULT_LOCATION, (Converter)new StringToIntegerConverter().nullIfEmpty());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DEFAULT_STATUS, (Converter)new StringToIntegerConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DEFAULT_THEMATIC_GROUP, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DEFAULT_ACQUISITION_WAY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DEFAULT_LOAN_CATEGORY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SettingKeys.DEFAULT_READER_CATEGORY, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(NcipSettingKeys.NCIP_CLIENT_AUTHENTICATION_REQUIRED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(NcipSettingKeys.NCIP_USER_IDENTIFIER, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SynchronizerSettingKeys.SYNCHRONIZATION_CRON, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(BakalariSettingKeys.BAKALARI_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(BakalariSettingKeys.BAKALARI_API_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(BakalariSettingKeys.BAKALARI_API_USER, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(BakalariSettingKeys.BAKALARI_API_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(BakalariSettingKeys.BAKALARI_STUDENT_READER_CATEGORY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(BakalariSettingKeys.BAKALARI_TEACHER_READER_CATEGORY, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(EdookitSettingKeys.EDOOKIT_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(EdookitSettingKeys.EDOOKIT_API_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(EdookitSettingKeys.EDOOKIT_API_USER, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(EdookitSettingKeys.EDOOKIT_API_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(EdookitSettingKeys.EDOOKIT_STUDENT_READER_CATEGORY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(EdookitSettingKeys.EDOOKIT_TEACHER_READER_CATEGORY, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(EdookitSettingKeys.EDOOKIT_EMAIL_GENERATOR_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(EdookitSettingKeys.EDOOKIT_EMAIL_DOMAIN, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(EdupageSettingKeys.EDUPAGE_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(EdupageSettingKeys.EDUPAGE_API_KEY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(EdupageSettingKeys.EDUPAGE_API_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(EdupageSettingKeys.EDUPAGE_STUDENT_READER_CATEGORY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(EdupageSettingKeys.EDUPAGE_TEACHER_READER_CATEGORY, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(EdupageSettingKeys.EDUPAGE_DEDUPLICATION_BY_BAKALARI_ID_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(SolSettingKeys.SOL_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(SolSettingKeys.SOL_API_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SolSettingKeys.SOL_API_USER, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SolSettingKeys.SOL_API_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SolSettingKeys.SOL_STUDENT_READER_CATEGORY, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(SolSettingKeys.SOL_TEACHER_READER_CATEGORY, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(SolSettingKeys.SOL_NAME_SYNCHRONIZATION_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(UnisSettingKeys.UNIS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(UnisSettingKeys.UNIS_API_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(UnisSettingKeys.UNIS_API_USER, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(UnisSettingKeys.UNIS_API_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(UnobSettingKeys.UNOB_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(UnobSettingKeys.UNOB_API_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(UnobSettingKeys.UNOB_API_USER, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(UnobSettingKeys.UNOB_API_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(UnobSettingKeys.UNOB_API_KEY, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(ReportServerSettingsKeys.REPORT_SERVER_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(ReportServerSettingsKeys.REPORT_SERVER_API_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(ReportServerSettingsKeys.REPORT_SERVER_READER_CLIENT_ID, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(ReportServerSettingsKeys.REPORT_SERVER_READER_CLIENT_TOKEN, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(ReportServerSettingsKeys.REPORT_SERVER_ROOT_FOLDER, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(ReportServerSettingsKeys.REPORT_SERVER_EDITOR_CLIENT_ID, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(ReportServerSettingsKeys.REPORT_SERVER_EDITOR_CLIENT_TOKEN, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_PORT, (Converter)new StringToIntegerConverter());
        bean.registerKeyReturningNullWhenNullSource(Sip2SettingKeys.SIP2_TERMINAL_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(Sip2SettingKeys.SIP2_CONTEXT, (Converter)new StringToIntegerConverter());
        bean.registerKeyReturningNullWhenNullSource(Sip2SettingKeys.SIP2_INSTITUTION_ID, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_USER_IDENTIFIER, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_STRICT_USER_IDENTIFIER_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_SORT_BIN_PROCEDURE_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_FORBIDDEN_LENDING_READER_CATEGORIES, (Converter)new StringToStringListConverter());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_ALLOWED_LENDING_LOCATIONS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_ALLOWED_LENDING_LOCATIONS, (Converter)new StringToIntegerListConverter());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_FORBIDDEN_LENDING_LOCATIONS, (Converter)new StringToIntegerListConverter());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_FORBIDDEN_LOAN_CATEGORIES, (Converter)new StringToStringListConverter());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_LENDING_RELAXED_DEBT_LIMIT_VALUE, (Converter)new StringToDoubleConverter());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_LENDING_RELAXED_DEBT_LIMIT_AMOUNT_TYPES, (Converter)new StringToIntegerListConverter());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_LENDING_EXEMPLAR_MAX_PRICE_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(Sip2SettingKeys.SIP2_LENDING_EXEMPLAR_MAX_PRICE, (Converter)new StringToIntegerConverter());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_ALLOWED_LENDING_EXEMPLAR_STATUSES_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_ALLOWED_LENDING_EXEMPLAR_STATUSES, (Converter)new StringToIntegerListConverter());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_LENDING_MAX_ONE_EXEMPLAR_OF_ONE_RECORD_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(Sip2SettingKeys.SIP2_HOLD_PATRON_ID_IN_ITEM_PROPERTIES_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(VerbisboxerManagerApiSettingKeys.VERBISBOXER_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(VerbisboxerManagerApiSettingKeys.VERBISBOXER_API_URL, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(VerbisboxerManagerApiSettingKeys.VERBISBOXER_API_TOKEN_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(VerbisboxerManagerApiSettingKeys.VERBISBOXER_API_CLIENT_ID, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(VerbisboxerManagerApiSettingKeys.VERBISBOXER_API_CLIENT_SECRET, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(IfisSettingKeys.IFIS_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyReturningNullWhenNullSource(IfisSettingKeys.IFIS_SOAP_URL, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(IfisSettingKeys.IFIS_SOAP_ENVELOPE_USERNAME, (Converter)new EToEConverter());
        bean.registerKeyReturningNullWhenNullSource(IfisSettingKeys.IFIS_SOAP_ENVELOPE_PASSWORD, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(FileSettingKeys.HTTPCLIENT5_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(FileSettingKeys.THUMBNAIL_APPSERVER_OMIT_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(FileSettingKeys.PORTARO_INDEXING_ENABLED, (Converter)StringToBooleanConverter.notAllowingNullSource());
        bean.registerKeyThrowingWhenNullSource(CatalogWebSettingsKeys.HEADER_BACKGROUND_COLOR, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(CatalogWebSettingsKeys.HEADER_TEXT_COLOR, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(CatalogWebSettingsKeys.HEADER_LINK_COLOR, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(CatalogWebSettingsKeys.MAIN_MENU_BACKGROUND_COLOR, (Converter)new EToEConverter());
        bean.registerKeyThrowingWhenNullSource(CatalogWebSettingsKeys.MAIN_MENU_TEXT_COLOR, (Converter)new EToEConverter());
        return bean;
    }

    @Bean
    public PermissionRegistry permissionRegistry() {
        return new PermissionRegistry();
    }

    @Bean
    public SecurityManager securityManager() {
        return new PermissionRegistrySecurityManager(this.permissionRegistry());
    }

    @Bean
    public ServerUrlConfiguration serverUrlConfiguration() {
        return new ServerUrlConfiguration(this.rootServerUrlProvider(), this.publicContextPath(), this.contextPath(), this.settingLoader().getOnRootProvider(SettingKeys.SERVER_REVERSE_PROXY), this.settingLoader().getOnRootProvider(SettingKeys.FORCE_HTTPS_ENABLED));
    }

    @Bean
    public Provider<@NonNull String> publicContextPath() {
        Provider nullablePublicContextPathProvider = this.rootServerUrlProvider().andThenFastReturningNull(arg_0 -> ((ServerUrlToPublicContextPathConverter)new ServerUrlToPublicContextPathConverter()).convert(arg_0));
        return FallbackedProvider.ofStaticFallback((Provider)nullablePublicContextPathProvider, (Object)this.contextPath()).fallbackOnException().fallbackOnNull();
    }

    @Bean
    public StartEventListener startEventListener() {
        return new StartEventListener(this.contextPath(), this.rootDepartmentProvider(), this.portaroVersion);
    }

    @Bean
    public UrlWebResolver serverUrlWebResolver() {
        return new CurrentDepartmentServerUrlProvidingUrlWebResolver(this.currentDepartmentWebResolver(), this.serverUrlProvider());
    }

    @Bean
    public RequestUrlCurrentDepartmentWebResolver.DepartmentByRequestUrlBreadthFirstSearchProvider departmentByRequestUrlBreadthFirstSearchProvider() {
        RequestUrlCurrentDepartmentWebResolver.DepartmentByRequestUrlBreadthFirstSearchProvider bean = new RequestUrlCurrentDepartmentWebResolver.DepartmentByRequestUrlBreadthFirstSearchProvider(this.rootDepartmentProvider(), this.departmentAccessor(), this.serverUrlProvider());
        this.cacheService.registerSpringCacheCleaner("departmentsByRequestUrl");
        return bean;
    }

    @Bean
    public WebResolver<Department> currentDepartmentWebResolver() {
        return new CompositeCurrentDepartmentWebResolver(List.of(new CookieValueWebResolver("cz.kpsys.portaro.view.util.CurrentBuildingRepository.CURRENT_BUILDING").thenConverting((Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)new IdToObjectConverter((ByIdLoadable)this.departmentLoader()))), new HttpHeaderValueWebResolver("X-Portaro-Department").thenConverting((Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)new IdToObjectConverter((ByIdLoadable)this.departmentLoader()))), new RequestUrlCurrentDepartmentWebResolver(this.departmentByRequestUrlBreadthFirstSearchProvider()), new ProvidedWebResolver(this.rootDepartmentProvider())));
    }

    @Bean
    public CurrentDepartmentSaver currentDepartmentSaver() {
        return new CookieCurrentDepartmentSaver();
    }

    @Bean
    @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
    public Provider<Department> currentDepartmentProvider() {
        return new CurrentDepartmentProvider(this.currentDepartmentWebResolver(), this.httpServletRequest);
    }

    @Bean
    public ExecutorService executorService() {
        return Executors.newCachedThreadPool();
    }

    @Bean
    public MessageSource messageSource() {
        return new TranslatorDelegatingMessageSource(this.translator(), this.rootDepartmentProvider());
    }

    @Bean
    public Translator<Department> translator() {
        return new HierarchyTraversingTranslator(this.localizationFormatsMapLoader(), arg_0 -> ((DepartmentAccessor)this.departmentAccessor()).getThisAndParentsChain(arg_0), CoreConstants.Locales.XX).withFallback(CoreConstants.Locales.SK, CoreConstants.Locales.CS).withFallback(CoreConstants.Locales.EN, CoreConstants.Locales.CS).withFallback(CoreConstants.Locales.DE, CoreConstants.Locales.EN).withFallback(CoreConstants.Locales.FR, CoreConstants.Locales.EN).withFallback(CoreConstants.Locales.ES, CoreConstants.Locales.EN).withFallback(CoreConstants.Locales.IT, CoreConstants.Locales.EN).withFallback(CoreConstants.Locales.HU, CoreConstants.Locales.EN).withFallback(CoreConstants.Locales.PL, CoreConstants.Locales.EN).withFallbackOfFallbacks(CoreConstants.Locales.CS);
    }

    @Bean
    public AllValuesProvider<Localization> localizationLoader() {
        return new SpringDbLocalizationLoader((ByIdLoadable)this.departmentLoader(), this.jdbcTemplate, this.queryFactory, this.stringToLocaleConverter());
    }

    @Bean
    public Provider<Map<LocalizationId, Map<String, MessageFormat>>> localizationFormatsMapLoader() {
        CachedProvider cachedProvider = new LocalizationLoaderDelegatingLocalizationFormatsMapLoader(this.localizationLoader()).cached();
        this.cacheService.registerCleaner(MessageFormat.class.getSimpleName(), (CacheCleaner)cachedProvider);
        return cachedProvider;
    }

    @Bean
    public Converter<String, Locale> stringToLocaleConverter() {
        return new StringToLocaleConverter();
    }

    @Bean
    public NumberFormat currencyFormat() {
        return NumberFormat.getCurrencyInstance(CatalogConstants.CURRENCY_CZK_LOCALE);
    }

    @Bean
    public ContextualProvider<Department, @NullableNotBlank String> nullableSiglaProvider() {
        return Department::getSigla;
    }

    @Bean
    public ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider() {
        ContextualProvider libraryName = this.settingLoader().getDepartmentedProvider(SettingKeys.LIBRARY_NAME).andThenFastReturningNull(StringUtil::notBlankTrimmedString);
        ContextualProvider libraryStreet = this.settingLoader().getDepartmentedProvider(SettingKeys.LIBRARY_STREET).andThenFastReturningNull(StringUtil::notBlankTrimmedString);
        ContextualProvider libraryPostalCode = this.settingLoader().getDepartmentedProvider(SettingKeys.LIBRARY_POSTAL_CODE).andThenFastReturningNull(StringUtil::notBlankTrimmedString);
        ContextualProvider libraryCity = this.settingLoader().getDepartmentedProvider(SettingKeys.LIBRARY_CITY).andThenFastReturningNull(StringUtil::notBlankTrimmedString);
        ContextualProvider libraryEmail = this.settingLoader().getDepartmentedProvider(SettingKeys.LIBRARY_EMAIL).andThenFastReturningNull(StringUtil::notBlankTrimmedString);
        ContextualProvider libraryPhoneNumber = this.settingLoader().getDepartmentedProvider(SettingKeys.LIBRARY_PHONE_NUMBER).andThenFastReturningNull(StringUtil::notBlankTrimmedString);
        return ctx -> new StaticSystemInstitution((String)libraryName.getOn(ctx), (String)libraryStreet.getOn(ctx), (String)libraryPostalCode.getOn(ctx), (String)libraryCity.getOn(ctx), (String)libraryEmail.getOn(ctx), (String)libraryPhoneNumber.getOn(ctx));
    }

    @Bean
    public Provider<@NonNull String> jwtSymetricKeySecretProvider() {
        Provider kpsysApiKeyProvider = this.settingLoader().getOnRootProvider(SettingKeys.KPSYS_API_KEY).throwingWhenNull();
        return () -> StringUtil.appendToSize((String)((String)kpsysApiKeyProvider.get()), (char)'0', (int)32);
    }

    @Bean
    public MessageCryptor messageCryptor() {
        return MessageCryptor.createWithAesCbcPkcs5Padding((Provider)this.jwtSymetricKeySecretProvider());
    }

    @Bean
    public ActionRequestUrlGenerator actionRequestUrlGenerator() {
        return new ActionRequestUrlGenerator(this.serverUrlProvider().throwingWhenNull(), this.objectMapper);
    }

    @Bean
    public Mailer<Department> mailer() {
        JavaMailSenderFactory mailSenderFactory = new JavaMailSenderFactory(this.settingLoader().getDepartmentedProvider(SettingKeys.SMTP_TRANSPORT_STRATEGY).throwingWhenNull(), this.settingLoader().getDepartmentedProvider(SettingKeys.SMTP_SERVER_ADDRESS).throwingWhenNull(), this.settingLoader().getDepartmentedProvider(SettingKeys.SMTP_SERVER_PORT).throwingWhenNull(), this.settingLoader().getDepartmentedProvider(SettingKeys.SMTP_AUTHENTICATION_ENABLED).throwingWhenNull(), this.settingLoader().getDepartmentedProvider(SettingKeys.SMTP_SERVER_USERNAME), this.settingLoader().getDepartmentedProvider(SettingKeys.SMTP_SERVER_PASSWORD), (ContextualProvider)ContextIgnoringContextualProvider.of((Object)false));
        TemporarilyCachedContextualProvider cachedMailSenderFactory = mailSenderFactory.cached(Duration.ofMinutes(1L));
        JavaMailSenderMailer pureMailer = new JavaMailSenderMailer(this.settingLoader().getDepartmentedProvider(SettingKeys.SMTP_SENDER_ADDRESS), this.settingLoader().getDepartmentedProvider(SettingKeys.SMTP_SENDER_NAME), this.settingLoader().getDepartmentedProvider(SettingKeys.SMTP_USE_SENDER_AND_FROM), this.settingLoader().getDepartmentedProvider(SettingKeys.SMTP_FROM_LIBRARY_MAILS_REPLY_TO_ADDRESS), (ContextualProvider)cachedMailSenderFactory);
        AttachmentsZippingMailer attachmentsZippingMailer = new AttachmentsZippingMailer(Integer.valueOf(3), (Mailer)pureMailer, (FileZipper)new FileZipperImpl());
        GenericTableWriteSaver mailSendingSaver = GenericTableWriteSaver.of((TableWriteGenerator)new MailSendingTableWriteGenerator(), (DmlAppserverService)this.dmlAppserverService(), (CacheCleaner[])new CacheCleaner[0]);
        return new ToDatabaseLoggingMailer((Mailer)attachmentsZippingMailer, (Saver)mailSendingSaver);
    }

    @Bean
    public ActionSaver actionSaver() {
        return new SpringDbActionSaver(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public IpAddressInRangeResolver internalIpResolver() {
        return new CombinedIpAddressRange(new ListedIpAddressRange(this.settingLoader().getOnRootProvidedList(SettingKeys.EXTERNAL_IP_ADDRESSES)), new ListedIpAddressRange(this.settingLoader().getOnRootProvidedList(SettingKeys.INTERNAL_IP_ADDRESSES)), this.settingLoader().getOnRootProvider(SettingKeys.INTERNAL_IP_ADDRESS_RANGE));
    }

    @Bean
    public AppserverService authorizedUserAddingAppserverService() {
        return new UserAddingAppserverService(this.authorizedAppserverService, this.authenticationHolder());
    }

    @Bean
    public MappingAppserverService mappingAppserver() {
        return new BasicMappingAppserverService(this.authorizedUserAddingAppserverService());
    }

    @Bean
    public DmlAppserverService dmlAppserverService() {
        return new MappingAppserverDmlAppserverService(this.mappingAppserver());
    }

    @Bean
    public LocalizationsSaver localizationsSaver() {
        return new LocalizationsSaverAppserver(this.dmlAppserverService(), this.cacheService.createCleanerFor(MessageFormat.class.getSimpleName()));
    }

    @Bean
    public ModelBeanBuilder modelBeanBuilder() {
        return new ModelBeanBuilder(this.entityManager, this.cacheService, this.dmlAppserverService(), this.searchLoaderBuilderFactory());
    }

    @Bean
    public SearchLoaderBuilderFactory searchLoaderBuilderFactory() {
        return new SearchLoaderBuilderFactory();
    }

    @Bean
    public SaverBuilderFactory saverBuilderFactory() {
        return new SaverBuilderFactory(this.dmlAppserverService(), this.cacheService);
    }

    @Bean
    public CompositeObjectUrlIdResolver objectUrlIdResolver() {
        return new CompositeObjectUrlIdResolver();
    }

    @Bean
    public BarCodeValidatorByBarCodeTypeProvider barCodeValidatorByBarCodeTypeProvider() {
        BarCodeValidatorByBarCodeTypeProvider provider = new BarCodeValidatorByBarCodeTypeProvider();
        return provider.registerValidator(BarCodeType.EAN_8, (BarCodeValidator)EanBarcodeValidator.EAN8_VALIDATOR).registerValidator(BarCodeType.EAN_13, (BarCodeValidator)EanBarcodeValidator.EAN13_VALIDATOR).registerValidator(BarCodeType.CODE_39, (BarCodeValidator)new Code39BarcodeValidator(this.settingLoader().getOnRootProvider(UserSettingKeys.USER_BARCODE_CORE_MAX_LENGTH))).registerValidator(BarCodeType.ITF_18, (BarCodeValidator)new ItfBarcodeValidator((Provider)StaticProvider.of((Object)18)));
    }

    @ConstructorProperties(value={"realRootDepartmentIdProvider", "portaroVersion", "cacheService", "queryFactory", "jdbcTemplate", "envVariablesAwareCustomSettingLoader", "settingTypeLoader", "authorizedAppserverService", "entityManager", "alertProvider", "context", "externalLogFields", "httpServletRequest", "objectMapper", "applicationEventPublisher", "codebookLoaderBuilderFactory"})
    @Generated
    public CoreConfig(@NonNull @NonNull Provider<@NonNull Integer> realRootDepartmentIdProvider, @NonNull PortaroVersion portaroVersion, @NonNull CacheService cacheService, @NonNull QueryFactory queryFactory, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull AllBySectionsLoader<CustomSetting<String>> envVariablesAwareCustomSettingLoader, @NonNull AllBySectionsLoader<SettingTypeDto<String>> settingTypeLoader, @NonNull AppserverService authorizedAppserverService, @NonNull EntityManager entityManager, @NonNull CompositeAlertProvider alertProvider, @NonNull ConfigurableApplicationContext context, @NonNull ExternalLogFields externalLogFields, @NonNull HttpServletRequest httpServletRequest, @NonNull ObjectMapper objectMapper, @NonNull ApplicationEventPublisher applicationEventPublisher, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory) {
        Objects.requireNonNull(realRootDepartmentIdProvider, "realRootDepartmentIdProvider is marked non-null but is null");
        Objects.requireNonNull(portaroVersion, "portaroVersion is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(envVariablesAwareCustomSettingLoader, "envVariablesAwareCustomSettingLoader is marked non-null but is null");
        Objects.requireNonNull(settingTypeLoader, "settingTypeLoader is marked non-null but is null");
        Objects.requireNonNull(authorizedAppserverService, "authorizedAppserverService is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(alertProvider, "alertProvider is marked non-null but is null");
        Objects.requireNonNull(context, "context is marked non-null but is null");
        Objects.requireNonNull(externalLogFields, "externalLogFields is marked non-null but is null");
        Objects.requireNonNull(httpServletRequest, "httpServletRequest is marked non-null but is null");
        Objects.requireNonNull(objectMapper, "objectMapper is marked non-null but is null");
        Objects.requireNonNull(applicationEventPublisher, "applicationEventPublisher is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        this.realRootDepartmentIdProvider = realRootDepartmentIdProvider;
        this.portaroVersion = portaroVersion;
        this.cacheService = cacheService;
        this.queryFactory = queryFactory;
        this.jdbcTemplate = jdbcTemplate;
        this.envVariablesAwareCustomSettingLoader = envVariablesAwareCustomSettingLoader;
        this.settingTypeLoader = settingTypeLoader;
        this.authorizedAppserverService = authorizedAppserverService;
        this.entityManager = entityManager;
        this.alertProvider = alertProvider;
        this.context = context;
        this.externalLogFields = externalLogFields;
        this.httpServletRequest = httpServletRequest;
        this.objectMapper = objectMapper;
        this.applicationEventPublisher = applicationEventPublisher;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
    }
}

