<#ftl outputFormat="HTML">
<#import "../../../../freemarker/_localization.ftl" as loc>

<div class="panel panel-default" ng-class="{'panel-success': $model.exemplar, 'panel-danger': !$model.exemplar}">
    <div class="panel-heading">
        <div class="pull-right" ng-show="searching.selectedItem === $model">${loc.loc("commons.Selected")?noEsc}</div>
        <span>{{$model.exemplar.designation}}</span>
        <span ng-show="$model.document.name"> - {{$model.document.name}}</span>
    </div>
    <div class="panel-body">
        <div>
            ${loc.loc("user.Reader")?noEsc}
            <a ui-sref="user({userId: $model.user.id})">{{$model.user | loc}}</a>
        </div>
        <div>${loc.loc("loan.DatumVypujceni")?noEsc} {{$model.lendDate | jpDate:'dd.MM.yyyy'}}</div>
        <div>
            ${loc.loc("loan.TerminVraceni")?noEsc}
            <span ng-class="{'text-success': !$model.expiredLoan, 'text-danger': $model.expiredLoan}">
                <strong>
                    {{$model.dueDate | jpDate:'d.M.yyyy'}} <span ng-show="$model.expiredLoan">Prošlá výpůjčka</span>
                </strong>
            </span>
        </div>
    </div>
</div>