<#ftl outputFormat="HTML">
<#import "../../../../freemarker/_localization.ftl" as loc>

<div class="container-fluid">

    <div class="row">
        <div class="col-xs-12">
            <h1></h1>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-9 col-md-8 col-sm-12 col-xs-12">
            <ui-gmap-google-map
                    center="$ctrl.map.center"
                    zoom="$ctrl.map.zoom"
                    draggable="true"
                    options="$ctrl.map.options"
                    bounds="$ctrl.map.bounds"
                    events="$ctrl.map.events">

                <ui-gmap-window
                        options="$ctrl.map.window.options"
                        templateUrl="$ctrl.historicalPlacesWindowTemplateUrl"
                        templateParameter="$ctrl.map.window.markers"
                        show="$ctrl.map.window.visible"
                        coords="$ctrl.map.window.coordinates"
                        closeClick="$ctrl.map.window.visible = false">
                </ui-gmap-window>

                <ui-gmap-markers
                        models="$ctrl.map.markers"
                        coords="'coordinates'"
                        icon="'icon'"
                        events="$ctrl.map.markerEvents"
                        doCluster="true"
                        clusteroptions="$ctrl.map.clusterOptions"
                        clusterevents="$ctrl.map.clusterEvents"></ui-gmap-markers>
            </ui-gmap-google-map>
        </div>

        <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12">
            <kp-svelte-component-wrapper component="::$ctrl.kpUniversalFormComponent"
                                         props="{formSettings: $ctrl.formSettings, model: $ctrl.query}"
                                         ng-on-submit="$ctrl.find($ctrl.query)">
            </kp-svelte-component-wrapper>

            <div class="row">
                <div class="col-xs-offset-2 col-xs-10">
                    <#--  TODO: when refactoring to svelte, move this to universal forms footer slot and use native submit (same as it was in angular editors before)                  -->
                    <button type="submit" class="btn btn-primary form-control" ng-click="$ctrl.find($ctrl.query)">${loc.loc('commons.hledat')}</button>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-offset-2 col-xs-10">
                    <span ng-show="$ctrl.places.length === 0">
                        ${loc.loc('commons.NoRecordFound')}
                    </span>

                    <span ng-show="$ctrl.places.length > 0">
                        <span ng-bind-html="'${loc.loc("commons.FoundXRecords")?noEsc}' | strParams : $ctrl.places.length"></span>
                    </span>

                    <span ng-show="$ctrl.places === 'error'">
                        Nastala chyba při vyhledávání.
                    </span>
                </div>
            </div>
        </div>

    </div>
</div>