<#ftl outputFormat="HTML">
<#import "../../../../../../freemarker/_localization.ftl" as loc>

<div class="panel-heading">
    <strong>${loc.loc("loan.Objednavka")?noEsc}</strong>
    <span class="label label-warning">${loc.loc("loan.Prezencni")?noEsc}</span>
</div>

<div class="panel-body">
    <p><strong>${loc.loc("loan.JednaSeOPrezencniVypujcku")?noEsc}</strong></p>
    <p ng-if="group.requestItems.length === 1">
        <kp-svelte-component-wrapper
                component="::$ctrl.kpPluralizeTextComponent"
                props="::{
                        count: option.capability.buildings.length,
                        oneCountText: '${loc.loc("loan.DokumentJeKObjednaniNaBudove")?esc}',
                        moreText: '${loc.loc("loan.DokumentJeKObjednaniNaBudovach")?esc}'}">
        </kp-svelte-component-wrapper>
    </p>
    <p ng-if="group.requestItems.length > 1">
        <kp-svelte-component-wrapper
                component="::$ctrl.kpPluralizeTextComponent"
                props="::{
                        count: option.capability.buildings.length,
                        oneCountText: '${loc.loc("loan.DokumentyJsouKObjednaniNaBudove")?esc}',
                        moreText: '${loc.loc("loan.DokumentyJsouKObjednaniNaBudovach")?esc}'}">
        </kp-svelte-component-wrapper>
    </p>

    <div ng-if="$ctrl.showLoginFirstButton(option)">
        <p class="loan-request-option-buildings-list">
            <strong>{{option.capability.buildings|prop:'text'|inline:', '}}</strong>
        </p>
        <div class="loan-request-option-footer">
            <button type="button" class="btn btn-warning btn-login-first" ng-click="$ctrl.sendRequest('standardOrderRequest', option, group)">${loc.loc("commons.NejdrivePrihlasit")?noEsc}</button>
        </div>
    </div>

    <div ng-if="!$ctrl.showLoginFirstButton(option)">
        <div ng-if="option.capability.buildings.length === 1">
            <p class="loan-request-option-buildings-list">
                <strong>{{option.formObject.desiredBuilding|loc}}</strong>
            </p>
        </div>
        <div style="margin-top: 20px;">
            <kp-svelte-component-wrapper component="::$ctrl.kpUniversalFormComponent"
                                         props="{formSettings: option.form, model: option.formObject, forceShowErrors: submitted}"
                                         get-svelte-component="$ctrl.connectFormController($svelteComponentInstant, 'standardVisitOrderabilityForm')"
                                         ng-on-submit="submitted = true">
            </kp-svelte-component-wrapper>
        </div>

        <div class="loan-request-option-footer">
            <button type="button"
                    class="btn btn-primary"
                    ng-disabled="!$ctrl.isValidOrder(option.formObject) || $ctrl.standardVisitOrderabilityForm.formInvalid"
                    ng-click="$ctrl.sendRequest('standardOrderRequest', option, group)">
                ${loc.loc("loan.Objednat")?noEsc}
            </button>
        </div>
    </div>
</div>