<#ftl outputFormat="HTML">
<#import "../../../../../../freemarker/_localization.ftl" as loc>

<div class="panel-heading">
    <strong>${loc.loc("loan.Objednavka")?noEsc}</strong>
    <span class="label label-warning">${loc.loc("loan.Prezencni")?noEsc}</span>
</div>

<div class="panel-body">
    <p>
        Vyberte datum a čas, který chcete objednat.
    </p>

    <div ng-if="$ctrl.showLoginFirstButton(option)">
        <p class="loan-request-option-buildings-list">
            <strong>{{option.capability.buildings | prop:'text' | inline:', '}}</strong>
        </p>
        <div class="loan-request-option-footer">
            <button type="button" class="btn btn-warning btn-login-first" ng-click="$ctrl.sendRequest('slotOrderRequest', option, group)">${loc.loc("commons.NejdrivePrihlasit")?noEsc}</button>
        </div>
    </div>

    <div ng-if="!$ctrl.showLoginFirstButton(option)">
        <div ng-if="option.capability.buildings.length === 1">
            <p class="loan-request-option-buildings-list">
                Budova: <strong>{{option.formObject.desiredBuilding | loc}}</strong>
            </p>
        </div>
        <div ng-init="$ctrl.loadSlotOrderingForm(option)">

            <div style="margin: 20px 0;">
                <kp-svelte-component-wrapper
                        component="::$ctrl.kpValueEditorComponent"
                        props="{
                            type: 'date',
                            validations: $ctrl.slotScopeDateRangeValueEditorValidations,
                            model: $ctrl.slotScopeDateRange.fromDate}"
                        ng-on-model-change="$ctrl.slotScopeDateRange.fromDate = $event.originalEvent.detail; $ctrl.slotOrderingFormChange(option);">
                </kp-svelte-component-wrapper>
            </div>

            <kp-svelte-component-wrapper ng-if="option.form"
                                         component="::$ctrl.kpUniversalFormForceSettingsWrapper"
                                         props="$ctrl.getTimeslotFormProps({
                                            forceSettings: $ctrl.kpUniversalFormForceSettings,
                                            formSettings: option.form,
                                            model: option.formObject,
                                            forceShowErrors: submitted})"
                                         get-svelte-component="$ctrl.connectFormController($svelteComponentInstant, 'slotVisitOrderabilityForm')"
                                         ng-on-model-change="$ctrl.refreshScope()"
                                         ng-on-submit="submitted = true">
            </kp-svelte-component-wrapper>
        </div>

        <div class="loan-request-option-footer">
            <button type="button"
                    class="btn btn-primary"
                    ng-disabled="!$ctrl.isValidOrder(option.formObject) || $ctrl.slotVisitOrderabilityForm.formInvalid"
                    ng-click="$ctrl.sendRequest('slotOrderRequest', option, group)">
                ${loc.loc("loan.Objednat")?noEsc}
            </button>
        </div>
    </div>
</div>