<#ftl outputFormat="HTML">
<#import "../../../../../../freemarker/_localization.ftl" as loc>

<div class="panel-heading">
    <strong>${loc.loc("loan.Vypujcit")?noEsc}</strong>
    <span class="label label-info">${loc.loc("loan.Absencni")?noEsc}</span>
</div>

<div class="panel-body">
    <p ng-if="group.requestItems.length === 1">
        <kp-svelte-component-wrapper
                component="::$ctrl.kpPluralizeTextComponent"
                props="::{
                        count: option.capability.buildings.length,
                        oneCountText: '${loc.loc("loan.DokumentJeKVyzvednutiNaBudove")?esc}',
                        moreText: '${loc.loc("loan.DokumentJeKVyzvednutiNaBudovach")?esc}'}">
        </kp-svelte-component-wrapper>
    </p>
    <p ng-if="group.requestItems.length > 1">
        <kp-svelte-component-wrapper
                component="::$ctrl.kpPluralizeTextComponent"
                props="::{
                        count: option.capability.buildings.length,
                        oneCountText: '${loc.loc("loan.DokumentyJsouKVyzvednutiNaBudove")?esc}',
                        moreText: '${loc.loc("loan.DokumentyJsouKVyzvednutiNaBudovach")?esc}'}">
        </kp-svelte-component-wrapper>
    </p>

    <p class="loan-request-option-buildings-list">
        <strong>{{option.capability.buildings|prop:'text'|inline:', '}}</strong>
    </p>
</div>