/*
👋 Hi! This file was autogenerated by tslint-to-eslint-config.
https://github.com/typescript-eslint/tslint-to-eslint-config

It represents the closest reasonable ESLint configuration to this
project's original TSLint configuration.

We recommend eventually switching this configuration to extend from
the recommended rulesets in typescript-eslint.
https://github.com/typescript-eslint/tslint-to-eslint-config/blob/master/docs/FAQs.md

Happy linting! 💖
*/
module.exports = {
    "env": {
        "browser": true,
        "es6": true,
        "es2020": true
    },
    "ignorePatterns": [
        "node_modules", // ignore dependencies
        "**/*.js", // ignore javascript files
        "test", // ignore tests config directory
        "webpack", // ignore webpack config directory
        "webpack.config.ts" // ignore root webpack config
    ],
    "extends": [
        "plugin:@typescript-eslint/recommended",
        "plugin:@typescript-eslint/recommended-requiring-type-checking",
        "plugin:storybook/recommended",
        "plugin:testing-library/dom"],
    "parser": "@typescript-eslint/parser",
    "parserOptions": {
        "sourceType": "module",
        "ecmaVersion": 2020,
        "project": ["tsconfig.frontend.json", "tsconfig.svelte.json"],
        "extraFileExtensions": [".svelte"]
    },
    "plugins": [
        "eslint-plugin-import",
        "eslint-plugin-jsdoc",
        "eslint-plugin-unicorn",
        "@typescript-eslint",
        "svelte3",
        "testing-library"
    ],
    "overrides": [
        {
            "files": ["*.svelte"],
            "processor": "svelte3/svelte3"
        }
    ],
    "settings": {
        "svelte3/typescript": true,
        "svelte3/ignore-styles": () => true, // do not lint (less) styles
        "testing-library/utils-module": "off", //https://github.com/testing-library/eslint-plugin-testing-library#switching-all-aggressive-reporting-mechanisms-off
        "testing-library/custom-renders": "off", //https://github.com/testing-library/eslint-plugin-testing-library#switching-all-aggressive-reporting-mechanisms-off
        "testing-library/custom-queries": "off", //https://github.com/testing-library/eslint-plugin-testing-library#switching-all-aggressive-reporting-mechanisms-off
    },
    "rules": {
        "@typescript-eslint/adjacent-overload-signatures": "error",
        "@typescript-eslint/array-type": [
            "off",
            {
                "default": "array-simple"
            }
        ],
        "@typescript-eslint/ban-types": [
            "warn",
            {
                "types": {
                    "Object": {
                        "message": "Avoid using the `Object` type. Did you mean `object`?"
                    },
                    "Function": {
                        "message": "Avoid using the `Function` type. Prefer a specific function type, like `() => void`."
                    },
                    "Boolean": {
                        "message": "Avoid using the `Boolean` type. Did you mean `boolean`?"
                    },
                    "Number": {
                        "message": "Avoid using the `Number` type. Did you mean `number`?"
                    },
                    "String": {
                        "message": "Avoid using the `String` type. Did you mean `string`?"
                    },
                    "Symbol": {
                        "message": "Avoid using the `Symbol` type. Did you mean `symbol`?"
                    },
                    "{}": {
                        "message": "Use `AnyObject` or `EmptyObject` from typings/portaro.fe.types.ts",
                        "fixWith": "AnyObject"
                    },
                    "object": {
                        "message": "Use `AnyObject` from typings/portaro.fe.types.ts",
                        "fixWith": "AnyObject"
                    }
                }
            }
        ],
        "@typescript-eslint/consistent-type-assertions": "error",
        "@typescript-eslint/dot-notation": "error",
        "@typescript-eslint/member-ordering": "off",
        "@typescript-eslint/naming-convention": "off",
        "@typescript-eslint/no-empty-function": "error",
        "@typescript-eslint/no-empty-interface": "error",
        "@typescript-eslint/no-explicit-any": "off",
        "@typescript-eslint/no-misused-new": "error",
        "@typescript-eslint/no-namespace": "error",
        "@typescript-eslint/no-parameter-properties": "off",
        "@typescript-eslint/no-shadow": [
            "error",
            {
                "hoist": "all"
            }
        ],
        "@typescript-eslint/no-unused-expressions": "error",
        "@typescript-eslint/no-use-before-define": "off",
        "@typescript-eslint/no-var-requires": "error",
        "@typescript-eslint/prefer-for-of": "error",
        "@typescript-eslint/prefer-function-type": "error",
        "@typescript-eslint/prefer-namespace-keyword": "error",
        "@typescript-eslint/quotes": [
            "error",
            "single"
        ],
        "@typescript-eslint/triple-slash-reference": [
            "error",
            {
                "path": "always",
                "types": "prefer-import",
                "lib": "always"
            }
        ],
        "@typescript-eslint/unified-signatures": "error",
        "@typescript-eslint/ban-ts-comment": ["error", {
            "ts-ignore": "allow-with-description"
        }],
        "@typescript-eslint/no-unsafe-member-access": "off", // todo enable after adding all missing typings
        "@typescript-eslint/no-unsafe-call": "off", // todo enable after adding all missing typings and removing angularjs
        "@typescript-eslint/no-unsafe-assignment": "off", // todo enable after adding all missing typings
        "@typescript-eslint/no-unsafe-return": "off", // because data services do not explicitly cast provided values
        "@typescript-eslint/unbound-method": "off", // because we are using @bind decorator and passing functions all the time
        "@typescript-eslint/no-floating-promises": "off", // because we are ignoring async functions return values
        "@typescript-eslint/require-await": "error",
        "@typescript-eslint/restrict-template-expressions": "off",
        "@typescript-eslint/no-misused-promises": "error",
        "@typescript-eslint/explicit-module-boundary-types": "off", // todo enable after adding all missing typings
        "@typescript-eslint/no-inferrable-types": [
            "warn",
            {
                "ignoreParameters": true
            }
        ],
        "@typescript-eslint/prefer-regexp-exec": "off",
        "@typescript-eslint/restrict-plus-operands": "warn",
        "@typescript-eslint/await-thenable": "error",
        "@typescript-eslint/consistent-type-imports": [
            "error",
            {
                "prefer": "type-imports",
                "disallowTypeAnnotations": true
            }
        ],
        "@typescript-eslint/no-unsafe-argument": "off", // hundreds of errors otherwise
        "arrow-parens": [
            "error",
            "always"
        ],
        "comma-dangle": "off",
        "complexity": "off",
        "constructor-super": "error",
        "dot-notation": "error",
        "eqeqeq": [
            "error",
            "always"
        ],
        "guard-for-in": "error",
        "id-blacklist": [
            "error",
            "any",
            "Number",
            "number",
            "String",
            "string",
            "Boolean",
            "boolean",
            "Undefined",
            "undefined"
        ],
        "id-match": "error",
        "import/order": "off",
        "jsdoc/check-alignment": "error",
        "jsdoc/check-indentation": "error",
        "max-classes-per-file": [
            "error",
            2
        ],
        "max-len": "off",
        "new-parens": "error",
        "no-bitwise": "error",
        "no-caller": "error",
        "no-cond-assign": "error",
        "no-console": "error",
        "no-debugger": "error",
        "no-empty": "error",
        "no-empty-function": "off", // used ts rule
        "no-eval": "error",
        "no-fallthrough": "off",
        "no-invalid-this": "error",
        "no-new-wrappers": "error",
        "no-return-await": "error",
        "no-shadow": "off", // used ts rule
        "no-throw-literal": "error",
        "no-trailing-spaces": "off",
        "no-undef-init": "error",
        "no-underscore-dangle": "off",
        "no-unsafe-finally": "error",
        "no-unused-expressions": "error",
        "no-unused-labels": "error",
        "no-use-before-define": "off",
        "no-var": "error",
        "object-shorthand": "error",
        "one-var": [
            "error",
            "never"
        ],
        "prefer-const": "error",
        "prefer-template": "error",
        "quotes": "off", // used ts rule
        "radix": "error",
        "spaced-comment": ["error", "always", {
            "line": {
                "markers": ["/"],
                "exceptions": ["@ngInject"]
            },
            "block": {
                "markers": ["/"],
                "exceptions": ["@ngInject"],
                "balanced": true
            }
        }],
        "unicorn/filename-case": ["error", {
            "case": "kebabCase",
            "ignore": ["ng-@decorators.ts"]
        }],
        "use-isnan": "error",
        "valid-typeof": "off"
    }
};
