<#ftl outputFormat="HTML">
<#import "_layouts.ftl" as layouts>
<#import "_localization.ftl" as loc>


<@layouts.headerOnly>
    <script type="text/javascript">
        window.model.directoryTree = ${objectMapper.writeValueAsString(directoryTree)?noEsc};
    </script>

    <script type="text/ng-template" id="mediaViewer/searchInDirectoriesTemplate.html">
        <div>
            <kp-media-viewer-search
                    query="mvc.searcher.searchQuery"
                    focus="true"
                    on-search="mvc.searchInDirectories($query)"
                    on-previous="mvc.searchPreviousFileInDirectories()"
                    on-next="mvc.searchNextFileInDirectories()"
                    on-cancel="mvc.cancelSearchingInDirectories()"
            ></kp-media-viewer-search>
        </div>
    </script>

    <script type="text/ng-template" id="mediaViewer/searchInFileTemplate.html">
        <div>
            <kp-media-viewer-search
                    query="mvc.searchInFileQuery"
                    focus="true"
                    on-search="mvc.searchInFile($query)"
                    on-previous="mvc.searchPreviousInFile()"
                    on-next="mvc.searchNextInFile()"
                    on-cancel="mvc.cancelSearchingInFile()"
                    search-api="mvc.mediaViewerSearchInFileSearchApi = $api"
            ></kp-media-viewer-search>
        </div>
    </script>

    <script type="text/ng-template" id="mediaViewer/copyLinkToClipboardTemplate.html">
        <div style="width: 400px;">
            <div class="input-group">
                <input class="form-control" type="text" readonly ng-model="mvc.linkToFile">
                <div class="input-group-btn">
                    <button class="btn btn-primary"
                            type="button"
                            title="${loc.loc("mediaviewer.CopyUrlToClipboard")?noEsc}"
                            ng-click="mvc.copyURLtoClipboard()">
                        <i class="glyphicon glyphicon-copy"></i>
                    </button>
                </div>
            </div>
            <div style="margin-top: 6px;">
                <kp-svelte-component-wrapper component="::mvc.checkboxComponent"
                                             props="{checked: mvc.pageNumberToLink, id: 'add-page-number-checkbox'}"
                                             ng-on-change="mvc.pageNumberToLink = !mvc.pageNumberToLink">
                </kp-svelte-component-wrapper>
                <#-- FIXME: when migrating to svelte move label content to slot of checkbox component -->
                <label for="add-page-number-checkbox">${loc.loc("mediaviewer.addPageNumber")?noEsc}</label>
            </div>
        </div>
    </script>

    <script type="text/ng-template" id="mediaViewer/searchInDirectoriesButtonTemplate.html">
        <button
                class="btn btn-default"
                type="button"
                title="${loc.loc("mediaviewer.SearchInFiles")?noEsc}"
                ng-class="{active: mvc.searchInDirectoriesVisible}"
                ng-if="mvc.viewer.files() && mvc.viewer.files().length > 1"
                uib-popover-template="'mediaViewer/searchInDirectoriesTemplate.html'"
                popover-placement="bottom-left"
                popover-append-to-body="true"
                popover-title="${loc.loc("mediaviewer.SearchInFiles")?noEsc}"
                popover-is-open="mvc.searchInDirectoriesVisible">
            <span class="glyphicon glyphicon-search"></span>
        </button>
    </script>

<#--@formatter:off-->
    <style>
        html,
        body {
            padding: 0;
            margin: 0;
        }
    </style>
<#--@formatter:on-->

    <toaster-container></toaster-container>

    <div class="media-viewer main-active browser-active"
         ng-controller="MediaViewerCtrl as mvc"
         ng-class="{'tree-active': mvc.viewer.hasDirectoryTree()}">

        <div ng-if="mvc.editMode || mvc.viewer.hasDirectoryTree()" class="splitter-content-wrapper notForPrint">
            <div class="toolbar" ng-include="'mediaViewer/searchInDirectoriesButtonTemplate.html'" ng-if="mvc.viewer.hasDirectoryTree()"></div>

            <kp-media-viewer-directories
                    class="media-viewer-file-browser"
                    directory="mvc.viewer.directoryTree()"
                    current-directory="mvc.viewer.currentDirectory()"
                    on-select="mvc.onDirectorySelect($directory)"
                    editing-enabled="mvc.currentAuthService.hasAnyRole('ROLE_ADMIN', 'ROLE_LIBRARIAN')">
            </kp-media-viewer-directories>
        </div>

        <div class="splitter-content-wrapper notForPrint" style="max-width: 20vw;">
            <div class="toolbar">
                <div ng-if="!mvc.viewer.hasDirectoryTree()" ng-include="'mediaViewer/searchInDirectoriesButtonTemplate.html'"></div>
                <span class="directory-name text-ellipsis" title="{{mvc.viewer.currentDirectory() | loc}}" ng-if="!mvc.viewer.hasDirectoryTree()">{{mvc.viewer.currentDirectory() | loc}}</span>
            </div>

            <kp-media-viewer-files
                    class="media-viewer-file-browser"
                    files="mvc.viewer.files()"
                    current-file="mvc.viewer.current()"
                    directory="mvc.viewer.currentDirectory()"
                    on-select="mvc.onFileSelect($file)"
                    editing-enabled="mvc.currentAuthService.hasAnyRole('ROLE_ADMIN', 'ROLE_LIBRARIAN')">
            </kp-media-viewer-files>
        </div>

        <div class="splitter-content-wrapper" style="flex-grow: 1;">
            <div class="toolbar notForPrint">
                <form class="form-inline">
                    <div class="form-group">
                        <div class="btn-group">
                            <a class="btn btn-link" ng-href="{{mvc.backUrl}}">
                                <i class="glyphicon glyphicon-arrow-left"></i>
                                ${loc.loc("mediaviewer.BackToCatalog")?noEsc}
                            </a>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="btn-group">
                            <button class="btn btn-default"
                                    title="${loc.loc("mediaviewer.ShowTextVersion")?noEsc}"
                                    ng-if="mvc.viewer.current() && mvc.viewer.current().hasTextualForm && mvc.viewer.current().exportable && mvc.viewer.getViewMode() !== 'TEXTUAL'"
                                    ng-click="mvc.viewer.setViewMode('TEXTUAL')">
                                <i class="glyphicon glyphicon-font"></i>
                            </button>

                            <button class="btn btn-default"
                                    type="button"
                                    title="${loc.loc("mediaviewer.ShowOriginal")?noEsc}"
                                    ng-if="mvc.viewer.current() && mvc.viewer.current().hasTextualForm && mvc.viewer.getViewMode() !== 'ORIGINAL'"
                                    ng-click="mvc.viewer.setViewMode('ORIGINAL')">
                                <i class="glyphicon glyphicon-picture"></i>
                            </button>

                            <button class="btn btn-default"
                                    type="button"
                                    title="${loc.loc("mediaviewer.SearchOnPage")?noEsc}"
                                    ng-class="{active: mvc.searchInFileVisible}"
                                    ng-show="mvc.viewer.current() && mvc.editMode"
                                    uib-popover-template="'mediaViewer/searchInFileTemplate.html'"
                                    popover-placement="bottom-right"
                                    popover-append-to-body="true"
                                    popover-title="${loc.loc("mediaviewer.SearchOnPage")?noEsc}"
                                    popover-is-open="mvc.searchInFileVisible">
                                <i class="glyphicon glyphicon-search"></i>
                            </button>

                            <button class="btn btn-default"
                                    type="button"
                                    title="${loc.loc("mediaviewer.sendByEmail")?noEsc}"
                                    ng-if="mvc.viewer.current().exportable"
                                    ng-click="mvc.mail(mvc.viewer.current())">
                                <i class="glyphicon glyphicon-envelope"></i>
                            </button>

                            <button class="btn btn-default"
                                    type="button"
                                    title="${loc.loc("commons.tisk")?noEsc}"
                                    ng-if="mvc.viewer.current().printable"
                                    ng-click="mvc.print(mvc.viewer.current())">
                                <i class="glyphicon glyphicon-print"></i>
                            </button>

                            <a class="btn btn-default"
                               type="button"
                               ng-if="mvc.viewer.current().exportable"
                               title="${loc.loc("commons.Stahnout")?noEsc}"
                               download="{{mvc.viewer.current().filename}}"
                               kp-href="/files/{{mvc.viewer.current().id}}?inline=false">
                                <i class="glyphicon glyphicon-save"></i>
                            </a>

                            <button class="btn btn-default"
                                    type="button"
                                    title="${loc.loc("mediaviewer.CopyUrlToClipboard")?noEsc}"
                                    ng-class="{active: mvc.copyLinkToClipboardVisible}"
                                    ng-if="mvc.mediaViewerPageCount > 0"
                                    uib-popover-template="'mediaViewer/copyLinkToClipboardTemplate.html'"
                                    popover-placement="bottom-right"
                                    popover-append-to-body="true"
                                    popover-title="${loc.loc("mediaviewer.CopyUrlToClipboard")?noEsc}"
                                    popover-is-open="mvc.copyLinkToClipboardVisible">
                                <i class="glyphicon glyphicon-copy"></i>
                            </button>

                            <button class="btn btn-default"
                                    type="button"
                                    title="${loc.loc("mediaviewer.CopyUrlToClipboard")?noEsc}"
                                    ng-if="mvc.viewer.current() && !mvc.mediaViewerPageCount > 0"
                                    ng-click="mvc.copyURLtoClipboard()">
                                <i class="glyphicon glyphicon-copy"></i>
                            </button>

                            <button class="btn btn-default"
                                    type="button"
                                    title="${loc.loc("mediaviewer.CopyUrlToClipboard")?noEsc}"
                                    ng-if="mvc.viewer.current().viewForms.includes('VIDEO')"
                                    ng-click="mvc.changeVideoPlayerAspectRatio()">
                                <i class="glyphicon flaticon-aspect-16-9" ng-show="mvc.videoPlayerAspectRatio === '4:3'"></i>
                                <i class="glyphicon flaticon-aspect-4-3" ng-show="mvc.videoPlayerAspectRatio === '16:9'"></i>
                            </button>
                        </div>
                    </div>

                    <div class="input-group" ng-show="mvc.viewer.files().length > 0">
                        <div class="input-group-btn">
                            <button class="btn btn-default"
                                    type="button"
                                    title="${loc.loc("mediaviewer.PreviousFile")}"
                                    ng-click="mvc.viewer.previous()"
                                    ng-disabled="!mvc.viewer.hasPrevious()">
                                <i class="glyphicon glyphicon-chevron-left"></i>
                            </button>
                        </div>

                        <span class="input-group-addon">{{mvc.currentFileIndex()}} / {{mvc.viewer.files().length}}</span>

                        <div class="input-group-btn">
                            <button class="btn btn-default"
                                    type="button"
                                    title="${loc.loc("mediaviewer.NextFile")}"
                                    ng-click="mvc.viewer.next()"
                                    ng-disabled="!mvc.viewer.hasNext()">
                                <i class="glyphicon glyphicon-chevron-right"></i>
                            </button>
                        </div>
                    </div>

                    <div class="form-group">
                        <kp-pdf-viewer-control-panel class="input-group"
                                                     pdf-control-id="pdf"
                                                     ng-if="mvc.viewer.current().viewForms.includes('PDF')">
                            <input class="form-control"
                                   type="number"
                                   title="${loc.loc("mediaviewer.CurrentPage")}"
                                   min="1"
                                   max="{{$pageCount}}"
                                   style="width: 70px;"
                                   ng-model="$currentPage">
                            <div class="input-group-addon input-group-addon-middle" title="${loc.loc("mediaviewer.PagesCount")}">
                                / {{$pageCount}}
                            </div>
                            <div class="input-group-btn">
                                <button class="btn btn-default" type="button" title="${loc.loc("mediaviewer.ZoomIn")}" kp-pdf-viewer-control-panel-zoom-in>
                                    <i class="glyphicon glyphicon-zoom-in"></i>
                                </button>
                                <button class="btn btn-default" type="button" title="${loc.loc("mediaviewer.ZoomOut")}" kp-pdf-viewer-control-panel-zoom-out>
                                    <i class="glyphicon glyphicon-zoom-out"></i>
                                </button>
                                <button class="btn btn-default" type="button" title="${loc.loc("mediaviewer.AdjustToHeight")}" kp-pdf-viewer-control-panel-fit-auto>
                                    <i class="glyphicon glyphicon-resize-full"></i>
                                </button>
                                <button class="btn btn-default" type="button" title="${loc.loc("mediaviewer.AdjustToWidth")}" kp-pdf-viewer-control-panel-fit-width>
                                    <i class="glyphicon glyphicon-resize-horizontal"></i>
                                </button>
                                <a class="btn btn-default display-pdf-in-web-browser-btn"
                                   type="button"
                                   title="${loc.loc("mediaviewer.OpenNewWindowAndDisplayInWebBrowser")?noEsc}"
                                   kp-href="/files/{{$parent.$parent.$parent.mvc.viewer.current().id}}"
                                   target="_blank"
                                   ng-if="$parent.$parent.$parent.mvc.viewer.current().exportable">
                                    ${loc.loc("mediaviewer.DisplayInWebBrowser")?noEsc}
                                </a>
                            </div>
                        </kp-pdf-viewer-control-panel>
                    </div>
                </form>
            </div>

            <kp-media-viewer-viewer
                    file="mvc.viewer.current()"
                    edit-mode="mvc.editMode"
                    view-mode="mvc.viewer.getViewMode()"
                    search-api="mvc.mediaViewerViewerSearchApi = $api"
                    current-page="mvc.mediaViewerCurrentPage"
                    on-current-page-change="mvc.mediaViewerCurrentPage = $currentPage"
                    on-page-count-change="mvc.mediaViewerPageCount = $pageCount"
            >
            </kp-media-viewer-viewer>
        </div>
    </div>
</@layouts.headerOnly>
