<#ftl outputFormat="HTML">
<#import "_layouts.ftl" as layouts>
<#import "_localization.ftl" as loc>
<#import "_util.ftl" as util>

<#-- @ftlvariable name="record" type="cz.kpsys.portaro.record.Record" -->
<#-- @ftlvariable name="viewableRecord" type="cz.kpsys.portaro.search.view.ExportingRichDocument" -->
<#-- @ftlvariable name="recordPrinter" type="cz.kpsys.portaro.record.print.RecordDetailPlainHtmlPrinter" -->


<@layouts.full>
    <script type="text/javascript">
        window.model.view = ${objectMapper.writeValueAsString(view)?noEsc};
    </script>


    <div ng-controller="DocumentCtrl" ng-init="init();" id="detail" class="container" style="margin-top: 40px;">


        <div class="row">
            <div class="main-panel-hlavni col-sm-8">


                <#-- NAZEV A AUTOR DILA -->
                <div class="record-heading">

                    <h1 id="detail-main-name">${viewableRecord.name?esc}</h1>

                    <h3 id="detail-main-subtitle" ng-bind-html="'${viewableRecord.subTitle?jsString}' | urlToLink"></h3>

                    <#assign fieldsCount = viewableRecord.query('787.t#0').size - 1>
                    <#list 0..fieldsCount as index>
                        <div id="detail-main-related-record">
                            <#assign field787 = viewableRecord.query('787#' + index + '.it')>
                            <#assign part = viewableRecord.query('787#' + index + '.g')>

                            <#if !field787.isEmpty() && (field787.contains('cyklu') || (field787.getRaw()?? && field787.getRaw()?upperCase?contains('SÉRIE')))>
                                <span>${recordPrinter.group(field787, "", "", " ", "")?noEsc}</span><#--
                                --><#if !part.isEmpty()><#--
                                    --><span>, ${loc.loc('commons.part')} ${part}</span>
                                </#if>
                            </#if>
                        </div>
                    </#list>

                    <#assign sf245c=viewableRecord.query('245.c')>
                    <#if sf245c.any>
                        <div id="detail-main-responsibility">${recordPrinter.group(sf245c)?noEsc}</div>
                    </#if>

                    <#assign sf100abc=viewableRecord.query('100.abc')>
                    <#if sf100abc.any>
                        <div id="detail-main-100abc">${recordPrinter.group(sf100abc)?noEsc}</div>
                    </#if>

                    <#assign mainAuthorsGroup=viewableRecord.query('100.a, 110.a, 111.a')>
                    <#if mainAuthorsGroup.any>
                        <div id="detail-main-author">${recordPrinter.group(mainAuthorsGroup)?noEsc}</div>
                    </#if>

                    <br />

                </div>


                <#-- hlavni obsah detailu od obalky po zacatek zalozkovych divu -->
                <div class="detail-blok-main document-detail-blok-main">


                    <img ng-if="availability.returnedToday && (availability.pickupable || availability.orderable)" ng-cloak class="returnedTodayImg documentReturnedTodayImg"
                         ng-src="{{CONTEXT_PATH}}/resources/img/icons/returned_today_80.png" width="80" height="80" alt="Dnes vráceno" title="Dnes vráceno" />


                    <#-- obalka -->
                    <div class="cover-container cover-container-document-detail">
                        <kp-svelte-component-wrapper component="::kpCoverComponent" props="::{record: document, target: 'cover', fillTo: 'width'}"></kp-svelte-component-wrapper>
                    </div>


                    <div>

                        <jp-custom-paragraph content="view.nextToCoverParagraph" class="paragraph-template odstavec_vedleObalky" style="margin: 12px 0"></jp-custom-paragraph>

                        <kp-rating record="document"></kp-rating>


                        <#-- DOSTUPNOST DOKUMENTU -->
                        <div class="document-availability" style="margin: 12px 0">
                            <#-- TLACITKO OBJEDNAT/REZERVOVAT -->
                            <kp-availability-button kp-availability="availability" kp-on-request="requestDocument()" kp-for-exemplar="false"></kp-availability-button>

                            <#-- INFORMACE O POCTU EXEMPLARU -->
                            <#-- ng-if == await for availability promise to resolve -->
                            <kp-svelte-component-wrapper ng-if="availability" component="::kpAvailabilityInfoComponent" props="{availability: availability}"></kp-svelte-component-wrapper>
                        </div>


                        <#if viewableRecord.withForeignOccurrences>
                            <kp-find-in-databases record-id="document.id" style="margin: 12px 0"></kp-find-in-databases>
                        </#if>


                        <#-- nahled -->
                        <#assign fg1856=viewableRecord.query('1856.u')>
                        <#if fg1856.any>
                            <div style="margin: 12px 0">
                                ${loc.loc("commons.Nahled")?noEsc}:
                                <#list fg1856.all as f1856>
                                    <a href="${f1856.raw}" target="_blank">${f1856.raw?contains('format=pdf')?then('PDF', (f1856.raw?contains('format=epub')?then('EPUB', f1856.raw)))}</a>
                                    <#sep>, </#sep>
                                </#list>
                            </div>
                        </#if>

                    </div>


                    <div style="clear: left;"></div>

                    <br />


                    <#-- definovatelny odstavec -->
                    <jp-custom-paragraph content="view.underCoverParagraph" class="paragraph-template odstavec_podObalkou"></jp-custom-paragraph>

                    <hr />


                </div>


                <div id="detail-blok-details" class="detail-blok detail-blok-details" ng-cloak>

                    <uib-tabset active="detailTabs.activeTabId">

                        <uib-tab ng-if="view.exemplarsShowing && !view.exemplarTabsByBuildingsEnabled" index="'EXEMPLARS'" ng-init="detailTabs.registerTab('EXEMPLARS')" ng-cloak>
                            <uib-tab-heading class="tab-button-exemplars">
                                <span ng-if="!document.periodical">${loc.loc("detail.exemplare")?noEsc}</span>
                                <span ng-if="document.periodical">${loc.loc("detail.svazaneRocniky")?noEsc}</span>
                                <span class="text-muted" ng-bind="exemplarList.filteredExemplars.length"></span>
                            </uib-tab-heading>
                            <div class="panel panel-default tab-content-exemplars">

                                <div jp-loading="xs" ng-show="!exemplarList" class="panel-body">${loc.loc("detail.nacitamExemplare")?noEsc}</div>

                                <div ng-show="exemplarList && exemplarList.empty" class="panel-body text-muted text-center">
                                    <span ng-if="document.status.id === 2 || document.status.id === 3">${loc.loc("detail.DokumentJeVeZpracovani")?noEsc}</span>
                                    <span ng-if="document.status.id !== 2 && document.status.id !== 3">
                                        <span ng-if="!document.periodical">${loc.loc("detail.ZadneExemplareKDispozici")?noEsc}</span>
                                        <span ng-if="document.periodical">${loc.loc("detail.dokumentNemaZadneSvazaneRocniky")?noEsc}</span>
                                    </span>
                                </div>

                                <div ng-show="exemplarList && !exemplarList.empty">
                                    <kp-exemplar-list exemplars="exemplarList.filteredExemplars"
                                                      type="exemplarList.type"
                                                      document="document"
                                                      properties="view.exemplarsView.exemplarColumns"
                                                      exemplar-filter="exemplarList.exemplarFilter">
                                    </kp-exemplar-list>
                                </div>

                                <div ng-if="exemplarList.canCreateAny()" class="panel-body text-center">
                                    <button type="button" ng-click="createExemplar()" class="btn btn-default btn-sm">${loc.loc("commons.pridatExemplar")?noEsc}</button>
                                </div>

                            </div>
                        </uib-tab>


                        <uib-tab ng-if="view.citationShowing" index="'CITATION'" ng-init="detailTabs.registerTab('CITATION')">
                            <uib-tab-heading class="tab-button-citace">
                                ${loc.loc("detail.citace")?noEsc}
                            </uib-tab-heading>
                            <div class="panel panel-default tab-content-citace">
                                <div class="panel-body">
                                    <kp-svelte-component-wrapper component="::kpCitationComponent" props="::{record: document, availableStyles: view.citationStyles}"></kp-svelte-component-wrapper>
                                </div>
                            </div>
                        </uib-tab>


                        <uib-tab index="'NONE'" ng-init="detailTabs.registerTab('NONE')" style="display:none;">
                            <div class="panel panel-default"></div>
                        </uib-tab>


                        <#if viewableRecord.canHasArticles()>
                            <uib-tab ng-if="articlesPagination.items.length > 0 && view.articlesTabShowing" index="'ARTICLES'" ng-init="detailTabs.registerTab('ARTICLES')">
                                <uib-tab-heading class="tab-button-clanky">
                                    ${loc.loc("detail.Souvisejici")?noEsc}
                                </uib-tab-heading>
                                <div class="panel panel-default tab-content-clanky">
                                    <kp-paginated-panel-list pagination="articlesPagination">
                                        <kp-svelte-component-wrapper component="::kpDocumentMiniComponent" props="::{document: $parent.item}"></kp-svelte-component-wrapper>
                                    </kp-paginated-panel-list>
                                </div>
                            </uib-tab>
                        </#if>


                        <#if viewableRecord.canHasParts()>
                            <uib-tab ng-if="partsPagination.items.length > 0" index="'PARTS'" ng-init="detailTabs.registerTab('PARTS')">
                                <uib-tab-heading class="tab-button-parts">
                                    ${loc.loc("detail.VsechnyDily")?noEsc}
                                </uib-tab-heading>
                                <div class="panel panel-default tab-content-parts">
                                    <kp-paginated-panel-list pagination="partsPagination">
                                        <kp-svelte-component-wrapper component="::kpDocumentMiniComponent" props="::{document: $parent.item}"></kp-svelte-component-wrapper>
                                    </kp-paginated-panel-list>
                                </div>
                            </uib-tab>
                        </#if>


                        <#if viewableRecord.tocContent?? || viewableRecord.tocUrl??>
                            <uib-tab index="'TOC'" ng-init="detailTabs.registerTab('TOC')">
                                <uib-tab-heading class="tab-button-obsah">
                                    ${loc.loc("detail.obsah")?noEsc}
                                </uib-tab-heading>
                                <div class="panel panel-default tab-content-obsah">
                                    <#if viewableRecord.tocUrl??>
                                        <div style="padding: 10px 10px 5px 10px;">
                                            <a href="${viewableRecord.tocUrl}">${viewableRecord.tocUrl?esc}</a>
                                        </div>
                                    </#if>
                                    <#if viewableRecord.tocContent??>
                                        <div style="padding: 5px 10px; font-size: 13px; overflow-x: scroll; white-space: pre; font-family: monospace;">${viewableRecord.tocContent?esc}</div>
                                    </#if>
                                </div>
                            </uib-tab>
                        </#if>


                        <uib-tab ng-if="view.detailTabShowing" index="'DETAIL'" ng-init="detailTabs.registerTab('DETAIL')">
                            <uib-tab-heading class="tab-button-detail">
                                ${loc.loc("detail.detail")?noEsc}
                            </uib-tab-heading>
                            <div class="panel panel-default tab-content-detail">
                                <kp-svelte-component-wrapper
                                        component="::kpRecordDetailTable"
                                        props="{rows: view.detailTableRows}"
                                ></kp-svelte-component-wrapper>
                            </div>
                        </uib-tab>


                        <uib-tab ng-if="view.marcTabShowing" index="'MARC'" ng-init="detailTabs.registerTab('MARC')">
                            <uib-tab-heading class="tab-button-marc">
                                ${loc.loc("detail.marc")?noEsc}
                            </uib-tab-heading>
                            <div class="panel panel-default tab-content-marc">
                                <@util.recordMarcTable view.fields />
                            </div>
                        </uib-tab>


                        <uib-tab ng-if="view.loansShowing" index="'LOANS'" ng-init="detailTabs.registerTab('LOANS')" select="loadLoans()">
                            <uib-tab-heading class="tab-button-loans">
                                ${loc.loc("loan.LoanHistory")?noEsc}
                            </uib-tab-heading>
                            <div class="panel panel-default tab-content-loans">
                                <kp-paginated-panel-list pagination="loanListSearchManager.getPagination()">
                                    <div class="pull-right">
                                        <div>{{$parent.item.lendDate | jpDate:'d.M.yyyy'}}</div>
                                        <div>{{$parent.item.endDate | jpDate:'d.M.yyyy'}}</div>
                                    </div>
                                    <div>
                                        <div>
                                            <strong>{{$parent.item.state | loc}}</strong> <span class="text-muted">${loc.loc("commons.byUser")?noEsc}</span> <a kp-href="/#!/users/{{$parent.item.user.id}}">{{$parent.item.user | loc}}</a>
                                        </div>
                                        <div><span class="text-muted">${loc.loc('exemplar.Exemplar.abbr')}</span> {{$parent.item.exemplar | loc}}</div>
                                        <div><span class="text-muted">${loc.loc('department.Department.abbr')}</span> {{$parent.item.department | loc}}</div>
                                    </div>
                                </kp-paginated-panel-list>
                            </div>
                        </uib-tab>


                        <uib-tab ng-if="view.operationsShowing" index="'OPERATIONS'" ng-init="detailTabs.registerTab('OPERATIONS')" select="loadOperations()">
                            <uib-tab-heading class="tab-button-operations">
                                ${loc.loc("record.ProcessingHistory")?noEsc}
                            </uib-tab-heading>
                            <div class="panel panel-default tab-content-operations">
                                <kp-paginated-panel-list pagination="operationListSearchManager.getPagination()">
                                    <kp-record-operation-list-item record-operation="$parent.item"></kp-record-operation-list-item>
                                </kp-paginated-panel-list>
                            </div>
                        </uib-tab>

                    </uib-tabset>

                </div>


                <#if viewableRecord.volumeable>
                    <div class="detail-blok" id="detail-blok-volumes" ng-cloak>
                        <kp-volumes document="document"
                                    exemplar-statuses="view.exemplarsView.showableExemplarStatuses"
                                    properties="view.exemplarsView.issueColumns"
                                    capabilities="{
                                        canCreateAnyVolume: view.exemplarsView.canCreateAny,
                                        canEditAnyVolume: view.exemplarsView.canEditAny,
                                        canCreateAnyExemplar: view.exemplarsView.canCreateAny,
                                        canEditAnyExemplar: view.exemplarsView.canEditAny
                                    }"
                        </kp-volumes>
                    </div>
                </#if>

                <div ng-if="view.exemplarsShowing && view.exemplarTabsByBuildingsEnabled" ng-cloak id="detail-blok-exemplare" class="detail-blok detail-blok-exemplare">
                    <kp-exemplars
                            document="document"
                            exemplar-list="exemplarList"
                            settings="view.exemplarsView"
                            properties="view.exemplarsView.exemplarColumns">
                    </kp-exemplars>
                </div>

                <div ng-if="view.commentsShowing" id="komentareContainer" class="detail-blok" style="min-height: 150px;">
                    <kp-comments document="document" anonymous-comments="view.anonymousCommentsEnabled"></kp-comments>
                </div>
            </div>


            <#-- pravy sloupec -->
            <aside class="main-panel-pravy col-sm-4">


                <#-- tlacitka predchozi a dalsi -->
                <div ng-if="::navigationButtons.showAny()" ng-cloak style="min-height: 40px; margin-top: 5px;">
                    <div class="btn-group pull-right back-previous-next-buttons">
                        <a ng-if="::navigationButtons.showBack()" ng-href="{{::navigationButtons.getBackLink()}}" class="btn btn-default btn-xs backToSearchButton">
                            <span class="glyphicon glyphicon-backward"></span> ${loc.loc("detail.zpetNaVyhledane")?noEsc}
                        </a>

                        <a ng-href="{{CONTEXT_PATH}}{{::navigationButtons.getPreviousPath()}}" ng-class="{'disabled': !navigationButtons.showPrevious()}" class="btn btn-default btn-xs previousButton">
                            <span class="glyphicon glyphicon-chevron-left"></span> ${loc.loc("commons.Predchozi")?noEsc}
                        </a>

                        <a ng-href="{{CONTEXT_PATH}}{{::navigationButtons.getNextPath()}}" ng-class="{'disabled': !navigationButtons.showNext()}" class="btn btn-default btn-xs nextButton">
                            ${loc.loc("commons.Nasledujici")?noEsc} <span class="glyphicon glyphicon-chevron-right"></span>
                        </a>
                    </div>
                </div>


                <#-- odstavec vedle nadpisu -->
                <jp-custom-paragraph content="view.nextToHeaderParagraph" class="side-column-panel paragraph-template odstavec_vedleNadpisu panel panel-default"></jp-custom-paragraph>


                <#-- prilohy -->
                <div ng-show="directoryInsight.sampleFiles.length > 0 || directoryInsight.withNonCoverFiles || directoryInsight.withSubdirectories" class="side-column-panel attachments-panel panel panel-default" ng-cloak>
                    <div class="panel-heading">
                        ${loc.loc("detail.PrilohyKeStazeni")?noEsc}
                    </div>
                    <ul class="list-group">
                        <li ng-if="directoryInsight.withNonCoverFiles || directoryInsight.withSubdirectories" class="list-group-item">
                            <a ng-href="{{CONTEXT_PATH}}/media-viewer?rootDirectory={{document.directoryId}}&origin={{$window.location.href | encodeUri}}">
                                ${loc.loc("file.ZobrazitPripojeneSoubory")?noEsc}
                            </a>
                        </li>
                        <li ng-repeat="file in directoryInsight.sampleFiles" class="list-group-item">
                            <a ng-href="{{CONTEXT_PATH}}/media-viewer?rootDirectory={{document.directoryId}}&origin={{$window.location.href | encodeUri}}#!?file={{file.id}}">
                                <div>
                                    <img ng-if="file.viewForms.includes('THUMBNAIL')" ng-src="{{CONTEXT_PATH}}/files/{{file.id}}?width=80" width="80" style="border: 1px solid #DDD;" /><span style="margin-left: 10px">{{file.name}}</span>
                                </div>
                            </a>
                        </li>
                    </ul>
                </div>


                <#if currentPage.can('RecordEdit', record) || currentPage.can('RecordCreateOfKind', record.type) || currentPage.can('FilesManage', null) || currentPage.can('RecordHoldingDeleteOfRecord', record) || currentPage.can('InsertIntoCollections', null)>
                    <div class="side-column-panel">
                        <div class="panel panel-default">
                            <div class="panel-heading">${loc.loc("record.RecordManagement")?noEsc}</div>
                            <div class="record-management-panel">
                                <#if currentPage.can('RecordEdit', record)>
                                    <a ng-href="{{CONTEXT_PATH}}/records/{{document.id}}/edit" class="btn btn-block btn-primary panel-item">${loc.loc("commons.editovat")?noEsc}</a>
                                    <button ng-click="updateWithExternalRecord()" class="btn btn-block btn-default panel-item" title="${loc.loc("detail.UpdateRecordTooltip")?noEsc}">${loc.loc("detail.UpdateRecord")?noEsc}</button>
                                </#if>
                                <#if currentPage.can('RecordCreateOfKind', record.type)>
                                    <button ng-click="copyRecord()" class="btn btn-block btn-default panel-item">${loc.loc("commons.Zkopirovat")?noEsc}</button>
                                </#if>
                                <#if currentPage.can('FilesManage', null)>
                                    <a ng-href="{{CONTEXT_PATH}}/media-viewer?rootDirectory={{document.directoryId}}&edit=true&origin={{$window.location.href | encodeUri}}" class="btn btn-block btn-default panel-item">
                                        ${loc.loc("file.PripojeneSoubory")?noEsc}
                                    </a>
                                </#if>
                                <#if currentPage.can('RecordEdit', record)>
                                    <kp-action-request-button ng-if="document.status.id === 3"
                                                              class="panel-item"
                                                              path="/api/records/phase" path-on-context="true" request-method="post" request-body="{record: document.id, phase: 'CATALOGED'}" on-success-callback="refresh()"
                                                              css-class="btn btn-block btn-default panel-button"
                                                              title="${loc.loc("detail.EndCatalogizationTooltip")?noEsc}">${loc.loc("detail.EndCatalogization")?noEsc}</kp-action-request-button>
                                    <kp-action-request-button ng-if="document.status.id === 4"
                                                              class="panel-item"
                                                              path="/api/records/phase" path-on-context="true" request-method="post" request-body="{record: document.id, phase: 'CATALOGING'}" on-success-callback="refresh()"
                                                              css-class="btn btn-block btn-default panel-button"
                                                              title="${loc.loc("detail.MarkAsUncataloguedTooltip")?noEsc}">${loc.loc("detail.MarkAsUncatalogued")?noEsc}</kp-action-request-button>
                                </#if>
                                <#if currentPage.can('RecordHoldingDeleteOfRecord', record)>
                                    <a ng-if="recordHoldings.length === 1" href="" ng-click="deleteRecordHolding(recordHoldings[0])" class="btn btn-block btn-default panel-item">${loc.loc("detail.DeleteDocument")?noEsc}</a>
                                    <div ng-if="recordHoldings.length > 1" class="record-deletion-dropdown btn-group panel-item">
                                        <button type="button" class="btn btn-block btn-default dropdown-toggle" data-toggle="dropdown">
                                            ${loc.loc("detail.DeleteDocument")?noEsc} <span class="caret"></span>
                                        </button>
                                        <ul class="dropdown-menu" role="menu">
                                            <li ng-repeat="recordHolding in recordHoldings track by recordHolding.id"><a href="" ng-click="deleteRecordHolding(recordHolding)">z {{recordHolding.department | loc}}</a></li>
                                        </ul>
                                    </div>
                                </#if>
                                <#if currentPage.can('InsertIntoCollections', null)>
                                    <kp-svelte-component-wrapper component="::kpCollectionSingleInsertButton" props="::{record: document}" class="panel-item"></kp-svelte-component-wrapper>
                                </#if>
                            </div>
                        </div>
                    </div>
                </#if>


                <#-- info o zaznamu pro adminy -->
                <#if currentPage.currentAuth.role?seqContains('ROLE_ADMIN')>
                    <div class="side-column-panel record-admin-info panel panel-default" ng-cloak>
                        <div class="panel-heading">${loc.loc("record.RecordInfo")?noEsc}</div>
                        <table class="table table-condensed">
                            <tr>
                                <td>${loc.loc("commons.Active")?noEsc}</td>
                                <td>{{document.active}}</td>
                            </tr>
                            <tr>
                                <td>${loc.loc("commons.Deleted")?noEsc}</td>
                                <td>{{document.deleted}}</td>
                            </tr>
                            <tr>
                                <td>${loc.loc("commons.fond")?noEsc}</td>
                                <td>{{document.fond.id}} - {{document.fond | loc}}</td>
                            </tr>
                            <tr>
                                <td>${loc.loc("record.Periodical")?noEsc}</td>
                                <td>
                                    <span ng-show="document.periodical" class="glyphicon glyphicon-ok"></span>
                                    <span ng-show="!document.periodical" class="glyphicon glyphicon-remove"></span>
                                </td>
                            </tr>
                            <tr>
                                <td>${loc.loc("record.CanHaveExemplars")?noEsc}</td>
                                <td>
                                    <span ng-show="document.exemplarable" class="glyphicon glyphicon-ok"></span>
                                    <span ng-show="!document.exemplarable" class="glyphicon glyphicon-remove"></span>
                                </td>
                            </tr>
                            <tr>
                                <td>${loc.loc("record.CanHaveVolumes")?noEsc}</td>
                                <td>
                                    <span ng-show="document.volumeable" class="glyphicon glyphicon-ok"></span>
                                    <span ng-show="!document.volumeable" class="glyphicon glyphicon-remove"></span>
                                </td>
                            </tr>
                            <tr>
                                <td>${loc.loc("record.Cover")?noEsc}</td>
                                <td>
                                    <span ng-hide="document.cover.id">${loc.loc("commons.Universal")?noEsc}</span>
                                    <span ng-show="document.cover.id">{{document.cover.id}} - {{document.cover.filename}}</span>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="side-column-panel record-admin-info panel panel-default" ng-cloak>
                        <div class="panel-heading">${loc.loc("record.RecordUsages")?noEsc}</div>
                        <table class="table table-condensed">
                            <tr ng-repeat="recordHolding in recordHoldings track by recordHolding.id">
                                <td>{{recordHolding.department | loc}}</td>
                                <td><span ng-show="recordHolding.discardionEventId" class="label label-danger">${loc.loc("document.status.9")?noEsc}</span></td>
                            </tr>
                        </table>
                    </div>
                </#if>


                <div class="side-column-panel">
                    <kp-svelte-component-wrapper component="::kpFavouritesPanelComponent" props="::{record: document}"></kp-svelte-component-wrapper>
                </div>

                <div class="side-column-panel">
                    <kp-svelte-component-wrapper component="::kpVisitedPanelComponent" props="::{showLastVisited: false}"></kp-svelte-component-wrapper>
                </div>

            </aside>
        </div>


        <div class="upperFooter row">
            <kp-similar-documents record-id="document.id"></kp-similar-documents>
        </div>

        <div class="upperFooter row">
            <div class="col-sm-12" style="margin-bottom: 10px;">

                <button type="button" class="odeslatEmailem btn btn-default btn-sm" ng-click="showSendMailForm()">
                    ${loc.loc("detail.odeslatEmailem")?noEsc}
                </button>


                <button type="button" class="tisknout btn btn-default btn-sm" onclick="window.print();">
                    ${loc.loc("commons.tisk")?noEsc}
                </button>


                <jp-links class="export-btn document-export"
                          links="view.exportLinks"
                          jp-show-if-empty="true"
                          jp-single-button-overwrite-link-text="'Export'"
                          jp-dropdown-button-text="'Export'">
                </jp-links>


                <jp-links class="vyhledatJinde"
                          links="view.searchElsewhereLinks"
                          jp-show-if-empty="false"
                          jp-dropdown-button-text="'${loc.loc("detail.vyhledatJinde")?noEsc}'"
                          force-dropdown="true">
                </jp-links>


                <jp-links class="document-external-detail-links"
                          links="view.externalDetailLinks"
                          jp-show-if-empty="false"
                          jp-single-button-prefix-text="'Zobrazit na'"
                          jp-dropdown-button-text="'Zobrazit na'">
                </jp-links>


                <#-- permalink -->
                <span style="margin-left: 10px;">
                    ${loc.loc("detail.permantentniLink")?noEsc}
                    <#assign permalink="${currentPage.serverUrl}/records/${viewableRecord.id}">
                    <input type="text" value="${permalink}" size="${permalink?length}" style="font-family: monospace; /*width: ${permalink?length*7}px*/" onclick="this.focus();this.select();" class="permalink-value" />
                </span>


                <#-- vyhledani obalky -->
                <#if currentPage.can('FilesManage', null)>
                    <kp-action-request-button path-on-context="true" path="/api/records/{{document.id}}/covers/search" on-success-callback="refresh()">${loc.loc("detail.ZnovuvyhledatObalku")?noEsc}</kp-action-request-button>
                </#if>


                <#-- smazani obalky -->
                <#if viewableRecord.cover?? && currentPage.can('FilesManage', null)>
                    <kp-action-request-button path-on-context="true" path="/api/records/{{document.id}}/covers/primary/delete" on-success-callback="refresh()">${loc.loc("detail.SmazatObalku")?noEsc}</kp-action-request-button>
                </#if>


                <#-- nahrani obalky -->
                <#if !viewableRecord.cover?? && currentPage.can('FilesManage', null)>
                    <form class="form-inline" style="display: inline-block;" ng-submit="onCoverFileSelect($files)">
                        <label>
                            ${loc.loc("detail.nahratObalku")?noEsc} <input class="form-control" ngf-select="onCoverFileSelect($files)" type="file" name="fileData" accept="image/*" />
                        </label>
                    </form>
                </#if>

            </div>

        </div>


        <div class="upperFooter row">
            <div class="col-sm-12">

                <#-- zobrazeni obrazku podle hodnoty podpole 1995 (pro MZLU - loga dotacniho programu EU) -->
                <#assign podpole1995=viewableRecord.query('1995.a').raw>
                <#if podpole1995?hasContent>
                    <div>
                        <img src="${currentPage.serverUrl}/custom/design/${podpole1995}.png" style="width: 60%; height: 60%" alt="${podpole1995}" />
                    </div>
                </#if>

                <#-- historie hledani -->
                <div class="notForPrint">
                    <a href="${currentPage.serverUrl}/search-history">${loc.loc("hledani.ZobrazitHledaneDotazy")?noEsc}</a>
                </div>

            </div>
        </div>

    </div>


</@layouts.full>
