<#ftl outputFormat="HTML">
<#import "../_localization.ftl" as loc>


<div class="row">

    <div class="col-xs-8">
        <div>
            <strong>{{record.name}}</strong>
        </div>
        <div>
            <span ng-if="record.directory">{{record.directory|loc}}/</span>{{record.filename}}
        </div>
        <div>
            <span class="text-muted">vytvořeno {{record.creationDate | jpDate:'d.M.yyyy'}}</span>
            <span class="text-muted">| velikost {{record.size | bytes}}</span>
        </div>
    </div>
    <div class="col-xs-2">
        <a kp-href="/files/{{record.id}}"><img ng-if="record.viewForms.includes('THUMBNAIL')" ng-src="{{CONTEXT_PATH}}/files/{{record.id}}?height=60" height="60" /></a>
    </div>
    <div class="col-xs-2">
        <div>
            <a kp-href="/files/{{record.id}}" download="{{record.filename}}" title="${loc.loc("commons.Stahnout")?noEsc}">
                <span class="glyphicon glyphicon-save"></span>
                <span>${loc.loc("commons.Stahnout")?noEsc}</span>
            </a>
        </div>
        <div>
            <a ng-if="record.directory" kp-href="/media-viewer?rootDirectory={{record.directory.id}}&edit=true#!?file={{record.id}}">
                <span class="glyphicon glyphicon-zoom-in"></span>
                <span>Zobrazit</span>
            </a>
        </div>
    </div>

</div>