<#ftl outputFormat="HTML">
<#import "../_localization.ftl" as loc>


<div class="department-created-dialog" ng-controller="DepartmentCreatedDialogCtrl as $ctrl" ng-init="$ctrl.init(modalWindowActions.cancel)">
    <div class="modal-header">
    </div>
    <div class="modal-body">
        <div class="modal-body-block text-center">
            <h2>Gratulujeme, toto je Vaše nová knihovna!</h2>
            <p>Vždy ji najdete na adrese</p>
            <h1>{{$ctrl.getHost()}}</h1>
        </div>
        <div class="modal-body-block text-center">
            <div ng-if="!$ctrl.currentAuth.evided">
                <p>
                    Teď už zbývá jen vytvořit Váš účet. Pokud již máte účet v nějaké jiné knihovně, použijte druhé tlačítko.
                </p>
                <p>
                    <button type="button" class="btn btn-primary" ng-click="$ctrl.registerWithEditorAccount()">Vytvořit účet</button>
                    <button type="button" class="btn btn-default" ng-click="$ctrl.loginAndAddEditorAccount()">Účet již mám</button>
                </p>
            </div>
            <div ng-if="$ctrl.currentAuth.evided && !$ctrl.currentAuth.role.includes('ROLE_LIBRARIAN')">
                <p>
                    Teď už zbývá jen vytvořit Váš administrátorský účet.
                </p>
                <p>
                    <button type="button" class="btn btn-primary" ng-click="$ctrl.addEditorAccount()">Vytvořit</button>
                </p>
            </div>
            <div ng-if="$ctrl.currentAuth.evided && $ctrl.currentAuth.role.includes('ROLE_LIBRARIAN')">
                <p>
                    Můžete začít třeba přidáním Vaší první knížky.
                </p>
                <p>
                    <button type="button" class="btn btn-primary" ng-click="$ctrl.activateDepartment()">Začít používat</button>
                </p>
            </div>
        </div>
    </div>
</div>


