<#ftl outputFormat="HTML">
<#import "_localization.ftl" as loc>


<#function escNg text>
    <#if text?? && text?contains("{{") && text?contains("}}")>
        <#return text?replace("{{", "")?replace("}}", "")>
    </#if>
    <#return text>
</#function>


<#macro paragraph paragraph>
    <#if paragraph??>
        <#attempt>
            <#if paragraph?hasContent>
                <div class="paragraphContent">${paragraph?noEsc}</div>
            </#if>
        <#recover>
            <!-- Exception --!>
            <#if .error.cause??>
                <#assign exc=.error.cause>
            </#if>
            <#if .error.stackTrace??>
                <!--
                <p>
                    <h1>STACK TRACE:</h1>
                    <#list .error.stackTrace as stackTraceElement>
                        ${loc.loc(stackTraceElement)?noEsc}<br/>
                    </#list>
                </p>
                -->
            </#if>
            <p class="alert alert-danger">
                <strong>Chyba při zpracování odstavce</strong><br/>
                <span class="error">${.error.message}</span>
            </p>
        </#attempt>
    </#if>
</#macro>


<#macro recordMarcTable viewableFields>
    <table class="detail-table greenHeaderTable marcTable">

        <thead>
        <tr>
            <td class="numberHeader">${loc.loc("commons.pole")?noEsc}</td>
            <td class="indikatoryHeader">${loc.loc("commons.ind")?noEsc}</td>
            <td class="obsahPoleHeader">${loc.loc("detail.obsahPole")?noEsc}</td>
        </tr>
        </thead>


        <tbody>
            <#list viewableFields as topfield>
                <#if topfield.code != 'toc'>
                    <tr class="${topfield?itemParity} field_${topfield.code}">
                        <td class="field-code">${topfield.code}</td>

                        <#attempt>

                            <#if topfield.kind == 'CONTROLFIELD'>
                                <td></td>
                                <td>
                                    <span class="field-value-text" title="${loc.locText(topfield.fieldTypeText)?esc}">
                                        ${topfield.raw!?noEsc}
                                    </span>
                                </td>
                            <#elseIf topfield.kind == 'DATAFIELD'>
                                <td>${topfield.ind1???then(topfield.ind1.id, '')?noEsc}${topfield.ind2???then(topfield.ind2.id, '')?noEsc}</td>
                                <td class="obsahPole">
                                    <#list topfield.fields as subfield>
                                        <@recordMarcTableSubfield subfield />
                                    </#list>
                                </td>
                            </#if>

                        <#recover>
                            ${.error}
                        </#attempt>

                    </tr>
                </#if>
            </#list>
        </tbody>
    </table>
</#macro>


<#macro recordMarcTableSubfield viewableField>
    <#if viewableField.fields?hasContent>
        <#list viewableField.fields as subfield>
            <span class="field-virtual">
                <@recordMarcTableSubfield subfield />
            </span>
        </#list>
    <#else>
        <span class="field_${viewableField.code?esc}" title="${loc.locText(viewableField.fieldTypeText)?noEsc}">
            $${viewableField.code?esc}
            <#if viewableField.ofRecord && viewableField.recordId??>
                <#-- subfild linking to other record -->
                <a href="${currentPage.serverUrl}/records/${viewableField.recordId}" class="field-value-text">${loc.locText(viewableField.text)?esc}</a>
            <#elseIf viewableField.url>
                <#-- PODPOLE S URL -->
                <a href="${viewableField.raw}" target="_blank" class="field-value-text">${viewableField.raw?esc}</a>
            <#else>
                <#-- NORMALNI PODPOLE -->
                <span class="field-value-text">${viewableField.raw?esc}</span>
            </#if>
        </span>
    </#if>
</#macro>