<#ftl outputFormat="HTML">
<#import "_localization.ftl" as loc>
<#import "_util.ftl" as util>

<#macro headerTop>
    <!DOCTYPE html>
    <html xmlns="http://www.w3.org/1999/xhtml" lang="${currentPage.currentLanguage???then(currentPage.currentLanguage.id, '')}" id="ng-app" ng-app="portaro" ng-controller="PageCtrl as $ctrl" ng-strict-di>
        <head ng-non-bindable>
            <meta http-equiv="X-UA-Compatible" content="IE=edge" />
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <meta name="keywords" xml:lang="cs" content="Portaro, knihovna, katalog, katalog knihovny, knihy, knihovní systém" />
            <meta name="description" xml:lang="cs" content="Portaro - Webový katalog knihovny" />
            <meta name="author" content="KP-SYS spol. s r. o." />
            <meta http-equiv="x-xrds-location" content="${currentPage.serverUrl!}/login/openid/xrds.xml" />
            <meta http-equiv="content-language" content="${currentPage.locale.language}" />
            <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no" />

            <#list currentPage.alternativePageLanguageLinks as languageLink>
                <link rel="alternate" href="${languageLink.url}" hreflang="${loc.locText(languageLink.text)}" />
            </#list>

            <link rel="search" type="application/opensearchdescription+xml" title="${loc.loc("commons.title")?esc}" href="${currentPage.contextPath}/opensearch.xml">

            <link rel="stylesheet" type="text/css" href="${currentPage.contextPath}/resources/dist/assets/styles/portaro.css?${currentPage.portaroVersion.value!}" media="all"/>
            <link rel="stylesheet" type="text/css" href="${currentPage.contextPath}/resources/static-styles/print.css" media="print" />
            <link rel="stylesheet" type="text/css" href="${currentPage.contextPath}/custom/design/style.css?${currentPage.portaroVersion.value!}" media="all"/>

            <style>
                :root {
                    --header-bg-color: ${currentPage.headerBackgroundColor};
                    --header-text-color: ${currentPage.headerTextColor};
                    --header-link-color: ${currentPage.headerLinkColor};
                    --main-menu-bg-color: ${currentPage.mainMenuBackgroundColor};
                    --main-menu-color:${currentPage.mainMenuTextColor};
                }
            </style>

            <link href="${currentPage.contextPath}/favicon.png" rel="icon" type="image/png" />
            <title>
                ${currentPage.titlePrefix}
                <#if pageTitle??>
                    ${loc.locText(pageTitle)?noEsc} -
                </#if>
                ${loc.loc("commons.title")?noEsc}
            </title>

            <script type="text/javascript">
                /* <![CDATA[ */
                window.contextPath = '${currentPage.contextPath}';
                window.serverUrl = '${currentPage.serverUrl!currentPage.contextPath}';
                window.currentAuth = ${currentPage.currentAuth???then(objectMapper.writeValueAsString(currentPage.currentAuth)?noEsc, null)};
                window.currentDep = ${currentPage.currentDepartment???then(objectMapper.writeValueAsString(currentPage.currentDepartment)?noEsc, null)};
                window.messages = {};
                window.portaroConfiguration = {};
                window.portaroConfiguration.loggingLevel = '${currentPage.frontendLoggerLevel.level}';
                window.portaroConfiguration.cameraScannerEnabled = ${objectMapper.writeValueAsString(currentPage.cameraScannerEnabled)?noEsc};
                window.portaroConfiguration.globalSearchInputEnabled = ${objectMapper.writeValueAsString(currentPage.globalSearchInputEnabled)?noEsc};
                window.dialogs = ${objectMapper.writeValueAsString(currentPage.dialogs)?noEsc};
                window.portaroVersion = ${objectMapper.writeValueAsString(currentPage.portaroVersion)?noEsc};
                window.apiBaseUrl = '${currentPage.contextPath}/api';
                <#if currentPage.currentLanguage??>window.currentLanguage = '${currentPage.currentLanguage.id!""}';</#if>
                window.model = {};
                /* ]]> */
            </script>

            <#include "./../resources/dist/localizations.ftl">

            <#-- pokud se nejedna o chybovou stranku, tzn. exception je null, zobraz all.html -->
            <#if !exception??>
                <#attempt>
                    ${currentPage.renderCustomFile("html", "all", "html")?noEsc}
                <#recover>
                    ${.error}
                </#attempt>
            </#if>

            <#-- outdated/unsupported browser alert -->
            <script type="text/javascript">
                if(/MSIE 9/i.test(window.navigator.userAgent)||/rv:11.0/i.test(window.navigator.userAgent)||/MSIE 10/i.test(window.navigator.userAgent)||/Edge\/\d./i.test(window.navigator.userAgent)) {
                    window.alert("${loc.loc("commons.pouzivateZastaralyProhlizec")?noEsc}!\n${loc.loc("commons.vyuzijteNekteryZTechtoProhlizecu")?noEsc}\nMozilla Firefox, Google Chrome, Microsoft Edge");
                }
            </script>

            <script type="text/javascript" src="${currentPage.contextPath}/resources/pluginy/jquery.js"></script>
            <script type="text/javascript" src="${currentPage.contextPath}/resources/dist/scripts/vendors.js?${currentPage.portaroVersion.value!}"></script>
            <script type="text/javascript" src="${currentPage.contextPath}/resources/dist/scripts/portaro.js?${currentPage.portaroVersion.value!}"></script>

        </head>

        <body class="${currentPage.currentDepartment.root?then('building_all', '')} building_${currentPage.currentDepartment.id?c} language_${currentPage.locale.language} ${currentPage.currentAuth.evided?then('logged', 'not-logged')}">
            <button class="sr-only" ng-click="$ctrl.skipToContent()">
                <#-- Button visible only by screen readers. It allows to skip to main part of the page by moving focus. -->
                ${loc.loc('commons.SkipToContent')?noEsc}
            </button>
            <main-configuration key="menuItems" value="${objectMapper.writeValueAsString(currentPage.generateMenu())?esc}" evaluate="true"></main-configuration>

            <#list currentPage.alerts as alert>
                <div class="global-alert ${(alert.severity() == 'DANGER')?then('bg-danger', '')}">
                    ${loc.locText(alert.text())?noEsc}
                </div>
            </#list>
</#macro>


<#macro headerBottom>
        </body>
    </html>
</#macro>



<#macro full spa=false>
    <@headerTop></@headerTop>
    <@body spa>
        <#nested />
    </@body>
    <@headerBottom></@headerBottom>
</#macro>

<#macro spa>
    <#nested />
</#macro>


<#macro headerOnly>
    <@headerTop></@headerTop>
    <#nested />
    <@headerBottom></@headerBottom>
</#macro>




<#macro body spa=false>

        <header class="logo-stripe">
            <div class="logo-content-container container">
                <div class="logo-search-row row">

                    <div class="customLogoArea custom-logo-area col-xs-12 col-sm-12 col-md-8 col-lg-7">
                        <#attempt>
                            ${currentPage.renderCustomFile("html", "logo", "html")?noEsc}
                        <#recover>
                            ${.error}
                        </#attempt>
                    </div>


                    <#-- jednoradkove vyhledavani -->
                    <div ng-if="$ctrl.globalSearchInputEnabled" class="logo-search pull-right col-xs-12 col-sm-12 col-md-4 col-lg-5">
                        <div class="input-group" role="search">
                            <kp-search-input css-class="form-control searchStringInput"
                                             css-id="searchStringInputVLogu"
                                             ng-model="searchPhrase"
                                             placeholder="${loc.loc("hledani.hledatKnihyAutoryTemata")?noEsc}"
                                             prefilled-value="{{$ctrl.getUrlParams().q}}"
                                             autofocus="{{$ctrl.autofocusGlobalSearch}}"
                                             on-submit="$ctrl.triggerGlobalSearch()"></kp-search-input>
                            <span class="input-group-btn">
                                <button type="button" class="btn btn-primary searchStringSubmit" ng-click="$ctrl.triggerGlobalSearch()" aria-label="${loc.loc("hledani.hledatKnihyAutoryTemata")?noEsc}">
                                    <i class="glyphicon glyphicon-search"></i>
                                </button>
                            </span>
                            <kp-global-search form-action="${currentPage.contextPath}/search" search-phrase="searchPhrase"></kp-global-search>
                        </div>

                        <div class="textPodLogoSearch">
                            <span class="custom-sub-search-area">
                                <#attempt>
                                    ${currentPage.renderCustomFile("html", "sub-search", "html")?noEsc}
                                <#recover>
                                    ${.error}
                                </#attempt>
                            </span>
                            <a class="extended-search" kp-href="/search-form">${loc.loc("hledani.RozsireneVyhledavani")?noEsc}</a>
                        </div>

                        <div class="cleaner"></div>
                    </div>

                </div>


                <div class="custom-logo-footer-area row">
                    <#attempt>
                        ${currentPage.renderCustomFile("html", "logo-footer", "html")?noEsc}
                    <#recover>
                        ${.error}
                    </#attempt>
                </div>


            </div>
        </header>

        <kp-main-menu menu-items="$ctrl.mainConfigurationService.configuration.menuItems" search-placeholder="${loc.loc("commons.hledat")?noEsc}">
            <kp-main-menu-logo>${currentPage.renderCustomFile("html", "main-menu-logo", "html")?noEsc}</kp-main-menu-logo>
            <kp-main-menu-custom-content>
            </kp-main-menu-custom-content>
        </kp-main-menu>


        <div role="alert" aria-atomic="false">
            <toaster-container></toaster-container>
        </div>

        <#-- initilize (and register) scanner-viewer and scanner-allower globally for whole application -->
        <kp-barcode-scanner-viewer append-to-body="true"></kp-barcode-scanner-viewer>

        <main class="main-content" tabindex="-1" ui-view>
            <#nested />
        </main>



        <div class="cleaner"></div>


        <footer class="footer-container">
            <div class="custom-footer">
                <#attempt>
                    ${currentPage.renderCustomFile("html", "footer", "html")?noEsc}
                    <#recover>
                    ${.error}
                </#attempt>
            </div>
            <div class="footer container">
                <div class="row">
                    <div class="col-lg-5 footer-block-left">
                        <div class="row">
                            <div class="col-lg-12 about">
                                ${loc.loc("commons.systemBylVyvinutFirmou")?noEsc}
                                <a href="https://kpsys.cz">KP-SYS <img src="${currentPage.contextPath}/resources/img/favicon.png" width="20" height="20" alt="${loc.loc('commons.KpSysUrl')?noEsc}"/></a>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12 version">
                                ${loc.loc("commons.VerzeSystemu")?noEsc} {{$ctrl.portaroVersion.date | date:'d.M.yyyy H:mm:ss'}} ({{$ctrl.portaroVersion.branch}} {{$ctrl.portaroVersion.value}})
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 footer-block-center">
                        <div class="row">
                            <div class="col-lg-12 rss"><a type="application/rss+xml" kp-href="/rss">RSS</a></div>
                            <#if !currentPage.currentDepartment.root>
                                <div class="col-lg-12 current-department">${loc.locText(currentPage.currentDepartment.text)?noEsc}</div>
                            </#if>
                        </div>
                    </div>
                    <nav class="col-lg-3 footer-block-right">
                        <#if currentPage.switchableLanguages?hasContent>
                            <ul class="lang-list">
                                <#list currentPage.switchableLanguages as lang>
                                    <li class="${lang.id}">
                                        <a href="" ng-click="$ctrl.setLocale('${lang.id}');" class="locale-change-item-btn">${loc.locText(lang.text)?noEsc}</a>
                                    </li>
                                </#list>
                            </ul>
                        </#if>
                        <#if currentPage.forAdministrationOnly && !currentPage.currentAuth.evided>
                            <a href="" ng-click="$ctrl.loginService.thisPageLogged()" class="pull-right">${loc.loc("login.menuLoginButton")}</a>
                        </#if>
                        <#if currentPage.currentAuth.evided>
                            <a class="pull-right" kp-href="/logout">${loc.loc("login.odhlasit")}</a>
                        </#if>
                    </nav>
                </div>
            </div>
        </footer>
</#macro>