/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.web;

import cz.kpsys.portaro.config.web.ProxiedStaticFileHttpHandler;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.jobrunr.dashboard.JobRunrApiHandler;
import org.jobrunr.dashboard.JobRunrSseHandler;
import org.jobrunr.dashboard.server.HttpExchangeHandler;
import org.jobrunr.dashboard.server.WebServer;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.ThreadSafeStorageProvider;
import org.jobrunr.utils.mapper.JsonMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxiedJobRunrDashboardWebServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProxiedJobRunrDashboardWebServer.class);
    @NonNull
    private final StorageProvider storageProvider;
    @NonNull
    private final JsonMapper jsonMapper;
    private final int port;
    private WebServer webServer;

    public ProxiedJobRunrDashboardWebServer(@NonNull StorageProvider storageProvider, @NonNull JsonMapper jsonMapper, int port) {
        Objects.requireNonNull(storageProvider, "storageProvider is marked non-null but is null");
        Objects.requireNonNull(jsonMapper, "jsonMapper is marked non-null but is null");
        this.storageProvider = new ThreadSafeStorageProvider(storageProvider);
        this.jsonMapper = jsonMapper;
        this.port = port;
    }

    public void start() {
        this.webServer = new WebServer(this.port);
        this.registerContext(this.createStaticFileHandler());
        this.registerContext(this.createApiHandler(this.storageProvider, this.jsonMapper));
        this.registerContext(this.createSSeHandler(this.storageProvider, this.jsonMapper));
        this.webServer.start();
        log.info("JobRunr Dashboard using {} started at http://{}:{}/dashboard", new Object[]{this.storageProvider.getStorageProviderInfo().getName(), this.webServer.getWebServerHostAddress(), this.webServer.getWebServerHostPort()});
    }

    public void stop() {
        if (this.webServer == null) {
            return;
        }
        this.webServer.stop();
        log.info("JobRunr dashboard stopped");
        this.webServer = null;
    }

    void registerContext(HttpExchangeHandler httpHandler) {
        this.webServer.createContext(httpHandler);
    }

    HttpExchangeHandler createStaticFileHandler() {
        return new ProxiedStaticFileHttpHandler("/dashboard", "org/jobrunr/dashboard/frontend/build/", true).replacing("\"/dashboard", "\"/jobs/dashboard").replacing("\"/api/", "\"/jobs/api/").replacing("\"/sse/", "\"/jobs/sse/");
    }

    HttpExchangeHandler createApiHandler(StorageProvider storageProvider, JsonMapper jsonMapper) {
        return new JobRunrApiHandler(storageProvider, jsonMapper, false);
    }

    HttpExchangeHandler createSSeHandler(StorageProvider storageProvider, JsonMapper jsonMapper) {
        return new JobRunrSseHandler(storageProvider, jsonMapper);
    }
}

