/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.modules;

import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.auth.UserAuthentication;
import cz.kpsys.portaro.commons.convert.StringToIntegerConverter;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.IdSettable;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.ActionDecoratingDeleter;
import cz.kpsys.portaro.commons.object.repo.ActionDecoratingSaver;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.SoftDeleterBySaver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.exemplar.volume.Volume;
import cz.kpsys.portaro.export.AbstractToTextualFileExporter;
import cz.kpsys.portaro.export.Exporter;
import cz.kpsys.portaro.export.ExporterResolver;
import cz.kpsys.portaro.export.XlsFileExporterByCsvExporter;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.LoadedIdentifiedFileLoaderDelegating;
import cz.kpsys.portaro.finance.Currency;
import cz.kpsys.portaro.logging.ActionSaver;
import cz.kpsys.portaro.pops.DemandApiController;
import cz.kpsys.portaro.pops.DemandLoader;
import cz.kpsys.portaro.pops.DemandLoaderSecurityHelper;
import cz.kpsys.portaro.pops.DemandLoaderSecurityHelperImpl;
import cz.kpsys.portaro.pops.EntitiesToDemandsConverter;
import cz.kpsys.portaro.pops.EntitiesToOffersConverter;
import cz.kpsys.portaro.pops.EntitiesToTendersConverter;
import cz.kpsys.portaro.pops.Offer;
import cz.kpsys.portaro.pops.OfferApiController;
import cz.kpsys.portaro.pops.OfferDeleterAppserver;
import cz.kpsys.portaro.pops.OfferDeletionRequest;
import cz.kpsys.portaro.pops.OfferLoader;
import cz.kpsys.portaro.pops.OfferSaverAppserver;
import cz.kpsys.portaro.pops.PopsSecurityActions;
import cz.kpsys.portaro.pops.SpringDbDemandLoader;
import cz.kpsys.portaro.pops.SpringDbOfferLoader;
import cz.kpsys.portaro.pops.Tender;
import cz.kpsys.portaro.pops.TenderApiController;
import cz.kpsys.portaro.pops.TenderEntity;
import cz.kpsys.portaro.pops.TenderLoader;
import cz.kpsys.portaro.pops.TenderLoaderDelegating;
import cz.kpsys.portaro.pops.TenderToRowConverter;
import cz.kpsys.portaro.pops.agreement.Agreement;
import cz.kpsys.portaro.pops.agreement.AgreementApiController;
import cz.kpsys.portaro.pops.agreement.AgreementConfirmer;
import cz.kpsys.portaro.pops.agreement.AgreementDeconfirmer;
import cz.kpsys.portaro.pops.agreement.AgreementFileVerifier;
import cz.kpsys.portaro.pops.agreement.AgreementLoader;
import cz.kpsys.portaro.pops.agreement.AgreementSaverAppserver;
import cz.kpsys.portaro.pops.agreement.AgreementStyle;
import cz.kpsys.portaro.pops.agreement.FileAgreementCreator;
import cz.kpsys.portaro.pops.agreement.FileAgreementCreatorITextPdf;
import cz.kpsys.portaro.pops.agreement.FileAgreementCreatorSavingProxy;
import cz.kpsys.portaro.pops.agreement.ITextPdfAgreementFileVerifier;
import cz.kpsys.portaro.pops.agreement.OfferingStateApiController;
import cz.kpsys.portaro.pops.agreement.OfferingStateResolver;
import cz.kpsys.portaro.pops.agreement.SignedFileVerifyingAgreementConfirmer;
import cz.kpsys.portaro.pops.agreement.SpringDbAgreementLoader;
import cz.kpsys.portaro.pops.export.CsvFileTenderDemandsExporter;
import cz.kpsys.portaro.record.KindedIdRecordDescriptor;
import cz.kpsys.portaro.record.authority.RichAuthority;
import cz.kpsys.portaro.record.document.RichDocument;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.template.Templates;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.role.supplier.SupplierRole;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class PopsConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PopsConfig.class);
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final AllByIdsLoadable<RichDocument, UUID> detailedDocumentLoader;
    @NonNull
    private final AllByIdsLoadable<Volume, Integer> volumeLoader;
    @NonNull
    private final AllByIdsLoadable<RichAuthority, Integer> nonDetailedAuthorityByKindedIdLoader;
    @NonNull
    private final IdAndIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final Provider<Currency> defaultCurrencyProvider;
    @NonNull
    private final ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader;
    @NonNull
    private final FileDataStreamer fileDataStreamer;
    @NonNull
    private final Saver<IdentifiedFile> loadedIdentifiedFileSaver;
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final ExporterResolver exporterResolver;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final Provider<Integer> portaroUserIdProvider;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final ActionSaver actionSaver;

    @Bean
    public TenderApiController tenderApiController() {
        log.debug("Enabling POPS module");
        return new TenderApiController(this.tenderLoader(), this.tenderSaver(), this.tenderDeleter());
    }

    @Bean
    public OfferApiController offerApiController() {
        return new OfferApiController(this.actionSaver, this.offerLoader(), this.offerSaver(), this.offerDeleter(), this.defaultCurrencyProvider, this.demandLoader(), this.securityManager);
    }

    @Bean
    public DemandApiController demandApiController() {
        return new DemandApiController(this.securityManager, this.demandLoaderSecurityHelper(), this.tenderLoader());
    }

    @Bean
    public AgreementApiController agreementApiController() {
        return new AgreementApiController(this.tenderLoader(), this.agreementLoader(), this.fileAgreementCreator(), this.agreementConfirmer(), this.agreementSaver());
    }

    @Bean
    public OfferingStateApiController offeringStateApiController() {
        return new OfferingStateApiController(this.tenderLoader(), this.offeringStateResolver());
    }

    @Bean
    public AgreementConfirmer agreementConfirmer() {
        return new SignedFileVerifyingAgreementConfirmer((AgreementFileVerifier)new ITextPdfAgreementFileVerifier(), this.agreementSaver(), this.settingLoader.getOnRootProvider(SettingKeys.AGREEMENT_STYLE));
    }

    @Bean
    public FileAgreementCreator fileAgreementCreator() {
        Provider agreementFileSigningEnabled = () -> this.settingLoader.getOnRootProvider(SettingKeys.AGREEMENT_STYLE).get() == AgreementStyle.FILE_SIGNING;
        return new FileAgreementCreatorSavingProxy((FileAgreementCreator)new FileAgreementCreatorITextPdf(this.demandLoader(), agreementFileSigningEnabled), this.agreementSaver(), this.portaroUserIdProvider, agreementFileSigningEnabled);
    }

    @Bean
    public Saver<Agreement> agreementSaver() {
        return new AgreementSaverAppserver(this.dmlAppserverService, this.loadedIdentifiedFileSaver);
    }

    @Bean
    public OfferingStateResolver offeringStateResolver() {
        return new OfferingStateResolver(this.agreementLoader(), this.offerLoader(), this.settingLoader.getOnRootProvider(SettingKeys.AGREEMENT_STYLE));
    }

    @Bean
    public AgreementLoader agreementLoader() {
        return new SpringDbAgreementLoader(this.jdbcTemplate, this.queryFactory, (ByIdLoadable)new LoadedIdentifiedFileLoaderDelegating(this.identifiedFileLoader, this.fileDataStreamer));
    }

    @Bean
    public Deleter<Agreement> agreementDeleter() {
        return new SoftDeleterBySaver(this.agreementSaver());
    }

    @Bean
    public TenderLoader tenderLoader() {
        Codebook tenderCodebook = this.codebookLoaderBuilderFactory.create().providedByJpa(TenderEntity.class, "createDate").converted((Converter)new EntitiesToTendersConverter((AllByIdsLoadable)this.basicUserLoader)).staticCached(Tender.class.getSimpleName()).build();
        return new TenderLoaderDelegating(tenderCodebook);
    }

    @Bean
    public Saver<Tender> tenderSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new TenderToRowConverter()).idSetting(TenderEntity.class, (Converter)new StringToIntegerConverter(), IdSettable::setId).withClearedCacheName(TenderEntity.class.getSimpleName()).build();
    }

    @Bean
    public Deleter<Tender> tenderDeleter() {
        return this.modelBeanBuilder.hibernateSoftDeleter(TenderEntity.class, (Converter)new TenderToRowConverter()).withClearedCacheName(TenderEntity.class.getSimpleName()).build();
    }

    @Bean
    public OfferLoader offerLoader() {
        return new SpringDbOfferLoader(this.jdbcTemplate, this.queryFactory, (Converter)new EntitiesToOffersConverter(this.nonDetailedAuthorityByKindedIdLoader, (AllByIdsLoadable)this.basicUserLoader));
    }

    @Bean
    public Saver<Offer> offerSaver() {
        OfferSaverAppserver pureSaver = new OfferSaverAppserver(this.dmlAppserverService);
        return new ActionDecoratingSaver((Saver)pureSaver).doAfter(offer -> {
            Optional agreementToInvalidate = this.agreementLoader().getBySupplierAndTender(offer.getSupplierAuthority(), offer.getTenderId().intValue());
            agreementToInvalidate.ifPresent(arg_0 -> ((AgreementDeconfirmer)this.agreementDeconfirmer()).deconfirm(arg_0));
        });
    }

    @Bean
    public Deleter<OfferDeletionRequest> offerDeleter() {
        OfferDeleterAppserver pureDeleter = new OfferDeleterAppserver(this.dmlAppserverService);
        return new ActionDecoratingDeleter((Deleter)pureDeleter).doAfter(req -> {
            Optional agreementToInvalidate = this.agreementLoader().getBySupplierAndTender(req.getOffer().getSupplierAuthority(), req.getOffer().getTenderId().intValue());
            agreementToInvalidate.ifPresent(arg_0 -> ((AgreementDeconfirmer)this.agreementDeconfirmer()).deconfirm(arg_0));
        });
    }

    @Bean
    public AgreementDeconfirmer agreementDeconfirmer() {
        return arg_0 -> ((Deleter)this.agreementDeleter()).delete(arg_0);
    }

    @Bean
    public DemandLoader demandLoader() {
        return new SpringDbDemandLoader(this.jdbcTemplate, this.queryFactory, this.offerLoader(), (Converter)new EntitiesToDemandsConverter(this.detailedDocumentLoader, this.volumeLoader, (ByIdLoadable)this.tenderLoader()));
    }

    @Bean
    public DemandLoaderSecurityHelper demandLoaderSecurityHelper() {
        return new DemandLoaderSecurityHelperImpl(this.securityManager, this.demandLoader());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerExports() {
        CsvFileTenderDemandsExporter tenderOffersCsvExporter = new CsvFileTenderDemandsExporter("tender-demands.csv", Templates.TEMPLATE_TENDER_OFFERS_CSV, this.templateEngine, this.demandLoader());
        this.exporterResolver.addStatic("CsvFileTenderDemands", (Exporter)tenderOffersCsvExporter);
        XlsFileExporterByCsvExporter tenderOffersXlsExporter = new XlsFileExporterByCsvExporter("tender-demands.xls", (AbstractToTextualFileExporter)tenderOffersCsvExporter);
        this.exporterResolver.addStatic("XlsFileTenderDemands", (Exporter)tenderOffersXlsExporter);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForIntegerId(Tender.class, (ByIdLoadable)this.tenderLoader());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        PermissionResolver currentEvidedAuthenticActiveCanRepresentOfferSupplier = PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActive(), (auth, ctx, offer) -> {
            KindedIdRecordDescriptor userAuthority = auth.getActiveUser().getAuthority();
            boolean userCanRepresentCompanyOfThisOffer = userAuthority != null && ((UUID)userAuthority.getId()).equals(offer.getSupplierAuthority().getId());
            return PermissionResult.ifCan((boolean)userCanRepresentCompanyOfThisOffer);
        }});
        this.permissionRegistry.add(PopsSecurityActions.POPS_TENDER_SHOW, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{(auth, ctx, tender) -> tender.getPhase() >= 2 ? PermissionResult.allow() : PermissionResult.cannot((UserAuthentication)auth, (Text)Texts.ofNative((String)"Cannot show not-opened tender")), this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN", "ROLE_LIBRARIAN"})}));
        this.permissionRegistry.add(PopsSecurityActions.POPS_TENDER_SAVE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{PermissionResolver.adaptingSubject(Tender::getCreator, (PermissionResolver)this.permissionFactory.currentIsSubjectUser()), this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN"})}));
        this.permissionRegistry.add(PopsSecurityActions.POPS_TENDER_DELETE, (PermissionResolver)PermissionResolver.adaptingSubject(Tender::getCreator, (PermissionResolver)this.permissionFactory.currentIsSubjectUser()));
        this.permissionRegistry.add(PopsSecurityActions.POPS_ALL_OFFERS_SHOW, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN", "ROLE_LIBRARIAN"}));
        this.permissionRegistry.add(PopsSecurityActions.POPS_SUPPLIER_OFFERS_SHOW, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser(), this.permissionFactory.subjectUserIsEvidedActiveWithRole(SupplierRole.class)}));
        this.permissionRegistry.add(PopsSecurityActions.POPS_OFFER_SHOW, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN", "ROLE_LIBRARIAN"}), currentEvidedAuthenticActiveCanRepresentOfferSupplier}));
        this.permissionRegistry.add(PopsSecurityActions.POPS_OFFER_SAVE, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_ADMIN"}), currentEvidedAuthenticActiveCanRepresentOfferSupplier}));
        this.permissionRegistry.add(PopsSecurityActions.POPS_OFFER_DELETE, this.permissionRegistry.get(PopsSecurityActions.POPS_OFFER_SAVE));
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "dmlAppserverService", "modelBeanBuilder", "codebookLoaderBuilderFactory", "saverBuilderFactory", "settingLoader", "detailedDocumentLoader", "volumeLoader", "nonDetailedAuthorityByKindedIdLoader", "basicUserLoader", "defaultCurrencyProvider", "identifiedFileLoader", "fileDataStreamer", "loadedIdentifiedFileSaver", "templateEngine", "exporterResolver", "converterRegisterer", "portaroUserIdProvider", "permissionRegistry", "securityManager", "permissionFactory", "actionSaver"})
    @Generated
    public PopsConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull DmlAppserverService dmlAppserverService, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull SettingLoader settingLoader, @NonNull AllByIdsLoadable<RichDocument, UUID> detailedDocumentLoader, @NonNull AllByIdsLoadable<Volume, Integer> volumeLoader, @NonNull AllByIdsLoadable<RichAuthority, Integer> nonDetailedAuthorityByKindedIdLoader, @NonNull IdAndIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull Provider<Currency> defaultCurrencyProvider, @NonNull ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader, @NonNull FileDataStreamer fileDataStreamer, @NonNull Saver<IdentifiedFile> loadedIdentifiedFileSaver, @NonNull TemplateEngine templateEngine, @NonNull ExporterResolver exporterResolver, @NonNull ConverterRegisterer converterRegisterer, @NonNull Provider<Integer> portaroUserIdProvider, @NonNull PermissionRegistry permissionRegistry, @NonNull SecurityManager securityManager, @NonNull PermissionFactory permissionFactory, @NonNull ActionSaver actionSaver) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(detailedDocumentLoader, "detailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(volumeLoader, "volumeLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedAuthorityByKindedIdLoader, "nonDetailedAuthorityByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(defaultCurrencyProvider, "defaultCurrencyProvider is marked non-null but is null");
        Objects.requireNonNull(identifiedFileLoader, "identifiedFileLoader is marked non-null but is null");
        Objects.requireNonNull(fileDataStreamer, "fileDataStreamer is marked non-null but is null");
        Objects.requireNonNull(loadedIdentifiedFileSaver, "loadedIdentifiedFileSaver is marked non-null but is null");
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(exporterResolver, "exporterResolver is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(portaroUserIdProvider, "portaroUserIdProvider is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(actionSaver, "actionSaver is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.dmlAppserverService = dmlAppserverService;
        this.modelBeanBuilder = modelBeanBuilder;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.saverBuilderFactory = saverBuilderFactory;
        this.settingLoader = settingLoader;
        this.detailedDocumentLoader = detailedDocumentLoader;
        this.volumeLoader = volumeLoader;
        this.nonDetailedAuthorityByKindedIdLoader = nonDetailedAuthorityByKindedIdLoader;
        this.basicUserLoader = basicUserLoader;
        this.defaultCurrencyProvider = defaultCurrencyProvider;
        this.identifiedFileLoader = identifiedFileLoader;
        this.fileDataStreamer = fileDataStreamer;
        this.loadedIdentifiedFileSaver = loadedIdentifiedFileSaver;
        this.templateEngine = templateEngine;
        this.exporterResolver = exporterResolver;
        this.converterRegisterer = converterRegisterer;
        this.portaroUserIdProvider = portaroUserIdProvider;
        this.permissionRegistry = permissionRegistry;
        this.securityManager = securityManager;
        this.permissionFactory = permissionFactory;
        this.actionSaver = actionSaver;
    }
}

