/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.modules;

import cz.kpsys.portaro.appserver.Appserver;
import cz.kpsys.portaro.appserver.AppserverService;
import cz.kpsys.portaro.view.web.AppserverApiProxyController;
import cz.kpsys.portaro.web.NoServletPathEmulatingServletWrappingController;
import cz.kpsys.portaro.web.proxy.UrlEncodedFormParametersCorrectingProxyServlet;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.mvc.ServletWrappingController;

@Configuration
public class AppserverProxyConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppserverProxyConfig.class);
    public static final String APPSERVER_PROXY_SERVLET_PATH = "/appserver";
    public static final String APPSERVER_MANAGER_PATH = "/appserver/manager";
    @NonNull
    private final Appserver appserver;
    @NonNull
    private final AppserverService basicAppserverService;

    @Bean
    public AppserverApiProxyController appserverApiProxyController() {
        return new AppserverApiProxyController(this.basicAppserverService);
    }

    @Bean
    public ServletWrappingController appserverProxyController() {
        log.debug("Enabling appserver reverse-proxy module");
        NoServletPathEmulatingServletWrappingController bean = new NoServletPathEmulatingServletWrappingController(UrlEncodedFormParametersCorrectingProxyServlet.class, APPSERVER_PROXY_SERVLET_PATH).withMatchAllPatternInServletMapping();
        Properties initParameters = new Properties();
        initParameters.setProperty("targetUri", this.appserver.getUrl());
        initParameters.setProperty("log", "true");
        bean.setInitParameters(initParameters);
        return bean;
    }

    @ConstructorProperties(value={"appserver", "basicAppserverService"})
    @Generated
    public AppserverProxyConfig(@NonNull Appserver appserver, @NonNull AppserverService basicAppserverService) {
        Objects.requireNonNull(appserver, "appserver is marked non-null but is null");
        Objects.requireNonNull(basicAppserverService, "basicAppserverService is marked non-null but is null");
        this.appserver = appserver;
        this.basicAppserverService = basicAppserverService;
    }
}

