/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.io.BigFileTransferer;
import cz.kpsys.portaro.commons.io.HttpFileTransferer;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.SettableProvider;
import cz.kpsys.portaro.licence.BusinessVersion;
import cz.kpsys.portaro.monitoring.health.StaticSettableHealthIndicator;
import cz.kpsys.portaro.resourcesupdate.JsonFileCurrentVersionSettableProvider;
import cz.kpsys.portaro.resourcesupdate.Portaro20FilesystemUpdatesProvider;
import cz.kpsys.portaro.resourcesupdate.ResourcesUpdaterImpl;
import cz.kpsys.portaro.resourcesupdate.UpdatesProvider;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.WritableResource;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class WindowsInstallationConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WindowsInstallationConfig.class);
    @NonNull
    private final StaticSettableHealthIndicator filesystemStructureHealthIndicator;
    @NonNull
    private final HttpClient fileDataHttpClient;
    @NonNull
    private final @NonNull Provider<@NonNull BusinessVersion> licenceVersionProvider;

    @Scheduled(initialDelay=1L, fixedDelay=99999999L, timeUnit=TimeUnit.MINUTES)
    public void updateWindowsFilesystemResources() {
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                JsonFileCurrentVersionSettableProvider versionRepository = new JsonFileCurrentVersionSettableProvider((WritableResource)new FileSystemResource("bin/version.json"), "portaro_2_0");
                Portaro20FilesystemUpdatesProvider portaro20Updates = new Portaro20FilesystemUpdatesProvider((BigFileTransferer)new HttpFileTransferer(this.fileDataHttpClient), this.licenceVersionProvider);
                ResourcesUpdaterImpl updater20 = new ResourcesUpdaterImpl((SettableProvider)versionRepository, (UpdatesProvider)portaro20Updates);
                updater20.update();
            }
            this.filesystemStructureHealthIndicator.setUp();
        }
        catch (Exception e) {
            this.filesystemStructureHealthIndicator.setDown(e);
            throw e;
        }
    }

    @ConstructorProperties(value={"filesystemStructureHealthIndicator", "fileDataHttpClient", "licenceVersionProvider"})
    @Generated
    public WindowsInstallationConfig(@NonNull StaticSettableHealthIndicator filesystemStructureHealthIndicator, @NonNull HttpClient fileDataHttpClient, @NonNull @NonNull Provider<@NonNull BusinessVersion> licenceVersionProvider) {
        Objects.requireNonNull(filesystemStructureHealthIndicator, "filesystemStructureHealthIndicator is marked non-null but is null");
        Objects.requireNonNull(fileDataHttpClient, "fileDataHttpClient is marked non-null but is null");
        Objects.requireNonNull(licenceVersionProvider, "licenceVersionProvider is marked non-null but is null");
        this.filesystemStructureHealthIndicator = filesystemStructureHealthIndicator;
        this.fileDataHttpClient = fileDataHttpClient;
        this.licenceVersionProvider = licenceVersionProvider;
    }
}

