/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.BasicUserAuthentication;
import cz.kpsys.portaro.auth.current.ActiveUserWebArgumentResolver;
import cz.kpsys.portaro.auth.current.CurrentAuthWebResolver;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.localization.UserFriendlyExceptionTextResolver;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.web.WebResolver;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.config.web.RequestMappingSupportingWebMvcConfigurationSupport;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.form.validation.AdhocValidator;
import cz.kpsys.portaro.form.validation.ValidFormObjectControllerAdvice;
import cz.kpsys.portaro.logging.ClientRequestCreatingInterceptor;
import cz.kpsys.portaro.logging.ClientSessionRepository;
import cz.kpsys.portaro.logging.ClientSessionWebArgumentResolver;
import cz.kpsys.portaro.search.MapToMapSearchParamsConverter;
import cz.kpsys.portaro.search.view.MapSearchParamsMethodArgumentResolver;
import cz.kpsys.portaro.search.view.SearchTextResolver;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.view.web.currentdepartment.CurrentDepartmentWebArgumentResolver;
import cz.kpsys.portaro.view.web.customfile.CustomFileResourceResolver;
import cz.kpsys.portaro.view.web.ratelimit.RateLimitInterceptor;
import cz.kpsys.portaro.view.web.rss.RssSearchHttpMessageConverter;
import cz.kpsys.portaro.web.UrlWebResolver;
import cz.kpsys.portaro.web.WebResolverAdaptingHandlerMethodArgumentResolver;
import cz.kpsys.portaro.web.client.WebClientRequest;
import cz.kpsys.portaro.web.exception.ExceptionHttpStatusResolver;
import cz.kpsys.portaro.web.exception.ExceptionObjectResolver;
import cz.kpsys.portaro.web.exception.ExceptionResponseLogger;
import cz.kpsys.portaro.web.mediatype.RequestMatchingContentNegotiationStrategy;
import cz.kpsys.portaro.web.page.CurrentPageFactory;
import cz.kpsys.portaro.web.page.ExceptionModelAndViewResolver;
import cz.kpsys.portaro.web.page.ModelAndPageViewFactory;
import cz.kpsys.portaro.web.page.SettableModelAndPageViewFactory;
import cz.kpsys.portaro.web.page.SimpleExceptionModelAndViewResolver;
import cz.kpsys.portaro.web.server.ServerUrlWebArgumentResolver;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.mvc.method.annotation.ServletWebArgumentResolverAdapter;
import org.springframework.web.servlet.resource.ResourceResolver;

@Configuration
public class WebMvcConfig
extends RequestMappingSupportingWebMvcConfigurationSupport {
    @NonNull
    private final @NonNull Provider<@NonNull String> publicContextPath;
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final WebResolver<Department> currentDepartmentWebResolver;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final CurrentAuthWebResolver currentAuthWebResolver;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final UrlWebResolver serverUrlWebResolver;
    @NonNull
    private final SearchTextResolver searchTitleResolver;
    @NonNull
    private final WebResolver<WebClientRequest> webClientRequestWebResolver;
    @NonNull
    private final Saver<WebClientRequest> clientRequestSaver;
    @NonNull
    private final MapToMapSearchParamsConverter mapToMapSearchParamsConverter;
    @NonNull
    private final ClientSessionRepository clientSessionRepository;
    @NonNull
    private final FormattingConversionService conversionService;
    @NonNull
    private final LocaleResolver portaroLocaleResolver;
    @NonNull
    private final Provider<Department> currentDepartmentProvider;
    @NonNull
    private final ConfigurableApplicationContext applicationContext;
    @NonNull
    private final ObjectMapper xmlMapper;
    @NonNull
    private final ExceptionHttpStatusResolver exceptionHttpStatusResolver;
    @NonNull
    private final ExceptionObjectResolver<Throwable> exceptionResponseObjectResolver;
    @NonNull
    private final ExceptionResponseLogger exceptionResponseLogger;
    @NonNull
    private final ViewResolver freeMarkerAngularTemplatesViewResolver;
    @NonNull
    private final UserFriendlyExceptionTextResolver userFriendlyExceptionTextResolver;
    @NonNull
    private final AdhocValidator adhocValidator;

    @Bean
    @NonNull
    public LocaleResolver localeResolver() {
        return this.portaroLocaleResolver;
    }

    @Bean
    @NonNull
    public FormattingConversionService mvcConversionService() {
        return this.conversionService;
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/api/**").allowedMethods(new String[]{"*"}).allowCredentials(false);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/db", (String)this.publicContextPath.get() + "/db/").setContextRelative(false);
        registry.addRedirectViewController("/appserver/manager", (String)this.publicContextPath.get() + "/appserver/manager/").setContextRelative(false);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/favicon.png"}).addResourceLocations(new String[]{"custom:/design", "classpath:/resources/img/"}).resourceChain(true).addResolver((ResourceResolver)new CustomFileResourceResolver());
        registry.addResourceHandler(new String[]{"/resources/**"}).addResourceLocations(new String[]{"classpath:/resources/"}).resourceChain(true);
        registry.addResourceHandler(new String[]{"/robots.txt"}).addResourceLocations(new String[]{"classpath:/resources/"}).resourceChain(true);
        registry.addResourceHandler(new String[]{"/docs/**"}).addResourceLocations(new String[]{"classpath:/docs/"});
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add((HandlerMethodArgumentResolver)new ServletWebArgumentResolverAdapter((WebArgumentResolver)new CurrentDepartmentWebArgumentResolver(this.currentDepartmentWebResolver)));
        resolvers.add((HandlerMethodArgumentResolver)new WebResolverAdaptingHandlerMethodArgumentResolver(BasicUserAuthentication.class, (WebResolver)this.currentAuthWebResolver));
        resolvers.add((HandlerMethodArgumentResolver)new ServletWebArgumentResolverAdapter((WebArgumentResolver)new ActiveUserWebArgumentResolver(this.authenticationHolder)));
        resolvers.add((HandlerMethodArgumentResolver)new ServletWebArgumentResolverAdapter((WebArgumentResolver)new ServerUrlWebArgumentResolver(this.serverUrlWebResolver)));
        resolvers.add((HandlerMethodArgumentResolver)new MapSearchParamsMethodArgumentResolver(this.mapToMapSearchParamsConverter));
        resolvers.add((HandlerMethodArgumentResolver)new ClientSessionWebArgumentResolver(this.clientSessionRepository));
        resolvers.add((HandlerMethodArgumentResolver)new WebResolverAdaptingHandlerMethodArgumentResolver(WebClientRequest.class, this.webClientRequestWebResolver));
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new ClientRequestCreatingInterceptor(this.webClientRequestWebResolver, this.clientRequestSaver));
        registry.addInterceptor((HandlerInterceptor)new RateLimitInterceptor(this.webClientRequestWebResolver));
    }

    @Bean
    @Primary
    @NonNull
    public ContentNegotiationManager mvcContentNegotiationManager() {
        return super.mvcContentNegotiationManager();
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.defaultContentTypeStrategy((ContentNegotiationStrategy)this.requestMatchingContentNegotiationStrategy()).favorParameter(true).parameterName("format").mediaType("rss20", new MediaType("application", "rss+xml"));
    }

    @Bean
    public RequestMatchingContentNegotiationStrategy requestMatchingContentNegotiationStrategy() {
        return new RequestMatchingContentNegotiationStrategy().add((RequestMatcher)new AntPathRequestMatcher("/api/**"), List.of(MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML));
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.stream().filter(MappingJackson2HttpMessageConverter.class::isInstance).findFirst().ifPresent(converters::remove);
        converters.add(0, (HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(this.objectMapper));
        converters.stream().filter(StringHttpMessageConverter.class::isInstance).findFirst().ifPresent(converters::remove);
        converters.add(1, (HttpMessageConverter<?>)new StringHttpMessageConverter(StandardCharsets.UTF_8));
        converters.add(2, (HttpMessageConverter<?>)new RssSearchHttpMessageConverter(this.translator, this.settingLoader.getOnRootProvider(CoreSettingKeys.DEFAULT_LOCALE), this.settingLoader.getOnRootProvider(SettingKeys.SERVER_URL), this.currentDepartmentProvider, this.searchTitleResolver));
        converters.stream().filter(MappingJackson2XmlHttpMessageConverter.class::isInstance).map(MappingJackson2XmlHttpMessageConverter.class::cast).forEach(httpMessageConverter -> httpMessageConverter.setSupportedMediaTypes(List.of(new MediaType("application", "xml"))));
    }

    @Bean
    public ValidFormObjectControllerAdvice requestBodyValidFormObjectControllerAdvice() {
        return new ValidFormObjectControllerAdvice(this.currentDepartmentProvider, this.adhocValidator);
    }

    @Bean
    public SettableModelAndPageViewFactory modelAndPageViewFactory() {
        return new SettableModelAndPageViewFactory((CurrentPageFactory)new CurrentPageFactory.NotInitializedYetCurrentPageFactory(), this.objectMapper, this.translator, this.localeResolver(), this.freeMarkerAngularTemplatesViewResolver);
    }

    @Bean
    public ExceptionModelAndViewResolver exceptionModelAndViewResolver() {
        return new SimpleExceptionModelAndViewResolver(this.translator, this.objectMapper, this.xmlMapper, this.exceptionHttpStatusResolver, this.exceptionResponseObjectResolver, this.exceptionResponseLogger, this.userFriendlyExceptionTextResolver, (ModelAndPageViewFactory)this.modelAndPageViewFactory(), (ContentNegotiationStrategy)this.mvcContentNegotiationManager(), this.currentDepartmentWebResolver, this.rootDepartmentProvider, this.localeResolver());
    }

    @ConstructorProperties(value={"publicContextPath", "objectMapper", "settingLoader", "currentDepartmentWebResolver", "rootDepartmentProvider", "currentAuthWebResolver", "authenticationHolder", "translator", "serverUrlWebResolver", "searchTitleResolver", "webClientRequestWebResolver", "clientRequestSaver", "mapToMapSearchParamsConverter", "clientSessionRepository", "conversionService", "portaroLocaleResolver", "currentDepartmentProvider", "applicationContext", "xmlMapper", "exceptionHttpStatusResolver", "exceptionResponseObjectResolver", "exceptionResponseLogger", "freeMarkerAngularTemplatesViewResolver", "userFriendlyExceptionTextResolver", "adhocValidator"})
    @Generated
    public WebMvcConfig(@NonNull @NonNull Provider<@NonNull String> publicContextPath, @NonNull ObjectMapper objectMapper, @NonNull SettingLoader settingLoader, @NonNull WebResolver<Department> currentDepartmentWebResolver, @NonNull Provider<Department> rootDepartmentProvider, @NonNull CurrentAuthWebResolver currentAuthWebResolver, @NonNull AuthenticationHolder authenticationHolder, @NonNull Translator<Department> translator, @NonNull UrlWebResolver serverUrlWebResolver, @NonNull SearchTextResolver searchTitleResolver, @NonNull WebResolver<WebClientRequest> webClientRequestWebResolver, @NonNull Saver<WebClientRequest> clientRequestSaver, @NonNull MapToMapSearchParamsConverter mapToMapSearchParamsConverter, @NonNull ClientSessionRepository clientSessionRepository, @NonNull FormattingConversionService conversionService, @NonNull LocaleResolver portaroLocaleResolver, @NonNull Provider<Department> currentDepartmentProvider, @NonNull ConfigurableApplicationContext applicationContext, @NonNull ObjectMapper xmlMapper, @NonNull ExceptionHttpStatusResolver exceptionHttpStatusResolver, @NonNull ExceptionObjectResolver<Throwable> exceptionResponseObjectResolver, @NonNull ExceptionResponseLogger exceptionResponseLogger, @NonNull ViewResolver freeMarkerAngularTemplatesViewResolver, @NonNull UserFriendlyExceptionTextResolver userFriendlyExceptionTextResolver, @NonNull AdhocValidator adhocValidator) {
        Objects.requireNonNull(publicContextPath, "publicContextPath is marked non-null but is null");
        Objects.requireNonNull(objectMapper, "objectMapper is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(currentDepartmentWebResolver, "currentDepartmentWebResolver is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(currentAuthWebResolver, "currentAuthWebResolver is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(serverUrlWebResolver, "serverUrlWebResolver is marked non-null but is null");
        Objects.requireNonNull(searchTitleResolver, "searchTitleResolver is marked non-null but is null");
        Objects.requireNonNull(webClientRequestWebResolver, "webClientRequestWebResolver is marked non-null but is null");
        Objects.requireNonNull(clientRequestSaver, "clientRequestSaver is marked non-null but is null");
        Objects.requireNonNull(mapToMapSearchParamsConverter, "mapToMapSearchParamsConverter is marked non-null but is null");
        Objects.requireNonNull(clientSessionRepository, "clientSessionRepository is marked non-null but is null");
        Objects.requireNonNull(conversionService, "conversionService is marked non-null but is null");
        Objects.requireNonNull(portaroLocaleResolver, "portaroLocaleResolver is marked non-null but is null");
        Objects.requireNonNull(currentDepartmentProvider, "currentDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(applicationContext, "applicationContext is marked non-null but is null");
        Objects.requireNonNull(xmlMapper, "xmlMapper is marked non-null but is null");
        Objects.requireNonNull(exceptionHttpStatusResolver, "exceptionHttpStatusResolver is marked non-null but is null");
        Objects.requireNonNull(exceptionResponseObjectResolver, "exceptionResponseObjectResolver is marked non-null but is null");
        Objects.requireNonNull(exceptionResponseLogger, "exceptionResponseLogger is marked non-null but is null");
        Objects.requireNonNull(freeMarkerAngularTemplatesViewResolver, "freeMarkerAngularTemplatesViewResolver is marked non-null but is null");
        Objects.requireNonNull(userFriendlyExceptionTextResolver, "userFriendlyExceptionTextResolver is marked non-null but is null");
        Objects.requireNonNull(adhocValidator, "adhocValidator is marked non-null but is null");
        this.publicContextPath = publicContextPath;
        this.objectMapper = objectMapper;
        this.settingLoader = settingLoader;
        this.currentDepartmentWebResolver = currentDepartmentWebResolver;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.currentAuthWebResolver = currentAuthWebResolver;
        this.authenticationHolder = authenticationHolder;
        this.translator = translator;
        this.serverUrlWebResolver = serverUrlWebResolver;
        this.searchTitleResolver = searchTitleResolver;
        this.webClientRequestWebResolver = webClientRequestWebResolver;
        this.clientRequestSaver = clientRequestSaver;
        this.mapToMapSearchParamsConverter = mapToMapSearchParamsConverter;
        this.clientSessionRepository = clientSessionRepository;
        this.conversionService = conversionService;
        this.portaroLocaleResolver = portaroLocaleResolver;
        this.currentDepartmentProvider = currentDepartmentProvider;
        this.applicationContext = applicationContext;
        this.xmlMapper = xmlMapper;
        this.exceptionHttpStatusResolver = exceptionHttpStatusResolver;
        this.exceptionResponseObjectResolver = exceptionResponseObjectResolver;
        this.exceptionResponseLogger = exceptionResponseLogger;
        this.freeMarkerAngularTemplatesViewResolver = freeMarkerAngularTemplatesViewResolver;
        this.userFriendlyExceptionTextResolver = userFriendlyExceptionTextResolver;
        this.adhocValidator = adhocValidator;
    }
}

