/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.auth.department.CurrentAuthDepartmentsLoader;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.date.DateRange;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.TimeGranularity;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadableByIdLoaderAdapter;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.property.Property;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.exemplar.acquisitionway.AcquisitionWay;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroup;
import cz.kpsys.portaro.location.DepartmentLocationRelationLoader;
import cz.kpsys.portaro.logging.ActionSaver;
import cz.kpsys.portaro.record.ForeignDatabase;
import cz.kpsys.portaro.record.RecordConstants;
import cz.kpsys.portaro.record.RecordStatus;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.search.CoreSearchParams;
import cz.kpsys.portaro.search.DefaultParamsFactory;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.stats.CompositeStatsLoader;
import cz.kpsys.portaro.stats.StatsConstants;
import cz.kpsys.portaro.stats.StatsLoader;
import cz.kpsys.portaro.stats.StatsLoaderConverterAdapter;
import cz.kpsys.portaro.stats.access.AccessStatsLoader;
import cz.kpsys.portaro.stats.access.SpringDbAccessStatsLoader;
import cz.kpsys.portaro.stats.data.DiscSpaceConsumptionStatProvider;
import cz.kpsys.portaro.stats.data.PublicStatsLoader;
import cz.kpsys.portaro.stats.data.SpringDbPublicStatsLoader;
import cz.kpsys.portaro.stats.model.MultipleCountsStat;
import cz.kpsys.portaro.stats.overall.OverallStatsLoader;
import cz.kpsys.portaro.stats.overall.SpringDbOverallStatsLoader;
import cz.kpsys.portaro.user.sec.SecurityActions;
import cz.kpsys.portaro.view.web.page.OverallStatsPageController;
import cz.kpsys.portaro.view.web.page.PublicStatsPageController;
import cz.kpsys.portaro.view.web.page.ZClientStatsPageController;
import cz.kpsys.portaro.view.web.rest.stats.AccessStatsApiController;
import cz.kpsys.portaro.view.web.rest.stats.OverallStatsApiController;
import cz.kpsys.portaro.view.web.rest.stats.PublicStatsApiController;
import cz.kpsys.portaro.web.page.ModelAndPageViewFactory;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class StatsConfig {
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final NamedParameterJdbcOperations notCriticalJdbcTemplate;
    @NonNull
    private final ActionSaver actionSaver;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final @NonNull Provider<@NonNull String> publicContextPath;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final DepartmentLocationRelationLoader departmentLocationRelationLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final ByIdLoadable<ThematicGroup, String> thematicGroupLoader;
    @NonNull
    private final ByIdLoadable<Fond, Integer> fondLoader;
    @NonNull
    private final ByIdLoadable<AcquisitionWay, String> acquisitionWayLoader;
    @NonNull
    private final ByIdLoadable<ForeignDatabase, Integer> foreignDatabaseLoader;
    @NonNull
    private final CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader;
    @NonNull
    private final ModelAndPageViewFactory modelAndPageViewFactory;
    @NonNull
    private final ContextualProvider<Department, List<Fond>> allowedFondsDepartmentedProvider;

    @Bean
    public AccessStatsApiController accessStatsApiController() {
        return new AccessStatsApiController(this.accessStatsLoader());
    }

    @Bean
    public PublicStatsPageController publicStatsPageController() {
        return new PublicStatsPageController(this.publicContextPath, this.modelAndPageViewFactory);
    }

    @Bean
    public PublicStatsApiController publicStatsApiController() {
        CompositeStatsLoader statsBuilder = new CompositeStatsLoader().addStat("registeredReadersCount", (StatsLoader)new StatsLoaderConverterAdapter(arg_0 -> ((PublicStatsLoader)this.publicStatsLoader()).getRegisteredReadersCount(arg_0))).addStat("documentsCount", (StatsLoader)new StatsLoaderConverterAdapter(arg_0 -> ((PublicStatsLoader)this.publicStatsLoader()).getDocumentsCount(arg_0))).addStat("exemplarsCount", (StatsLoader)new StatsLoaderConverterAdapter(arg_0 -> ((PublicStatsLoader)this.publicStatsLoader()).getExemplarsCount(arg_0))).addStat("documentsAndExemplarsCountsByFonds", (StatsLoader)new StatsLoaderConverterAdapter(arg_0 -> ((PublicStatsLoader)this.publicStatsLoader()).getDocumentsAndExemplarsCountsByFonds(arg_0))).addStat("activeLoansCount", (StatsLoader)new StatsLoaderConverterAdapter(arg_0 -> ((PublicStatsLoader)this.publicStatsLoader()).getLoanRealizationsCount(arg_0))).addStat("activeELoansCount", (StatsLoader)new StatsLoaderConverterAdapter(arg_0 -> ((PublicStatsLoader)this.publicStatsLoader()).getELoanRealizationsCount(arg_0))).addStat("movementsCounts", (StatsLoader)new StatsLoaderConverterAdapter(arg_0 -> ((PublicStatsLoader)this.publicStatsLoader()).getMovementsCounts(arg_0))).addStat("searchTypesCounts", (StatsLoader)new StatsLoaderConverterAdapter(arg_0 -> ((PublicStatsLoader)this.publicStatsLoader()).getSearchTypesCounts(arg_0))).addStat("entersAndLoginsCounts", (StatsLoader)new StatsLoaderConverterAdapter(arg_0 -> ((PublicStatsLoader)this.publicStatsLoader()).getEntersAndLoginsCounts(arg_0))).addStat("enterTypesCounts", (StatsLoader)new StatsLoaderConverterAdapter(arg_0 -> ((PublicStatsLoader)this.publicStatsLoader()).getEnterTypesCounts(arg_0))).addStat("documentsByDatabasesCounts", (StatsLoader)new StatsLoaderConverterAdapter(arg_0 -> ((PublicStatsLoader)this.publicStatsLoader()).getDocumentsByDatabasesCounts(arg_0))).addStat("discSpaceConsumptionStatProvider", (StatsLoader)new StatsLoaderConverterAdapter(p -> this.discSpaceConsumptionStatProvider().get()));
        DefaultParamsFactory defaultParamsFactory = ctx -> MapBackedParams.build(p -> {
            List forbiddenRecordStatuses = (List)this.settingLoader.getDepartmentedProvider(SettingKeys.FORBIDDEN_RECORD_STATUSES).andThen(arg_0 -> ((AllByIdsLoadableByIdLoaderAdapter)new AllByIdsLoadableByIdLoaderAdapter((ByIdLoadable)RecordStatus.CODEBOOK)).getAllByIds(arg_0)).getOn((Object)ctx);
            p.set((Property)CoreSearchParams.DEPARTMENT, (Object)this.departmentAccessor.getAllSubdepartmentsIncludingThis(ctx));
            p.set((Property)CoreSearchParams.INCLUDE_DRAFT, (Object)false);
            p.set((Property)CoreSearchParams.INCLUDE_DELETED, (Object)false);
            p.set((Property)RecordConstants.SearchParams.INCLUDE_EXCLUDED, (Object)false);
            p.set((Property)RecordConstants.SearchParams.FOND, (Object)((List)this.allowedFondsDepartmentedProvider.getOn((Object)ctx)));
            p.set((Property)RecordConstants.SearchParams.FORBIDDEN_RECORD_STATUS, (Object)forbiddenRecordStatuses);
            p.set((Property)RecordConstants.SearchParams.EXEMPLAR_STATUS, (Object)((List)this.settingLoader.getDepartmentedProvider(SettingKeys.EXEMPLAR_STATUSES).getOn((Object)ctx)));
            p.set((Property)CoreSearchParams.CENTRAL_INDEX_ENABLED, (Object)((Boolean)this.settingLoader.getDepartmentedProvider(SettingKeys.CENTRAL_INDEX_ENABLED).getOn((Object)ctx)));
            DateRange period = DateRange.ofMonth((Instant)Instant.now(), (boolean)true, (ZoneId)CoreConstants.CZECH_TIME_ZONE_ID);
            p.set((Property)CoreSearchParams.FROM_DATE, (Object)period.fromDate());
            p.set((Property)CoreSearchParams.TO_DATE, (Object)period.toDate());
            p.set((Property)StatsConstants.SearchParams.TIME_GRANULARITY, (Object)TimeGranularity.DAY);
        });
        return new PublicStatsApiController((StatsLoader)statsBuilder, defaultParamsFactory);
    }

    @Bean
    public ZClientStatsPageController zClientStatsPageController() {
        return new ZClientStatsPageController(this.publicStatsLoader(), this.modelAndPageViewFactory);
    }

    @Bean
    public OverallStatsApiController overallStatsApiController() {
        CompositeStatsLoader statsBuilder = new CompositeStatsLoader().addStat("stats", (StatsLoader)new StatsLoaderConverterAdapter(p -> this.overallStatsLoader().get(p))).addStat("exemplarIncreasesByAcquisitionWays", (StatsLoader)new StatsLoaderConverterAdapter(p -> this.overallStatsLoader().getExemplarIncreasesByAcqWaysStats(p))).addStat("exemplarIncreasesByFonds", (StatsLoader)new StatsLoaderConverterAdapter(p -> this.overallStatsLoader().getExemplarIncreasesByFondsStats(p))).addStat("exemplarIncreasesByThematicGroups", (StatsLoader)new StatsLoaderConverterAdapter(p -> this.overallStatsLoader().getExemplarIncreasesByThematicGroupStats(p))).addStat("exemplarDecreasesByAcquisitionWays", (StatsLoader)new StatsLoaderConverterAdapter(p -> this.overallStatsLoader().getExemplarDecreasesByAcqWaysStats(p))).addStat("exemplarDecreasesByFonds", (StatsLoader)new StatsLoaderConverterAdapter(p -> this.overallStatsLoader().getExemplarDecreasesByFondsStats(p))).addStat("exemplarDecreasesByThematicGroups", (StatsLoader)new StatsLoaderConverterAdapter(p -> this.overallStatsLoader().getExemplarDecreasesByThematicGroupStats(p)));
        DefaultParamsFactory defaultParamsFactory = ctx -> MapBackedParams.build(p -> {
            p.set((Property)CoreSearchParams.DEPARTMENT, (Object)this.departmentAccessor.getAllSubdepartmentsIncludingThis(ctx));
            DateRange period = DateRange.ofYear((Instant)Instant.now(), (boolean)true, (ZoneId)CoreConstants.CZECH_TIME_ZONE_ID);
            p.set((Property)CoreSearchParams.FROM_DATE, (Object)period.fromDate());
            p.set((Property)CoreSearchParams.TO_DATE, (Object)period.toDate());
        });
        return new OverallStatsApiController((StatsLoader)statsBuilder, defaultParamsFactory);
    }

    @Bean
    public OverallStatsPageController overallStatsPageController() {
        return new OverallStatsPageController(this.actionSaver, this.publicContextPath, this.departmentLocationRelationLoader, this.currentAuthEditableDepartmentsLoader, this.departmentAccessor, this.modelAndPageViewFactory);
    }

    @Bean
    public PublicStatsLoader publicStatsLoader() {
        SpringDbPublicStatsLoader loader = new SpringDbPublicStatsLoader(this.notCriticalJdbcTemplate, this.queryFactory, this.fondLoader, this.foreignDatabaseLoader);
        this.cacheService.registerCleaner((CacheCleaner)loader);
        return loader;
    }

    @Bean
    public OverallStatsLoader overallStatsLoader() {
        return new SpringDbOverallStatsLoader(this.notCriticalJdbcTemplate, this.queryFactory, this.fondLoader, this.acquisitionWayLoader, this.thematicGroupLoader, this.departmentAccessor);
    }

    @Bean
    public AccessStatsLoader accessStatsLoader() {
        return new SpringDbAccessStatsLoader(this.notCriticalJdbcTemplate, this.queryFactory);
    }

    @Bean
    public Provider<MultipleCountsStat<Long>> discSpaceConsumptionStatProvider() {
        return new DiscSpaceConsumptionStatProvider(this.notCriticalJdbcTemplate, this.queryFactory);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(SecurityActions.STATS_SHOW, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicence(), this.permissionFactory.currentEvidedAuthenticEditWithLoanLicence()}));
    }

    @ConstructorProperties(value={"queryFactory", "notCriticalJdbcTemplate", "actionSaver", "settingLoader", "cacheService", "publicContextPath", "permissionRegistry", "permissionFactory", "departmentLocationRelationLoader", "departmentAccessor", "thematicGroupLoader", "fondLoader", "acquisitionWayLoader", "foreignDatabaseLoader", "currentAuthEditableDepartmentsLoader", "modelAndPageViewFactory", "allowedFondsDepartmentedProvider"})
    @Generated
    public StatsConfig(@NonNull QueryFactory queryFactory, @NonNull NamedParameterJdbcOperations notCriticalJdbcTemplate, @NonNull ActionSaver actionSaver, @NonNull SettingLoader settingLoader, @NonNull CacheService cacheService, @NonNull @NonNull Provider<@NonNull String> publicContextPath, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull DepartmentLocationRelationLoader departmentLocationRelationLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull ByIdLoadable<ThematicGroup, String> thematicGroupLoader, @NonNull ByIdLoadable<Fond, Integer> fondLoader, @NonNull ByIdLoadable<AcquisitionWay, String> acquisitionWayLoader, @NonNull ByIdLoadable<ForeignDatabase, Integer> foreignDatabaseLoader, @NonNull CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader, @NonNull ModelAndPageViewFactory modelAndPageViewFactory, @NonNull ContextualProvider<Department, List<Fond>> allowedFondsDepartmentedProvider) {
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(notCriticalJdbcTemplate, "notCriticalJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(actionSaver, "actionSaver is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(publicContextPath, "publicContextPath is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(departmentLocationRelationLoader, "departmentLocationRelationLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(thematicGroupLoader, "thematicGroupLoader is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(acquisitionWayLoader, "acquisitionWayLoader is marked non-null but is null");
        Objects.requireNonNull(foreignDatabaseLoader, "foreignDatabaseLoader is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableDepartmentsLoader, "currentAuthEditableDepartmentsLoader is marked non-null but is null");
        Objects.requireNonNull(modelAndPageViewFactory, "modelAndPageViewFactory is marked non-null but is null");
        Objects.requireNonNull(allowedFondsDepartmentedProvider, "allowedFondsDepartmentedProvider is marked non-null but is null");
        this.queryFactory = queryFactory;
        this.notCriticalJdbcTemplate = notCriticalJdbcTemplate;
        this.actionSaver = actionSaver;
        this.settingLoader = settingLoader;
        this.cacheService = cacheService;
        this.publicContextPath = publicContextPath;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.departmentLocationRelationLoader = departmentLocationRelationLoader;
        this.departmentAccessor = departmentAccessor;
        this.thematicGroupLoader = thematicGroupLoader;
        this.fondLoader = fondLoader;
        this.acquisitionWayLoader = acquisitionWayLoader;
        this.foreignDatabaseLoader = foreignDatabaseLoader;
        this.currentAuthEditableDepartmentsLoader = currentAuthEditableDepartmentsLoader;
        this.modelAndPageViewFactory = modelAndPageViewFactory;
        this.allowedFondsDepartmentedProvider = allowedFondsDepartmentedProvider;
    }
}

